/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class TreeItem
extends Item {
    Tree parent;
    Font font;
    Font[] cellFont;
    boolean cached;
    boolean grayed;
    static final int EXPANDER_EXTRA_PADDING = 4;

    public TreeItem(Tree tree, int n) {
        this(TreeItem.checkNull(tree), 0, n, -1, true);
    }

    public TreeItem(Tree tree, int n, int n2) {
        this(TreeItem.checkNull(tree), 0, n, TreeItem.checkIndex(n2), true);
    }

    public TreeItem(TreeItem treeItem, int n) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, treeItem.handle, n, -1, true);
    }

    public TreeItem(TreeItem treeItem, int n, int n2) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, treeItem.handle, n, TreeItem.checkIndex(n2), true);
    }

    TreeItem(Tree tree, int n, int n2, int n3, boolean bl) {
        super(tree, n2);
        this.parent = tree;
        if (bl) {
            tree.createItem(this, n, n3);
        } else {
            this.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
            OS.gtk_tree_model_iter_nth_child(tree.modelHandle, this.handle, n, n3);
        }
    }

    static int checkIndex(int n) {
        if (n < 0) {
            SWT.error(6);
        }
        return n;
    }

    static TreeItem checkNull(TreeItem treeItem) {
        if (treeItem == null) {
            SWT.error(4);
        }
        return treeItem;
    }

    static Tree checkNull(Tree tree) {
        if (tree == null) {
            SWT.error(4);
        }
        return tree;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Color _getBackground() {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 4, nArray, -1);
        if (nArray[0] == 0) {
            return this.parent.getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, nArray[0], GdkColor.sizeof);
        OS.gdk_color_free(nArray[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Color _getBackground(int n) {
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this._getBackground();
        }
        int[] nArray = new int[1];
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 3, nArray, -1);
        if (nArray[0] == 0) {
            return this._getBackground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, nArray[0], GdkColor.sizeof);
        OS.gdk_color_free(nArray[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    boolean _getChecked() {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 1, nArray, -1);
        return nArray[0] != 0;
    }

    Color _getForeground() {
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 3, nArray, -1);
        if (nArray[0] == 0) {
            return this.parent.getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, nArray[0], GdkColor.sizeof);
        OS.gdk_color_free(nArray[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Color _getForeground(int n) {
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this._getForeground();
        }
        int[] nArray = new int[1];
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 2, nArray, -1);
        if (nArray[0] == 0) {
            return this._getForeground();
        }
        GdkColor gdkColor = new GdkColor();
        OS.memmove(gdkColor, nArray[0], GdkColor.sizeof);
        OS.gdk_color_free(nArray[0]);
        return Color.gtk_new(this.display, gdkColor);
    }

    Image _getImage(int n) {
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return null;
        }
        int[] nArray = new int[1];
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 0, nArray, -1);
        if (nArray[0] == 0) {
            return null;
        }
        ImageList imageList = this.parent.imageList;
        int n4 = imageList.indexOf(nArray[0]);
        OS.g_object_unref(nArray[0]);
        if (n4 == -1) {
            return null;
        }
        return imageList.get(n4);
    }

    String _getText(int n) {
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return "";
        }
        int[] nArray = new int[1];
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, n3 + 1, nArray, -1);
        if (nArray[0] == 0) {
            return "";
        }
        int n4 = OS.strlen(nArray[0]);
        byte[] byArray = new byte[n4];
        OS.memmove(byArray, nArray[0], n4);
        OS.g_free(nArray[0]);
        return new String(Converter.mbcsToWcs(null, byArray));
    }

    void clear() {
        if (this.parent.currentItem == this) {
            return;
        }
        if (this.cached || (this.parent.style & 0x10000000) == 0) {
            int n = OS.gtk_tree_model_get_n_columns(this.parent.modelHandle);
            int n2 = 1;
            while (n2 < 3) {
                OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, n2, 0, -1);
                ++n2;
            }
            n2 = 3;
            while (n2 < n) {
                OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, n2, 0, -1);
                ++n2;
            }
            if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
                this.redraw();
            }
        }
        this.cached = false;
        this.font = null;
        this.cellFont = null;
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        this.parent.clear(this.handle, n, bl);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        this.parent.clearAll(bl, this.handle);
    }

    void destroyWidget() {
        this.parent.releaseItem(this, false);
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground();
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground(n);
    }

    public Rectangle getBounds(int n) {
        int[] nArray;
        int[] nArray2;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = this.parent.handle;
        int n3 = 0;
        n3 = n >= 0 && n < this.parent.columnCount ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n2, n);
        if (n3 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n4 = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(n2);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(n2, n4, n3, gdkRectangle);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 18) && OS.gtk_tree_view_get_expander_column(n2) == n3) {
            nArray2 = new int[1];
            OS.gtk_widget_style_get(n2, OS.expander_size, nArray2, 0);
            gdkRectangle.x += nArray2[0] + 4;
            gdkRectangle.width -= nArray2[0] + 4;
            OS.gtk_widget_style_get(n2, OS.horizontal_separator, nArray2, 0);
            gdkRectangle.x += nArray2[0];
        }
        if ((this.parent.getStyle() & 0x8000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 10, 0)) {
            int n5 = OS.gtk_tree_path_get_depth(n4);
            nArray = new int[1];
            OS.gtk_widget_style_get(n2, OS.expander_size, nArray, 0);
            gdkRectangle.x += n5 * (nArray[0] + 4);
        }
        OS.gtk_tree_path_free(n4);
        if (n == 0 && (this.parent.style & 0x20) != 0) {
            nArray2 = new int[1];
            nArray = new int[1];
            OS.gtk_tree_view_column_cell_get_position(n3, this.parent.checkRenderer, nArray2, nArray);
            gdkRectangle.x += nArray2[0] + nArray[0];
            gdkRectangle.width -= nArray2[0] + nArray[0];
        }
        int n6 = OS.gtk_tree_view_column_get_visible(n3) ? gdkRectangle.width + 1 : 0;
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, n6, gdkRectangle.height + 1);
    }

    public Rectangle getBounds() {
        int n;
        int n2;
        int n3;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((n3 = OS.gtk_tree_view_get_column(n2 = this.parent.handle, 0)) == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n4 = this.parent.getTextRenderer(n3);
        int n5 = this.parent.getPixbufRenderer(n3);
        if (n4 == 0 || n5 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n6 = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(n2);
        boolean bl = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean bl2 = OS.gtk_tree_view_row_expanded(n2, n6);
        OS.gtk_tree_view_column_cell_set_cell_data(n3, this.parent.modelHandle, this.handle, bl, bl2);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(n2, n6, n3, gdkRectangle);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        int n7 = gdkRectangle.x + gdkRectangle.width;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.parent.ignoreSize = true;
        OS.gtk_cell_renderer_get_size(n4, n2, null, null, null, nArray2, null);
        this.parent.ignoreSize = false;
        gdkRectangle.width = nArray2[0];
        int[] nArray3 = new int[1];
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 18) && OS.gtk_tree_view_get_expander_column(n2) == n3) {
            OS.gtk_widget_style_get(n2, OS.expander_size, nArray3, 0);
            gdkRectangle.x += nArray3[0] + 4;
        }
        if ((this.parent.getStyle() & 0x8000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 10, 0)) {
            n = OS.gtk_tree_path_get_depth(n6);
            int[] nArray4 = new int[1];
            OS.gtk_widget_style_get(n2, OS.expander_size, nArray4, 0);
            gdkRectangle.x += n * (nArray4[0] + 4);
        }
        OS.gtk_tree_path_free(n6);
        OS.gtk_widget_style_get(n2, OS.horizontal_separator, nArray3, 0);
        n = nArray3[0];
        gdkRectangle.x += n;
        OS.gtk_tree_view_column_cell_get_position(n3, n4, nArray, null);
        gdkRectangle.x += nArray[0];
        if (this.parent.columnCount > 0 && gdkRectangle.x + gdkRectangle.width > n7) {
            gdkRectangle.width = Math.max(0, n7 - gdkRectangle.x);
        }
        int n8 = OS.gtk_tree_view_column_get_visible(n3) ? gdkRectangle.width + 1 : 0;
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, n8, gdkRectangle.height + 1);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this._getChecked();
    }

    public boolean getExpanded() {
        this.checkWidget();
        int n = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        boolean bl = OS.gtk_tree_view_row_expanded(this.parent.handle, n);
        OS.gtk_tree_path_free(n);
        return bl;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (n < 0 || n > n2 - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[n] == null) {
            return this.getFont();
        }
        return this.cellFont[n];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground();
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground(n);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getImage(0);
    }

    public Image getImage(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getImage(n);
    }

    public Rectangle getImageBounds(int n) {
        int[] nArray;
        int[] nArray2;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = this.parent.handle;
        int n3 = 0;
        n3 = n >= 0 && n < this.parent.getColumnCount() ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n2, n);
        if (n3 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n4 = this.parent.getPixbufRenderer(n3);
        if (n4 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        int n5 = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(n2);
        OS.gtk_tree_view_get_cell_area(n2, n5, n3, gdkRectangle);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 18) && OS.gtk_tree_view_get_expander_column(n2) == n3) {
            nArray2 = new int[1];
            OS.gtk_widget_style_get(n2, OS.expander_size, nArray2, 0);
            gdkRectangle.x += nArray2[0] + 4;
            gdkRectangle.width -= nArray2[0] + 4;
        }
        if ((this.parent.getStyle() & 0x8000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 10, 0)) {
            int n6 = OS.gtk_tree_path_get_depth(n5);
            nArray = new int[1];
            OS.gtk_widget_style_get(n2, OS.expander_size, nArray, 0);
            gdkRectangle.x += n6 * (nArray[0] + 4);
        }
        OS.gtk_tree_path_free(n5);
        nArray2 = new int[1];
        nArray = new int[1];
        OS.gtk_tree_view_column_cell_get_position(n3, n4, nArray2, nArray);
        gdkRectangle.x += nArray2[0];
        gdkRectangle.width = nArray[0];
        int n7 = OS.gtk_tree_view_column_get_visible(n3) ? gdkRectangle.width : 0;
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, n7, gdkRectangle.height + 1);
    }

    public int getItemCount() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle);
    }

    public TreeItem getItem(int n) {
        int n2;
        this.checkWidget();
        if (n < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n >= (n2 = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle))) {
            this.error(6);
        }
        return this.parent._getItem(this.handle, n);
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getItems(this.handle);
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        int n = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        TreeItem treeItem = null;
        int n2 = OS.gtk_tree_path_get_depth(n);
        if (n2 > 1) {
            OS.gtk_tree_path_up(n);
            int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter(this.parent.modelHandle, n3, n)) {
                treeItem = this.parent._getItem(n3);
            }
            OS.g_free(n3);
        }
        OS.gtk_tree_path_free(n);
        return treeItem;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getText(0);
    }

    public String getText(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getText(n);
    }

    public Rectangle getTextBounds(int n) {
        int n2;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n3 - 1) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n4 = this.parent.handle;
        int n5 = 0;
        n5 = n >= 0 && n < this.parent.columnCount ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n4, n);
        if (n5 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n6 = this.parent.getTextRenderer(n5);
        int n7 = this.parent.getPixbufRenderer(n5);
        if (n6 == 0 || n7 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n8 = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        OS.gtk_widget_realize(n4);
        boolean bl = OS.gtk_tree_model_iter_n_children(this.parent.modelHandle, this.handle) > 0;
        boolean bl2 = OS.gtk_tree_view_row_expanded(n4, n8);
        OS.gtk_tree_view_column_cell_set_cell_data(n5, this.parent.modelHandle, this.handle, bl, bl2);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(n4, n8, n5, gdkRectangle);
        if ((this.parent.getStyle() & 0x8000000) != 0) {
            gdkRectangle.x = this.parent.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
        }
        int n9 = gdkRectangle.x + gdkRectangle.width;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.parent.ignoreSize = true;
        OS.gtk_cell_renderer_get_size(n6, n4, null, null, null, nArray2, null);
        this.parent.ignoreSize = false;
        int[] nArray3 = new int[1];
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 18) && OS.gtk_tree_view_get_expander_column(n4) == n5) {
            OS.gtk_widget_style_get(n4, OS.expander_size, nArray3, 0);
            gdkRectangle.x += nArray3[0] + 4;
        }
        if ((this.parent.getStyle() & 0x8000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 10, 0)) {
            n2 = OS.gtk_tree_path_get_depth(n8);
            int[] nArray4 = new int[1];
            OS.gtk_widget_style_get(n4, OS.expander_size, nArray4, 0);
            gdkRectangle.x += n2 * (nArray4[0] + 4);
        }
        OS.gtk_tree_path_free(n8);
        OS.gtk_widget_style_get(n4, OS.horizontal_separator, nArray3, 0);
        n2 = nArray3[0];
        gdkRectangle.x += n2;
        OS.gtk_tree_view_column_cell_get_position(n5, n6, nArray, null);
        gdkRectangle.x += nArray[0];
        if (this.parent.columnCount > 0 && gdkRectangle.x + gdkRectangle.width > n9) {
            gdkRectangle.width = Math.max(0, n9 - gdkRectangle.x);
        }
        int n10 = OS.gtk_tree_view_column_get_visible(n5) ? gdkRectangle.width + 1 : 0;
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, n10, gdkRectangle.height + 1);
    }

    public int indexOf(TreeItem treeItem) {
        int n;
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        int n2 = -1;
        boolean bl = false;
        int n3 = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        int n4 = OS.gtk_tree_model_get_path(this.parent.modelHandle, treeItem.handle);
        int n5 = OS.gtk_tree_path_get_depth(n4);
        if (n5 > 1 && OS.gtk_tree_path_up(n4) && OS.gtk_tree_path_compare(n3, n4) == 0) {
            bl = true;
        }
        OS.gtk_tree_path_free(n3);
        OS.gtk_tree_path_free(n4);
        if (!bl) {
            return n2;
        }
        int n6 = OS.gtk_tree_model_get_path(this.parent.modelHandle, treeItem.handle);
        if (n5 > 1 && (n = OS.gtk_tree_path_get_indices(n6)) != 0) {
            int[] nArray = new int[n5];
            OS.memmove(nArray, n, 4 * nArray.length);
            n2 = nArray[nArray.length - 1];
        }
        OS.gtk_tree_path_free(n6);
        return n2;
    }

    void redraw() {
        int n = this.parent.handle;
        if ((OS.GTK_WIDGET_FLAGS(n) & 0x40) != 0) {
            int n2 = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gtk_tree_view_get_cell_area(n, n2, 0, gdkRectangle);
            OS.gtk_tree_path_free(n2);
            int n3 = OS.gtk_tree_view_get_bin_window(n);
            gdkRectangle.x = 0;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gdk_drawable_get_size(n3, nArray, nArray2);
            gdkRectangle.width = nArray[0];
            OS.gdk_window_invalidate_rect(n3, gdkRectangle, false);
        }
    }

    void releaseChildren(boolean bl) {
        if (bl) {
            this.parent.releaseItems(this.handle);
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        if (this.handle != 0) {
            OS.g_free(this.handle);
        }
        this.handle = 0;
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.font = null;
        this.cellFont = null;
    }

    public void removeAll() {
        this.checkWidget();
        int n = this.parent.modelHandle;
        int n2 = OS.gtk_tree_model_iter_n_children(n, this.handle);
        if (n2 == 0) {
            return;
        }
        int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (n3 == 0) {
            this.error(2);
        }
        if (this.parent.fixAccessibility()) {
            this.parent.ignoreAccessibility = true;
        }
        int n4 = OS.gtk_tree_view_get_selection(this.parent.handle);
        int[] nArray = new int[1];
        while (OS.gtk_tree_model_iter_children(n, n3, this.handle)) {
            Widget widget;
            OS.gtk_tree_model_get(n, n3, 0, nArray, -1);
            Widget widget2 = widget = nArray[0] != -1 ? this.parent.items[nArray[0]] : null;
            if (widget != null && !widget.isDisposed()) {
                widget.dispose();
                continue;
            }
            OS.g_signal_handlers_block_matched(n4, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_store_remove(n, n3);
            OS.g_signal_handlers_unblock_matched(n4, 16, 0, 0, 0, 0, 6);
        }
        if (this.parent.fixAccessibility()) {
            this.parent.ignoreAccessibility = false;
            OS.g_object_notify(this.parent.handle, OS.model);
        }
        OS.g_free(n3);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getBackground().equals(color)) {
            return;
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 4, gdkColor, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
    }

    public void setBackground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getBackground(n).equals(color)) {
            return;
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, n3 + 3, gdkColor, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
        if (color != null) {
            boolean bl;
            boolean bl2 = bl = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[n].customDraw;
            if (!bl) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int n4 = this.parent.handle;
                    int n5 = 0;
                    n5 = this.parent.columnCount > 0 ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n4, n);
                    if (n5 == 0) {
                        return;
                    }
                    int n6 = this.parent.getTextRenderer(n5);
                    int n7 = this.parent.getPixbufRenderer(n5);
                    OS.gtk_tree_view_column_set_cell_data_func(n5, n6, this.display.cellDataProc, n4, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(n5, n7, this.display.cellDataProc, n4, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[n].customDraw = true;
                }
            }
        }
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this._getChecked() == bl) {
            return;
        }
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 1, bl, -1);
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 2, !bl ? false : this.grayed, -1);
        this.cached = true;
    }

    public void setExpanded(boolean bl) {
        this.checkWidget();
        int n = OS.gtk_tree_model_get_path(this.parent.modelHandle, this.handle);
        if (bl != OS.gtk_tree_view_row_expanded(this.parent.handle, n)) {
            if (bl) {
                OS.g_signal_handlers_block_matched(this.parent.handle, 16, 0, 0, 0, 0, 51);
                OS.gtk_tree_view_expand_row(this.parent.handle, n, false);
                OS.g_signal_handlers_unblock_matched(this.parent.handle, 16, 0, 0, 0, 0, 51);
            } else {
                OS.g_signal_handlers_block_matched(this.parent.handle, 16, 0, 0, 0, 0, 50);
                OS.gtk_widget_realize(this.parent.handle);
                OS.gtk_tree_view_collapse_row(this.parent.handle, n);
                OS.g_signal_handlers_unblock_matched(this.parent.handle, 16, 0, 0, 0, 0, 50);
            }
        }
        OS.gtk_tree_path_free(n);
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        int n = font != null ? font.handle : 0;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 5, n, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
    }

    public void setFont(int n, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[n2];
        }
        if ((font2 = this.cellFont[n]) == font) {
            return;
        }
        this.cellFont[n] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        int n4 = font != null ? font.handle : 0;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, n3 + 4, n4, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
        if (font != null) {
            boolean bl;
            boolean bl2 = bl = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[n].customDraw;
            if (!bl) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int n5 = this.parent.handle;
                    int n6 = 0;
                    n6 = this.parent.columnCount > 0 ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n5, n);
                    if (n6 == 0) {
                        return;
                    }
                    int n7 = this.parent.getTextRenderer(n6);
                    int n8 = this.parent.getPixbufRenderer(n6);
                    OS.gtk_tree_view_column_set_cell_data_func(n6, n7, this.display.cellDataProc, n5, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(n6, n8, this.display.cellDataProc, n5, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[n].customDraw = true;
                }
            }
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getForeground().equals(color)) {
            return;
        }
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 3, gdkColor, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
    }

    public void setForeground(int n, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (this._getForeground(n).equals(color)) {
            return;
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        GdkColor gdkColor = color != null ? color.handle : null;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, n3 + 2, gdkColor, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
        if (color != null) {
            boolean bl;
            boolean bl2 = bl = this.parent.columnCount == 0 ? this.parent.firstCustomDraw : this.parent.columns[n].customDraw;
            if (!bl) {
                if ((this.parent.style & 0x10000000) == 0) {
                    int n4 = this.parent.handle;
                    int n5 = 0;
                    n5 = this.parent.columnCount > 0 ? this.parent.columns[n].handle : OS.gtk_tree_view_get_column(n4, n);
                    if (n5 == 0) {
                        return;
                    }
                    int n6 = this.parent.getTextRenderer(n5);
                    int n7 = this.parent.getPixbufRenderer(n5);
                    OS.gtk_tree_view_column_set_cell_data_func(n5, n6, this.display.cellDataProc, n4, 0);
                    OS.gtk_tree_view_column_set_cell_data_func(n5, n7, this.display.cellDataProc, n4, 0);
                }
                if (this.parent.columnCount == 0) {
                    this.parent.firstCustomDraw = true;
                } else {
                    this.parent.columns[n].customDraw = true;
                }
            }
        }
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl) {
            return;
        }
        this.grayed = bl;
        int[] nArray = new int[1];
        OS.gtk_tree_model_get(this.parent.modelHandle, this.handle, 1, nArray, -1);
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, 2, nArray[0] == 0 ? false : bl, -1);
        this.cached = true;
    }

    public void setImage(int n, Image image) {
        int n2;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image != null && image.type == 1 && image.equals(this._getImage(n))) {
            return;
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n3 - 1) {
            return;
        }
        int n4 = 0;
        if (image != null) {
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n2 = imageList.indexOf(image)) == -1) {
                n2 = imageList.add(image);
            }
            n4 = imageList.getPixbuf(n2);
        }
        int n5 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, n5 + 0, n4, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 6, 3) && this.parent.columnCount == 0) {
            this.redraw();
        }
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == null && image != null) {
            n2 = this.parent.handle;
            int n6 = OS.gtk_tree_view_get_column(n2, n);
            int[] nArray = new int[1];
            int n7 = this.parent.getPixbufRenderer(n6);
            OS.gtk_tree_view_column_cell_get_position(n6, n7, null, nArray);
            if (nArray[0] < image.getBounds().width) {
                int n8 = OS.gtk_widget_get_modifier_style(n2);
                this.parent.modifyStyle(n2, n8);
            }
        }
        this.cached = true;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < imageArray.length) {
            this.setImage(n, imageArray[n]);
            ++n;
        }
    }

    public void setItemCount(int n) {
        this.checkWidget();
        n = Math.max(0, n);
        this.parent.setItemCount(this.handle, n);
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this._getText(n).equals(string)) {
            return;
        }
        int n2 = Math.max(1, this.parent.getColumnCount());
        if (n < 0 || n > n2 - 1) {
            return;
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n3 = this.parent.columnCount == 0 ? 6 : this.parent.columns[n].modelIndex;
        OS.gtk_tree_store_set(this.parent.modelHandle, this.handle, n3 + 1, byArray, -1);
        if ((this.parent.style & 0x10000000) != 0 && OS.GTK_VERSION < OS.VERSION(2, 6, 3)) {
            this.redraw();
        }
        this.cached = true;
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string != null) {
                this.setText(n, string);
            }
            ++n;
        }
    }
}

