<?php
require_once 'review_classes/_base.class.php';
class review extends review_base {

// Utilities

function assign_item_info($item_id) {
	require_once 'item.class.php';
	$item_obj = new item();
	$item_obj->assign_search_form($this);
	$item_obj->QuictyStatus = 'BROWSE';
	$item_obj->display_record('id='.$item_id);
	$this->item = $item_obj->item;
	$this->assign_form('item_info',$item_obj->form);
}

function check_wrote($item_id) {
	$check = $this->select_row('review',"where item_id=$item_id and user_id=".$this->user['id']);
	if($check) {
		return $check['id'];
	} else {
		return false;
	}
}

// dispatch actions

function dispatch_index() {
	if(!$this->is_cached($this->current_template,$this->cache_id)) {
		require_once 'item.class.php';
		$item_obj = new item();
		$item_obj->assign_search_form($this);
		$list_table = $this->list_records('');

		$this->assign('table_view',$this->list->display_table_value($list_table));
		$this->assign('display_cmd','info');
		$this->page['pager'] = $this->set_pager();
		$this->assign_page_and_pathlist($this->W['review'].' '.$this->W['list']);
	}
	return $this->display($this->current_template,$this->cache_id);
}

function dispatch_info() {
	$result = $this->display_record();
	$item_id = $this->review['item_id'];
	$this->assign_item_info($item_id);
	
	$this->assign_form('input_form',$this->form);
	$this->assign_page_and_pathlist($this->W['review'].' '.$this->W['display']);
	return $this->display($this->current_template);
}

function dispatch_add() {
	if(is_numeric($_GET['item_id'])) {
		$item_id = $_GET['item_id'];
		if($review_id=$this->check_wrote($item_id)) {
			redirect('<!--{$folder_name}-->/review/edit?id='.$review_id);
		}
	} elseif(is_numeric($_POST['item_id'])) {
		$item_id = $_POST['item_id'];
	} else {
		redirect('top');
	}

	$this->assign_item_info($item_id);
	$result = $this->display_record();
	if($this->QuictyStatus=='INSERT') {
		redirect('<!--{$folder_name}-->/item/info?id='.$item_id);
	}
	
	$this->assign_form('input_form',$this->form);
	$this->assign_page_and_pathlist($this->W['review'].' '.$this->W['add']);
	return $this->display($this->current_template);
}

function dispatch_edit() {
	$result = $this->display_record();
	$item_id = $this->review['item_id'];
	if($this->QuictyStatus=='UPDATE') {
		redirect('<!--{$folder_name}-->/item/info?id='.$item_id);
	} else {
		$this->assign_item_info($item_id);
	}
	
	$this->assign_form('input_form',$this->form);
	$this->assign_page_and_pathlist($this->W['review'].' '.$this->W['edit']);
	return $this->display($this->current_template);
}

function dispatch_delete() {
	$result = $this->display_record();
	$item_id = $this->review['item_id'];
	if($this->QuictyStatus=='DELETE') {
		redirect('<!--{$folder_name}-->/item/info?id='.$_POST['item_id']);
	} else {
		$this->assign_item_info($item_id);
	}
	
	$this->assign_form('input_form',$this->form);
	$this->assign_page_and_pathlist($this->W['review'].' '.$this->W['delete']);
	return $this->display($this->current_template);
}

function dispatch_error() {
	$this->page['message'] = $this->W['_review_login_error'];
	$this->assign_page_and_pathlist($this->W['_review_please_login']);
	return $this->display($this->current_template);
}

function dispatch_batch_update() {
	$list_table = $this->batch_update();
	if($this->QuictyStatus=='UPDATE') {
		redirect('<!--{$folder_name}-->/review/');
	}
	
	$base_url = quicty_base_url();
	$update_form['display_cmd'] = $base_url.'<!--{$folder_name}-->/review/edit';
	//$update_form['conditions']['any_key'] = $_REQUEST['any_key'];
	$update_form['even_color'] = '#fee';	
	$this->assign_batch_form('table_view',$list_table,$max_column=1,$update_form);
	//$navi = $this->list->get_pager_links();
	//$this->assign('pager_navi',$navi['all']);
	$this->page['pager'] = $this->set_pager();
	$this->assign_page_and_pathlist($this->W['review'].' '.$this->W['batch_update']);
	return $this->display($this->current_template);
}

} // end of review class
?>