<?php
class fields_form_options extends myQuicty {

function __construct($page) {
	parent::__construct();
	$this->page = $page;
	$this->form = $this->page->form;
	$this->init_field_define();
}

function set_defaults() {
	$fields = $this->form->select('where datasets_id='.$_REQUEST['datasets_id'].' order by seq desc','seq');
	$max_seq = $fields[0]['seq'];
	$seq = $max_seq + 1;
	$defaults['seq'] = $seq;

	$hqf_type = $this->fields_reverse_map[$_POST['type']]['type'];
	switch($hqf_type) {
		case 'id':
			$defaults['name'] = 'id';
			$defaults['sort_flag'] = 1;
			break;
		case 'text':
			$defaults['search_flag'] = 1;
		default:
			$name = $type =$_POST['type'];
			//$defaults['name'] = $name.$seq;
			$defaults['name'] = $name;
			$label = $this->fields_reverse_map[$_POST['type']]['label'];
			//$defaults['label'] = $label.$seq;
			$defaults['label'] = $label;
	}
	
	$this->form->setDefaults($defaults);
	$this->form->setConstants(array('type'=>$type,'hqf_type'=>$hqf_type));
}

function set_form_options() {
	$this->form->set_base_link_addr(quicty_base_url().'/fields/');
	$this->form->set_restart_link_addr(quicty_base_url().'/fields/');
	$this->form->set_button_status('use_confirm',false);

	if($_POST['mode']=='add')
		$this->set_defaults();

	require_once 'includes/field_properties.class.php';
	$field_properties = new field_properties($this->page);
	$field_properties->set();
}

// filters

function set_form_filters() {
	$this->form->applyFilter('_ALL_','trim');
}

} // end of class fields_form_options
?>