/*
 * Decompiled with CFR 0.152.
 */
package org.qrone.xmlsocket;

import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.qrone.xmlsocket.XMLSocketNIO;
import org.qrone.xmlsocket.event.XMLSocketServerListener;
import org.qrone.xmlsocket.nio.SelectorServerSocket;
import org.qrone.xmlsocket.nio.SelectorSocket;
import org.qrone.xmlsocket.nio.SelectorThread;

public class XMLSocketServerNIO
extends SelectorServerSocket {
    private static final Logger log;
    private static final int SERVER_TIMEOUT = 30000;
    private LinkedList serverlistener = new LinkedList();
    private Charset inputcs = Charset.forName("UTF-8");
    private Charset outputcs = Charset.forName("UTF-8");
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.qrone.xmlsocket.XMLSocketServerNIO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public XMLSocketServerNIO() throws IOException {
        super(new SelectorThread());
    }

    public XMLSocketServerNIO(SelectorThread thread) {
        super(thread);
    }

    public void setEncoding(Charset cs) {
        this.setEncoding(cs, cs);
    }

    public void setEncoding(String charset) {
        this.setEncoding(Charset.forName(charset));
    }

    public void setEncoding(Charset input, Charset output) {
        this.inputcs = input;
        this.outputcs = output;
    }

    public ServerSocket getServerSocket() {
        return this.serverchannel.socket();
    }

    public void onOpen(boolean success) {
        Iterator iter = this.serverlistener.iterator();
        while (iter.hasNext()) {
            ((XMLSocketServerListener)iter.next()).onOpen(success);
        }
        if (success) {
            log.debug((Object)"OPEN");
        }
    }

    public void onError(Exception e) {
        Iterator iter = this.serverlistener.iterator();
        while (iter.hasNext()) {
            ((XMLSocketServerListener)iter.next()).onError(e);
        }
        log.debug((Object)"ERROR");
    }

    public void onClose() {
        Iterator iter = this.serverlistener.iterator();
        while (iter.hasNext()) {
            ((XMLSocketServerListener)iter.next()).onClose();
        }
        log.debug((Object)"CLOSE");
    }

    public void onNewClient(XMLSocketNIO socket) {
        Iterator iter = this.serverlistener.iterator();
        while (iter.hasNext()) {
            ((XMLSocketServerListener)iter.next()).onNewClient(socket);
        }
        log.debug((Object)("NEWCLIENT " + socket.getSocket().getInetAddress().getHostAddress()));
    }

    public void onNewClient(SelectorSocket socket) {
        this.onNewClient((XMLSocketNIO)socket);
    }

    public void addXMLSocketServerListener(XMLSocketServerListener listener) {
        this.serverlistener.add(listener);
    }

    public void removeXMLSocketServerListener(XMLSocketServerListener listener) {
        this.serverlistener.remove(listener);
    }

    public SelectorSocket createSelectorSocket() {
        XMLSocketNIO socket = new XMLSocketNIO(this.thread);
        socket.setEncoding(this.inputcs, this.outputcs);
        return socket;
    }
}

