/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.reedsolomon;

import jp.sourceforge.reedsolomon.Galois;

public class RsDecode {
    public static final int RS_PERM_ERROR = -1;
    public static final int RS_CORRECT_ERROR = -2;
    private static final Galois galois = Galois.getInstance();
    private int npar;

    public RsDecode(int n) {
        this.npar = n;
    }

    public int calcSigmaMBM(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = new int[this.npar];
        int[] nArray5 = new int[this.npar];
        nArray4[1] = 1;
        nArray5[0] = 1;
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < this.npar; ++i) {
            int n4;
            int n5 = nArray3[i];
            for (n4 = 1; n4 <= n2; ++n4) {
                n5 ^= galois.mul(nArray5[n4], nArray3[i - n4]);
            }
            if (n5 != 0) {
                int n6;
                n4 = galois.toLog(n5);
                int[] nArray6 = new int[this.npar];
                for (n6 = 0; n6 <= i; ++n6) {
                    nArray6[n6] = nArray5[n6] ^ galois.mulExp(nArray4[n6], n4);
                }
                n6 = i - n3;
                if (n6 > n2) {
                    n3 = i - n2;
                    n2 = n6;
                    if (n2 > this.npar / 2) {
                        return -1;
                    }
                    for (int j = 0; j <= n; ++j) {
                        nArray4[j] = galois.divExp(nArray5[j], n4);
                    }
                    n = n2;
                }
                nArray5 = nArray6;
            }
            System.arraycopy(nArray4, 0, nArray4, 1, Math.min(nArray4.length - 1, n));
            nArray4[0] = 0;
            ++n;
        }
        galois.mulPoly(nArray2, nArray5, nArray3);
        System.arraycopy(nArray5, 0, nArray, 0, Math.min(nArray5.length, nArray.length));
        return n2;
    }

    private int chienSearch(int[] nArray, int n, int n2, int[] nArray2) {
        int n3 = nArray2[1];
        if (n2 == 1) {
            if (galois.toLog(n3) >= n) {
                return -2;
            }
            nArray[0] = n3;
            return 0;
        }
        int n4 = n2 - 1;
        for (int i = 0; i < n; ++i) {
            int n5;
            int n6 = 255 - i;
            int n7 = 1;
            for (n5 = 1; n5 <= n2; ++n5) {
                n7 ^= galois.mulExp(nArray2[n5], n6 * n5 % 255);
            }
            if (n7 != 0) continue;
            n5 = galois.toExp(i);
            n3 ^= n5;
            nArray[n4--] = n5;
            if (n4 != 0) continue;
            if (galois.toLog(n3) >= n) {
                return -2;
            }
            nArray[0] = n3;
            return 0;
        }
        return -2;
    }

    private void doForney(int[] nArray, int n, int n2, int[] nArray2, int[] nArray3, int[] nArray4) {
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = nArray2[i];
            int n5 = 255 - galois.toLog(n4);
            int n6 = nArray4[0];
            for (n3 = 1; n3 < n2; ++n3) {
                n6 ^= galois.mulExp(nArray4[n3], n5 * n3 % 255);
            }
            n3 = nArray3[1];
            for (int j = 2; j < n2; j += 2) {
                n3 ^= galois.mulExp(nArray3[j + 1], n5 * j % 255);
            }
            int n7 = galois.toPos(n, n4);
            nArray[n7] = nArray[n7] ^ galois.mul(n4, galois.div(n6, n3));
        }
    }

    public int decode(int[] nArray, int n, boolean bl) {
        if (n < this.npar || n > 255) {
            return -1;
        }
        int[] nArray2 = new int[this.npar];
        if (galois.calcSyndrome(nArray, n, nArray2)) {
            return 0;
        }
        int[] nArray3 = new int[this.npar / 2 + 2];
        int[] nArray4 = new int[this.npar / 2 + 1];
        int n2 = this.calcSigmaMBM(nArray3, nArray4, nArray2);
        if (n2 <= 0) {
            return -2;
        }
        int[] nArray5 = new int[n2];
        int n3 = this.chienSearch(nArray5, n, n2, nArray3);
        if (n3 < 0) {
            return n3;
        }
        if (!bl) {
            this.doForney(nArray, n, n2, nArray5, nArray3, nArray4);
        }
        return n2;
    }

    public int decode(int[] nArray, int n) {
        return this.decode(nArray, n, false);
    }

    public int decode(int[] nArray) {
        return this.decode(nArray, nArray.length, false);
    }
}

