/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.geom;

import jp.sourceforge.qrcode.geom.Point;
import jp.sourceforge.qrcode.util.QRCodeUtility;

public class Line {
    int x1;
    int y1;
    int x2;
    int y2;

    public Line() {
        this.y2 = 0;
        this.x2 = 0;
        this.y1 = 0;
        this.x1 = 0;
    }

    public Line(int n, int n2, int n3, int n4) {
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
    }

    public Line(Point point, Point point2) {
        this.x1 = point.getX();
        this.y1 = point.getY();
        this.x2 = point2.getX();
        this.y2 = point2.getY();
    }

    public Point getP1() {
        return new Point(this.x1, this.y1);
    }

    public Point getP2() {
        return new Point(this.x2, this.y2);
    }

    public void setLine(int n, int n2, int n3, int n4) {
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
    }

    public void setP1(Point point) {
        this.x1 = point.getX();
        this.y1 = point.getY();
    }

    public void setP1(int n, int n2) {
        this.x1 = n;
        this.y1 = n2;
    }

    public void setP2(Point point) {
        this.x2 = point.getX();
        this.y2 = point.getY();
    }

    public void setP2(int n, int n2) {
        this.x2 = n;
        this.y2 = n2;
    }

    public void translate(int n, int n2) {
        this.x1 += n;
        this.y1 += n2;
        this.x2 += n;
        this.y2 += n2;
    }

    public static boolean isNeighbor(Line line, Line line2) {
        return Math.abs(line.getP1().getX() - line2.getP1().getX()) < 2 && Math.abs(line.getP1().getY() - line2.getP1().getY()) < 2 && Math.abs(line.getP2().getX() - line2.getP2().getX()) < 2 && Math.abs(line.getP2().getY() - line2.getP2().getY()) < 2;
    }

    public boolean isHorizontal() {
        return this.y1 == this.y2;
    }

    public boolean isVertical() {
        return this.x1 == this.x2;
    }

    public static boolean isCross(Line line, Line line2) {
        return line.isHorizontal() && line2.isVertical() ? line.getP1().getY() > line2.getP1().getY() && line.getP1().getY() < line2.getP2().getY() && line2.getP1().getX() > line.getP1().getX() && line2.getP1().getX() < line.getP2().getX() : line.isVertical() && line2.isHorizontal() && line.getP1().getX() > line2.getP1().getX() && line.getP1().getX() < line2.getP2().getX() && line2.getP1().getY() > line.getP1().getY() && line2.getP1().getY() < line.getP2().getY();
    }

    public Point getCenter() {
        int n = (this.x1 + this.x2) / 2;
        int n2 = (this.y1 + this.y2) / 2;
        return new Point(n, n2);
    }

    public int getLength() {
        int n = Math.abs(this.x2 - this.x1);
        int n2 = Math.abs(this.y2 - this.y1);
        int n3 = QRCodeUtility.sqrt(n * n + n2 * n2);
        return n3;
    }

    public static Line getLongest(Line[] lineArray) {
        Line line = new Line();
        for (int i = 0; i < lineArray.length; ++i) {
            if (lineArray[i].getLength() <= line.getLength()) continue;
            line = lineArray[i];
        }
        return line;
    }

    public String toString() {
        return "(" + this.x1 + "," + this.y1 + ")-(" + this.x2 + "," + this.y2 + ")";
    }
}

