/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.geom;

import jp.sourceforge.qrcode.geom.Point;
import jp.sourceforge.qrcode.reader.QRCodeImageReader;

public class Axis {
    int sin;
    int cos;
    int modulePitch;
    Point origin;

    public Axis(int[] nArray, int n) {
        this.sin = nArray[0];
        this.cos = nArray[1];
        this.modulePitch = n;
        this.origin = new Point();
    }

    public void setOrigin(Point point) {
        this.origin = point;
    }

    public void setModulePitch(int n) {
        this.modulePitch = n;
    }

    public Point translate(Point point) {
        int n = point.getX();
        int n2 = point.getY();
        return this.translate(n, n2);
    }

    public Point translate(Point point, Point point2) {
        this.setOrigin(point);
        int n = point2.getX();
        int n2 = point2.getY();
        return this.translate(n, n2);
    }

    public Point translate(Point point, int n, int n2) {
        this.setOrigin(point);
        return this.translate(n, n2);
    }

    public Point translate(Point point, int n, int n2, int n3) {
        this.setOrigin(point);
        this.modulePitch = n;
        return this.translate(n2, n3);
    }

    public Point translate(int n, int n2) {
        long l = QRCodeImageReader.DECIMAL_POINT;
        Point point = new Point();
        int n3 = n == 0 ? 0 : this.modulePitch * n >> (int)l;
        int n4 = n2 == 0 ? 0 : this.modulePitch * n2 >> (int)l;
        point.translate(n3 * this.cos - n4 * this.sin >> (int)l, n3 * this.sin + n4 * this.cos >> (int)l);
        point.translate(this.origin.getX(), this.origin.getY());
        return point;
    }
}

