import anydbm
import datetime

class FixDate:
    def __init__(self, config, environ):
        dbpath = config.setdefault("path", None)
        if not dbpath:
            self.db = {}
        else:
            self.db = anydbm.open(dbpath, "c")

    def execute(self, content):
        now = datetime.datetime.now().timetuple()
        for entry in content["entries"]:
            link = entry["link"]
            dt = self.db.setdefault("link", now)
            entry["parsed_updated"] = dt
            
        return content



def create(config, environ):
    return FixDate(config, environ)
