/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.petitroyal;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.petitroyal.MakeBodyHtml;
import zephyr.util.ZephyrUtil;

public class MakeMorphHtml {
    private static final String MORPH_REGEXP = "<span class='cjw'>[^<]+</span><span class='cjb'>(.+?)</span>.*?<span class='cjt'>([^<]+)</span>";
    private static final Pattern MORPH = Pattern.compile("<span class='cjw'>[^<]+</span><span class='cjb'>(.+?)</span>.*?<span class='cjt'>([^<]+)</span>");

    private String morphTxt(String string, String string2) {
        Matcher matcher = MORPH.matcher(string);
        if (matcher.find()) {
            String string3 = matcher.group(2).replace("\uff0f", " / ");
            return String.format("<a href=\"items.html#%s\">%s</a> %s", string2, matcher.group(1), string3);
        }
        return "";
    }

    public void loadConjuIndices(String string) throws Exception {
        Class.forName("org.sqlite.JDBC");
        Connection connection = DriverManager.getConnection("jdbc:sqlite:" + string);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select key1,key2,item_id,html from conju_indices;");
        System.out.println("<html><body>");
        int n = 0;
        while (resultSet.next()) {
            String string2 = resultSet.getString("html");
            if (string2.isEmpty()) continue;
            String string3 = resultSet.getString("key1");
            String string4 = resultSet.getString("key2");
            String string5 = string4.isEmpty() ? string3 : string4;
            String string6 = resultSet.getString("item_id");
            System.out.print("<dt>");
            System.out.print(string5);
            System.out.print("</dt><dd>");
            String string7 = this.morphTxt(string2, string6);
            if (string7.trim().isEmpty()) {
                System.err.println("\tdd is empty: " + string5);
            }
            System.out.print(string7);
            System.out.println("</dd>");
            if (++n % 10000 != 0) continue;
            System.err.print(".");
        }
        System.out.println("</body></html>");
        resultSet.close();
        connection.close();
        System.err.println();
        System.err.println("done. " + n + " entries");
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length == 0 ? "petit.sql" : stringArray[0];
        MakeBodyHtml.checkDBFile(string);
        MakeMorphHtml makeMorphHtml = new MakeMorphHtml();
        try {
            ZephyrUtil.setUTF8Ouput();
            makeMorphHtml.loadConjuIndices(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

