/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.petitroyal;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.UTF8toSJIS;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final String CONJU_HEADER_REGEXP = "id='conjuBtn' value='\u6d3b\u7528\u8868' onClick=\"showCTable\\('(.+?)'\\)\"";
    private static final Pattern CONJU_HEADER = Pattern.compile("id='conjuBtn' value='\u6d3b\u7528\u8868' onClick=\"showCTable\\('(.+?)'\\)\"");
    private final LinkedList<String> invConj = new LinkedList();
    private static final String MIDASI_REGEXP = "<td class='midasi' name='top'><span class='mid' id='[0-9]+'>(.+)</span>";
    private static final Pattern MIDASI = Pattern.compile("<td class='midasi' name='top'><span class='mid' id='[0-9]+'>(.+)</span>");
    private static final String[][] RANK_FIX = new String[21][2];
    private static final String ITEM_REGEXP = "<tr><td><span class=[\"']mid[\"'] rank=[\"']([0-9]+)[\"']>(.*)</td></tr>";
    private static final Pattern ITEM;

    private String fixItem(String string) {
        String[][] stringArrayArray = new String[][]{{"\n", " "}, {"<span class='stm'>\u00e9\u306e<\u306e\u8a18\u53f7</span>", "<span class='stm'>\u00e9\u306e\u02ca\u306e\u8a18\u53f7</span>"}, {"<td colspan='3' class='kju'>\u25c6\u6bcd\u97f3\u307e\u305f\u306f\u7121\u97f3\u306e\uff48\u3067\u59cb\u307e\u308b\u7537\u6027\u5358\u6570\u540d\u8a5e\u306e\u524d\u3067\u306fcet\u3092\u7528\u3044\uff0c\u30ea\u30a8\u30be\u30f3\u3059\u308b</span></td>", "<td colspan='3' class='kju'>\u25c6\u6bcd\u97f3\u307e\u305f\u306f\u7121\u97f3\u306e\uff48\u3067\u59cb\u307e\u308b\u7537\u6027\u5358\u6570\u540d\u8a5e\u306e\u524d\u3067\u306fcet\u3092\u7528\u3044\uff0c\u30ea\u30a8\u30be\u30f3\u3059\u308b</td>"}, {"<span class='gng'>\u65b0\u3057\u3044\u91d8\u304c\u53e4\u3044\u91d8\u3092\u62bc\u3057\u51fa\u3059</span></td></tr>", "<span class='gng'>\u65b0\u3057\u3044\u91d8\u304c\u53e4\u3044\u91d8\u3092\u62bc\u3057\u51fa\u3059</span></td></tr></td></tr></table></td></tr>"}, {"<span class='yri'>semelles <i>compensees<</i></span>", "<span class='yri'>semelles <i>compensees</i></span>"}, {"&copy;", "\u00a9"}, {"<b>\u4fa1\u5024</b>\u3092\u4e0b\u3052\u308b&</span>", "<b>\u4fa1\u5024</b>\u3092\u4e0b\u3052\u308b</span>"}, {"\uff08\uff1d\u6d3b\u7528de<clinaison\uff09", "\uff08\uff1d\u6d3b\u7528declinaison\uff09"}, {"<table class='hyou'>  <tt>", "<table class='hyou'>  <tr>"}, {"desquelles</span></td></tr></td></tr></table></span></td></tr>", "desquelles</td></tr></table></span></td></tr>"}, {"<span class='yry'>\u7db4\u308a\u5b57\u8a18\u53f7</span> \u02ca  \u02cb \u02c6  \u0308 \u306a\u3069</span>", "<span class='yry'>\u7db4\u308a\u5b57\u8a18\u53f7</span> \u02ca  \u02cb \u02c6  \u0308 \u306a\u3069"}, {"<br>", "<br/>"}, {"<td>son <span class='phn'>s\u0254\u0303 \u30bd<span class='skan'>\u30f3</span></td>", "<td>son <span class='phn'>s\u0254\u0303 \u30bd</span><span class='skan'>\u30f3</span></td>"}, {"<span class='phn'>se-za-mi</span></span>  </td></tr></table></span></td></tr><tr><td>", "<span class='phn'>se-za-mi</span></td></tr></table></span></td></tr><tr><td>"}, {"<span class='ykg'>$\u6fc0\u3057\u3044\u82e6\u75db&</span>", "<span class='ykg'>\u6fc0\u3057\u3044\u82e6\u75db</span>"}, {"<td>ton <span class='phn'>t\u0254\u0303 \u30c8<span class='skan'>\u30f3</span></td>", "<td>ton <span class='phn'>t\u0254\u0303 \u30c8</span><span class='skan'>\u30f3</span></td>"}, {"<span class='phn'>tut</span>\u3068\u306a\u308b</span><br />", "<span class='phn'>tut</span>\u3068\u306a\u308b</td></tr></table></span><br />"}, {"<span class='phn'>tuz</span>\u3068\u306a\u308b</span><br />\u25c6tous\u304c\u4ee3\u540d\u8a5e\u306e\u3068\u304d\u306f\u5e38\u306b<span class='phn'>tus</span>\u3068\u767a\u97f3\u3059\u308b</td></tr></table></span><span class='rsm'></span></td></tr>", "<span class='phn'>tuz</span>\u3068\u306a\u308b<br />\u25c6tous\u304c\u4ee3\u540d\u8a5e\u306e\u3068\u304d\u306f\u5e38\u306b<span class='phn'>tus</span>\u3068\u767a\u97f3\u3059\u308b</td></tr><span class='rsm'></span>"}, {"<td>un <span class='phn'>\u0153\u0303 \u30a2<span class='skan'>\u30f3</span></td>", "<td>un <span class='phn'>\u0153\u0303 \u30a2</span><span class='skan'>\u30f3</span></td>"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            string = string.replace(stringArrayArray[i][0], stringArrayArray[i][1]);
        }
        return string;
    }

    private String conjuRef(String string, String string2) throws Exception {
        Matcher matcher = CONJU_HEADER.matcher(string2);
        if (matcher.find()) {
            String string3 = matcher.group(1);
            if (string3.matches("[A-Z][0-9]+")) {
                return "<conju>" + string3 + "</conju>";
            }
            String string4 = string.replaceAll("<.+?>", "").replaceAll(",.*$", "");
            string4 = UTF8toSJIS.convert(string4);
            this.invConj.add(string4);
            return "";
        }
        return "";
    }

    private String getHead(String string) {
        int n = string.startsWith("<span ") ? string.indexOf("</span>") + "</span>".length() : 0;
        if ((n = string.indexOf("</span>", n)) > 0) {
            return string.substring(0, n);
        }
        System.err.println("ERROR: cannot find head: " + string);
        return "###";
    }

    private String auxMidasi(String string) {
        String[] stringArray;
        Matcher matcher = MIDASI.matcher(string);
        if (matcher.find() && (stringArray = matcher.group(1).split(", *")).length > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("<key type=\"\u8868\u8a18\">");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("</key>");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public void loadItems(String string) throws Exception {
        Class.forName("org.sqlite.JDBC");
        Connection connection = DriverManager.getConnection("jdbc:sqlite:" + string);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select id,header,html from items;");
        System.out.println("<html><body>");
        int n = 0;
        while (resultSet.next()) {
            String string2 = resultSet.getString("id");
            String string3 = resultSet.getString("html");
            String string4 = resultSet.getString("header");
            Matcher matcher = ITEM.matcher(string3);
            if (matcher.find()) {
                String string5;
                int n2 = Integer.parseInt(matcher.group(1));
                String string6 = this.getHead(matcher.group(2));
                String string7 = this.fixItem(string3);
                int n3 = string7.indexOf(string5 = ">" + string6 + "</span>");
                if (n3 >= 0) {
                    string7 = string7.substring(0, n3) + "></span>" + string7.substring(n3 + string5.length());
                }
                System.out.print("<dt id=\"");
                System.out.print(string2);
                System.out.print("\">");
                System.out.print(RANK_FIX[n2][0]);
                System.out.print(string6);
                System.out.print(RANK_FIX[n2][1]);
                System.out.print("</dt>");
                System.out.print(this.auxMidasi(string4));
                System.out.print("<dd>");
                System.out.print(this.conjuRef(string6, string4));
                System.out.print(string7);
                System.out.println("</dd>");
                if (++n % 1000 != 0) continue;
                System.err.print(".");
                continue;
            }
            System.err.println("ERROR: " + string3);
        }
        System.out.println("</body></html>");
        resultSet.close();
        connection.close();
        System.err.println();
        System.err.println("done. " + n + " entries");
        if (!this.invConj.isEmpty()) {
            System.err.print("WARN: invalid conju id :");
            for (String string3 : this.invConj) {
                System.err.print(" " + string3);
            }
            System.err.println();
        }
    }

    static void checkDBFile(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            System.err.println("**************************");
            System.err.println("ERROR: cannot find " + string);
            System.err.println("**************************");
            System.exit(1);
        }
        if (file.length() == 0L) {
            System.err.println("**************************");
            System.err.println("ERROR: invalid " + string + ", size=0");
            System.err.println("**************************");
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length == 0 ? "petit.sql" : stringArray[0];
        MakeBodyHtml.checkDBFile(string);
        MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
        try {
            ZephyrUtil.setUTF8Ouput();
            makeBodyHtml.loadItems(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        MakeBodyHtml.RANK_FIX[20][0] = "<b>*** ";
        MakeBodyHtml.RANK_FIX[20][1] = "</b>";
        MakeBodyHtml.RANK_FIX[10][0] = "<b>** ";
        MakeBodyHtml.RANK_FIX[10][1] = "</b>";
        MakeBodyHtml.RANK_FIX[11][0] = "<b>* ";
        MakeBodyHtml.RANK_FIX[11][1] = "</b>";
        MakeBodyHtml.RANK_FIX[12][0] = "<b>";
        MakeBodyHtml.RANK_FIX[12][1] = "</b>";
        MakeBodyHtml.RANK_FIX[0][0] = "<b>";
        MakeBodyHtml.RANK_FIX[0][1] = "</b>";
        MakeBodyHtml.RANK_FIX[13][0] = "";
        MakeBodyHtml.RANK_FIX[13][1] = "";
        ITEM = Pattern.compile(ITEM_REGEXP);
    }
}

