/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.kangorin;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import zephyr.util.ImageConverter;

public class MakeImages {
    private static final int BLKSIZE = 2048;
    private static final int MAX_IMAGE_SIZE = 0x100000;
    private final byte[] header = new byte[8];
    private final byte[] buffer = new byte[0x100000];
    public static final Pattern SINGLE_IMAGE = Pattern.compile("<1F4D><0000><0000><x=0,y=0><w=0,h=0>\\[0*([0-9A-F]+):0*([0-9A-F]+)\\]([^<]*)<1F6D>");
    private File tmpFile;

    private int byte2int(byte by) {
        return by & 0xFF;
    }

    private void makeImage(RandomAccessFile randomAccessFile, int n, File file, int n2) throws Exception {
        randomAccessFile.seek(n);
        int n3 = randomAccessFile.read(this.header, 0, this.header.length);
        if (n3 != this.header.length) {
            System.err.printf("cannot read header from %X\n", n);
            return;
        }
        if (this.header[0] != 100 || this.header[1] != 97 || this.header[2] != 116 || this.header[3] != 97) {
            System.err.printf("invalid header at %X\n", n);
            return;
        }
        int n4 = (this.byte2int(this.header[7]) << 24) + (this.byte2int(this.header[6]) << 16) + (this.byte2int(this.header[5]) << 8) + this.byte2int(this.header[4]);
        randomAccessFile.seek(n + this.header.length);
        n3 = randomAccessFile.read(this.buffer, 0, n4);
        if (n3 != n4) {
            System.err.printf("cannot read filedata from %X\n", n);
            return;
        }
        if (n2 == 100) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.buffer, 0, n4);
            fileOutputStream.close();
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.tmpFile);
        fileOutputStream.write(this.buffer, 0, n4);
        fileOutputStream.close();
        BufferedImage bufferedImage = ImageIO.read(this.tmpFile);
        int n5 = n2 * bufferedImage.getWidth() / 100;
        int n6 = n2 * bufferedImage.getHeight() / 100;
        BufferedImage bufferedImage2 = ImageConverter.resize(bufferedImage, n5, n6);
        ImageIO.write((RenderedImage)bufferedImage2, "bmp", file);
    }

    private static int calcPos(String string, String string2) {
        return (Integer.parseInt(string, 16) - 1) * 2048 + Integer.parseInt(string2, 16);
    }

    private static String pos2filename(int n) {
        return String.format("%08X.bmp", n);
    }

    public static String pos2filename(String string, String string2) {
        return MakeImages.pos2filename(MakeImages.calcPos(string, string2));
    }

    private void load(File file, File file2, File file3, int n) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "Windows-31J"));
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "r");
        file3.mkdirs();
        this.tmpFile = new File(file3, "original.bmp");
        int n2 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = SINGLE_IMAGE.matcher(string);
            if (!matcher.find()) continue;
            int n3 = MakeImages.calcPos(matcher.group(1), matcher.group(2));
            File file4 = new File(file3, MakeImages.pos2filename(n3));
            this.makeImage(randomAccessFile, n3, file4, n);
            if (++n2 % 100 != 0) continue;
            if (n2 % 1000 == 0) {
                System.err.print(n2 / 1000);
                continue;
            }
            System.err.print(".");
        }
        this.tmpFile.delete();
        randomAccessFile.close();
        bufferedReader.close();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : "kangorin.txt";
        String string2 = stringArray.length > 1 ? stringArray[1] : "HONMON";
        String string3 = stringArray.length > 2 ? stringArray[2] : "g";
        int n = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : 100;
        MakeImages makeImages = new MakeImages();
        makeImages.load(new File(string), new File(string2), new File(string3), n);
    }
}

