/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanseido.teniwoha;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import zephyr.sanseido.teniwoha.TatePositionComparator;

public class PDF2Text
extends PDFTextStripper {
    private static final TatePositionComparator POS_COMP = new TatePositionComparator();

    private LinkedList<TextPosition>[] divideParts() {
        LinkedList[] linkedListArray = new LinkedList[4];
        for (int i = 0; i < linkedListArray.length; ++i) {
            linkedListArray[i] = new LinkedList();
        }
        List list = this.getCharactersByArticle();
        for (List list2 : list) {
            for (TextPosition textPosition : list2) {
                float f = textPosition.getYDirAdj() - textPosition.getHeightDir();
                int n = TatePositionComparator.getYPart(f);
                if (1 > n || n > 4) continue;
                linkedListArray[n - 1].add(textPosition);
            }
        }
        return linkedListArray;
    }

    public void processPage(PDPage pDPage) throws IOException {
        super.processPage(pDPage);
        int n = this.getCurrentPageNo();
        if (n < this.getStartPage() || this.getEndPage() < n) {
            return;
        }
        System.err.print(n + " ");
        LinkedList<TextPosition>[] linkedListArray = this.divideParts();
        for (int i = 0; i < linkedListArray.length; ++i) {
            System.out.println("-----------------------");
            LinkedList<TextPosition> linkedList = linkedListArray[i];
            Collections.sort(linkedList, POS_COMP);
            for (TextPosition textPosition : linkedList) {
                String string = textPosition.toString().trim();
                if (string.length() == 0) continue;
                float f = textPosition.getYDirAdj() - textPosition.getHeightDir();
                int n2 = TatePositionComparator.getYTopMargin(i + 1, f);
                if (n2 <= 8) {
                    System.out.println();
                    System.out.print("\u2605\u3000");
                }
                System.out.print(textPosition.toString());
            }
            System.out.println();
        }
        System.out.println();
        System.out.println();
        System.out.println();
    }

    private void load(String string, int n, int n2) throws Exception {
        PDDocument pDDocument = PDDocument.load((File)new File(string));
        this.setStartPage(n);
        this.setEndPage(n2);
        this.getText(pDDocument);
        pDDocument.close();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : "sample.pdf";
        int n = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 1;
        int n2 = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : Integer.MAX_VALUE;
        PDF2Text pDF2Text = new PDF2Text();
        pDF2Text.load(string, n, n2);
    }
}

