/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.jpcollo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.UTF8toSJIS;

public class MakeBodyHtml {
    private static final Pattern GAIJI = Pattern.compile("<span style=\"display:none;\">\u2606\u2606\u2606\u5916\u5b57\uff1a(.+?)</span>");

    private String normalize(String string) {
        string = string.replace("<p class=\"moji-down\">", "");
        string = string.replace("</p>", "");
        string = string.replace("<br>", "");
        string = string.replaceAll("<a.+?>(.*?)</a>", "$1");
        string = string.replaceAll("<img src=\"1.png\".*?>", "\u3010\u4f8b\u6587\u3011");
        string = string.replaceAll("<img src=\"2.png\".*?>", "\u3010\u5408\u6210\u8a9e\u3011");
        string = string.replaceAll("<img src=\"3.png\".*?>", "\u3010\u6163\u7528\u53e5\u3011");
        string = string.replaceAll("<img src=\"4.png\".*?>", "\u3010\u8a9e\u7fa9\u3011");
        string = string.replaceAll("<img src=\"5.png\".*?>", "\u3010\u540d\u8a5e\u3011");
        string = string.replaceAll("<img .*?>", "");
        string = string.replaceAll("<div class=\"midashi\">(.+?)</div>", "<dt>$1</dt>");
        string = string.replaceAll("<div.+?style=\"margin-left:2.000000em;\">", "\u3000");
        string = string.replaceAll("<div.+?>", "");
        string = string.replace("</div>", "");
        string = string.replaceAll("<span class=\"hankaku\">(.*?)</span>", "$1");
        string = string.replace("<ruby class=\"ruby7\">", "<ruby>");
        string = string.replace("<rb class=\"rb7\">", "<rb>");
        string = string.replace("<rt class=\"rt7\">", "<rt>");
        string = string.replaceAll("<rp .+?>.+?</rp>", "");
        string = UTF8toSJIS.hex2uni(string);
        string = this.gaijiFix(string);
        return string;
    }

    private String gaijiFix(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        Matcher matcher = GAIJI.matcher(string);
        int n = 0;
        while (matcher.find()) {
            if (n < matcher.start()) {
                stringBuffer.append(string.substring(n, matcher.start()));
            }
            switch (matcher.group(1)) {
                case "b135": {
                    stringBuffer.append("<b>(21)</b>");
                    break;
                }
                case "b136": {
                    stringBuffer.append("<b>(22)</b>");
                    break;
                }
                case "b137": {
                    stringBuffer.append("<b>(23)</b>");
                    break;
                }
                case "b138": {
                    stringBuffer.append("<b>(24)</b>");
                    break;
                }
                default: {
                    System.err.println(matcher.group());
                    System.exit(1);
                }
            }
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private void parse(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        boolean bl = false;
        System.out.println("<html><body>");
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).isEmpty() || string2.equals("<br>")) continue;
            if (string2.startsWith("<html>") || string2.startsWith("</body>")) {
                bl = true;
                continue;
            }
            if (bl) {
                if (!string2.startsWith("<div class=\"midashi\">")) continue;
                bl = false;
            }
            if ((string2 = this.normalize(string2)).isEmpty()) continue;
            if (string2.startsWith("<dt>")) {
                System.out.println(string2);
                continue;
            }
            System.out.println("<p>" + string2 + "</p>");
        }
        System.out.println("</body></html>");
        bufferedReader.close();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : "body.txt";
        MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
        makeBodyHtml.parse(string);
    }
}

