/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class UTF8toSJIS {
    private static final TreeSet<Character> extChSet = new TreeSet();
    private static final HashMap<Integer, String> extFixMap = new HashMap();
    private static final String UNICODE_REGEXP = "unicode=\"#x([^\"]*)\"";
    private static final Pattern convpat;
    private HashSet<Integer> gaijiUniSet = new HashSet();

    private static void addExtFix(char c, String string) {
        extFixMap.put(Integer.valueOf(c), string);
    }

    private static String kuromarunum(int n) {
        return Integer.toString(n);
    }

    private static String siromarunum(int n) {
        return Integer.toString(n);
    }

    private static String parnum(int n) {
        return "(" + n + ")";
    }

    static String code2hex(char c) {
        return String.format("&#x%x;", c);
    }

    private static void addExtFixAsHex(char c) {
        UTF8toSJIS.addExtFix(c, UTF8toSJIS.code2hex(c));
    }

    private static void addExtFix(char c) {
        UTF8toSJIS.addExtFix(c, Character.toString(c));
    }

    public static String convert(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            String string2 = extFixMap.get(n);
            if (string2 != null) {
                stringBuffer.append(string2);
                continue;
            }
            if (n >= 65280 || 913 <= n && n <= 969) {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (128 <= n && n < 1024 || 1280 <= n && n < 12288 || 57344 <= n) {
                stringBuffer.append(String.format("&#x%x;", n));
                extChSet.add(Character.valueOf(string.charAt(i)));
                continue;
            }
            if (n == 12316) {
                stringBuffer.append('\uff5e');
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private void output(String string) {
        System.out.println(string);
    }

    private void convert(String[] stringArray) throws Exception {
        String string;
        InputStream inputStream = stringArray.length > 0 && !stringArray[0].equals("-") ? new FileInputStream(new File(stringArray[0])) : System.in;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        while ((string = bufferedReader.readLine()) != null) {
            this.output(UTF8toSJIS.convert(string));
        }
    }

    private void loadGaijiMap(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = convpat.matcher(string2);
            if (!matcher.find()) continue;
            int n = Integer.parseInt(matcher.group(1), 16);
            this.gaijiUniSet.add(n);
        }
    }

    private void checkExtChSet(String[] stringArray) throws Exception {
        String string = "../../ebwin/GaijiMap.xml";
        if (stringArray.length >= 3) {
            string = stringArray[2].equals("arabic") ? "../../ebwin/ArabicGaijiMap.xml" : (stringArray[2].equals("sanskrit") ? "../../ebwin/SanskritGaijiMap.xml" : stringArray[2]);
        }
        this.loadGaijiMap(string);
        for (Character c : extChSet.toArray(new Character[0])) {
            char c2 = c.charValue();
            if (this.gaijiUniSet.contains(c2)) continue;
            String string2 = String.format("&#x%04X=%c is not in %s", c2, c, string);
            System.err.println("WARN: " + string2);
        }
    }

    public static void main(String[] stringArray) {
        ZephyrUtil.setShiftJisOuput();
        try {
            UTF8toSJIS uTF8toSJIS = new UTF8toSJIS();
            uTF8toSJIS.convert(stringArray);
            if (stringArray.length >= 2 && stringArray[1].equals("check")) {
                uTF8toSJIS.checkExtChSet(stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        UTF8toSJIS.addExtFix('\u278a', UTF8toSJIS.kuromarunum(1));
        UTF8toSJIS.addExtFix('\u278b', UTF8toSJIS.kuromarunum(2));
        UTF8toSJIS.addExtFix('\u278c', UTF8toSJIS.kuromarunum(3));
        UTF8toSJIS.addExtFix('\u278d', UTF8toSJIS.kuromarunum(4));
        UTF8toSJIS.addExtFix('\u278e', UTF8toSJIS.kuromarunum(5));
        UTF8toSJIS.addExtFix('\u278f', UTF8toSJIS.kuromarunum(6));
        UTF8toSJIS.addExtFix('\u2790', UTF8toSJIS.kuromarunum(7));
        UTF8toSJIS.addExtFix('\u2791', UTF8toSJIS.kuromarunum(8));
        UTF8toSJIS.addExtFix('\u2792', UTF8toSJIS.kuromarunum(9));
        UTF8toSJIS.addExtFix('\u2793', UTF8toSJIS.kuromarunum(10));
        UTF8toSJIS.addExtFix('\u24eb', UTF8toSJIS.kuromarunum(11));
        UTF8toSJIS.addExtFix('\u24ec', UTF8toSJIS.kuromarunum(12));
        UTF8toSJIS.addExtFix('\u24ed', UTF8toSJIS.kuromarunum(13));
        UTF8toSJIS.addExtFix('\u24ee', UTF8toSJIS.kuromarunum(14));
        UTF8toSJIS.addExtFix('\u24ef', UTF8toSJIS.kuromarunum(15));
        UTF8toSJIS.addExtFix('\u24f0', UTF8toSJIS.kuromarunum(16));
        UTF8toSJIS.addExtFix('\u24f1', UTF8toSJIS.kuromarunum(17));
        UTF8toSJIS.addExtFix('\u24f2', UTF8toSJIS.kuromarunum(18));
        UTF8toSJIS.addExtFix('\u24f3', UTF8toSJIS.kuromarunum(19));
        UTF8toSJIS.addExtFix('\u24f4', UTF8toSJIS.kuromarunum(20));
        UTF8toSJIS.addExtFix('\u2460', UTF8toSJIS.siromarunum(1));
        UTF8toSJIS.addExtFix('\u2461', UTF8toSJIS.siromarunum(2));
        UTF8toSJIS.addExtFix('\u2462', UTF8toSJIS.siromarunum(3));
        UTF8toSJIS.addExtFix('\u2463', UTF8toSJIS.siromarunum(4));
        UTF8toSJIS.addExtFix('\u2464', UTF8toSJIS.siromarunum(5));
        UTF8toSJIS.addExtFix('\u2465', UTF8toSJIS.siromarunum(6));
        UTF8toSJIS.addExtFix('\u2466', UTF8toSJIS.siromarunum(7));
        UTF8toSJIS.addExtFix('\u2467', UTF8toSJIS.siromarunum(8));
        UTF8toSJIS.addExtFix('\u2469', UTF8toSJIS.siromarunum(10));
        UTF8toSJIS.addExtFix('\u246a', UTF8toSJIS.siromarunum(11));
        UTF8toSJIS.addExtFix('\u2471', UTF8toSJIS.siromarunum(18));
        UTF8toSJIS.addExtFix('\u2474', UTF8toSJIS.parnum(1));
        UTF8toSJIS.addExtFix('\u2475', UTF8toSJIS.parnum(2));
        UTF8toSJIS.addExtFix('\u2476', UTF8toSJIS.parnum(3));
        UTF8toSJIS.addExtFix('\u2477', UTF8toSJIS.parnum(4));
        UTF8toSJIS.addExtFix('\u2478', UTF8toSJIS.parnum(5));
        UTF8toSJIS.addExtFix('\u2479', UTF8toSJIS.parnum(6));
        UTF8toSJIS.addExtFix('\u247a', UTF8toSJIS.parnum(7));
        UTF8toSJIS.addExtFixAsHex('\u3016');
        UTF8toSJIS.addExtFixAsHex('\u3017');
        UTF8toSJIS.addExtFixAsHex('\u25b7');
        UTF8toSJIS.addExtFix('\u2192');
        UTF8toSJIS.addExtFix('\u2190');
        UTF8toSJIS.addExtFix('\u2191');
        UTF8toSJIS.addExtFix('\u2193');
        UTF8toSJIS.addExtFix('\u21d4');
        UTF8toSJIS.addExtFix('\u21d2');
        UTF8toSJIS.addExtFix('\u2605');
        UTF8toSJIS.addExtFix('\u25b3');
        UTF8toSJIS.addExtFix('\u25bd');
        UTF8toSJIS.addExtFix('\u25c6');
        UTF8toSJIS.addExtFix('\u25bc');
        UTF8toSJIS.addExtFix('\u25c7');
        UTF8toSJIS.addExtFix('\u25cb');
        UTF8toSJIS.addExtFix('\u25cf');
        UTF8toSJIS.addExtFix('\u2640');
        UTF8toSJIS.addExtFix('\u2642');
        UTF8toSJIS.addExtFix('\u266d');
        UTF8toSJIS.addExtFix('\u266f');
        UTF8toSJIS.addExtFix('\u2010');
        UTF8toSJIS.addExtFix('\u2015');
        UTF8toSJIS.addExtFix('\u2501');
        UTF8toSJIS.addExtFix('\u2103');
        UTF8toSJIS.addExtFix('\u226a');
        UTF8toSJIS.addExtFix('\uff3b');
        UTF8toSJIS.addExtFix('\uff3d');
        UTF8toSJIS.addExtFix('\u2026');
        UTF8toSJIS.addExtFix('\u221a');
        UTF8toSJIS.addExtFix('\u3010');
        UTF8toSJIS.addExtFix('\u3011');
        convpat = Pattern.compile(UNICODE_REGEXP);
    }
}

