/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusya.lajp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.AppendJPKeys;
import zephyr.util.MultiHashMap;
import zephyr.util.ZephyrUtil;

public class MakeJpLaBodyHtml {
    private final HashMap<String, Integer> latinIdMap = new HashMap();
    private static final String DT_ID_REGEXP = "<dt id=\"([0-9]+)\">(.+?)</dt>";
    private static final Pattern DT_ID = Pattern.compile("<dt id=\"([0-9]+)\">(.+?)</dt>");
    private static final String[] TAGNAMES = new String[]{"a", "href"};
    private static final String MIDASHI_START = "\u898b\u3060\u3057\u958b\u59cb";
    private static final String MIDASHI_END = "\u898b\u3060\u3057\u7d42\u4e86";
    private static final String ENTRY_DELIM = "======";
    private MultiHashMap<String, String> kanaMap = new MultiHashMap();
    private static final String NAKAGURO_HALF = "\uff65";
    private static final String NAKAGURO_FULL = "\u30fb";
    private final LinkedList<String> entries = new LinkedList();
    private final HashMap<String, Integer> dtIdMap = new HashMap();
    private static final String JPREF_REGEXP = "(\u21d2(.+?)\uff0e)|(\\(\uff1d(.+?)\\))";
    private static final Pattern JPREF = Pattern.compile("(\u21d2(.+?)\uff0e)|(\\(\uff1d(.+?)\\))");
    private static final String JPREFWORD_REGEXP = "([^, ]+)";
    private static final Pattern JPREFWORD = Pattern.compile("([^, ]+)");
    private static final String LAREF_REGEXP = "([a-zA-Z]+)";
    private static final Pattern LAREF = Pattern.compile("([a-zA-Z]+)");
    private static final String PARA_REGEXP = "<p>(.+?)</p>";
    private static final Pattern PARA = Pattern.compile("<p>(.+?)</p>");

    private void loadLAJPBody(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = DT_ID.matcher(string2);
            if (!stringArray.find()) continue;
            String string3 = stringArray.group(2);
            Integer n2 = Integer.parseInt(stringArray.group(1));
            for (String string4 : string3.split(", *")) {
                String string5 = ZephyrUtil.makeKey(ZephyrUtil.hex2uni(string4), true).toLowerCase();
                if (this.latinIdMap.containsKey(string5)) continue;
                this.latinIdMap.put(string5, n2);
            }
            ++n;
        }
        System.err.println("load " + n + " latin-japanese entries' id");
        for (String string6 : TAGNAMES) {
            this.latinIdMap.remove(string6);
        }
    }

    MakeJpLaBodyHtml() {
        this.kanaMap.put("\u5b89\u697d\u6b7b", "\u3042\u3093\u3089\u304f\u3057");
        this.kanaMap.put("\u5f15\u529b", "\u3044\u3093\u308a\u3087\u304f");
        this.kanaMap.put("\u904b\u547d", "\u3046\u3093\u3081\u3044");
        this.kanaMap.put("\u9060\u616e", "\u3048\u3093\u308a\u3087");
        this.kanaMap.put("\u9854\u6599", "\u304c\u3093\u308a\u3087\u3046");
        this.kanaMap.put("\u7de9\u548c", "\u304b\u3093\u308f");
        this.kanaMap.put("\u541f\u5473", "\u304e\u3093\u307f");
        this.kanaMap.put("\u91d1\u5229", "\u304d\u3093\u308a");
        this.kanaMap.put("\u8ecd\u670d", "\u3050\u3093\u3077\u304f");
        this.kanaMap.put("\u8a13\u7df4", "\u304f\u3093\u308c\u3093");
        this.kanaMap.put("\u6a29\u529b", "\u3051\u3093\u308a\u3087\u304f");
        this.kanaMap.put("\u8a00\u8ad6", "\u3052\u3093\u308d\u3093");
        this.kanaMap.put("\u5c71\u8108", "\u3055\u3093\u307f\u3083\u304f");
        this.kanaMap.put("\u4eba\u985e\u5b66", "\u3058\u3093\u308b\u3044\u304c\u304f");
        this.kanaMap.put("\u795e\u8a71", "\u3057\u3093\u308f");
        this.kanaMap.put("\u5bf8\u6cd5", "\u3059\u3093\u307d\u3046");
        this.kanaMap.put("\u5168\u529b", "\u305c\u3093\u308a\u3087\u304f");
        this.kanaMap.put("\u6d17\u7df4", "\u305b\u3093\u308c\u3093");
        this.kanaMap.put("\u5897\u5927", "\u305e\u3046\u3060\u3044");
        this.kanaMap.put("\u62c5\u4fdd", "\u305f\u3093\u307d");
        this.kanaMap.put("\u6696\u7089", "\u3060\u3093\u308d");
        this.kanaMap.put("\u9673\u5217", "\u3061\u3093\u308c\u3064");
        this.kanaMap.put("\u9023\u308c\u308b", "\u3064\u308c\u308b");
        this.kanaMap.put("\u5929\u6587\u5b66", "\u3066\u3093\u3082\u3093\u304c\u304f");
        this.kanaMap.put("\u96fb\u8a71", "\u3067\u3093\u308f");
        this.kanaMap.put("\u8caa\u6b32", "\u3069\u3093\u3088\u304f");
        this.kanaMap.put("\u96e3\u6c11", "\u306a\u3093\u307f\u3093");
        this.kanaMap.put("\u4efb\u547d", "\u306b\u3093\u3081\u3044");
        this.kanaMap.put("\u5e74\u9f62", "\u306d\u3093\u308c\u3044");
        this.kanaMap.put("\u53cd\u8ad6", "\u306f\u3093\u308d\u3093");
        this.kanaMap.put("\u8ca7\u4e4f", "\u3073\u3093\u307c\u3046");
        this.kanaMap.put("\u5206\u5225", "\u3075\u3093\u3079\u3064");
        this.kanaMap.put("\u5206\u88c2", "\u3076\u3093\u308c\u3064");
        this.kanaMap.put("\u5f01\u8ad6", "\u3079\u3093\u308d\u3093");
        this.kanaMap.put("\u4e07\u5e74\u7b46", "\u307e\u3093\u306d\u3093\u3072\u3064");
        this.kanaMap.put("\u6c11\u65cf", "\u307f\u3093\u305e\u304f");
        this.kanaMap.put("\u7fa4\u308c", "\u3080\u308c");
        this.kanaMap.put("\u7dbf\u5bc6", "\u3081\u3093\u307f\u3064");
        this.kanaMap.put("\u554f\u984c", "\u3082\u3093\u3060\u3044");
        this.kanaMap.put("\u548c\u3089\u3052\u308b", "\u3084\u308f\u3089\u3052\u308b");
        this.kanaMap.put("\u63fa\u308c\u308b", "\u3086\u308c\u308b");
        this.kanaMap.put("\u5f31\u308b", "\u3088\u308f\u308b");
        this.kanaMap.put("\u4e71\u7528", "\u3089\u3093\u3088\u3046");
        this.kanaMap.put("\u502b\u7406", "\u308a\u3093\u308a");
        this.kanaMap.put("\u9023\u7d61", "\u308c\u3093\u3089\u304f");
        this.kanaMap.put("\u8ad6\u7406", "\u308d\u3093\u308a");
        this.kanaMap.put("\u6e7e", "\u308f\u3093");
    }

    private void loadMidashi(BufferedReader bufferedReader) throws Exception {
        String string = bufferedReader.readLine();
        if (!MIDASHI_START.equals(string)) {
            throw new Exception("missing \u898b\u3060\u3057\u958b\u59cb");
        }
        while ((string = bufferedReader.readLine()) != null && !string.equals(MIDASHI_END)) {
            String[] stringArray = string.trim().split("\t");
            if (stringArray.length != 2) continue;
            this.kanaMap.put(stringArray[0], stringArray[1]);
            if (!stringArray[0].contains(NAKAGURO_HALF)) continue;
            this.kanaMap.put(stringArray[0].replace(NAKAGURO_HALF, NAKAGURO_FULL), stringArray[1]);
        }
        System.err.println("load " + this.kanaMap.size() + " kana entries");
    }

    private void loadBody(BufferedReader bufferedReader) throws Exception {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.trim().isEmpty()) continue;
            if (string.equals(ENTRY_DELIM)) {
                stringBuffer.append("</dd>");
                this.entries.add(stringBuffer.toString());
                stringBuffer = null;
                stringBuffer = new StringBuffer();
                continue;
            }
            if (string.charAt(0) != ' ') {
                String string2 = string.trim();
                LinkedList linkedList = this.kanaMap.getWithoutNull(string2);
                stringBuffer.append("<dt id=\"");
                stringBuffer.append(n);
                if (!this.dtIdMap.containsKey(string2)) {
                    this.dtIdMap.put(string2, n);
                }
                ++n;
                stringBuffer.append("\">");
                stringBuffer.append(string2);
                for (String string3 : linkedList) {
                    stringBuffer.append("\u3010");
                    stringBuffer.append(string3);
                    stringBuffer.append("\u3011");
                }
                stringBuffer.append("</dt>");
                if (linkedList.isEmpty()) {
                    String string4 = AppendJPKeys.makeKana(string2);
                    if (string4 != null) {
                        stringBuffer.append("<key type=\"\u304b\u306a\">");
                        stringBuffer.append(string4);
                        stringBuffer.append("</key>");
                    } else if (!AppendJPKeys.isKana(string2.charAt(0))) {
                        System.err.println("WARN: missing kana: " + string2);
                    }
                }
                stringBuffer.append("<dd>");
                continue;
            }
            stringBuffer.append("<p>");
            stringBuffer.append(string.trim());
            stringBuffer.append("</p>");
        }
    }

    private void appendJPref(StringBuffer stringBuffer, String string) {
        Matcher matcher = JPREFWORD.matcher(string);
        int n = 0;
        while (matcher.find()) {
            String string2;
            Integer n2;
            if (n < matcher.start(1)) {
                stringBuffer.append(string.substring(n, matcher.start(1)));
            }
            if ((n2 = this.dtIdMap.get(string2 = matcher.group(1))) != null) {
                stringBuffer.append(String.format("<a href=\"#%d\">%s</a>", n2, string2));
            } else {
                stringBuffer.append(string2);
            }
            n = matcher.end(1);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
    }

    private String appendJPref(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = JPREF.matcher(string);
        int n = 0;
        while (matcher.find()) {
            int n2;
            int n3 = n2 = matcher.group(1) != null ? 2 : 4;
            if (n < matcher.start(n2)) {
                stringBuffer.append(string.substring(n, matcher.start(n2)));
            }
            this.appendJPref(stringBuffer, matcher.group(n2));
            n = matcher.end(n2);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private void appendLArefPara(StringBuffer stringBuffer, String string) {
        Matcher matcher = LAREF.matcher(string);
        int n = 0;
        while (matcher.find()) {
            String string2;
            String string3;
            Integer n2;
            if (n < matcher.start(1)) {
                stringBuffer.append(string.substring(n, matcher.start(1)));
            }
            if ((n2 = this.latinIdMap.get(string3 = (string2 = matcher.group(1)).toLowerCase())) != null) {
                stringBuffer.append(String.format("<a href=\"body-lajp.html#%d\">%s</a>", n2, string2));
            } else {
                stringBuffer.append(string2);
            }
            n = matcher.end(1);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
    }

    private String appendLAref(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PARA.matcher(string);
        int n = 0;
        while (matcher.find()) {
            if (n < matcher.start(1)) {
                stringBuffer.append(string.substring(n, matcher.start(1)));
            }
            this.appendLArefPara(stringBuffer, matcher.group(1));
            n = matcher.end(1);
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private void outBody() {
        for (String string : this.entries) {
            System.out.println(this.appendLAref(this.appendJPref(string)));
        }
        System.err.println("done. " + this.entries.size() + " entries");
    }

    private void loadTxt(String string) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        System.out.println("<html><body>");
        this.loadMidashi(bufferedReader);
        this.loadBody(bufferedReader);
        this.outBody();
        System.out.println("</body></html>");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 2) {
            MakeJpLaBodyHtml makeJpLaBodyHtml = new MakeJpLaBodyHtml();
            try {
                ZephyrUtil.setShiftJisOuput();
                makeJpLaBodyHtml.loadLAJPBody(stringArray[1]);
                makeJpLaBodyHtml.loadTxt(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeJpLaBodyHtml kenkyusya-jpla.txt body-lajp.html");
        }
    }
}

