package jp.co.powerbeans.eclipse.plugin.powerdbj.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;

import jp.co.powerbeans.eclipse.plugin.powerdbj.Msg;
import jp.co.powerbeans.eclipse.plugin.powerdbj.export.ExportMgr;
import jp.co.powerbeans.eclipse.plugin.powerdbj.export.ExportProgressNotifyListener;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

/**
 * This is a sample new wizard. Its role is to create a new file 
 * resource in the provided container. If the container resource
 * (a folder or a project) is selected in the workspace 
 * when the wizard is opened, it will accept it as the target
 * container. The wizard creates one file with the extension
 * "java". If a sample multi-page editor (also available
 * as a template) is registered for the same extension, it will
 * be able to open it.
 */

public class PowerDBJWizard extends Wizard implements INewWizard, ExportProgressNotifyListener {


	private PowerDBJWizardBase page1SetDB;
	private PowerDBJWizardBase page2SelectDB;
	private PowerDBJWizardBase page3SelectDB;
//	private PowerDBJWizardPage page;
	private ISelection selection;
	private DBInfo dbinfo;
  private IProgressMonitor lastMonitor;

	/**
	 * Constructor for PowerDBJWizard.
	 */
	public PowerDBJWizard() {
		super();
		setNeedsProgressMonitor(true);
	}
	
	/**
	 * Adding the page to the wizard.
	 */

	public void addPages() {
		dbinfo = new DBInfo();
		page1SetDB = new PowerDBJWizard1SetDB(selection, dbinfo);
		addPage(page1SetDB);
		
		page2SelectDB = new PowerDBJWizard2SelectDB(selection, dbinfo);
		addPage(page2SelectDB);
		
		page3SelectDB = new PowerDBJWizard3SelectExportType(selection, dbinfo, true);
		addPage(page3SelectDB);
		
//		page = new PowerDBJWizardPage(selection);
//		addPage(page);
	}

	/**
	 * This method is called when 'Finish' button is pressed in
	 * the wizard. We will create an operation and run it
	 * using wizard as execution context.
	 */
	public boolean performFinish() {
//		final String containerName = page3SelectDB.getContainerName();
//		final String fileName = page3SelectDB.getFileName();
		IRunnableWithProgress op = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException {
				try {
					doFinish(monitor);
//					doFinish(containerName, fileName, monitor);
				} catch (CoreException e) {
					throw new InvocationTargetException(e);
				} finally {
					monitor.done();
				}
			}
		};
		try {
			getContainer().run(true, false, op);
		} catch (InterruptedException e) {
			return false;
		} catch (InvocationTargetException e) {
			Throwable realException = e.getTargetException();
			MessageDialog.openError(getShell(), "Error", realException.getMessage());
			return false;
		}
		return true;
	}
	
	/**
	 * The worker method. It will find the container, create the
	 * file if missing or just replace its contents, and open
	 * the editor on the newly created file.
	 */

	private void doFinish(
		IProgressMonitor monitor)
		throws CoreException {
    this.lastMonitor = monitor;
		
		// create a sample file
		monitor.beginTask("exporting ", this.dbinfo.getSelectTables().length);

    ExportMgr export_mgr = new ExportMgr();
    export_mgr.setExportProgressNotifyListener(this);
    export_mgr.export(this.dbinfo);
		
		monitor.setTaskName("Opening file for editing...");
	}
  
  /* (non-Javadoc)
   * @see jp.co.powerbeans.eclipse.plugin.powerdbj.export.ExportProgressNotifyListener#progressNotify(java.lang.String, int)
   */
  public void progressNotify(String msg, int percent) {
    this.lastMonitor.worked(1);
    this.lastMonitor.setTaskName(msg);
  } 
  
	/**
	 * We will initialize file contents with a sample text.
	 */

	private InputStream openContentStream() {
		String contents =
			"This is the initial file contents for *.java file that should be word-sorted in the Preview page of the multi-page editor";
		return new ByteArrayInputStream(contents.getBytes());
	}

	private void throwCoreException(String message) throws CoreException {
		IStatus status =
			new Status(IStatus.ERROR, Msg.getAppName(), IStatus.OK, message, null);
		throw new CoreException(status);
	}

	/**
	 * We will accept the selection in the workbench to see if
	 * we can initialize from it.
	 * @see IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection = selection;
	}
	
	public boolean canFinish() {
		return super.canFinish() && dbinfo.isFinish();
	}

}