/**
 * PowerDBJ
 * create date 2006/09/15
 * amonden
 */
package jp.co.powerbeans.eclipse.common;

import jp.co.powerbeans.eclipse.plugin.datacreator.DataCreatorPlugin;
import jp.co.powerbeans.eclipse.plugin.powerdbj.Msg;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

/**
 * PBEcllipseUtil
 * 
 * @author amonden
 * @create date 2006/09/15
 */
public final class PBEclipseUtil {

  /**
   * 
   */
  private PBEclipseUtil() {
  }

  public static Plugin getPlugin() {
    return DataCreatorPlugin.getDefault();
  }
  /**
   * eclipseのpluginsフォルダを取得する. ex) c:/eclipse/plugins
   * 
   * @return pluginsフォルダパス
   */
  public static String getPluginsPath() {
    
    String pindir = "";
    pindir = Platform.getInstallLocation().getURL().getPath() + "plugins";

    if (pindir.endsWith("/")) {
      pindir = pindir.substring(0, pindir.length() - 1);
    }
    if (pindir.startsWith("file:")) {
      pindir = pindir.substring("file:".length());
    }
//    info(pindir);
    return pindir;
  }

  /**
   * @param pindir
   */
  public static void info(String msg) {
    Plugin plugin = getPlugin();
    ILog logger = plugin.getLog();
    IStatus status = new Status(Status.INFO, Msg.getPluginId(), Status.INFO, msg, null);
    logger.log(status);
  }
}
