/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.mirror;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.artifact.mirror.FileMirrorLog;
import org.eclipse.equinox.internal.p2.artifact.mirror.IArtifactMirrorLog;
import org.eclipse.equinox.internal.p2.artifact.mirror.Mirroring;
import org.eclipse.equinox.internal.p2.artifact.mirror.XMLMirrorLog;
import org.eclipse.equinox.internal.p2.artifact.processors.md5.MD5ArtifactComparator;
import org.eclipse.equinox.internal.p2.artifact.repository.Activator;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.repository.IRepository;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class MirrorApplication
implements IApplication {
    private URI sourceLocation;
    private URI destinationLocation;
    private URI baselineLocation;
    private IArtifactRepository source;
    private IArtifactRepository destination;
    private IArtifactRepository baseline;
    private boolean append = true;
    private boolean raw = false;
    private boolean failOnError = true;
    private boolean validate = false;
    private boolean verbose = false;
    private IArtifactRepositoryManager cachedManager;
    private boolean sourceLoaded = false;
    private boolean destinationLoaded = false;
    private boolean baselineLoaded = false;
    private boolean compare = false;
    private String comparatorID = MD5ArtifactComparator.MD5_COMPARATOR_ID;
    private String destinationName;
    private IArtifactMirrorLog mirrorLog;
    private IArtifactMirrorLog comparatorLog;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Object start(IApplicationContext context) throws Exception {
        try {
            MultiStatus result;
            Map args = context.getArguments();
            this.initializeFromArguments((String[])args.get("application.args"));
            this.setupRepositories();
            Mirroring mirroring = new Mirroring(this.source, this.destination, this.raw);
            mirroring.setCompare(this.compare);
            mirroring.setComparatorId(this.comparatorID);
            mirroring.setBaseline(this.baseline);
            mirroring.setValidate(this.validate);
            if (this.comparatorLog != null) {
                mirroring.setComparatorLog(this.comparatorLog);
            }
            if (!(result = mirroring.run(this.failOnError, this.verbose)).isOK()) {
                if (result.matches(1)) {
                    System.err.println("Mirroring completed. Please check log file for more information.");
                } else {
                    System.err.println("Mirroring completed with warnings and/or errors. Please check log file for more information.");
                }
                this.log((IStatus)result);
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw e;
        }
        finally {
            this.cleanup();
        }
    }

    private IArtifactRepositoryManager getManager() {
        IArtifactRepositoryManager result;
        if (this.cachedManager != null) {
            return this.cachedManager;
        }
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((result = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            result = this.cachedManager = new ArtifactRepositoryManager();
        }
        return result;
    }

    private void setupRepositories() throws ProvisionException {
        if (this.destinationLocation == null || this.sourceLocation == null) {
            throw new IllegalStateException(Messages.exception_needSourceDestination);
        }
        this.sourceLoaded = this.getManager().contains(this.sourceLocation);
        this.destinationLoaded = this.getManager().contains(this.destinationLocation);
        this.source = this.getManager().loadRepository(this.sourceLocation, 0, null);
        this.destination = this.initializeDestination();
        if (this.baselineLocation != null) {
            this.baselineLoaded = this.getManager().contains(this.baselineLocation);
            try {
                this.baseline = this.getManager().loadRepository(this.baselineLocation, 0, null);
            }
            catch (ProvisionException e) {
                System.err.println("Error occurred while trying to load baseline repository.");
                e.printStackTrace();
            }
        }
    }

    private IArtifactRepository initializeDestination() throws ProvisionException {
        try {
            IArtifactRepository repository = this.getManager().loadRepository(this.destinationLocation, 1, null);
            if (repository != null && repository.isModifiable()) {
                if (this.destinationName != null) {
                    repository.setName(this.destinationName);
                }
                if (!this.append) {
                    repository.removeAll();
                }
                return repository;
            }
        }
        catch (ProvisionException provisionException) {}
        return (IArtifactRepository)RepositoryHelper.validDestinationRepository((IRepository)this.getManager().createRepository(this.destinationLocation, this.destinationName == null ? this.source.getName() : this.destinationName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", this.source.getProperties()));
    }

    public void stop() {
    }

    public void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        String comparatorLogLocation = null;
        String mirrorLogLocation = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-raw")) {
                this.raw = true;
            }
            if (args[i].equalsIgnoreCase("-ignoreErrors")) {
                this.failOnError = false;
            }
            if (args[i].equalsIgnoreCase("-verbose")) {
                this.verbose = true;
            }
            if (args[i].equalsIgnoreCase("-compare")) {
                this.compare = true;
            }
            if (args[i].equalsIgnoreCase("-validate")) {
                this.validate = true;
            }
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase("-comparator")) {
                    this.comparatorID = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-comparatorLog")) {
                    comparatorLogLocation = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-destinationName")) {
                    this.destinationName = arg;
                }
                if (args[i - 1].equalsIgnoreCase("-writeMode") && args[i].equalsIgnoreCase("clean")) {
                    this.append = false;
                }
                if (args[i - 1].equalsIgnoreCase("-log")) {
                    mirrorLogLocation = arg;
                }
                try {
                    if (args[i - 1].equalsIgnoreCase("-source")) {
                        this.sourceLocation = RepositoryHelper.localRepoURIHelper((URI)URIUtil.fromString((String)arg));
                    }
                    if (args[i - 1].equalsIgnoreCase("-destination")) {
                        this.destinationLocation = RepositoryHelper.localRepoURIHelper((URI)URIUtil.fromString((String)arg));
                    }
                    if (args[i - 1].equalsIgnoreCase("-compareAgainst")) {
                        this.baselineLocation = RepositoryHelper.localRepoURIHelper((URI)URIUtil.fromString((String)arg));
                        this.compare = true;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.exception_malformedRepoURI, (Object)arg));
                }
            }
            ++i;
        }
        if (mirrorLogLocation != null) {
            this.mirrorLog = this.getLog(mirrorLogLocation, "p2.artifact.mirror");
        }
        if (comparatorLogLocation != null && this.comparatorID != null) {
            this.comparatorLog = this.getLog(comparatorLogLocation, this.comparatorID);
        }
    }

    public void setLog(IArtifactMirrorLog log) {
        this.mirrorLog = log;
    }

    private IArtifactMirrorLog getLog(String location, String root) {
        if (location.toLowerCase().endsWith(".xml")) {
            return new XMLMirrorLog(location, this.verbose ? 1 : 4, root);
        }
        return new FileMirrorLog(location, this.verbose ? 1 : 4, root);
    }

    private void log(IStatus status) {
        if (this.mirrorLog == null) {
            FrameworkLog log;
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((log = (FrameworkLog)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
                System.err.println("Log file location: " + log.getFile());
            }
            LogHelper.log((IStatus)status);
        } else {
            this.mirrorLog.log(status);
        }
    }

    private void cleanup() {
        if (!this.sourceLoaded && this.sourceLocation != null) {
            this.getManager().removeRepository(this.sourceLocation);
        }
        if (!this.destinationLoaded && this.destinationLocation != null) {
            this.getManager().removeRepository(this.destinationLocation);
        }
        if (this.baselineLocation != null && !this.baselineLoaded) {
            this.getManager().removeRepository(this.baselineLocation);
        }
        if (this.mirrorLog != null) {
            this.mirrorLog.close();
        }
        if (this.comparatorLog != null) {
            this.comparatorLog.close();
        }
    }
}

