/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.engine.Touchpoint;

public class ParameterizedProvisioningAction
extends ProvisioningAction {
    private ProvisioningAction action;
    private Map actionParameters;
    private String actionText;

    public ParameterizedProvisioningAction(ProvisioningAction action, Map actionParameters, String actionText) {
        if (action == null || actionParameters == null) {
            throw new IllegalArgumentException(Messages.ParameterizedProvisioningAction_action_or_parameters_null);
        }
        this.action = action;
        this.actionParameters = actionParameters;
        this.actionText = actionText;
    }

    public IStatus execute(Map parameters) {
        parameters = this.processActionParameters(parameters);
        return this.action.execute(parameters);
    }

    public IStatus undo(Map parameters) {
        parameters = this.processActionParameters(parameters);
        return this.action.undo(parameters);
    }

    private Map processActionParameters(Map parameters) {
        HashMap<String, String> result = new HashMap<String, String>(parameters);
        Iterator it = this.actionParameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String value = this.processVariables((String)entry.getValue(), parameters);
            result.put(name, value);
        }
        return Collections.unmodifiableMap(result);
    }

    private String processVariables(String parameterValue, Map parameters) {
        int variableBeginIndex = parameterValue.indexOf("${");
        if (variableBeginIndex == -1) {
            return parameterValue;
        }
        int variableEndIndex = parameterValue.indexOf(125, variableBeginIndex + 2);
        if (variableEndIndex == -1) {
            return parameterValue;
        }
        String preVariable = parameterValue.substring(0, variableBeginIndex);
        String variableName = parameterValue.substring(variableBeginIndex + 2, variableEndIndex);
        Object value = parameters.get(variableName);
        if (value == null && variableName.charAt(0) == '#') {
            try {
                int code = Integer.parseInt(variableName.substring(1));
                if (code >= 0 && code < 65536) {
                    value = Character.toString((char)code);
                }
            }
            catch (Throwable throwable) {}
        }
        String variableValue = value == null ? "" : value.toString();
        String postVariable = this.processVariables(parameterValue.substring(variableEndIndex + 1), parameters);
        return String.valueOf(preVariable) + variableValue + postVariable;
    }

    public ProvisioningAction getAction() {
        return this.action;
    }

    public Map getParameters() {
        return this.actionParameters;
    }

    public String getActionText() {
        return this.actionText;
    }

    public Touchpoint getTouchpoint() {
        return this.action.getTouchpoint();
    }

    public void setTouchpoint(Touchpoint touchpoint) {
        throw new UnsupportedOperationException();
    }
}

