/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.text;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import sun.font.FontDesignMetrics;
import sun.swing.text.CompoundPrintable;
import sun.swing.text.CountingPrintable;
import sun.swing.text.html.FrameEditorPaneTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextComponentPrintable
implements CountingPrintable {
    private static final int LIST_SIZE = 1000;
    private boolean isLayouted = false;
    private final JTextComponent textComponentToPrint;
    private final AtomicReference<FontRenderContext> frc = new AtomicReference<Object>(null);
    private final JTextComponent printShell;
    private final MessageFormat headerFormat;
    private final MessageFormat footerFormat;
    private static final float HEADER_FONT_SIZE = 18.0f;
    private static final float FOOTER_FONT_SIZE = 12.0f;
    private final Font headerFont;
    private final Font footerFont;
    private final List<IntegerSegment> rowsMetrics;
    private final List<IntegerSegment> pagesMetrics;
    private boolean needReadLock = false;

    public static Printable getPrintable(JTextComponent jTextComponent, MessageFormat messageFormat, MessageFormat messageFormat2) {
        if (jTextComponent instanceof JEditorPane && TextComponentPrintable.isFrameSetDocument(jTextComponent.getDocument())) {
            List<JEditorPane> list = TextComponentPrintable.getFrames((JEditorPane)jTextComponent);
            ArrayList<CountingPrintable> arrayList = new ArrayList<CountingPrintable>();
            for (JEditorPane jEditorPane : list) {
                arrayList.add((CountingPrintable)TextComponentPrintable.getPrintable(jEditorPane, messageFormat, messageFormat2));
            }
            return new CompoundPrintable(arrayList);
        }
        return new TextComponentPrintable(jTextComponent, messageFormat, messageFormat2);
    }

    private static boolean isFrameSetDocument(Document document) {
        HTMLDocument hTMLDocument;
        boolean bl = false;
        if (document instanceof HTMLDocument && (hTMLDocument = (HTMLDocument)document).getIterator(HTML.Tag.FRAME).isValid()) {
            bl = true;
        }
        return bl;
    }

    private static List<JEditorPane> getFrames(JEditorPane jEditorPane) {
        ArrayList<JEditorPane> arrayList = new ArrayList<JEditorPane>();
        TextComponentPrintable.getFrames(jEditorPane, arrayList);
        if (arrayList.size() == 0) {
            TextComponentPrintable.createFrames(jEditorPane);
            TextComponentPrintable.getFrames(jEditorPane, arrayList);
        }
        return arrayList;
    }

    private static void getFrames(Container container, List<JEditorPane> list) {
        for (Component component : container.getComponents()) {
            if (component instanceof FrameEditorPaneTag && component instanceof JEditorPane) {
                list.add((JEditorPane)component);
                continue;
            }
            if (!(component instanceof Container)) continue;
            TextComponentPrintable.getFrames((Container)component, list);
        }
    }

    private static void createFrames(final JEditorPane jEditorPane) {
        Runnable runnable = new Runnable(){

            public void run() {
                CellRendererPane cellRendererPane = new CellRendererPane();
                cellRendererPane.add(jEditorPane);
                cellRendererPane.setSize(500, 500);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception);
            }
        }
    }

    private TextComponentPrintable(JTextComponent jTextComponent, MessageFormat messageFormat, MessageFormat messageFormat2) {
        this.textComponentToPrint = jTextComponent;
        this.headerFormat = messageFormat;
        this.footerFormat = messageFormat2;
        this.headerFont = jTextComponent.getFont().deriveFont(1, 18.0f);
        this.footerFont = jTextComponent.getFont().deriveFont(0, 12.0f);
        this.pagesMetrics = Collections.synchronizedList(new ArrayList());
        this.rowsMetrics = new ArrayList<IntegerSegment>(1000);
        this.printShell = this.createPrintShell(jTextComponent);
    }

    private JTextComponent createPrintShell(final JTextComponent jTextComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.createPrintShellOnEDT(jTextComponent);
        }
        FutureTask<JTextComponent> futureTask = new FutureTask<JTextComponent>(new Callable<JTextComponent>(){

            @Override
            public JTextComponent call() throws Exception {
                return TextComponentPrintable.this.createPrintShellOnEDT(jTextComponent);
            }
        });
        SwingUtilities.invokeLater(futureTask);
        try {
            return futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
    }

    private JTextComponent createPrintShellOnEDT(final JTextComponent jTextComponent) {
        assert (SwingUtilities.isEventDispatchThread());
        JTextComponent jTextComponent2 = null;
        if (jTextComponent instanceof JTextField) {
            jTextComponent2 = new JTextField(){
                {
                    this.setHorizontalAlignment(((JTextField)jTextComponent).getHorizontalAlignment());
                }

                public FontMetrics getFontMetrics(Font font) {
                    return TextComponentPrintable.this.frc.get() == null ? super.getFontMetrics(font) : FontDesignMetrics.getMetrics(font, (FontRenderContext)TextComponentPrintable.this.frc.get());
                }
            };
        } else if (jTextComponent instanceof JTextArea) {
            jTextComponent2 = new JTextArea(){
                {
                    JTextArea jTextArea = (JTextArea)jTextComponent;
                    this.setLineWrap(jTextArea.getLineWrap());
                    this.setWrapStyleWord(jTextArea.getWrapStyleWord());
                    this.setTabSize(jTextArea.getTabSize());
                }

                public FontMetrics getFontMetrics(Font font) {
                    return TextComponentPrintable.this.frc.get() == null ? super.getFontMetrics(font) : FontDesignMetrics.getMetrics(font, (FontRenderContext)TextComponentPrintable.this.frc.get());
                }
            };
        } else if (jTextComponent instanceof JTextPane) {
            jTextComponent2 = new JTextPane(){

                public FontMetrics getFontMetrics(Font font) {
                    return TextComponentPrintable.this.frc.get() == null ? super.getFontMetrics(font) : FontDesignMetrics.getMetrics(font, (FontRenderContext)TextComponentPrintable.this.frc.get());
                }

                public EditorKit getEditorKit() {
                    if (this.getDocument() == jTextComponent.getDocument()) {
                        return ((JTextPane)jTextComponent).getEditorKit();
                    }
                    return super.getEditorKit();
                }
            };
        } else if (jTextComponent instanceof JEditorPane) {
            jTextComponent2 = new JEditorPane(){

                public FontMetrics getFontMetrics(Font font) {
                    return TextComponentPrintable.this.frc.get() == null ? super.getFontMetrics(font) : FontDesignMetrics.getMetrics(font, (FontRenderContext)TextComponentPrintable.this.frc.get());
                }

                public EditorKit getEditorKit() {
                    if (this.getDocument() == jTextComponent.getDocument()) {
                        return ((JEditorPane)jTextComponent).getEditorKit();
                    }
                    return super.getEditorKit();
                }
            };
        }
        jTextComponent2.setBorder(null);
        jTextComponent2.setOpaque(jTextComponent.isOpaque());
        jTextComponent2.setEditable(jTextComponent.isEditable());
        jTextComponent2.setEnabled(jTextComponent.isEnabled());
        jTextComponent2.setFont(jTextComponent.getFont());
        jTextComponent2.setBackground(jTextComponent.getBackground());
        jTextComponent2.setForeground(jTextComponent.getForeground());
        jTextComponent2.setComponentOrientation(jTextComponent.getComponentOrientation());
        if (jTextComponent2 instanceof JEditorPane) {
            jTextComponent2.putClientProperty("JEditorPane.honorDisplayProperties", jTextComponent.getClientProperty("JEditorPane.honorDisplayProperties"));
            jTextComponent2.putClientProperty("JEditorPane.w3cLengthUnits", jTextComponent.getClientProperty("JEditorPane.w3cLengthUnits"));
            jTextComponent2.putClientProperty("charset", jTextComponent.getClientProperty("charset"));
        }
        jTextComponent2.setDocument(jTextComponent.getDocument());
        return jTextComponent2;
    }

    @Override
    public int getNumberOfPages() {
        return this.pagesMetrics.size();
    }

    @Override
    public int print(final Graphics graphics, final PageFormat pageFormat, final int n) throws PrinterException {
        int n2;
        if (!this.isLayouted) {
            if (graphics instanceof Graphics2D) {
                this.frc.set(((Graphics2D)graphics).getFontRenderContext());
            }
            this.layout((int)Math.floor(pageFormat.getImageableWidth()));
            this.calculateRowsMetrics();
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            Callable<Integer> callable = new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return TextComponentPrintable.this.printOnEDT(graphics, pageFormat, n);
                }
            };
            FutureTask<Integer> futureTask = new FutureTask<Integer>(callable);
            SwingUtilities.invokeLater(futureTask);
            try {
                n2 = futureTask.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof PrinterException) {
                    throw (PrinterException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException(throwable);
            }
        } else {
            n2 = this.printOnEDT(graphics, pageFormat, n);
        }
        return n2;
    }

    private int printOnEDT(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Object[] objectArray;
        assert (SwingUtilities.isEventDispatchThread());
        Border border = BorderFactory.createEmptyBorder();
        if (this.headerFormat != null || this.footerFormat != null) {
            objectArray = new Object[]{n + 1};
            if (this.headerFormat != null) {
                border = new TitledBorder(border, this.headerFormat.format(objectArray), 2, 1, this.headerFont, this.printShell.getForeground());
            }
            if (this.footerFormat != null) {
                border = new TitledBorder(border, this.footerFormat.format(objectArray), 2, 6, this.footerFont, this.printShell.getForeground());
            }
        }
        objectArray = border.getBorderInsets(this.printShell);
        this.updatePagesMetrics(n, (int)Math.floor(pageFormat.getImageableHeight()) - objectArray.top - objectArray.bottom);
        if (this.pagesMetrics.size() <= n) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        border.paintBorder(this.printShell, graphics2D, 0, 0, (int)Math.floor(pageFormat.getImageableWidth()), (int)Math.floor(pageFormat.getImageableHeight()));
        graphics2D.translate(0, objectArray.top);
        Rectangle rectangle = new Rectangle(0, 0, (int)pageFormat.getWidth(), this.pagesMetrics.get((int)n).end - this.pagesMetrics.get((int)n).start + 1);
        graphics2D.clip(rectangle);
        int n2 = 0;
        if (ComponentOrientation.RIGHT_TO_LEFT == this.printShell.getComponentOrientation()) {
            n2 = (int)pageFormat.getImageableWidth() - this.printShell.getWidth();
        }
        graphics2D.translate(n2, -this.pagesMetrics.get((int)n).start);
        this.printShell.print(graphics2D);
        return 0;
    }

    private void releaseReadLock() {
        assert (!SwingUtilities.isEventDispatchThread());
        Document document = this.textComponentToPrint.getDocument();
        if (document instanceof AbstractDocument) {
            try {
                ((AbstractDocument)document).readUnlock();
                this.needReadLock = true;
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    private void acquireReadLock() {
        assert (!SwingUtilities.isEventDispatchThread());
        if (this.needReadLock) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            Document document = this.textComponentToPrint.getDocument();
            ((AbstractDocument)document).readLock();
            this.needReadLock = false;
        }
    }

    private void layout(final int n) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Callable<Object> callable = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    TextComponentPrintable.this.layoutOnEDT(n);
                    return null;
                }
            };
            FutureTask<Object> futureTask = new FutureTask<Object>(callable);
            this.releaseReadLock();
            SwingUtilities.invokeLater(futureTask);
            try {
                futureTask.get();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException(throwable);
            }
            finally {
                this.acquireReadLock();
            }
        } else {
            this.layoutOnEDT(n);
        }
        this.isLayouted = true;
    }

    private void layoutOnEDT(int n) {
        assert (SwingUtilities.isEventDispatchThread());
        CellRendererPane cellRendererPane = new CellRendererPane();
        JViewport jViewport = new JViewport();
        jViewport.setBorder(null);
        Dimension dimension = new Dimension(n, 2147482647);
        if (this.printShell instanceof JTextField) {
            dimension = new Dimension(dimension.width, this.printShell.getPreferredSize().height);
        }
        this.printShell.setSize(dimension);
        jViewport.setComponentOrientation(this.printShell.getComponentOrientation());
        jViewport.setSize(dimension);
        jViewport.add(this.printShell);
        cellRendererPane.add(jViewport);
    }

    private void updatePagesMetrics(int n, int n2) {
        while (n >= this.pagesMetrics.size() && !this.rowsMetrics.isEmpty()) {
            int n3;
            int n4 = this.pagesMetrics.size() - 1;
            int n5 = n4 >= 0 ? this.pagesMetrics.get((int)n4).end + 1 : 0;
            for (n3 = 0; n3 < this.rowsMetrics.size() && this.rowsMetrics.get((int)n3).end - n5 + 1 <= n2; ++n3) {
            }
            if (n3 == 0) {
                this.pagesMetrics.add(new IntegerSegment(n5, n5 + n2 - 1));
                continue;
            }
            this.pagesMetrics.add(new IntegerSegment(n5, this.rowsMetrics.get((int)(--n3)).end));
            for (int i = 0; i <= n3; ++i) {
                this.rowsMetrics.remove(0);
            }
        }
    }

    private void calculateRowsMetrics() {
        int n;
        int n2 = this.printShell.getDocument().getLength();
        ArrayList<IntegerSegment> arrayList = new ArrayList<IntegerSegment>(1000);
        int n3 = -1;
        int n4 = -1;
        for (n = 0; n < n2; ++n) {
            try {
                Rectangle rectangle = this.printShell.modelToView(n);
                if (rectangle == null) continue;
                int n5 = (int)rectangle.getY();
                int n6 = (int)rectangle.getHeight();
                if (n6 == 0 || n5 == n3 && n6 == n4) continue;
                n3 = n5;
                n4 = n6;
                arrayList.add(new IntegerSegment(n5, n5 + n6 - 1));
                continue;
            }
            catch (BadLocationException badLocationException) {
                assert (false);
                continue;
            }
        }
        Collections.sort(arrayList);
        n = Integer.MIN_VALUE;
        n3 = Integer.MIN_VALUE;
        for (IntegerSegment integerSegment : arrayList) {
            if (n3 < integerSegment.start) {
                if (n3 != Integer.MIN_VALUE) {
                    this.rowsMetrics.add(new IntegerSegment(n, n3));
                }
                n = integerSegment.start;
                n3 = integerSegment.end;
                continue;
            }
            n3 = integerSegment.end;
        }
        if (n3 != Integer.MIN_VALUE) {
            this.rowsMetrics.add(new IntegerSegment(n, n3));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerSegment
    implements Comparable<IntegerSegment> {
        final int start;
        final int end;

        IntegerSegment(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        @Override
        public int compareTo(IntegerSegment integerSegment) {
            int n = this.start - integerSegment.start;
            return n != 0 ? n : this.end - integerSegment.end;
        }

        public boolean equals(Object object) {
            if (object instanceof IntegerSegment) {
                return this.compareTo((IntegerSegment)object) == 0;
            }
            return false;
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + this.start;
            n = 37 * n + this.end;
            return n;
        }

        public String toString() {
            return "IntegerSegment [" + this.start + ", " + this.end + "]";
        }
    }
}

