/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.peer.DialogPeer;
import sun.awt.im.InputMethodManager;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WWindowPeer;

class WDialogPeer
extends WWindowPeer
implements DialogPeer {
    static final Color defaultBackground = SystemColor.control;
    boolean needDefaultBackground;

    WDialogPeer(Dialog dialog) {
        super(dialog);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
    }

    native void create(WComponentPeer var1);

    native void showModal();

    native void endModal();

    void initialize() {
        Dialog dialog = (Dialog)this.target;
        if (this.needDefaultBackground) {
            dialog.setBackground(defaultBackground);
        }
        super.initialize();
        if (dialog.getTitle() != null) {
            this.setTitle(dialog.getTitle());
        }
        this.setResizable(dialog.isResizable());
    }

    protected void realShow() {
        Dialog dialog = (Dialog)this.target;
        if (dialog.getModalityType() != Dialog.ModalityType.MODELESS) {
            this.showModal();
            this.visible = true;
        } else {
            super.realShow();
        }
    }

    public void hide() {
        Dialog dialog = (Dialog)this.target;
        if (dialog.getModalityType() != Dialog.ModalityType.MODELESS) {
            this.endModal();
            this.visible = false;
        } else {
            super.hide();
        }
    }

    public Dimension getMinimumSize() {
        if (((Dialog)this.target).isUndecorated()) {
            return super.getMinimumSize();
        }
        return new Dimension(WDialogPeer.getSysMinWidth(), WDialogPeer.getSysMinHeight());
    }

    boolean isTargetUndecorated() {
        return ((Dialog)this.target).isUndecorated();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.constrainBounds(n, n2, n3, n4);
        if (((Dialog)this.target).isUndecorated()) {
            super.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.reshapeFrame(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void setDefaultColor() {
        this.needDefaultBackground = true;
    }

    native void pSetIMMOption(String var1);

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest((Component)this.target);
    }
}

