/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.addressing.WsaClientTube;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.WSService;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.client.ClientPipelineHook;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.TransportTubeFactory;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.handler.ClientLogicalHandlerTube;
import com.sun.xml.internal.ws.handler.ClientSOAPHandlerTube;
import com.sun.xml.internal.ws.protocol.soap.ClientMUTube;
import com.sun.xml.internal.ws.transport.DeferredTransportPipe;
import com.sun.xml.internal.ws.util.pipe.DumpTube;
import java.io.PrintStream;
import javax.xml.ws.soap.SOAPBinding;

public class ClientTubeAssemblerContext {
    @NotNull
    private final EndpointAddress address;
    @NotNull
    private final WSDLPort wsdlModel;
    @NotNull
    private final WSService rootOwner;
    @NotNull
    private final WSBinding binding;
    @NotNull
    private final Container container;
    @NotNull
    private Codec codec;

    public ClientTubeAssemblerContext(@NotNull EndpointAddress endpointAddress, @NotNull WSDLPort wSDLPort, @NotNull WSService wSService, @NotNull WSBinding wSBinding) {
        this(endpointAddress, wSDLPort, wSService, wSBinding, Container.NONE);
    }

    public ClientTubeAssemblerContext(@NotNull EndpointAddress endpointAddress, @NotNull WSDLPort wSDLPort, @NotNull WSService wSService, @NotNull WSBinding wSBinding, @NotNull Container container, Codec codec) {
        this.address = endpointAddress;
        this.wsdlModel = wSDLPort;
        this.rootOwner = wSService;
        this.binding = wSBinding;
        this.container = container;
        this.codec = codec;
    }

    public ClientTubeAssemblerContext(@NotNull EndpointAddress endpointAddress, @NotNull WSDLPort wSDLPort, @NotNull WSService wSService, @NotNull WSBinding wSBinding, @NotNull Container container) {
        this(endpointAddress, wSDLPort, wSService, wSBinding, container, ((BindingImpl)wSBinding).createCodec());
    }

    @NotNull
    public EndpointAddress getAddress() {
        return this.address;
    }

    @Nullable
    public WSDLPort getWsdlModel() {
        return this.wsdlModel;
    }

    @NotNull
    public WSService getService() {
        return this.rootOwner;
    }

    @NotNull
    public WSBinding getBinding() {
        return this.binding;
    }

    public Container getContainer() {
        return this.container;
    }

    public Tube createDumpTube(String string, PrintStream printStream, Tube tube) {
        return new DumpTube(string, printStream, tube);
    }

    @NotNull
    public Tube createSecurityTube(@NotNull Tube tube) {
        ClientPipelineHook clientPipelineHook = this.container.getSPI(ClientPipelineHook.class);
        if (clientPipelineHook != null) {
            ClientPipeAssemblerContext clientPipeAssemblerContext = new ClientPipeAssemblerContext(this.address, this.wsdlModel, this.rootOwner, this.binding, this.container);
            return PipeAdapter.adapt(clientPipelineHook.createSecurityPipe(clientPipeAssemblerContext, PipeAdapter.adapt(tube)));
        }
        return tube;
    }

    public Tube createWsaTube(Tube tube) {
        if (this.binding instanceof SOAPBinding && AddressingVersion.isEnabled(this.binding) && this.wsdlModel != null) {
            return new WsaClientTube(this.wsdlModel, this.binding, tube);
        }
        return tube;
    }

    public Tube createHandlerTube(Tube tube) {
        ClientSOAPHandlerTube clientSOAPHandlerTube = null;
        if (this.binding instanceof SOAPBinding) {
            clientSOAPHandlerTube = new ClientSOAPHandlerTube(this.binding, this.wsdlModel, tube);
            tube = clientSOAPHandlerTube;
        }
        return new ClientLogicalHandlerTube(this.binding, tube, clientSOAPHandlerTube);
    }

    public Tube createClientMUTube(Tube tube) {
        if (this.binding instanceof SOAPBinding) {
            return new ClientMUTube(this.binding, tube);
        }
        return tube;
    }

    public Tube createTransportTube() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.address.toString().equals("") || this.address.toString().equals("REPLACE_WITH_ACTUAL_URL")) {
            return new DeferredTransportPipe(classLoader, this);
        }
        return TransportTubeFactory.create(classLoader, this);
    }

    @NotNull
    public Codec getCodec() {
        return this.codec;
    }

    public void setCodec(@NotNull Codec codec) {
        this.codec = codec;
    }
}

