/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.ModifiedServiceEvent;
import org.eclipse.osgi.internal.serviceregistry.ServiceProperties;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.internal.serviceregistry.ServiceUse;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceRegistrationImpl
implements ServiceRegistration,
Comparable {
    private final Framework framework;
    private final ServiceRegistry registry;
    private final BundleContextImpl context;
    private final Bundle bundle;
    private final String[] clazzes;
    private final Object service;
    private ServiceReferenceImpl reference;
    private List contextsUsing;
    private ServiceProperties properties;
    private final long serviceid;
    private int serviceranking;
    private final Object registrationLock = new Object();
    private int state = 0;
    private static final int REGISTERED = 0;
    private static final int UNREGISTERING = 1;
    private static final int UNREGISTERED = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRegistrationImpl(ServiceRegistry registry, BundleContextImpl context, String[] clazzes, Object service) {
        this.registry = registry;
        this.context = context;
        this.bundle = context.getBundleImpl();
        this.framework = context.getFramework();
        this.clazzes = clazzes;
        this.service = service;
        this.serviceid = registry.getNextServiceId();
        Object object = this.registrationLock;
        synchronized (object) {
            this.contextsUsing = null;
            this.reference = new ServiceReferenceImpl(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(Dictionary props) {
        ServiceReferenceImpl ref;
        ServiceRegistry serviceRegistry = this.registry;
        synchronized (serviceRegistry) {
            this.context.checkValid();
            Object object = this.registrationLock;
            synchronized (object) {
                ref = this.reference;
                this.properties = this.createProperties(props);
            }
            if (Debug.DEBUG_SERVICES) {
                Debug.println("registerService[" + this.bundle + "](" + this + ")");
            }
            this.registry.addServiceRegistration(this.context, this);
        }
        this.registry.publishServiceEvent(new ServiceEvent(1, ref));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary props) {
        ServiceProperties previousProperties;
        ServiceReferenceImpl ref;
        ServiceRegistry serviceRegistry = this.registry;
        synchronized (serviceRegistry) {
            Object object = this.registrationLock;
            synchronized (object) {
                if (this.state != 0) {
                    throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
                }
                ref = this.reference;
                previousProperties = this.properties;
                this.properties = this.createProperties(props);
            }
            this.registry.modifyServiceRegistration(this.context, this);
        }
        this.registry.publishServiceEvent(new ModifiedServiceEvent(ref, previousProperties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        ServiceReferenceImpl ref;
        ServiceRegistry serviceRegistry = this.registry;
        synchronized (serviceRegistry) {
            Object object = this.registrationLock;
            synchronized (object) {
                if (this.state != 0) {
                    throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
                }
                if (Debug.DEBUG_SERVICES) {
                    Debug.println("unregisterService[" + this.bundle + "](" + this + ")");
                }
                this.registry.removeServiceRegistration(this.context, this);
                this.state = 1;
                ref = this.reference;
            }
        }
        this.registry.publishServiceEvent(new ServiceEvent(4, ref));
        int size = 0;
        BundleContextImpl[] users = null;
        Object object = this.registrationLock;
        synchronized (object) {
            this.state = 2;
            if (this.contextsUsing != null && (size = this.contextsUsing.size()) > 0) {
                if (Debug.DEBUG_SERVICES) {
                    Debug.println("unregisterService: releasing users");
                }
                users = this.contextsUsing.toArray(new BundleContextImpl[size]);
            }
        }
        int i = 0;
        while (i < size) {
            this.releaseService(users[i]);
            ++i;
        }
        Object object2 = this.registrationLock;
        synchronized (object2) {
            this.contextsUsing = null;
            this.reference = null;
        }
    }

    public ServiceReference getReference() {
        return this.getReferenceImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceReferenceImpl getReferenceImpl() {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.reference == null) {
                throw new IllegalStateException(Msg.SERVICE_ALREADY_UNREGISTERED_EXCEPTION);
            }
            return this.reference;
        }
    }

    private ServiceProperties createProperties(Dictionary p) {
        ServiceProperties props = new ServiceProperties(p);
        props.set("objectClass", this.clazzes, true);
        props.set("service.id", new Long(this.serviceid), true);
        props.setReadOnly();
        Object ranking = props.getProperty("service.ranking");
        this.serviceranking = ranking instanceof Integer ? (Integer)ranking : 0;
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceProperties getProperties() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getProperty(String key) {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.getProperty(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getPropertyKeys() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.properties.getPropertyKeys();
        }
    }

    long getId() {
        return this.serviceid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRanking() {
        Object object = this.registrationLock;
        synchronized (object) {
            return this.serviceranking;
        }
    }

    String[] getClasses() {
        return this.clazzes;
    }

    Object getServiceObject() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle getBundle() {
        Object object = this.registrationLock;
        synchronized (object) {
            block4: {
                if (this.reference != null) break block4;
                return null;
            }
            return this.bundle;
        }
    }

    /*
     * Exception decompiling
     */
    Object getService(BundleContextImpl user) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean ungetService(BundleContextImpl user) {
        ServiceUse use;
        Map servicesInUse;
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.state == 2) {
                return false;
            }
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("ungetService[" + user.getBundleImpl() + "](" + this + ")");
        }
        if ((servicesInUse = user.getServicesInUseMap()) == null) {
            return false;
        }
        Object object2 = servicesInUse;
        synchronized (object2) {
            use = (ServiceUse)servicesInUse.get(this);
            if (use == null) {
                return false;
            }
        }
        object2 = use;
        synchronized (object2) {
            if (!use.ungetService()) return true;
            Map map = servicesInUse;
            synchronized (map) {
                Object object3 = this.registrationLock;
                synchronized (object3) {
                    servicesInUse.remove(this);
                    this.contextsUsing.remove(user);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseService(BundleContextImpl user) {
        ServiceUse use;
        Map servicesInUse;
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.reference == null) {
                return;
            }
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("releaseService[" + user.getBundleImpl() + "](" + this + ")");
        }
        if ((servicesInUse = user.getServicesInUseMap()) == null) {
            return;
        }
        Object object2 = servicesInUse;
        synchronized (object2) {
            Object object3 = this.registrationLock;
            synchronized (object3) {
                use = (ServiceUse)servicesInUse.remove(this);
                if (use == null) {
                    return;
                }
                if (this.contextsUsing != null) {
                    this.contextsUsing.remove(user);
                }
            }
        }
        object2 = use;
        synchronized (object2) {
            use.releaseService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle[] getUsingBundles() {
        Object object = this.registrationLock;
        synchronized (object) {
            int size;
            block9: {
                block8: {
                    block7: {
                        if (this.state != 2) break block7;
                        return null;
                    }
                    if (this.contextsUsing != null) break block8;
                    return null;
                }
                size = this.contextsUsing.size();
                if (size != 0) break block9;
                return null;
            }
            Bundle[] bundles = new Bundle[size];
            int i = 0;
            while (i < size) {
                bundles[i] = ((BundleContextImpl)this.contextsUsing.get(i)).getBundleImpl();
                ++i;
            }
            return bundles;
        }
    }

    boolean isAssignableTo(Bundle client, String className) {
        return this.framework.isServiceAssignableTo(this.bundle, client, className, this.service.getClass());
    }

    public String toString() {
        int size = this.clazzes.length;
        StringBuffer sb = new StringBuffer(50 * size);
        sb.append('{');
        int i = 0;
        while (i < size) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.clazzes[i]);
            ++i;
        }
        sb.append("}=");
        sb.append(this.getProperties().toString());
        return sb.toString();
    }

    public int compareTo(Object object) {
        long otherId;
        int otherRanking;
        ServiceRegistrationImpl other = (ServiceRegistrationImpl)object;
        int thisRanking = this.getRanking();
        if (thisRanking != (otherRanking = other.getRanking())) {
            if (thisRanking < otherRanking) {
                return 1;
            }
            return -1;
        }
        long thisId = this.getId();
        if (thisId == (otherId = other.getId())) {
            return 0;
        }
        if (thisId < otherId) {
            return -1;
        }
        return 1;
    }
}

