/*
 * Decompiled with CFR 0.152.
 */
package jdd.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import jdd.sat.CNF;
import jdd.sat.DimacsReader;
import jdd.sat.Solver;
import jdd.sat.bdd.BDDSolver;
import jdd.sat.bdd.BDDSolver2;
import jdd.sat.dpll.DPLLSolver;
import jdd.sat.gsat.GSAT2Solver;
import jdd.sat.gsat.WalkSATSolver;
import jdd.util.JDDConsole;
import jdd.util.TextAreaTarget;

public class SolverApplet
extends Applet
implements ActionListener {
    private TextArea msg;
    private TextArea code;
    private Button bSolve;
    private Button bClear;
    private Button bLoad;
    private Choice chModels;
    private Choice chSolver;
    private Checkbox cbVerbose;
    private String initial_text = "c This applet demonstrates solving CNF [Conjunctive Normal Form, aka product of sums] formulas.\nc A solution to such formula is a series of assignments to each variables that makes the formula\nc become logically true. If no such solution exists, the formula is UNSATisfiable.\nc A DIMACS formula starts with the line  'p cnf num-of-variables num-of-cluases'\nc A clause is a set of disjunctions where a number n represents variable v_n being true, while\nc -n indicates v_n being false. Each clause end with a zero. For example the formula\nc 'f(v1,v2,v3) = (v1 OR v2) AND (v2 or NOT v3) AND (v3 or NOT v2)' looks like this in DIMACS:\np cnf 3 3\n1 2 0\n2 -3 0\n3 -2 0\n";

    public SolverApplet() {
        Color color = new Color(224, 224, 224);
        this.setBackground(color);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(new FlowLayout(0));
        panel.setBackground(color);
        this.add((Component)panel, "North");
        this.bSolve = new Button("Solve");
        panel.add(this.bSolve);
        this.bClear = new Button("Clear");
        panel.add(this.bClear);
        panel.add(new Label(" models: "));
        this.chModels = new Choice();
        panel.add(this.chModels);
        this.bLoad = new Button("<-- load");
        panel.add(this.bLoad);
        panel.add(new Label(" Solver:"));
        this.chSolver = new Choice();
        panel.add(this.chSolver);
        this.chSolver.add("BDD");
        this.chSolver.add("BDD2");
        this.chSolver.add("GSAT");
        this.chSolver.add("WalkSAT");
        this.chSolver.add("DPLL");
        this.cbVerbose = new Checkbox("verbose", false);
        panel.add(this.cbVerbose);
        this.code = new TextArea(25, 80);
        this.add((Component)this.code, "Center");
        this.msg = new TextArea(10, 80);
        this.add((Component)this.msg, "South");
        this.msg.setEditable(false);
        this.msg.setBackground(color);
        this.bSolve.addActionListener(this);
        this.bClear.addActionListener(this);
        this.bLoad.addActionListener(this);
        JDDConsole.out = new TextAreaTarget(this.msg);
        this.code.setFont(new Font("Monospaced", 0, 12));
        this.code.setBackground(Color.yellow);
        this.code.setForeground(Color.red);
        this.code.setText(this.initial_text);
        this.chModels.add("8xQueens.cnf.gz");
        this.chModels.add("aim-50-1_6-no-2.cnf.gz");
        this.chModels.add("aim-50-2_0-yes1-2.cnf.gz");
        this.chModels.add("aim-50-3_4-yes1-4.cnf.gz");
        this.chModels.add("aim-100-1_6-no-2.cnf.gz");
        this.chModels.add("aim-100-6_0-yes1-2.cnf.gz");
        this.chModels.add("aim-200-2_0-yes1-2.cnf.gz");
        this.chModels.add("aim-200-3_4-yes1-3.cnf.gz");
        this.chModels.add("dubois22.cnf.gz");
        this.chModels.add("par16-4.cnf.gz");
    }

    private void load(BufferedReader bufferedReader) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            this.code.setText("(reading file, please wait)");
            while ((string = bufferedReader.readLine()) != null) {
                int n = (string = string.trim()).length();
                if (n <= 0) continue;
                if (string.charAt(0) != 'c' || string.length() > 2) {
                    // empty if block
                }
                stringBuffer.append(string);
                if (n < 2 || string.charAt(0) == 'c' || string.charAt(0) == 'p' || string.charAt(n - 1) == '0' && (string.charAt(n - 2) > '9' || string.charAt(n - 2) < '0')) {
                    stringBuffer.append('\n');
                    continue;
                }
                stringBuffer.append(' ');
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            this.msg.append("Failed: " + iOException + "\n");
            iOException.printStackTrace();
            this.code.setText("");
            iOException.printStackTrace();
            return;
        }
        this.code.setText(stringBuffer.toString());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.bSolve) {
            this.doSolve();
        } else if (object == this.bClear) {
            this.doClear();
        } else if (object == this.bLoad) {
            this.doLoad();
        }
    }

    private void doClear() {
        this.msg.setText("");
        this.code.setText("");
    }

    private void doLoad() {
        try {
            String string = "/dimacs/" + this.chModels.getSelectedItem();
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                this.msg.append("UNABLE to load " + string + "\n");
                return;
            }
            BufferedReader bufferedReader = null;
            bufferedReader = string.endsWith(".gz") || string.endsWith(".Z") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(inputStream))) : new BufferedReader(new InputStreamReader(inputStream));
            this.load(bufferedReader);
            inputStream.close();
        }
        catch (IOException iOException) {
            this.msg.append("--> " + iOException + "\n");
        }
    }

    private Solver getSolver() {
        JDDConsole.out.println("Loading solver '" + this.chSolver.getSelectedItem() + "'...");
        int n = this.chSolver.getSelectedIndex();
        boolean bl = this.cbVerbose.getState();
        switch (n) {
            case 0: {
                return new BDDSolver(bl);
            }
            case 1: {
                return new BDDSolver2(bl);
            }
            case 2: {
                return new GSAT2Solver(15000L);
            }
            case 3: {
                return new WalkSATSolver(15000L, 0.05);
            }
            case 4: {
                return new DPLLSolver();
            }
        }
        return null;
    }

    private void doSolve() {
        String string = this.code.getText();
        if (string == null) {
            return;
        }
        try {
            DimacsReader dimacsReader = new DimacsReader(string, false);
            Solver solver = this.getSolver();
            CNF cNF = dimacsReader.getFormula();
            solver.setFormula(cNF);
            dimacsReader = null;
            int[] nArray = solver.solve();
            solver.cleanup();
            if (nArray != null) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (i % 64 == 0) {
                        this.msg.append("\n");
                    }
                    this.msg.append(nArray[i] == -1 ? "-" : "" + nArray[i]);
                }
                this.msg.append("\n");
            }
        }
        catch (Exception exception) {
            this.msg.append("\nFailed: " + exception + "\n");
            exception.printStackTrace();
        }
    }
}

