/*
 * Decompiled with CFR 0.152.
 */
package jdd.graph;

import jdd.graph.Edge;
import jdd.graph.Graph;
import jdd.graph.Node;
import jdd.util.Test;

public class Factory {
    public static Graph complete(int n) {
        int n2;
        Node[] nodeArray = new Node[n];
        Graph graph = new Graph(false);
        for (n2 = 0; n2 < n; ++n2) {
            nodeArray[n2] = graph.addNode();
        }
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = n2 + 1; i < n; ++i) {
                graph.addEdge(nodeArray[n2], nodeArray[i]);
            }
        }
        return graph;
    }

    public static Graph complete_bipartie(int n, int n2) {
        int n3;
        Node[] nodeArray = new Node[n + n2];
        Graph graph = new Graph(false);
        for (n3 = 0; n3 < nodeArray.length; ++n3) {
            nodeArray[n3] = graph.addNode();
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (int i = 0; i < n2; ++i) {
                graph.addEdge(nodeArray[n3], nodeArray[n + i]);
            }
        }
        return graph;
    }

    public static Graph path(int n) {
        return Factory.sequence(n, false);
    }

    public static Graph circle(int n) {
        return Factory.sequence(n, true);
    }

    private static Graph sequence(int n, boolean bl) {
        int n2;
        Node[] nodeArray = new Node[n];
        Graph graph = new Graph(false);
        for (n2 = 0; n2 < n; ++n2) {
            nodeArray[n2] = graph.addNode();
        }
        for (n2 = 1; n2 < n; ++n2) {
            graph.addEdge(nodeArray[n2 - 1], nodeArray[n2]);
        }
        if (bl) {
            graph.addEdge(nodeArray[0], nodeArray[n - 1]);
        }
        return graph;
    }

    public static Graph tree(int n, int n2) {
        Graph graph = new Graph(true);
        if (n > 0) {
            Node node = graph.addNode();
            node.flags |= 1;
            Factory.tree_rec(graph, node, n - 1, n2);
        }
        return graph;
    }

    private static void tree_rec(Graph graph, Node node, int n, int n2) {
        if (n == 0) {
            node.flags |= 4;
            return;
        }
        for (int i = 0; i < n2; ++i) {
            Node node2 = graph.addNode();
            graph.addEdge(node, node2);
            Factory.tree_rec(graph, node2, n - 1, n2);
        }
    }

    public static Graph permutation(int n) {
        return Factory.permutation(n, n);
    }

    public static Graph permutation(int n, int n2) {
        Graph graph = new Graph(true);
        if (n > 0) {
            Node node = graph.addNode();
            node.flags |= 1;
            Factory.permutation_rec(graph, node, n - 1, n2);
        }
        return graph;
    }

    private static void permutation_rec(Graph graph, Node node, int n, int n2) {
        if (n == 0) {
            node.flags |= 4;
            return;
        }
        for (int i = 0; i < n2; ++i) {
            Node node2 = graph.addNode();
            Edge edge = graph.addEdge(node, node2);
            Factory.tree_rec(graph, node2, n - 1, n2 - 1);
        }
    }

    public static void internal_test() {
        Test.start("Factory");
        Graph graph = Factory.complete(4);
        Test.checkEquality(graph.numOfEdges(), graph.numOfNodes() * (graph.numOfNodes() - 1) / 2, "complete graph (1)");
        Graph graph2 = Factory.complete(7);
        Test.checkEquality(graph2.numOfEdges(), graph2.numOfNodes() * (graph2.numOfNodes() - 1) / 2, "complete graph (2)");
        Graph graph3 = Factory.complete(32);
        Test.checkEquality(graph3.numOfEdges(), graph3.numOfNodes() * (graph3.numOfNodes() - 1) / 2, "complete graph (3)");
        Graph graph4 = Factory.tree(3, 2);
        Test.checkEquality(graph4.numOfEdges(), 6, "tree (1)");
        Test.checkEquality(graph4.numOfNodes(), 1 + graph4.numOfEdges(), "tree (2)");
        Graph graph5 = Factory.tree(5, 3);
        Test.checkEquality(graph5.numOfEdges(), 120, "tree (3)");
        Test.checkEquality(graph5.numOfNodes(), 1 + graph5.numOfEdges(), "tree (4)");
        Graph graph6 = Factory.permutation(3, 5);
        Test.checkEquality(graph6.numOfNodes(), 1 + graph6.numOfEdges(), "permutation (1)");
        Test.checkEquality(graph6.numOfEdges(), 25, "permutation (2)");
        Graph graph7 = Factory.permutation(5, 3);
        Test.checkEquality(graph7.numOfNodes(), 1 + graph7.numOfEdges(), "permutation (3)");
        Test.checkEquality(graph7.numOfEdges(), 45, "permutation (4)");
        Test.end();
    }
}

