<?php
/**
 * phpoot - template engine for php
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @author Haruki Setoyama <haruki@planewave.org>
 * @copyright Copyright &copy; 2003-2004, Haruki SETOYAMA <haruki@planewave.org>
 * @license http://www.opensource.org/licenses/lgpl-license.php LGPL
 * @version 0.6- $Id: date.php,v 1.1 2004/05/11 05:36:51 haruki Exp $
 * @link http://phpoot.sourceforge.jp/
 * @package phpoot
 * @subpackage _format
 */
/**
 * offset for date formatting. (second)
 */
$GLOBALS['PHPOOT_OFFSET'] = null;
/**
 * print formated date
 */
function phpoot_format_date($val, $var, $format, $quiet =true)
{
    if (is_numeric($val)) {
		if (isset($GLOBALS['PHPOOT_OFFSET'])) {
		    echo gmdate($format, (int)$val+(int)$GLOBALS['PHPOOT_OFFSET']);
		} else {
			echo date($format, (int)$val);
		}  
    }
    elseif (is_array($val)
    && (is_numeric($val[$var]))) {
		if (isset($GLOBALS['PHPOOT_OFFSET'])) {
		    echo gmdate($format, (int)$val[$var]+(int)$GLOBALS['PHPOOT_OFFSET']);
		} else {
			echo date($format, (int)$val[$var]);
		}
    }
    else {
        echo (! $quiet) ? "<!-- NON NUMERIC DATA '$var' -->" : '';
    }
}
/**
 * set offset time (sec.)
 */
function phpoot_format_date_option($sec)
{
	$GLOBALS['PHPOOT_OFFSET'] = (int)$sec;
}
?>