<?php
/**
 * phpoot - template engine for php
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @author Haruki Setoyama <haruki@planewave.org>
 * @copyright Copyright &copy; 2003-2004, Haruki SETOYAMA <haruki@planewave.org>
 * @license http://www.opensource.org/licenses/lgpl-license.php LGPL
 * @version 0.4 $Id: phpoot.compiler.php,v 1.9 2004/03/04 12:02:30 haruki Exp $
 * @link http://phpoot.sourceforge.jp/
 * @package phpoot
 */
/**
* Requires PHPOOT
*/
require_once 'phpoot.php';

/**
 * PHPOOT user interfase for template compiling
 *
 * @access public
 * @package phpoot
 * @subpackage sub_interface
 */
class phpoot_compiler extends phpoot {

    /**
     * path to directory where template files are
     * @var string
     * @access private
     */
    var $_template_dir;

    /**
     * set a path for directory where template files are
     *
     * @param stirng $dir
     * @return void
     */
    function setTemplateDir($dir)
    {
        $this->_template_dir = $dir;
        if (! $this->_compiled_dir_use) {
            $this->_compiled_dir = $this->_template_dir;
        }
    }

    /**
     * compile all the template files in TemplateDir
     *
     * @param stirng $ext   extention of templates
     * @return void
     */
    function compileAll($ext ='html')
    {
        $compiled = array();
        if (is_dir($this->_template_dir)) {
            $ext = '.' . $ext;
            $ext_len = 0 - strlen($ext);

            $handle = opendir($this->_template_dir);
            if (! $handle) return $this->raiseError("Fail to open directory '$this->_template_dir'. ");
            while (false !== ($file = readdir($handle))) {
                if (substr($file, $ext_len) == $ext) {
                    $compiled_file = $this->_compiled_dir . '/' . $file . PHPOOT_EXT;
                    $this->_template_file = $this->_template_dir . '/' . $file;
                    $err = $this->_compile($compiled_file);
                    if ($err !== true) {
                        $this->raiseError($err);
                    } else {
                        $compiled[] = $file;
                    }
                }
            }
        }
        return $compiled;
    }

    /**
     * remove all the compiled template files in CompiledDir
     *
     * @param stirng $ext   extention of templates
     * @return void
     */
    function removeCompiled($ext ='html')
    {
        $removed = array();
        if (is_dir($this->_template_dir)) {
            $ext = '.' . $ext;
            $ext_len = 0 - strlen($ext);

            $handle = opendir($this->_template_dir);
            if (! $handle) return $this->raiseError("Fail to open directory '$this->_template_dir'. ");
            while (false !== ($file = readdir($handle))) {
                if (substr($file, $ext_len) == $ext) {
                    $compiled_file = $this->_compiled_dir . '/' . $file . PHPOOT_EXT;
                    if (file_exists($compiled_file) && unlink($compiled_file)) {
                        $removed[] = $compiled_file;
                    }
                }
            }
        }
        return $removed;
    }
}
?>