<?php
// phpoot, PHP Object Orient style Template engine
//
// Copyright (C) Haruki Setoyama <haruki@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
* phpoot, PHP Object Orient style Template engine
*
* @author Haruki Setoyama  <haruki@planewave.org>
* @version $Id: phpoot.php,v 1.4 2002/12/23 01:09:00 haruki Exp $
* @package phpoot
**/
/**
* debug mode of phpoot
**/
if(!defined('PHPOOT_DEBUG')){
    define('PHPOOT_DEBUG',true);
}
/**
* phpoot, PHP Object Orient style Template engine
*
* @access public
**/
class phpoot {

    /**
    * variable for pathes
    *
    * @var string $template_dir     end with '/'
    * @var string $template_file
    * @var string $compile_dir      end with '/'
    * @access public
    **/
    var $template_dir;
    var $template_file;
    var $compile_dir;

    /**
    * variable for variations
    *
    * @var string $default     end with '/' or blank
    * @var string $variation
    * @access public
    **/
    var $default = '';
    var $variation = '';

    /**
    * variable for options
    *
    * @access public
    **/
    var $file_exists_check = true;
    var $compiled_file_exention = '.php';

    /**
    * variable for template
    *
    * @access public
    **/
    var $val = array();

    /**
    * @access private
    **/
    var $_real_template_file;
    var $_real_compiled_file;

    /**
    * constructor
    * @access public
    **/
    function phpoot(){

    }

    /**
    * set a value for the template
    * @access public
    * @param string $index
    * @param mixed $val
    * @return void
    */
    function setVal($index, $val){
        $this->val[$index] = $val;
    }

    /**
    * returns the template output
    * @access public
    * @return string
    */
    function fetch() {
        if(! $this->_set_real_path()){
            return false;
        }
        if($this->_need_compile()){
            include_once 'phpoot.compiler.php';
            $compiler = new phpoot_compiler;
            if(! $compiler->compile($this->_real_template_file, $this->_real_compiled_file))
                return '';
        }
        include_once $this->_real_compiled_file;
        $classname = 'phpoot_c_'.str_replace('.','_',$this->template_file);
        $compiled = new $classname;
        return $compiled->fetch($this->val);
	}

    /**
    * print the template output
    * @access public
    * @return void
    */
    function display() {
        echo $this->fetch();
    }

    /**
    * set the path of the template and the directory for compile
    * @access private
    * @return bool
    */
	function _set_real_path(){
	    $_real_template_dir = $this->template_dir;
        if($this->variation != '') {
            if(is_dir($_real_template_dir.$this->variation.'/')){
                $_real_template_dir .= $this->variation.'/';
                $_variation_dir = $this->variation.'/';
            }else{
                $_real_template_dir .= $this->default;
                $_variation_dir = $this->default;
            }
	    }

        $this->_real_template_file = $_real_template_dir.$this->template_file;

        if(empty($this->compile_dir)){
            $this->compile_dir = $this->template_dir.'compiled/';
        }
        $_real_compile_dir = $this->compile_dir;

        if($this->variation != '')
            $_real_compile_dir .= $_variation_dir;
        $this->_real_compiled_file = $_real_compile_dir.$this->template_file.$this->compiled_file_exention;

        // checking the template file and the compile directory
        if(! $this->file_exists_check)
            return true;

        if(! is_readable($this->_real_template_file)) {
            return false;
        }

        if(is_file($this->_real_compiled_file)){
            if(is_writable($this->_real_compiled_file)){
                return true;
            } else {
                return false;
            }
        }

        if(is_dir($_real_compile_dir)) {
            if(is_writable($_real_compile_dir)) {
                return true;
            } else {
                return false;
            }
        } else {
            if(@mkdir($_real_compile_dir, 0766)){
                return true;
            }
        }

		return false;
	}

    /**
    * check if compiling is need
    * @access private
    * @return bool
    */
    function _need_compile() {
        if(! file_exists($this->_real_compiled_file))
            return true;
        if(filemtime($this->_real_template_file) >= filemtime($this->_real_compiled_file))
            return true;
        return false;
    }

}


/**
* phpoot_compiled
*
* @access public
**/
class phpoot_compiled {
    function fetch($val){
        return $this->_compiled_0($val);
    }
}
?>