<?php
// phpoot, PHP Object Orient style Template engine
//
// Copyright (C) Haruki Setoyama <haruki@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/**
* buffer for phpoot
*
* @author Haruki Setoyama  <haruki@planewave.org>
* @version $Id: phpoot.buffer.php,v 1.2 2002/12/23 01:09:00 haruki Exp $
* @package phpoot
**/
/**
* phpoot_buffer
*
* @access public
**/
class phpoot_buffer {

    /**
    * variables
    * @access private
    * @var $_buf    buffer itself
    * @var $_num    current buffer
    * @var $_max    number of buffers
    * @var $_out_var    variable name for output
    **/
    var $_buf;
    var $_num=0;
    var $_max=0;
    var $_out_var = '$out';

    /**
    * stack
    * @access private
    * @var $_stack_num
    * @var $_stack_out_var
    **/
    var $_stack_num = array();
    var $_stack_out_var;

    /**
    * constructor
    * @access public
    **/
    function phpoot_buffer() {
        $this->_buf[0] = array();
        $this->_stack_out_var[0] = array();
    }

    /**
    * set data into the buffer
    * @access public
    **/
    function set($data){
        $this->_buf[$this->_num][] = $data;
    }

    /**
    * set variable type data into the buffer
    * @access public
    **/
    function setVariable($data){
        if(strlen($data) > 0)
            $this->_buf[$this->_num][] = array($this->_out_var, $data);
    }

    /**
    * set text data into the buffer
    * @access public
    **/
    function setText($data){
        $tail_n = 0;
        while(substr($data,-1) == "\n"){
            $tail_n++;
            $data = substr($data,0,strlen($scaned['parm'])-1);
        }
        $head_n = 0;
        while(substr($data,0,1) == "\n"){
            $head_n++;
            $data = substr($data,1);
        }
        if($head_n > 0)
            $this->_buf[$this->_num][] = array($this->_out_var, '"'.str_repeat('\n',$head_n).'"'."\n");
        if(strlen($data) > 0)
            $this->_buf[$this->_num][] = array($this->_out_var, $this->_quote($data));
        if($tail_n > 0)
            $this->_buf[$this->_num][] = array($this->_out_var, '"'.str_repeat('\n',$tail_n).'"'."\n");
    }

    /**
    * set PHP sentnce type data into the buffer
    * @access public
    **/
    function setSentence($data){
        if(strlen($data) > 0)
            $this->_buf[$this->_num][] = $data;
    }

    /**
    * push variable name for output
    * @access public
    **/
    function pushOutVar($name=''){
        array_push($this->_stack_out_var[$this->_num], $this->_out_var);
        if($name != '')
            $this->setOutVar($name);
    }

    /**
    * set variable name for output
    * @access public
    **/
    function setOutVar($name){
        $this->_out_var = $name;
    }

    /**
    * pop variable name for output
    * @access public
    **/
    function popOutVar(){
        $this->_out_var = array_pop($this->_stack_out_var[$this->_num]);
    }

    /**
    * create brandnew buffer
    * @access public
    **/
    function newBuffer(){
        $this->_max++;
        $this->_buf[$this->_max] = array();
        $this->_stack_out_var[$this->_max] = array();
        array_push($this->_stack_num, $this->_num);
        $this->pushOutVar();
        $this->_num = $this->_max;
        $this->_out_var = '$out';
        return $this->_num;
    }

    /**
    * get the number of buffer that will be created next
    * @access public
    **/
    function newBufferNumber(){
        return $this->_max+1;
    }

    /**
    * get the number of current buffer
    * @access public
    **/
    function bufferNumber(){
        return $this->_num;
    }

    /**
    * go back to previous buffer
    * @access public
    **/
    function prevBuffer(){
        $this->_num = array_pop($this->_stack_num);
        $this->popOutVar();
    }

    /**
    * get all the contents buffers hold
    * @access public
    **/
    function getAll(){
        for($i=0; $i<=$this->_max; $i++){
            $ret[$i] = $this->_implode_buffer($this->_buf[$i]);
        }
        return $ret;
    }

/////////////////////////////
///// private functions /////
/////////////////////////////

    /**
    * single quote a string
    * @access private
    * @param string $str
    * @return string
    */
    function _quote($str){
        return  '\''.str_replace(array('\'','\\'),array('\\\'','\\\\'),$str).'\'';
    }

    function _implode_buffer($arr){
        $ret='';
        $flag_sentence=true;
        $flag_val = '';
        foreach($arr as $val){
            if(is_array($val)){
                if($flag_sentence){
                    $ret .= "\n".$val[0].' .= '.$val[1];
                }elseif($flag_val != $val[0]){
                    if(substr($ret,-1)=="\n") {
                        $ret = substr($ret,0,strlen($ret)-1).";\n";
                    }else{
                        $ret .= ";\n";
                    }
                    $ret .= $val[0].' .= '.$val[1];
                }else{
                    if(substr($ret,-1)=="\n") $ret .= ' ';
                    $ret .= '.'.$val[1];
                }
                $flag_sentence=false;
                $flag_val=$val[0];
            }else{
                if(! $flag_sentence){
                    if(substr($ret,-1)=="\n") $ret = substr($ret,0,strlen($ret)-1);
                    $ret .= ';';
                }
                $ret .= "\n".$val;
                $flag_sentence = true;
            }
        }
        if(! $flag_sentence){
            if(substr($ret,-1)=="\n") $ret = substr($ret,0,strlen($ret)-1);
            $ret .= ';';
        }
        return $ret;
    }
}

?>