<?php
// phpoot, PHP Object Orient style Template engine
//
// Copyright (C) Haruki Setoyama <haruki@planewave.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/**
* parsers for phpoot compiler
*
* @author Haruki Setoyama  <haruki@planewave.org>
* @version $Id: phpoot.parsers.php,v 1.4 2002/12/23 01:09:00 haruki Exp $
* @package phpoot
**/
/**
* phpoot_parser_val
*
* @access public
**/
class phpoot_parser_val extends phpoot_parser {

    /**
    * constructor
    * @access public
    **/
    function phpoot_parser_val(&$buffer, &$manager){
        $this->buffer =& $buffer;
        $this->manager =& $manager;
    }

    function parse($scaned){
        if($scaned['type'] != 'tag' && $scaned['type'] != 'val')
            return false;

        if($scaned['subtype'] != 'val')
            return false;

        $scaned_param = $this->_scan_parameter($scaned['parm']);
        if(! $scaned_param || $scaned_param[0]['type'] != 'variable') return 'error';

        $parsed = $this->manager->parseVariable($scaned_param[0]);
        if(! $parsed)  return 'error';

        if($scaned['type'] == 'val') {
            $this->buffer->setVariable($parsed);
        }
        else{
            $this->buffer->set($parsed);
        }
        return true;
    }

}

/**
* phpoot_parser_each
*
* @access public
**/
class phpoot_parser_each extends phpoot_parser {

    /**
    * constructor
    * @access public
    **/
   function phpoot_parser_each(&$buffer, &$manager){
        $this->buffer =& $buffer;
        $this->manager =& $manager;
    }

	function parse($scaned){
        if($scaned['type'] != 'tag')
            return false;

        switch($scaned['subtype']){

        case 'each':
            $scaned_param = $this->_scan_parameter($scaned['parm']);
            if(! $scaned_param)  return 'error';

            $parsed_variable = $this->manager->parseVariable($scaned_param[0]);
            if(! $parsed_variable) return 'error';

            $loop_variable = $this->manager->parseLoopVariable($scaned_param[1]);
            if(! $loop_variable) return 'error';

            if($scaned_param[0]['vartype'] != 'method'){
                $this->buffer->set("\nforeach(".$parsed_variable.' as '.$loop_variable.'){ ');
            }else{
                $this->buffer->set("\nwhile(".$loop_variable.' = '.$parsed_variable.') { ');
            }
            $this->manager->pushLoop('each');
            $this->manager->pushLoopVariable($scaned_param[1], $loop_variable);

            break;

        case '/each':
            if($this->manager->getCurrentLoop() != 'each'){
                $this->_put_error('Invalid location of [/each] tag.');
                return 'error';
            }

            $loopvar = $this->manager->getLoopVariable();
            if($loopvar == false){
                $this->_put_error('[each] tag error.');
                return 'error';
            }

            $this->manager->popLoop();
            $this->manager->popLoopVariable();
            $this->buffer->set("}\n");
            break;

        default:
            return false;
        }

        return true;
    }

    function _scan_parameter($str){
        $scaned = $this->_scan_parameter_sub($this->_tokenize_parameter($str));

        if($scaned[0]['type']!='variable'){
            $this->_put_error('Parameter of each tag do not start from variable.');
            return false;
        }
        if(count($scaned)==1){
            $ret[0] = $scaned[0];
            $ret[1] = $scaned[0];
            return $ret;
        }
        if(count($scaned)==3 && $scaned[1]['type']=='as'
        && $scaned[2]['type']=='variable' && $scaned[2]['vartype']=='loop') {
            $ret[0] = $scaned[0];
            $ret[1] = $scaned[2];
            return $ret;
        }
        $this->_put_error('Invalid parameter of each tag.');
        return false;
    }

    function _tokenize_parameter($str){
        $tokens[] = array('\s+as\s+','as');
        return $this->_tokenize_parameter_sub($str, $tokens);
    }

}

/**
* phpoot_parser_reach
*
* @access public
**/
class phpoot_parser_loop extends phpoot_parser {

    var $loop_variable_stack = array();

    /**
    * constructor
    * @access public
    **/
    function phpoot_parser_loop(&$buffer, &$manager){
        $this->buffer =& $buffer;
        $this->manager =& $manager;
    }

    function parse($scaned){
        if($scaned['type'] != 'tag')
            return false;

        switch($scaned['subtype']){

        case 'loop':
            $scaned_param = $this->_scan_parameter($scaned['parm']);

            if(! $scaned_param)  return 'error';

            $var = $this->manager->parseVariable($scaned_param['var']);
            if(! $var) return 'error';

            $by = $this->manager->parseVariable($scaned_param['by']);
            if(! $by) return 'error';

            $loop_variable = $this->manager->parseLoopVariable($scaned_param['as']);
            if(! $loop_variable) return 'error';

            $buf_num = $this->buffer->newBufferNumber();

            $this->buffer->setVariable('$this->_compiled_'.$buf_num.'($val, $loop, '.$var.')');

            $this->buffer->newBuffer();

            if($scaned_param['by']['vartype'] != 'method'){
                $this->buffer->setSentence('foreach( $param'.$by.' as '.$loop_variable.'){ ');
            }else{
                $this->buffer->setSentence('while('.$loop_variable.' = $param'.$by.') { ');
            }
            $this->manager->pushLoop('loop');
            $this->manager->pushLoopVariable($scaned_param['as'], $loop_variable);
            array_push($this->loop_variable_stack, $loop_variable);
            break;

        case 'again':
            // again tag can be used in other loop like if tag.
            if(count($this->loop_variable_stack) == 0){
                return 'error';
            }
            $buf_num = $this->buffer->bufferNumber();
            $loop_variable = $this->loop_variable_stack[count($this->loop_variable_stack)-1];
            $this->buffer->setVariable('$this->_compiled_'.$buf_num.'($val, $loop, '.$loop_variable.')');
            break;

        case '/loop':
            if($this->manager->getCurrentLoop() != 'loop'){
                $this->_put_error('Invalid location of [/loop] tag.');
                return 'error';
            }
            $this->manager->popLoop();

            if($this->manager->popLoopVariable() == false){
                $this->_put_error('"loop" tag error.');
                return 'error';
            }

            $this->buffer->setSentence("}\n");
            $this->buffer->prevBuffer();
            array_pop($this->loop_variable_stack);
            break;

        default:
            return false;
        }

        return true;
    }

    function _scan_parameter($str){
        $scaned = $this->_scan_parameter_sub($this->_tokenize_parameter($str));

        if(count($scaned)!=5){
        	$this->_put_error('Invalid number of the parameter of loop tag.');
            return false;
        }
        if($scaned[0]['type']=='variable'){
       		$ret['var'] = $scaned[0];
        }else{
            $this->_put_error('Parameter of loop tag do not start from variable.');
            return false;
        }
        $i=1;
        while($i<5){
            if($scaned[$i]['type']=='by'){
                if($scaned[$i+1]['type']=='variable-nohead'){
                    $ret['by'] = $scaned[$i+1];
                }
            }
            elseif($scaned[$i]['type']=='as'){
                if($scaned[$i+1]['type']=='variable' && $scaned[$i+1]['vartype']=='loop'){
                    $ret['as'] = $scaned[$i+1];
                }
            }else{
                $this->_put_error('Invalid parameter of loop tag.');
                return false;
            }
            $i+=2;
        }
        return $ret;
    }

    function _tokenize_parameter($str){
        $tokens[] = array('\s+as\s+','as');
        $tokens[] = array('\s+by\s+','by');
        return $this->_tokenize_parameter_sub($str, $tokens);
    }
}

/**
* phpoot_parser_other
*
* @access public
**/
class phpoot_parser_other extends phpoot_parser {

    /**
    * constructor
    * @access public
    **/
    function phpoot_parser_other(&$buffer, &$manager){
        $this->buffer =& $buffer;
        $this->manager =& $manager;
    }

    function parse($scaned){

        if($scaned['subtype'] == 'comment')
            return true;

        if($scaned['type'] == 'val')
            $this->_put_error('Invalid variable.');
        if($scaned['type'] == 'tag')
            $this->_put_error('Undefined phpoot tag.');

        if(isset($scaned['orig'])){
            $this->buffer->setText($scaned['orig']);
        }else{
            $this->buffer->setText($scaned['parm']);
        }

        return true;
    }

}

/**
* phpoot_parser_tpl
*
* @access public
**/
class phpoot_parser_tpl extends phpoot_parser {

    /**
    * constructor
    * @access public
    **/
    function phpoot_parser_tpl(&$buffer, &$manager){
        $this->buffer =& $buffer;
        //$this->manager =& $manager;
    }

    function parse($scaned){
        switch($scaned['type']){

        case 'tpl':
            $this->buffer->setText($scaned['parm']);
            break;

        default:
            return false;
        }
        return ture;
    }

}

/**
* phpoot_parser_if
*
* @access public
**/
class phpoot_parser_if extends phpoot_parser {

    /**
    * constructor
    * @access public
    **/
    function phpoot_parser_if(&$buffer, &$manager){
        $this->buffer =& $buffer;
        $this->manager =& $manager;
    }

    function parse($scaned){
        if($scaned['type'] != 'tag')
            return false;

        switch($scaned['subtype']){

        case 'if':
            $scaned = $this->_scan_parameter($scaned['parm']);
            if(! $scaned)
                return 'error';
            $this->buffer->setSentence("\nif(".$this->_parse_parameter($scaned).') { ');
            $this->manager->pushLoop('if');
            break;

        case 'elseif':
            if($this->manager->getCurrentLoop() != 'if'){
                $this->_put_error('Invalid location of [elseif] tag.');
                return 'error';
            }
            $scaned = $this->_scan_parameter($scaned['parm']);
            if(! $scaned)
                return 'error';
            $this->buffer->setSentence("}\nelseif(".$this->_parse_parameter($scaned).') { ');
            break;

        case 'else':
            if($this->manager->getCurrentLoop() != 'if'){
                $this->_put_error('Invalid location of [else] tag.');
                return 'error';
            }
            $this->buffer->setSentence("}\nelse { ");
            break;

        case '/if':
            if($this->manager->getCurrentLoop() != 'if'){
                $this->_put_error('Invalid location of [/if] tag.');
                return 'error';
            }
            $this->manager->popLoop();
            $this->buffer->setSentence("}\n");
            break;

        default:
            return false;

        }
        return true;
    }

    function _tokenize_parameter($str){
        $tokens[] = array('(?:count|isset|strlen|substr|empty)\s*\(','function');
        $tokens[] = array('\s*(?:!==|===|and|or|\|\||&&|==|!=|<>|<=|>=|<<|<|>|\+|\-|\*|\/|\^|\.)\s*','operator');
        $tokens[] = array('\s*!\s*','operator2');
        return $this->_tokenize_parameter_sub($str, $tokens);
    }

    function _scan_parameter($str){
        $str = str_replace("\n",' ',$str);
        $scaned = $this->_scan_parameter_sub($this->_tokenize_parameter($str));

        $parens=0;
        $apart[] = array('double-quoted','single-quoted','variable','number');
        $apart[] = array('operator');
        $ban = array('etc','variable-nohead');
        for($i=0; $i<count($scaned)-1; $i++){
            if(in_array($scaned[$i]['type'],$ban)){
                $this->_put_error('Invalid parameter.');
                return false;
            }
            foreach($apart as $hey){
                if(in_array($scaned[$i]['type'],$hey) && in_array($scaned[$i+1]['type'],$hey)){
                    $this->_put_error('Invalid order of parameters');
                    return false;
                }
            }
            if($scaned[$i]['type'] == 'open-paren' || $scaned[$i]['type'] == 'function')
                $parens++;
            if($scaned[$i]['type'] == 'close-paren')
                $parens--;
        }
        if($scaned[$i]['type'] == 'open-paren' || $scaned[$i]['type'] == 'function')
            $parens++;
        if($scaned[$i]['type'] == 'close-paren')
            $parens--;

        if($parens > 0){
            $this->_put_error('Number of parenthesis is invalid.');
            return false;
        }
        return $scaned;
    }

    function _parse_parameter($param){
        if(!$param) return false;
        $sentence = '';
        for($i=0; $i<count($param); $i++){
            if($param[$i]['type'] == 'variable' ){
                $sentence .= $this->manager->parseVariable($param[$i]);
            }else{
                $sentence .= $param[$i]['value'];
            }
        }
        return $sentence;
    }
}

/**
* phpoot_parser_alt
*
* @access public
**/
class phpoot_parser_alt extends phpoot_parser {

    var $_num = 0;
    var $_name = array();
    var $_nexts;

    /**
    * constructor
    * @access public
    **/
    function phpoot_parser_alt(&$buffer, &$manager){
        $this->buffer =& $buffer;
        $this->manager =& $manager;
    }

    function parse($scaned){
        if($scaned['type'] != 'tag')
            return false;

        switch($scaned['subtype']){

        case 'alt':
            if(trim($scaned['param']) == ''){
                $varname = $this->_num;
                $this->_num++;
            }
            elseif(preg_match('/^('.REGEX_WORD.'+)$/',trim($scaned['param']),$match)){
                $varname = $match[1];
            }else{
                $this->_put_error('Invalid parameters of [alt] tag.');
                return 'error';
            }
            array_push($this->_name, $varname);
            $this->_nexts[$varname] = 0;
            $this->manager->pushLoop('alt');

            $this->buffer->setSentence('if (! isset($var[\'_alt_'.$varname.'\'])) { $var[\'_alt_'.$varname.'\'] = 0; } ');
            $this->buffer->setSentence('if ($var[\'_alt_'.$varname.'\'] == 0) {');
            break;

        case 'next':
            if($this->manager->getCurrentLoop() != 'alt'){
                $this->_put_error('Invalid location of [next] tag.');
                return 'error';
            }
            $varname = $this->_name[count($this->_name)-1];
            $this->_nexts[$varname]++;

            $this->buffer->setSentence('} ');
            $this->buffer->setSentence('if ($var[\'_alt_'.$varname.'\'] == '.$this->_nexts[$varname].') {');
            break;

        case '/alt':
            if($this->manager->getCurrentLoop() != 'alt'){
                $this->_put_error('Invalid location of [/alt] tag.');
                return 'error';
            }
            $varname = $this->_name[count($this->_name)-1];
            $this->manager->popLoop();
            array_pop($this->_name);

            $this->buffer->setSentence('} ');
            $this->buffer->setSentence('$var[\'_alt_'.$varname.'\']++; ');
            $this->buffer->setSentence('if ($var[\'_alt_'.$varname.'\'] > '.$this->_nexts[$varname].') { $var[\'_alt_'.$varname.'\'] = 0; } ');
            break;

        default:
            return false;
        }
        return ture;
    }

    function _tokenize_alt($str){
        $tokens[] = array(REGEX_DOUBLE_QUOTED,'double-quoted');
        $tokens[] = array(REGEX_SINGLE_QUOTED,'single-quoted');
        $tokens[] = array('\s*|\s*','divider');
        $tokens[] = array('\s+','space');
        return $this->_tokenize($str, $tokens);
    }

}
?>