package org.phosphoresce.contentnotifier.exception;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * ʒm̗ONX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2006/10/12	Kitagawa		VK쐬
 *-->
 */
public class NotifyExecuteException extends Exception {

	/** [gP[XOIuWFNg */
	private Throwable parent = null;

	/**
	 * RXgN^<br>
	 */
	public NotifyExecuteException() {
		super();
	}

	/**
	 * RXgN^<br>
	 * @param message
	 * @param cause
	 */
	public NotifyExecuteException(String message, Throwable cause) {
		super(message, cause);
		this.parent = cause;
	}

	/**
	 * RXgN^<br>
	 * @param message
	 */
	public NotifyExecuteException(String message) {
		super(message);
	}

	/**
	 * RXgN^<br>
	 * @param cause
	 */
	public NotifyExecuteException(Throwable cause) {
		super(cause);
		this.parent = cause;
	}

	/**
	 * [gP[XOێ邩肵܂B<br>
	 * @return [gP[XOێꍇtrueԋp
	 */
	public final boolean hasParent() {
		return parent != null;
	}

	/**
	 * [gP[XO擾܂B<br>
	 * @return [gP[XOԋp܂B
	 */
	public final Throwable getParent() {
		return parent;
	}

	/**
	 * @see java.lang.Throwable#printStackTrace()
	 */
	public void printStackTrace() {
		super.printStackTrace();
		if (hasParent()) {
			parent.printStackTrace();
		}
	}

	/**
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintStream)
	 */
	public void printStackTrace(PrintStream s) {
		super.printStackTrace(s);
		if (hasParent()) {
			parent.printStackTrace(s);
		}
	}

	/**
	 * @see java.lang.Throwable#printStackTrace(java.io.PrintWriter)
	 */
	public void printStackTrace(PrintWriter s) {
		super.printStackTrace(s);
		if (hasParent()) {
			parent.printStackTrace(s);
		}
	}
}
