package org.phosphoresce.contentnotifier;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.phosphoresce.contentnotifier.exception.MailSendingException;
import org.phosphoresce.contentnotifier.exception.NotifyExecuteException;
import org.phosphoresce.contentnotifier.setting.MailSetting;
import org.phosphoresce.contentnotifier.setting.NotifySetting;
import org.phosphoresce.contentnotifier.strategy.CheckStrategy;
import org.phosphoresce.contentnotifier.util.MailUtil;

/**
 * Rec`FbN[ʒmAvP[VNNX<br>
 * 
 * @author Kitagawa<br>
 * 
 *<!--
 * XV		XV			XVe
 * 2006/10/12	Kitagawa		VK쐬
 *-->
 */
public final class ContentNotifier implements ContentNotifierConstants {

	/**
	 * w肳ꂽvpeBt@C̋NJavaAvP[Vs܂B<br>
	 * vpeBt@Cw肳Ȃꍇ̓fBtHg̃vpeBt@Cgp܂B<br>
	 * @param args R}hC(:vpeBt@C)
	 * @throws Exception sɗ\ʗOꍇɃX[܂
	 */
	public static void main(String[] args) throws Exception {
		if (args != null && args.length >= 1) {
			execute(args[0]);
		} else {
			execute(DEFAULT_PROPERTIES);
		}
	}

	/**
	 * w肳ꂽvpeBt@C̏ɊÂă`FbNs܂B<br>
	 * `FbN̓vpeBɒ`ꂽCheckStrategyۃNXɈˑ܂B<br>
	 * @param properties vpeBt@C
	 * @throws NotifyExecuteException ʒmɗOꍇɃX[܂
	 */
	private static void execute(String properties) throws NotifyExecuteException {
		NotifySetting setting = null;
		try {
			// ʒmݒIuWFNg
			setting = new NotifySetting(properties);

			// `FbNNXCX^X
			CheckStrategy strategy = setting.getCheckStrategy();

			// `FbN{ʒmKvȏꍇ̓[M
			if (!strategy.check()) {
				MailUtil.send(setting.getMailSetting());
			}
		} catch (Exception e) {
			// ɗOꍇ͕KvɉĊǗ҂Ƀ[M
			if (setting != null && setting.isOnerrorCall()) {
				// X^bNg[X̎擾
				StringWriter stringWriter = new StringWriter();
				PrintWriter printWriter = new PrintWriter(stringWriter);
				e.printStackTrace(printWriter);
				// OR[p̃[ݒIuWFNg𐶐
				MailSetting mailSetting = new MailSetting();
				mailSetting.setMailAddressFrom(setting.getOnerrorAddressFrom());
				mailSetting.setMailAddressTo(setting.getOnerrorAddressTo());
				mailSetting.setMailAttach(null);
				mailSetting.setMailSmtp(setting.getMailSetting().getMailSmtp());
				mailSetting.setMailSubject(setting.getOnerrorSubject());
				StringBuffer buffer = new StringBuffer();
				buffer.append(setting.getOnerrorMessage());
				if (setting.isOnerrorStacktrace()) {
					buffer.append("\n\n");
					buffer.append(stringWriter.toString());
				}
				mailSetting.setMailTemplate(buffer.toString());
				try {
					MailUtil.send(mailSetting);
				} catch (MailSendingException e1) {
					//
				}
			}
			throw new NotifyExecuteException("ʒmɗ\ʗO܂", e);
		}
	}
}
