/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.contentnotifier.setting;

import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.phosphoresce.contentnotifier.ContentNotifierConstants;
import org.phosphoresce.contentnotifier.exception.IllegalSettingException;
import org.phosphoresce.contentnotifier.util.PropertiesUtil;
import org.phosphoresce.contentnotifier.util.StringUtil;

public final class MailSetting
implements ContentNotifierConstants {
    public static final String DEFAULT_CHARSET = "ISO-2022-JP";
    private boolean mailDebug;
    private Date mailDate;
    private String mailSmtp;
    private String mailAddressFrom;
    private String[] mailAddressTo;
    private String mailCharset;
    private String mailSubject;
    private String[] mailAttach;
    private String mailTemplate;
    private String mailTemplateFile;

    public MailSetting() {
        this.mailDebug = false;
        this.mailDate = new Date();
        this.mailSmtp = "";
        this.mailAddressFrom = "";
        this.mailAddressTo = new String[0];
        this.mailCharset = DEFAULT_CHARSET;
        this.mailSubject = "";
        this.mailAttach = new String[0];
        this.mailTemplate = "";
        this.mailTemplateFile = "";
    }

    public MailSetting(String properties) throws IllegalSettingException {
        try {
            this.mailDebug = Boolean.valueOf(PropertiesUtil.getValue(properties, "mail.debug"));
            this.mailDate = new Date();
            this.mailSmtp = PropertiesUtil.getValue(properties, "mail.smtp");
            this.mailAddressFrom = PropertiesUtil.getValue(properties, "mail.address.from");
            this.mailAddressTo = StringUtil.getTokenArray(PropertiesUtil.getValue(properties, "mail.address.to"), ",");
            this.mailCharset = PropertiesUtil.getValue(properties, "mail.charset");
            this.mailSubject = PropertiesUtil.getValue(properties, "mail.subject");
            this.mailAttach = StringUtil.getTokenArray(PropertiesUtil.getValue(properties, "mail.attach"), ",");
            this.mailTemplate = PropertiesUtil.getValue(properties, "mail.template");
            this.mailTemplateFile = PropertiesUtil.getValue(properties, "mail.template.file");
        }
        catch (Exception e) {
            throw new IllegalSettingException("\u30e1\u30fc\u30eb\u8a2d\u5b9a\u60c5\u5831\u304c\u6b63\u5e38\u306b\u521d\u671f\u5316\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
    }

    private String renderBindedString(String value) {
        String buffer = value;
        buffer = StringUtil.binder(buffer, "timestamp", new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(this.mailDate));
        buffer = StringUtil.binder(buffer, "date", new SimpleDateFormat("yyyy/MM/dd").format(this.mailDate));
        buffer = StringUtil.binder(buffer, "time", new SimpleDateFormat("HH:mm:ss").format(this.mailDate));
        return buffer;
    }

    private String loadTemplate() throws IllegalSettingException {
        StringBuffer buffer = new StringBuffer();
        try {
            if (!StringUtil.isEmpty(this.mailTemplateFile)) {
                BufferedReader reader = new BufferedReader(new FileReader(this.mailTemplateFile));
                while (reader.ready()) {
                    buffer.append(reader.readLine());
                    buffer.append("\n");
                }
                reader.close();
            }
        }
        catch (Exception e) {
            throw new IllegalSettingException("\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u308b\u30e1\u30fc\u30eb\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u3092\u6b63\u5e38\u306b\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093\u3067\u3057\u305f", e);
        }
        return buffer.toString();
    }

    public Date getMailDate() {
        return this.mailDate;
    }

    public void setMailDate(Date mailDate) {
        this.mailDate = mailDate;
    }

    public boolean isMailDebug() {
        return this.mailDebug;
    }

    public void setMailDebug(boolean mailDebug) {
        this.mailDebug = mailDebug;
    }

    public String getMailTemplateFile() {
        return this.mailTemplateFile;
    }

    public void setMailTemplateFile(String mailTemplateFile) {
        this.mailTemplateFile = mailTemplateFile;
    }

    public String getMailAddressFrom() {
        return this.mailAddressFrom;
    }

    public void setMailAddressFrom(String mailAddressFrom) {
        this.mailAddressFrom = mailAddressFrom;
    }

    public String[] getMailAddressTo() {
        return this.mailAddressTo;
    }

    public void setMailAddressTo(String[] mailAddressTo) {
        this.mailAddressTo = mailAddressTo;
    }

    public String[] getMailAttach() {
        return this.mailAttach;
    }

    public void setMailAttach(String[] mailAttach) {
        this.mailAttach = mailAttach;
    }

    public String getMailCharset() {
        return this.mailCharset;
    }

    public void setMailCharset(String mailCharset) {
        this.mailCharset = mailCharset;
    }

    public String getMailSmtp() {
        return this.mailSmtp;
    }

    public void setMailSmtp(String mailSmtp) {
        this.mailSmtp = mailSmtp;
    }

    public String getMailSubject() {
        return this.renderBindedString(this.mailSubject);
    }

    public void setMailSubject(String mailSubject) {
        this.mailSubject = mailSubject;
    }

    public String getMailTemplate() throws IllegalSettingException {
        return !StringUtil.isEmpty(this.mailTemplateFile) ? this.renderBindedString(this.loadTemplate()) : this.renderBindedString(this.mailTemplate);
    }

    public void setMailTemplate(String mailTemplate) {
        this.mailTemplate = mailTemplate;
    }
}

