\echo ###### Prepare for the test
\set QUIET
SET client_min_messages = 'error';
CREATE EXTENSION IF NOT EXISTS pg_store_plans;
DROP TABLE IF EXISTS plans;
CREATE TABLE plans (id int, title text, lplan text, splan text);
SET client_min_messages = 'notice';
\set ECHO none

\echo ###### insert original JSON plans
INSERT INTO plans (VALUES
(-1, '###### Plan -1: all properties 1/2',
 '{
  "Plan": 0,
  "Plans": 0,
  "Node Type": "Result",
  "Node Type": "ModifyTable",
  "Node Type": "Append",
  "Node Type": "Merge Append",
  "Node Type": "Recursive Union",
  "Node Type": "BitmapAnd",
  "Node Type": "BitmapOr",
  "Node Type": "Seq Scan",
  "Node Type": "Index Scan",
  "Node Type": "Index Only Scan",
  "Node Type": "Bitmap Index Scan",
  "Node Type": "Bitmap Heap Scan",
  "Node Type": "Tid Scan",
  "Node Type": "Subquery Scan",
  "Node Type": "Function Scan",
  "Node Type": "Values Scan",
  "Node Type": "CTE Scan",
  "Node Type": "WorkTable Scan",
  "Node Type": "Foreign Scan",
  "Node Type": "Nested Loop",
  "Node Type": "Merge Join",
  "Node Type": "Hash Join",
  "Node Type": "Materialize",
  "Node Type": "Sort",
  "Node Type": "Group",
  "Node Type": "Aggregate",
  "Node Type": "WindowAgg",
  "Node Type": "Unique",
  "Node Type": "Hash",
  "Node Type": "SetOp",
  "Node Type": "LockRows",
  "Node Type": "Limit",
  "Node Type": "Sample Scan",
  "Node Type": "Gather",
  "Node Type": "ProjectSet",
  "Node Type": "Table Function Scan",
  "Node Type": "Named Tuplestore Scan",
  "Node Type": "Gather Merge",
  "Parent Relationship": "Outer",
  "Parent Relationship": "Inner",
  "Parent Relationship": "Subquery",
  "Parent Relationship": "Member",
  "Parent Relationship": "InitPlan",
  "Parent Relationship": "SubPlan",
  "Scan Direction": "Backward",
  "Scan Direction": "NoMovement",
  "Scan Direction": "Forward",
  "Index Name": 0,
  "Relation Name": 0,
  "Function Name": 0,
  "CTE Name": 0,
  "Schema": 0,
  "Alias": 0,
  "Output": "[]",
  "Merge Cond": "a",
  "Strategy": "Plain",
  "Strategy": "Sorted",
  "Strategy": "Hashed",
  "Strategy": "Mixed",
  "Join Type": "Inner",
  "Join Type": "Left",
  "Join Type": "Full",
  "Join Type": "Right",
  "Join Type": "Semi",
  "Join Type": "Anti",
  "Command": "Intersect",
  "Command": "Intersect All",
  "Command": "Except",
  "Command": "Except All",
  "Sort Method": "top-N heapsort",
  "Sort Method": "quicksort",
  "Sort Method": "external sort",
  "Sort Method": "external merge",
  "Sort Method": "still in progress",
  "Sort Key": "a",
  "Group Key": "a",
  "Grouping Sets": "a",
  "Group Keys": "a",
  "Hash Keys": "a",
  "Hash Key": "a",
  "Parallel Aware": "true",
  "Workers Planned": "0",
  "Workers Launched": "0",
  "Workers": "x",
  "Worker Number": "0",
  "Filter": "a",
  "Join Filter": "a",
  "Hash Cond": "a",
  "Index Cond": "a",
  "TID Cond": "a",
  "Recheck Cond": "a",
  "Conflict Resolution": "a",
  "Conflict Arbiter Indexes": "a",
  "Tuples Inserted": 0,
  "Conflicting Tuples": 0,
  "Target Tables": "a",
  "Operation": "Insert",
  "Operation": "Delete",
  "Operation": "Update",
  "Subplan Name": "a",
  "Triggers": 0,
  "Trigger": 0,
  "Trigger Name": 0,
  "Relation": 0,
  "Constraint Name": 0,
  "Function Call": 0,
  "Startup Cost": 0,
  "Total Cost": 0,
  "Plan Rows": 0,
  "Plan Width": 0,
  "Actual Startup Time": 0,
  "Actual Total Time": 0,
  "Actual Rows": 0,
  "Actual Loops": 0,
  "Heap Fetches": 0,
  "Shared Hit Blocks": 0,
  "Shared Read Blocks": 0,
  "Shared Dirtied Blocks": 0,
  "Shared Written Blocks": 0,
  "Local Hit Blocks": 0,
  "Local Read Blocks": 0,
  "Local Dirtied Blocks": 0,
  "Local Written Blocks": 0,
  "Temp Read Blocks": 0,
  "Temp Written Blocks": 0,
  "I/O Read Time": 0,
  "I/O Write Time": 0,
  "Sort Space Used": 0,
  "Sort Space Type": "Disk",
  "Sort Space Type": "Memory",
  "Peak Memory Usage": 0,
  "Original Hash Batches": 0,
  "Original Hash Buckets": 0
}'),(-2, '###### Plan -2: all properties 2/2',
 '{
  "Hash Batches": 0,
  "Hash Buckets": 0,
  "Rows Removed by Filter": 0,
  "Rows Removed by Index Recheck": 0,
  "Time": 0,
  "Calls": 0,
  "Planning Time": 0,
  "Execution Time": 0,
  "Exact Heap Blocks": 0,
  "Lossy Heap Blocks": 0,
  "Rows Removed by Join Filter": 0,
  "Target Tables": "dummy",
  "Conflict Resolution": "NOTHING",
  "Conflict Arbiter Indexes": "ia",
  "Tuples Inserted": 123,
  "Conflicting Tuples": 234,
  "Sampling Method": "system",
  "Sampling Parameters": ["''10''::real"],
  "Repeatable Seed": "''0''::double precision",
  "Workers": "dummy",
  "Worker Number": 0
}'),(-3, '###### Plan -3: some properties plus unknown key',
 '{
  "Plan": 0,
  "Plans": 0,
  "Node Type": "Result",
  "Node Type": "ModifyTable",
  "Node Type": "Append",
  "Node Type": "Merge Append",
  "Node Type": "Recursive Union",
  "Node Type": "BitmapAnd",
  "Node Type": "BitmapOr",
  "Node Type": "Seq Scan",
  "Node Type": "Index Scan",
  "Node Type": "Index Only Scan",
  "Node Type": "Bitmap Index Scan",
  "Node Type": "Bitmap Heap Scan",
  "Node Type": "Tid Scan",
  "Node Type": "Subquery Scan",
  "Node Type": "Function Scan",
  "Node Type": "Values Scan",
  "Node Type": "CTE Scan",
  "Node Type": "WorkTable Scan",
  "Node Type": "Foreign Scan",
  "Node Type": "Nested Loop",
  "Node Type": "Merge Join",
  "Node Type": "Hash Join",
  "Node Type": "Materialize",
  "Node Type": "Sort",
  "Node Type": "Group",
  "Node Type": "Aggregate",
  "Node Type": "WindowAgg",
  "Node Type": "Unique",
  "Node Type": "Hash",
  "Node Type": "SetOp",
  "Node Type": "LockRows",
  "Node Type": "Limit",
  "Node Type": "Sample Scan",
  "Node Type": "Gather",
  "Node Type": "ProjectSet",
  "Node Type": "Table Function Scan",
  "Node Type": "Named Tuplestore Scan",
  "Node Type": "Gather Merge",
  "Parent Relationship": "Outer",
  "Parent Relationship": "Inner",
  "Parent Relationship": "Subquery",
  "Parent Relationship": "Member",
  "Parent Relationship": "InitPlan",
  "Parent Relationship": "SubPlan",
  "Scan Direction": "Backward",
  "Scan Direction": "NoMovement",
  "Scan Direction": "Forward",
  "Index Name": 0,
  "Relation Name": 0,
  "Function Name": 0,
  "CTE Name": 0,
  "Schema": 0,
  "Alias": 0,
  "Output": "[]",
  "Merge Cond": "a",
  "Strategy": "Plain",
  "Strategy": "Sorted",
  "Strategy": "Hashed",
  "Strategy": "Mixed",
  "Join Type": "Inner",
  "Join Type": "Left",
  "Join Type": "Full",
  "Join Type": "Right",
  "Join Type": "Semi",
  "Join Type": "Anti",
  "Command": "Intersect",
  "Command": "Intersect All",
  "Command": "Except",
  "Command": "Except All",
  "Sort Method": "top-N heapsort",
  "Sort Method": "quicksort",
  "Sort Method": "external sort",
  "Sort Method": "external merge",
  "Sort Method": "still in progress",
  "Sort Key": "a",
  "Group Key": "a",
  "Grouping Sets": "a",
  "Group Keys": "a",
  "Hash Keys": "a",
  "Hash Key": "a",
  "Parallel Aware": "true",
  "Workers Planned": "0",
  "Workers Launched": "0",
  "Workers": "x",
  "Worker Number": "0",
  "Filter": "a",
  "Join Filter": "a",
  "Hash Cond": "a",
  "Index Cond": "a",
  "TID Cond": "a",
  "Recheck Cond": "a",
  "Conflict Resolution": "a",
  "Conflict Arbiter Indexes": "a",
  "Tuples Inserted": 0,
  "Conflicting Tuples": 0,
  "Target Tables": "a",
  "Operation": "Insert",
  "Operation": "Delete",
  "Operation": "Update",
  "Subplan Name": "a",
  "Triggers": 0,
  "Trigger": 0,
  "Trigger Name": 0,
  "Relation": 0,
  "Constraint Name": 0,
  "Function Call": 0,
  "Startup Cost": 0,
  "Total Cost": 0,
  "Plan Rows": 0,
  "Plan Width": 0,
  "Actual Startup Time": 0,
  "Actual Total Time": 0,
  "Actual Rows": 0,
  "Actual Loops": 0,
  "Heap Fetches": 0,
  "Shared Hit Blocks": 0,
  "Shared Read Blocks": 0,
  "Shared Dirtied Blocks": 0,
  "Shared Written Blocks": 0,
  "Local Hit Blocks": 0,
  "Local Read Blocks": 0,
  "Local Dirtied Blocks": 0,
  "Local Written Blocks": 0,
  "Temp Read Blocks": 0,
  "Temp Written Blocks": 0,
  "I/O Read Time": 0,
  "I/O Write Time": 0,
  "Sort Space Used": 0,
  "Sort Space Type": "Disk",
  "Sort Space Type": "Memory",
  "Peak Memory Usage": 0,
  "Original Hash Batches": 0,
  "Original Hash Buckets": 0,
  "Unknown Key": "Unknown Value"
}'),
(1, '###### Plan 1: Insert, Trigger',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Insert",
    "Parallel Aware": false,
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 10.00,
    "Plan Rows": 1000,
    "Plan Width": 40,
    "Actual Startup Time": 348.383,
    "Actual Total Time": 348.383,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Shared Hit Blocks": 29732,
    "Shared Read Blocks": 87,
    "Shared Dirtied Blocks": 85,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Function Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Function Name": "generate_series",
        "Schema": "pg_catalog",
        "Alias": "a",
        "Startup Cost": 0.00,
        "Total Cost": 10.00,
        "Plan Rows": 1000,
        "Plan Width": 40,
        "Actual Startup Time": 2.530,
        "Actual Total Time": 10.954,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["a.a", "NULL::integer", "NULL::text"],
        "Function Call": "generate_series(0, 10000)",
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.063,
  "Triggers": [
    {
      "Trigger Name": "tt1_trig_1",
      "Relation": "tt1",
      "Time": 120.303,
      "Calls": 10001
    },
    {
      "Trigger Name": "tt1_trig_2",
      "Relation": "tt1",
      "Time": 95.115,
      "Calls": 10001
    }
  ],
  "Execution Time": 349.084
}'),
(2, '###### Plan 2: Update, Trigger',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Update",
    "Parallel Aware": false,
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 137.50,
    "Plan Rows": 6600,
    "Plan Width": 46,
    "Actual Startup Time": 332.064,
    "Actual Total Time": 332.064,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Shared Hit Blocks": 50276,
    "Shared Read Blocks": 108,
    "Shared Dirtied Blocks": 108,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 137.50,
        "Plan Rows": 6600,
        "Plan Width": 46,
        "Actual Startup Time": 0.031,
        "Actual Total Time": 9.136,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["(a + 1)", "b", "c", "ctid"],
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.204,
  "Triggers": [
    {
      "Trigger Name": "tt1_trig_1",
      "Relation": "tt1",
      "Time": 98.808,
      "Calls": 10001
    },
    {
      "Trigger Name": "tt1_trig_2",
      "Relation": "tt1",
      "Time": 71.353,
      "Calls": 10001
    }
  ],
  "Execution Time": 332.250
}'),
(3, '###### Plan 3: Delete',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Delete",
    "Parallel Aware": false,
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 305.20,
    "Plan Rows": 65,
    "Plan Width": 6,
    "Actual Startup Time": 7.444,
    "Actual Total Time": 7.444,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Shared Hit Blocks": 1109,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 305.20,
        "Plan Rows": 65,
        "Plan Width": 6,
        "Actual Startup Time": 2.885,
        "Actual Total Time": 5.893,
        "Actual Rows": 1000,
        "Actual Loops": 1,
        "Output": ["ctid"],
        "Filter": "((tt1.a % 10) = 0)",
        "Rows Removed by Filter": 9001,
        "Shared Hit Blocks": 109,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.104,
  "Triggers": [
  ],
  "Execution Time": 7.583
}'),
(4, '###### Plan 4: Result, Append Seq Scan',
 '{
  "Plan": {
    "Node Type": "Result",
    "Parallel Aware": false,
    "Startup Cost": 0.00,
    "Total Cost": 643.04,
    "Plan Rows": 20002,
    "Plan Width": 12,
    "Actual Startup Time": 2.860,
    "Actual Total Time": 23.689,
    "Actual Rows": 20002,
    "Actual Loops": 1,
    "Output": ["((tt1.a + 1))", "(3)", "1"],
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Append",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Startup Cost": 0.00,
        "Total Cost": 443.02,
        "Plan Rows": 20002,
        "Plan Width": 8,
        "Actual Startup Time": 2.856,
        "Actual Total Time": 16.737,
        "Actual Rows": 20002,
        "Actual Loops": 1,
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 288.01,
            "Plan Rows": 10001,
            "Plan Width": 8,
            "Actual Startup Time": 2.855,
            "Actual Total Time": 7.781,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["(tt1.a + 1)", "3"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 8,
            "Actual Startup Time": 0.015,
            "Actual Total Time": 4.341,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.a", "4"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.456,
  "Triggers": [
  ],
  "Execution Time": 26.681
}'),
(5, '###### Plan 5: Index scan (forward) ANY, array in expr, escape',
 E'{
  "Plan": {
    "Node Type": "Index Scan",
    "Parallel Aware": false,
    "Scan Direction": "Forward",
    "Index Name": "i_tt1",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "x\\"y",
    "Startup Cost": 0.29,
    "Total Cost": 21.21,
    "Plan Rows": 4,
    "Plan Width": 12,
    "Actual Startup Time": 0.040,
    "Actual Total Time": 0.080,
    "Actual Rows": 4,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "Index Cond": "(\\"x\\"\\"y\\".a = ANY (\'{50,120,300,500}\'::integer[]))",
    "Rows Removed by Index Recheck": 0,
    "Shared Hit Blocks": 27,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.160,
  "Triggers": [
  ],
  "Execution Time": 0.275
}'),
(6, '###### Plan 6: Index scan (backward), MergeJoin, Sort, quicksort, alias',
 '{
  "Plan": {
    "Node Type": "Limit",
    "Parallel Aware": false,
    "Startup Cost": 819.75,
    "Total Cost": 820.79,
    "Plan Rows": 10,
    "Plan Width": 12,
    "Actual Startup Time": 17.714,
    "Actual Total Time": 17.714,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["x.b", "x.c", "x.a"],
    "Shared Hit Blocks": 61,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Merge Join",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Join Type": "Inner",
        "Startup Cost": 819.75,
        "Total Cost": 1854.80,
        "Plan Rows": 10001,
        "Plan Width": 12,
        "Actual Startup Time": 17.712,
        "Actual Total Time": 17.712,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["x.b", "x.c", "x.a"],
        "Inner Unique": false,
        "Merge Cond": "(x.a = (((- y.b) * 3)))",
        "Shared Hit Blocks": 61,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Index Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Scan Direction": "Backward",
            "Index Name": "i_tt1",
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "x",
            "Startup Cost": 0.29,
            "Total Cost": 760.30,
            "Plan Rows": 10001,
            "Plan Width": 12,
            "Actual Startup Time": 0.072,
            "Actual Total Time": 0.072,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["x.a", "x.b", "x.c"],
            "Shared Hit Blocks": 6,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "Sort",
            "Parent Relationship": "Inner",
            "Parallel Aware": false,
            "Startup Cost": 819.47,
            "Total Cost": 844.47,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 13.465,
            "Actual Total Time": 14.609,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["y.b", "(((- y.b) * 3))"],
            "Sort Key": ["(((- y.b) * 3)) DESC"],
            "Sort Method": "quicksort",
            "Sort Space Used": 855,
            "Sort Space Type": "Memory",
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Plans": [
              {
                "Node Type": "Seq Scan",
                "Parent Relationship": "Outer",
                "Parallel Aware": false,
                "Relation Name": "tt2",
                "Schema": "public",
                "Alias": "y",
                "Startup Cost": 0.00,
                "Total Cost": 155.01,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.017,
                "Actual Total Time": 4.767,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["y.b", "((- y.b) * 3)"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.440,
  "Triggers": [
  ],
  "Execution Time": 18.482
}'),
(7, '###### Plan 7: IndexOnlyScan',
 '{
  "Plan": {
    "Node Type": "Index Only Scan",
    "Parallel Aware": false,
    "Scan Direction": "Forward",
    "Index Name": "i_tt1",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.29,
    "Total Cost": 8.46,
    "Plan Rows": 10,
    "Plan Width": 4,
    "Actual Startup Time": 0.023,
    "Actual Total Time": 0.058,
    "Actual Rows": 10,
    "Actual Loops": 1,
    "Output": ["a"],
    "Index Cond": "(tt1.a < 10)",
    "Rows Removed by Index Recheck": 0,
    "Heap Fetches": 29,
    "Shared Hit Blocks": 31,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.109,
  "Triggers": [
  ],
  "Execution Time": 0.205
}'),
(8, '###### Plan 8: Plain Aggregate, CTE, Recursive Union, WorkTable Scan, CTE Scan',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Plain",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Startup Cost": 3.65,
    "Total Cost": 3.66,
    "Plan Rows": 1,
    "Plan Width": 8,
    "Actual Startup Time": 0.061,
    "Actual Total Time": 0.061,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Output": ["sum(cte1.a)"],
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Recursive Union",
        "Parent Relationship": "InitPlan",
        "Subplan Name": "CTE cte1",
        "Parallel Aware": false,
        "Startup Cost": 0.00,
        "Total Cost": 2.95,
        "Plan Rows": 31,
        "Plan Width": 4,
        "Actual Startup Time": 0.002,
        "Actual Total Time": 0.039,
        "Actual Rows": 10,
        "Actual Loops": 1,
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Result",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Startup Cost": 0.00,
            "Total Cost": 0.01,
            "Plan Rows": 1,
            "Plan Width": 4,
            "Actual Startup Time": 0.000,
            "Actual Total Time": 0.001,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["1"],
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "WorkTable Scan",
            "Parent Relationship": "Inner",
            "Parallel Aware": false,
            "CTE Name": "cte1",
            "Alias": "cte1_1",
            "Startup Cost": 0.00,
            "Total Cost": 0.23,
            "Plan Rows": 3,
            "Plan Width": 4,
            "Actual Startup Time": 0.001,
            "Actual Total Time": 0.001,
            "Actual Rows": 1,
            "Actual Loops": 10,
            "Output": ["(cte1_1.a + 1)"],
            "Filter": "(cte1_1.a < 10)",
            "Rows Removed by Filter": 0,
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      },
      {
        "Node Type": "CTE Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "CTE Name": "cte1",
        "Alias": "cte1",
        "Startup Cost": 0.00,
        "Total Cost": 0.62,
        "Plan Rows": 31,
        "Plan Width": 4,
        "Actual Startup Time": 0.004,
        "Actual Total Time": 0.049,
        "Actual Rows": 10,
        "Actual Loops": 1,
        "Output": ["cte1.a"],
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.156,
  "Triggers": [
  ],
  "Execution Time": 0.453
}'),
(9, '###### Plan 9: FunctionScan, Hash/HashJoin, Nested Loop',
 '{
  "Plan": {
    "Node Type": "Hash Join",
    "Parallel Aware": false,
    "Join Type": "Left",
    "Startup Cost": 1.11,
    "Total Cost": 3.37,
    "Plan Rows": 100,
    "Plan Width": 64,
    "Actual Startup Time": 0.094,
    "Actual Total Time": 0.103,
    "Actual Rows": 7,
    "Actual Loops": 1,
    "Output": ["d.datname"],
    "Inner Unique": true,
    "Hash Cond": "(s.datid = d.oid)",
    "Shared Hit Blocks": 1,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Function Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Function Name": "pg_stat_get_activity",
        "Schema": "pg_catalog",
        "Alias": "s",
        "Startup Cost": 0.00,
        "Total Cost": 1.00,
        "Plan Rows": 100,
        "Plan Width": 8,
        "Actual Startup Time": 0.066,
        "Actual Total Time": 0.069,
        "Actual Rows": 7,
        "Actual Loops": 1,
        "Output": ["s.datid", "s.pid", "s.usesysid", "s.application_name", "s.state", "s.query", "s.wait_event_type", "s.wait_event", "s.xact_start", "s.query_start", "s.backend_start", "s.state_change", "s.client_addr", "s.client_hostname", "s.client_port", "s.backend_xid", "s.backend_xmin", "s.backend_type", "s.ssl", "s.sslversion", "s.sslcipher", "s.sslbits", "s.sslcompression", "s.sslclientdn"],
        "Function Call": "pg_stat_get_activity(NULL::integer)",
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Hash",
        "Parent Relationship": "Inner",
        "Parallel Aware": false,
        "Startup Cost": 1.05,
        "Total Cost": 1.05,
        "Plan Rows": 5,
        "Plan Width": 68,
        "Actual Startup Time": 0.020,
        "Actual Total Time": 0.020,
        "Actual Rows": 5,
        "Actual Loops": 1,
        "Output": ["d.datname", "d.oid"],
        "Hash Buckets": 1024,
        "Original Hash Buckets": 1024,
        "Hash Batches": 1,
        "Original Hash Batches": 1,
        "Peak Memory Usage": 9,
        "Shared Hit Blocks": 1,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Relation Name": "pg_database",
            "Schema": "pg_catalog",
            "Alias": "d",
            "Startup Cost": 0.00,
            "Total Cost": 1.05,
            "Plan Rows": 5,
            "Plan Width": 68,
            "Actual Startup Time": 0.009,
            "Actual Total Time": 0.012,
            "Actual Rows": 5,
            "Actual Loops": 1,
            "Output": ["d.datname", "d.oid"],
            "Shared Hit Blocks": 1,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.565,
  "Triggers": [
  ],
  "Execution Time": 0.644
}'),
(10, '###### Plan 10: MergeAppend, Values',
 E'{
  "Plan": {
    "Node Type": "Merge Append",
    "Parallel Aware": false,
    "Startup Cost": 0.36,
    "Total Cost": 935.42,
    "Plan Rows": 10004,
    "Plan Width": 4,
    "Actual Startup Time": 0.036,
    "Actual Total Time": 33.263,
    "Actual Rows": 10004,
    "Actual Loops": 1,
    "Sort Key": ["tt1.a"],
    "Shared Hit Blocks": 30069,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Index Only Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.29,
        "Total Cost": 760.30,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.021,
        "Actual Total Time": 30.772,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt1.a"],
        "Heap Fetches": 29973,
        "Shared Hit Blocks": 30069,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Sort",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Startup Cost": 0.06,
        "Total Cost": 0.07,
        "Plan Rows": 3,
        "Plan Width": 4,
        "Actual Startup Time": 0.014,
        "Actual Total Time": 0.014,
        "Actual Rows": 3,
        "Actual Loops": 1,
        "Output": ["\\"*VALUES*\\".column1"],
        "Sort Key": ["\\"*VALUES*\\".column1"],
        "Sort Method": "quicksort",
        "Sort Space Used": 25,
        "Sort Space Type": "Memory",
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Values Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Alias": "*VALUES*",
            "Startup Cost": 0.00,
            "Total Cost": 0.04,
            "Plan Rows": 3,
            "Plan Width": 4,
            "Actual Startup Time": 0.002,
            "Actual Total Time": 0.005,
            "Actual Rows": 3,
            "Actual Loops": 1,
            "Output": ["\\"*VALUES*\\".column1"],
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.193,
  "Triggers": [
  ],
  "Execution Time": 35.065
}'),
(11, '###### Plan 11: Append, HashAggregate',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Hashed",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Startup Cost": 668.04,
    "Total Cost": 868.06,
    "Plan Rows": 20002,
    "Plan Width": 4,
    "Actual Startup Time": 21.630,
    "Actual Total Time": 27.849,
    "Actual Rows": 20002,
    "Actual Loops": 1,
    "Output": ["tt1.a"],
    "Group Key": ["tt1.a"],
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Append",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Startup Cost": 0.00,
        "Total Cost": 618.04,
        "Plan Rows": 20002,
        "Plan Width": 4,
        "Actual Startup Time": 0.162,
        "Actual Total Time": 10.468,
        "Actual Rows": 20002,
        "Actual Loops": 1,
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 263.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.162,
            "Actual Total Time": 3.517,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt1.a"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Parallel Aware": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.012,
            "Actual Total Time": 3.281,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.108,
  "Triggers": [
  ],
  "Execution Time": 30.935
}'),
(12, '###### Plan 12: GroupAggregate',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Sorted",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Startup Cost": 1067.47,
    "Total Cost": 1242.49,
    "Plan Rows": 10001,
    "Plan Width": 12,
    "Actual Startup Time": 13.558,
    "Actual Total Time": 24.047,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["sum(a)", "b"],
    "Group Key": ["tt1.b"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 44,
    "Temp Written Blocks": 56,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Startup Cost": 1067.47,
        "Total Cost": 1092.47,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 13.552,
        "Actual Total Time": 16.191,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["b", "a"],
        "Sort Key": ["tt1.b"],
        "Sort Method": "external merge",
        "Sort Space Used": 208,
        "Sort Space Type": "Disk",
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 44,
        "Temp Written Blocks": 56,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 263.01,
            "Plan Rows": 10001,
            "Plan Width": 8,
            "Actual Startup Time": 0.147,
            "Actual Total Time": 3.206,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["b", "a"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.115,
  "Triggers": [
  ],
  "Execution Time": 25.808
}'),
(13, '###### Plan 13: Group',
 '{
  "Plan": {
    "Node Type": "Group",
    "Parallel Aware": false,
    "Startup Cost": 1067.47,
    "Total Cost": 1117.47,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 12.547,
    "Actual Total Time": 19.383,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["b"],
    "Group Key": ["tt1.b"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 36,
    "Temp Written Blocks": 44,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Startup Cost": 1067.47,
        "Total Cost": 1092.47,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 12.545,
        "Actual Total Time": 14.931,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["b"],
        "Sort Key": ["tt1.b"],
        "Sort Method": "external merge",
        "Sort Space Used": 168,
        "Sort Space Type": "Disk",
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 36,
        "Temp Written Blocks": 44,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 263.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.133,
            "Actual Total Time": 2.966,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["b"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.046,
  "Triggers": [
  ],
  "Execution Time": 20.508
}'),
(14, '###### Plan 14: SetOp intersect, SbuqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Parallel Aware": false,
    "Startup Cost": 1332.50,
    "Total Cost": 1357.51,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 18.874,
    "Actual Total Time": 18.874,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 25,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Command": "Intersect",
        "Startup Cost": 0.00,
        "Total Cost": 668.04,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 18.869,
        "Actual Total Time": 18.869,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Startup Cost": 0.00,
            "Total Cost": 618.04,
            "Plan Rows": 20002,
            "Plan Width": 8,
            "Actual Startup Time": 0.166,
            "Actual Total Time": 12.521,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.166,
                "Actual Total Time": 5.461,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.165,
                    "Actual Total Time": 3.005,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.009,
                "Actual Total Time": 4.507,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.009,
                    "Actual Total Time": 2.416,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.091,
  "Triggers": [
  ],
  "Execution Time": 19.535
}'),
(15, '###### Plan 15: Sorted SetOp, Sort on Disk',
 E'{
  "Plan": {
    "Node Type": "SetOp",
    "Strategy": "Sorted",
    "Parallel Aware": false,
    "Command": "Intersect",
    "Startup Cost": 2323.47,
    "Total Cost": 2423.48,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 42.218,
    "Actual Total Time": 42.218,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 113,
    "Temp Written Blocks": 126,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Startup Cost": 2323.47,
        "Total Cost": 2373.47,
        "Plan Rows": 20002,
        "Plan Width": 8,
        "Actual Startup Time": 31.621,
        "Actual Total Time": 35.575,
        "Actual Rows": 20002,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Sort Key": ["\\"*SELECT* 1\\".a"],
        "Sort Method": "external merge",
        "Sort Space Used": 384,
        "Sort Space Type": "Disk",
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 113,
        "Temp Written Blocks": 126,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Startup Cost": 0.00,
            "Total Cost": 618.04,
            "Plan Rows": 20002,
            "Plan Width": 8,
            "Actual Startup Time": 0.116,
            "Actual Total Time": 11.983,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.116,
                "Actual Total Time": 4.795,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.115,
                    "Actual Total Time": 2.492,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.008,
                "Actual Total Time": 4.778,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.008,
                    "Actual Total Time": 2.517,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.082,
  "Triggers": [
  ],
  "Execution Time": 42.624
}'),
(16, '###### Plan 16: HashSetOp intersect All, SubqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Parallel Aware": false,
    "Startup Cost": 1332.50,
    "Total Cost": 1357.51,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 18.612,
    "Actual Total Time": 18.612,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 25,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Command": "Intersect All",
        "Startup Cost": 0.00,
        "Total Cost": 668.04,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 18.606,
        "Actual Total Time": 18.606,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Startup Cost": 0.00,
            "Total Cost": 618.04,
            "Plan Rows": 20002,
            "Plan Width": 8,
            "Actual Startup Time": 0.129,
            "Actual Total Time": 12.270,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.129,
                "Actual Total Time": 5.147,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.128,
                    "Actual Total Time": 2.886,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.010,
                "Actual Total Time": 4.666,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.010,
                    "Actual Total Time": 2.546,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.089,
  "Triggers": [
  ],
  "Execution Time": 19.308
}'),
(17, '###### Plan 17: HashSetOp except, SubqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Parallel Aware": false,
    "Startup Cost": 1332.50,
    "Total Cost": 1357.51,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 22.556,
    "Actual Total Time": 23.380,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 855,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Command": "Except",
        "Startup Cost": 0.00,
        "Total Cost": 668.04,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 17.434,
        "Actual Total Time": 18.500,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Startup Cost": 0.00,
            "Total Cost": 618.04,
            "Plan Rows": 20002,
            "Plan Width": 8,
            "Actual Startup Time": 0.136,
            "Actual Total Time": 11.989,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.136,
                "Actual Total Time": 4.805,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.135,
                    "Actual Total Time": 2.625,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.010,
                "Actual Total Time": 4.669,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.010,
                    "Actual Total Time": 2.538,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.099,
  "Triggers": [
  ],
  "Execution Time": 25.727
}'),
(18, '###### Plan 18: HashSetOp except all, SubqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Parallel Aware": false,
    "Startup Cost": 1332.50,
    "Total Cost": 1357.51,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 22.101,
    "Actual Total Time": 22.924,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 855,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Command": "Except All",
        "Startup Cost": 0.00,
        "Total Cost": 668.04,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 17.050,
        "Actual Total Time": 17.997,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Startup Cost": 0.00,
            "Total Cost": 618.04,
            "Plan Rows": 20002,
            "Plan Width": 8,
            "Actual Startup Time": 0.139,
            "Actual Total Time": 11.633,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.138,
                "Actual Total Time": 4.680,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.138,
                    "Actual Total Time": 2.536,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Parallel Aware": false,
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 8,
                "Actual Startup Time": 0.009,
                "Actual Total Time": 4.554,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Parallel Aware": false,
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.008,
                    "Actual Total Time": 2.495,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.097,
  "Triggers": [
  ],
  "Execution Time": 25.260
}'),
(19, '###### Plan 19: merge LEFT join',
 '{
  "Plan": {
    "Node Type": "Merge Join",
    "Parallel Aware": false,
    "Join Type": "Left",
    "Startup Cost": 0.71,
    "Total Cost": 4293.92,
    "Plan Rows": 33292,
    "Plan Width": 4,
    "Actual Startup Time": 0.032,
    "Actual Total Time": 65.448,
    "Actual Rows": 60003,
    "Actual Loops": 1,
    "Output": ["x.b"],
    "Inner Unique": false,
    "Merge Cond": "(x.a = y.a)",
    "Shared Hit Blocks": 20946,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "x",
        "Startup Cost": 0.29,
        "Total Cost": 760.30,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 0.008,
        "Actual Total Time": 5.025,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["x.a", "x.b", "x.c"],
        "Shared Hit Blocks": 165,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Index Only Scan",
        "Parent Relationship": "Inner",
        "Parallel Aware": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt3_a",
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "y",
        "Startup Cost": 0.42,
        "Total Cost": 9030.73,
        "Plan Rows": 180003,
        "Plan Width": 4,
        "Actual Startup Time": 0.020,
        "Actual Total Time": 38.025,
        "Actual Rows": 60004,
        "Actual Loops": 1,
        "Output": ["y.a"],
        "Heap Fetches": 60004,
        "Shared Hit Blocks": 20781,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.374,
  "Triggers": [
  ],
  "Execution Time": 70.459
}'),
(20, '###### Plan 20: hash FULL join',
 '{
  "Plan": {
    "Node Type": "Hash Join",
    "Parallel Aware": false,
    "Join Type": "Full",
    "Startup Cost": 280.02,
    "Total Cost": 680.55,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 5.466,
    "Actual Total Time": 11.552,
    "Actual Rows": 17001,
    "Actual Loops": 1,
    "Output": ["x.b"],
    "Inner Unique": false,
    "Hash Cond": "(x.a = y.a)",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "x",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 0.126,
        "Actual Total Time": 1.575,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["x.a", "x.b", "x.c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Hash",
        "Parent Relationship": "Inner",
        "Parallel Aware": false,
        "Startup Cost": 155.01,
        "Total Cost": 155.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 5.326,
        "Actual Total Time": 5.326,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["y.a"],
        "Hash Buckets": 16384,
        "Original Hash Buckets": 16384,
        "Hash Batches": 1,
        "Original Hash Batches": 1,
        "Peak Memory Usage": 480,
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "y",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.012,
            "Actual Total Time": 2.530,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["y.a"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.121,
  "Triggers": [
  ],
  "Execution Time": 13.019
}'),
(21, '###### Plan 21: hash SEMI join',
 '{
  "Plan": {
    "Node Type": "Hash Join",
    "Parallel Aware": false,
    "Join Type": "Semi",
    "Startup Cost": 280.02,
    "Total Cost": 680.55,
    "Plan Rows": 10001,
    "Plan Width": 12,
    "Actual Startup Time": 8.862,
    "Actual Total Time": 8.862,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["tt1.a", "tt1.b", "tt1.c"],
    "Inner Unique": false,
    "Hash Cond": "(tt1.a = tt2.b)",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 12,
        "Actual Startup Time": 0.106,
        "Actual Total Time": 1.502,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt1.a", "tt1.b", "tt1.c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Hash",
        "Parent Relationship": "Inner",
        "Parallel Aware": false,
        "Startup Cost": 155.01,
        "Total Cost": 155.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 5.222,
        "Actual Total Time": 5.222,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt2.b"],
        "Hash Buckets": 16384,
        "Original Hash Buckets": 16384,
        "Hash Batches": 1,
        "Original Hash Batches": 1,
        "Peak Memory Usage": 480,
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.008,
            "Actual Total Time": 2.498,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.192,
  "Triggers": [
  ],
  "Execution Time": 9.096
}'),
(22, '###### Plan 22: Hash Anti Join',
 '{
  "Plan": {
    "Node Type": "Hash Join",
    "Parallel Aware": false,
    "Join Type": "Anti",
    "Startup Cost": 280.02,
    "Total Cost": 580.54,
    "Plan Rows": 1,
    "Plan Width": 12,
    "Actual Startup Time": 5.858,
    "Actual Total Time": 10.988,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["tt1.a", "tt1.b", "tt1.c"],
    "Inner Unique": false,
    "Hash Cond": "(tt1.a = tt2.b)",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 12,
        "Actual Startup Time": 0.107,
        "Actual Total Time": 1.538,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt1.a", "tt1.b", "tt1.c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Hash",
        "Parent Relationship": "Inner",
        "Parallel Aware": false,
        "Startup Cost": 155.01,
        "Total Cost": 155.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 5.741,
        "Actual Total Time": 5.741,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt2.b"],
        "Hash Buckets": 16384,
        "Original Hash Buckets": 16384,
        "Hash Batches": 1,
        "Original Hash Batches": 1,
        "Peak Memory Usage": 480,
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.008,
            "Actual Total Time": 2.697,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.141,
  "Triggers": [
  ],
  "Execution Time": 11.936
}'),
(23, '###### Plan 23: WindowAgg',
 '{
  "Plan": {
    "Node Type": "WindowAgg",
    "Parallel Aware": false,
    "Startup Cost": 952.47,
    "Total Cost": 1152.49,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 4.993,
    "Actual Total Time": 16.485,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["first_value(a) OVER (?)", "((a / 10))"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Startup Cost": 952.47,
        "Total Cost": 977.47,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 4.985,
        "Actual Total Time": 5.858,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["((a / 10))", "a"],
        "Sort Key": ["((tt1.a / 10))"],
        "Sort Method": "quicksort",
        "Sort Space Used": 855,
        "Sort Space Type": "Memory",
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 288.01,
            "Plan Rows": 10001,
            "Plan Width": 8,
            "Actual Startup Time": 0.110,
            "Actual Total Time": 2.504,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["(a / 10)", "a"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.058,
  "Triggers": [
  ],
  "Execution Time": 17.937
}'),
(24, '###### Plan 24: Unique',
 '{
  "Plan": {
    "Node Type": "Unique",
    "Parallel Aware": false,
    "Startup Cost": 0.29,
    "Total Cost": 785.30,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 0.017,
    "Actual Total Time": 8.763,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["a"],
    "Shared Hit Blocks": 165,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Index Only Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.29,
        "Total Cost": 760.30,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.016,
        "Actual Total Time": 4.962,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["a"],
        "Heap Fetches": 10001,
        "Shared Hit Blocks": 165,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.051,
  "Triggers": [
  ],
  "Execution Time": 9.638
}'),
(25, '###### Plan 25: PlainAggregate',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Plain",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Startup Cost": 288.01,
    "Total Cost": 288.02,
    "Plan Rows": 1,
    "Plan Width": 8,
    "Actual Startup Time": 3.420,
    "Actual Total Time": 3.420,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Output": ["sum(a)"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.113,
        "Actual Total Time": 1.452,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["a", "b", "c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.062,
  "Triggers": [
  ],
  "Execution Time": 3.537
}'),
(26, '###### Plan 26: BitmapIndexScan/BitmapHeapScan, BitmapOr, lossy',
 E'{
  "Plan": {
    "Node Type": "Bitmap Heap Scan",
    "Parallel Aware": false,
    "Relation Name": "tt3",
    "Schema": "public",
    "Alias": "tt3",
    "Startup Cost": 4239.43,
    "Total Cost": 7462.44,
    "Plan Rows": 180001,
    "Plan Width": 12,
    "Actual Startup Time": 26.037,
    "Actual Total Time": 64.054,
    "Actual Rows": 180000,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "Recheck Cond": "(tt3.b > \'-99998\'::integer)",
    "Rows Removed by Index Recheck": 0,
    "Exact Heap Blocks": 973,
    "Lossy Heap Blocks": 0,
    "Shared Hit Blocks": 1682,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Bitmap Index Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Index Name": "i_tt3_b",
        "Startup Cost": 0.00,
        "Total Cost": 4194.43,
        "Plan Rows": 180001,
        "Plan Width": 0,
        "Actual Startup Time": 25.838,
        "Actual Total Time": 25.838,
        "Actual Rows": 180000,
        "Actual Loops": 1,
        "Index Cond": "(tt3.b > \'-99998\'::integer)",
        "Shared Hit Blocks": 709,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.124,
  "Triggers": [
  ],
  "Execution Time": 77.880
}'),
(27, '###### Plan 27: Join Filter',
 '{
  "Plan": {
    "Node Type": "Limit",
    "Parallel Aware": false,
    "Startup Cost": 0.00,
    "Total Cost": 21.52,
    "Plan Rows": 100,
    "Plan Width": 12,
    "Actual Startup Time": 5.615,
    "Actual Total Time": 5.725,
    "Actual Rows": 100,
    "Actual Loops": 1,
    "Output": ["tt2.a", "tt2.b", "tt2.c"],
    "Shared Hit Blocks": 40,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 12,
    "Plans": [
      {
        "Node Type": "Nested Loop",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Join Type": "Inner",
        "Startup Cost": 0.00,
        "Total Cost": 43048282.11,
        "Plan Rows": 200023334,
        "Plan Width": 12,
        "Actual Startup Time": 5.614,
        "Actual Total Time": 5.712,
        "Actual Rows": 100,
        "Actual Loops": 1,
        "Output": ["tt2.a", "tt2.b", "tt2.c"],
        "Inner Unique": false,
        "Join Filter": "((tt2.a < tt3.a) AND ((tt3.a + tt2.a) < 100000))",
        "Rows Removed by Join Filter": 7001,
        "Shared Hit Blocks": 40,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 12,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 12,
            "Actual Startup Time": 0.014,
            "Actual Total Time": 0.014,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["tt2.a", "tt2.b", "tt2.c"],
            "Shared Hit Blocks": 1,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Node Type": "Materialize",
            "Parent Relationship": "Inner",
            "Parallel Aware": false,
            "Startup Cost": 0.00,
            "Total Cost": 4377.05,
            "Plan Rows": 180003,
            "Plan Width": 4,
            "Actual Startup Time": 0.010,
            "Actual Total Time": 4.634,
            "Actual Rows": 7101,
            "Actual Loops": 1,
            "Output": ["tt3.a"],
            "Shared Hit Blocks": 39,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 12,
            "Plans": [
              {
                "Node Type": "Seq Scan",
                "Parent Relationship": "Outer",
                "Parallel Aware": false,
                "Relation Name": "tt3",
                "Schema": "public",
                "Alias": "tt3",
                "Startup Cost": 0.00,
                "Total Cost": 2773.03,
                "Plan Rows": 180003,
                "Plan Width": 4,
                "Actual Startup Time": 0.008,
                "Actual Total Time": 1.872,
                "Actual Rows": 7101,
                "Actual Loops": 1,
                "Output": ["tt3.a"],
                "Shared Hit Blocks": 39,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.274,
  "Triggers": [
  ],
  "Execution Time": 6.070
}'),
(28, '###### Plan 28: TidScan',
 E'{
  "Plan": {
    "Node Type": "Tid Scan",
    "Parallel Aware": false,
    "Relation Name": "tt3",
    "Schema": "public",
    "Alias": "tt3",
    "Startup Cost": 0.00,
    "Total Cost": 4.01,
    "Plan Rows": 1,
    "Plan Width": 12,
    "Actual Startup Time": 0.004,
    "Actual Total Time": 0.004,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "TID Cond": "(tt3.ctid = \'(0,28)\'::tid)",
    "Shared Hit Blocks": 1,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.068,
  "Triggers": [
  ],
  "Execution Time": 0.080
}'),
(29, '###### Plan 29: LockRows',
 '{
  "Plan": {
    "Node Type": "LockRows",
    "Parallel Aware": false,
    "Startup Cost": 0.00,
    "Total Cost": 313.51,
    "Plan Rows": 50,
    "Plan Width": 10,
    "Actual Startup Time": 0.247,
    "Actual Total Time": 3.890,
    "Actual Rows": 1001,
    "Actual Loops": 1,
    "Output": ["a", "ctid"],
    "Shared Hit Blocks": 1164,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 313.01,
        "Plan Rows": 50,
        "Plan Width": 10,
        "Actual Startup Time": 0.236,
        "Actual Total Time": 2.665,
        "Actual Rows": 1001,
        "Actual Loops": 1,
        "Output": ["a", "ctid"],
        "Filter": "((tt1.a % 10) = 0)",
        "Rows Removed by Filter": 9000,
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.041,
  "Triggers": [
  ],
  "Execution Time": 4.146
}'),
(30, '###### Plan 30: Materialize',
 '{
  "Plan": {
    "Node Type": "Seq Scan",
    "Parallel Aware": false,
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 1150490.52,
    "Plan Rows": 5000,
    "Plan Width": 12,
    "Actual Startup Time": 5.303,
    "Actual Total Time": 5.303,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["tt1.a", "tt1.b", "tt1.c"],
    "Filter": "(SubPlan 1)",
    "Rows Removed by Filter": 10001,
    "Shared Hit Blocks": 164,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Materialize",
        "Parent Relationship": "SubPlan",
        "Subplan Name": "SubPlan 1",
        "Parallel Aware": false,
        "Startup Cost": 0.00,
        "Total Cost": 205.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.000,
        "Actual Total Time": 0.000,
        "Actual Rows": 1,
        "Actual Loops": 10001,
        "Output": ["tt2.b"],
        "Shared Hit Blocks": 1,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": false,
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.007,
            "Actual Total Time": 0.007,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 1,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.058,
  "Triggers": [
  ],
  "Execution Time": 5.462
}'),
(31, '###### Plan 31: Update on partitioned tables',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Update",
    "Parallel Aware": false,
    "Relation Name": "p",
    "Schema": "public",
    "Alias": "p",
    "Startup Cost": 0.00,
    "Total Cost": 3691.07,
    "Plan Rows": 200006,
    "Plan Width": 18,
    "Actual Startup Time": 4815.842,
    "Actual Total Time": 4815.842,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Target Tables": [
      {
        "Relation Name": "p",
        "Schema": "public",
        "Alias": "p"
      },
      {
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1"
      },
      {
        "Relation Name": "tt2",
        "Schema": "public",
        "Alias": "tt2"
      },
      {
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "tt3"
      }
    ],
    "Shared Hit Blocks": 1563330,
    "Shared Read Blocks": 2644,
    "Shared Dirtied Blocks": 2644,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Relation Name": "p",
        "Schema": "public",
        "Alias": "p",
        "Startup Cost": 0.00,
        "Total Cost": 0.00,
        "Plan Rows": 1,
        "Plan Width": 46,
        "Actual Startup Time": 0.001,
        "Actual Total Time": 0.001,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["p.a", "(p.b + 1)", "p.c", "p.ctid"],
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 288.01,
        "Plan Rows": 10001,
        "Plan Width": 18,
        "Actual Startup Time": 0.104,
        "Actual Total Time": 8.404,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt1.a", "(tt1.b + 1)", "tt1.c", "tt1.ctid"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Relation Name": "tt2",
        "Schema": "public",
        "Alias": "tt2",
        "Startup Cost": 0.00,
        "Total Cost": 180.01,
        "Plan Rows": 10001,
        "Plan Width": 18,
        "Actual Startup Time": 0.010,
        "Actual Total Time": 5.678,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt2.a", "(tt2.b + 1)", "tt2.c", "tt2.ctid"],
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "tt3",
        "Startup Cost": 0.00,
        "Total Cost": 3223.04,
        "Plan Rows": 180003,
        "Plan Width": 18,
        "Actual Startup Time": 0.010,
        "Actual Total Time": 113.138,
        "Actual Rows": 180003,
        "Actual Loops": 1,
        "Output": ["tt3.a", "(tt3.b + 1)", "tt3.c", "tt3.ctid"],
        "Shared Hit Blocks": 973,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.174,
  "Triggers": [
    {
      "Trigger Name": "tt1_trig_1",
      "Relation": "tt1",
      "Time": 96.575,
      "Calls": 10001
    },
    {
      "Trigger Name": "tt1_trig_2",
      "Relation": "tt1",
      "Time": 69.629,
      "Calls": 10001
    }
  ],
  "Execution Time": 4816.260
}'),
(32, '###### Plan 32: Delete on partitioned tables',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Delete",
    "Parallel Aware": false,
    "Relation Name": "p",
    "Schema": "public",
    "Alias": "p",
    "Startup Cost": 0.00,
    "Total Cost": 32.80,
    "Plan Rows": 6,
    "Plan Width": 6,
    "Actual Startup Time": 0.499,
    "Actual Total Time": 0.499,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Target Tables": [
      {
        "Relation Name": "p",
        "Schema": "public",
        "Alias": "p"
      },
      {
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1"
      },
      {
        "Relation Name": "tt2",
        "Schema": "public",
        "Alias": "tt2"
      },
      {
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "tt3"
      }
    ],
    "Shared Hit Blocks": 18,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Relation Name": "p",
        "Schema": "public",
        "Alias": "p",
        "Startup Cost": 0.00,
        "Total Cost": 0.00,
        "Plan Rows": 1,
        "Plan Width": 6,
        "Actual Startup Time": 0.005,
        "Actual Total Time": 0.005,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["p.ctid"],
        "Filter": "(p.a = 100)",
        "Rows Removed by Filter": 0,
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.29,
        "Total Cost": 8.30,
        "Plan Rows": 1,
        "Plan Width": 6,
        "Actual Startup Time": 0.144,
        "Actual Total Time": 0.239,
        "Actual Rows": 1,
        "Actual Loops": 1,
        "Output": ["tt1.ctid"],
        "Index Cond": "(tt1.a = 100)",
        "Rows Removed by Index Recheck": 0,
        "Shared Hit Blocks": 5,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt2",
        "Relation Name": "tt2",
        "Schema": "public",
        "Alias": "tt2",
        "Startup Cost": 0.29,
        "Total Cost": 8.30,
        "Plan Rows": 1,
        "Plan Width": 6,
        "Actual Startup Time": 0.011,
        "Actual Total Time": 0.011,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["tt2.ctid"],
        "Index Cond": "(tt2.a = 100)",
        "Rows Removed by Index Recheck": 0,
        "Shared Hit Blocks": 2,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      },
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Scan Direction": "Forward",
        "Index Name": "i_tt3_a",
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "tt3",
        "Startup Cost": 0.42,
        "Total Cost": 16.20,
        "Plan Rows": 3,
        "Plan Width": 6,
        "Actual Startup Time": 0.016,
        "Actual Total Time": 0.216,
        "Actual Rows": 2,
        "Actual Loops": 1,
        "Output": ["tt3.ctid"],
        "Index Cond": "(tt3.a = 100)",
        "Rows Removed by Index Recheck": 0,
        "Shared Hit Blocks": 8,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.452,
  "Triggers": [
  ],
  "Execution Time": 1.191
}'),
(33, '###### Plan 33: ON CONFLICT',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Insert",
    "Parallel Aware": false,
    "Relation Name": "ct1",
    "Schema": "public",
    "Alias": "ct1",
    "Startup Cost": 0.00,
    "Total Cost": 0.01,
    "Plan Rows": 1,
    "Plan Width": 8,
    "Actual Startup Time": 0.068,
    "Actual Total Time": 0.068,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Conflict Resolution": "UPDATE",
    "Conflict Arbiter Indexes": ["ct1_a_key"],
    "Tuples Inserted": 0,
    "Conflicting Tuples": 1,
    "Shared Hit Blocks": 5,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Result",
        "Parent Relationship": "Member",
        "Parallel Aware": false,
        "Startup Cost": 0.00,
        "Total Cost": 0.01,
        "Plan Rows": 1,
        "Plan Width": 8,
        "Actual Startup Time": 0.002,
        "Actual Total Time": 0.002,
        "Actual Rows": 1,
        "Actual Loops": 1,
        "Output": ["1", "1"],
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.107,
  "Triggers": [
  ],
  "Execution Time": 0.373
}'),
(34, '###### Plan 34: GROUP BY',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Hashed",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Startup Cost": 450.00,
    "Total Cost": 583.13,
    "Plan Rows": 13314,
    "Plan Width": 40,
    "Actual Startup Time": 23.255,
    "Actual Total Time": 32.379,
    "Actual Rows": 10000,
    "Actual Loops": 1,
    "Output": ["a", "b", "max(c)"],
    "Group Key": ["tt1.a", "tt1.b"],
    "Shared Hit Blocks": 217,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 350.14,
        "Plan Rows": 13314,
        "Plan Width": 12,
        "Actual Startup Time": 0.238,
        "Actual Total Time": 9.547,
        "Actual Rows": 10000,
        "Actual Loops": 1,
        "Output": ["a", "b", "c"],
        "Shared Hit Blocks": 217,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.148,
  "Triggers": [
  ],
  "Execution Time": 35.078
}'),
(35, '###### Plan 35: GROUPING SETS',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Mixed",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Startup Cost": 0.00,
    "Total Cost": 782.86,
    "Plan Rows": 26629,
    "Plan Width": 40,
    "Actual Startup Time": 24.354,
    "Actual Total Time": 39.455,
    "Actual Rows": 20001,
    "Actual Loops": 1,
    "Output": ["a", "b", "max(c)"],
    "Grouping Sets": [
      {
        "Hash Keys": [
          ["tt1.a"]
        ]
      },
      {
        "Hash Keys": [
          ["tt1.b"]
        ]
      },
      {
        "Group Keys": [
          []
        ]
      }
    ],
    "Shared Hit Blocks": 217,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 350.14,
        "Plan Rows": 13314,
        "Plan Width": 12,
        "Actual Startup Time": 0.228,
        "Actual Total Time": 3.187,
        "Actual Rows": 10000,
        "Actual Loops": 1,
        "Output": ["a", "b", "c"],
        "Shared Hit Blocks": 217,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  },
  "Planning Time": 0.160,
  "Triggers": [
  ],
  "Execution Time": 44.202
}'),
(36, '###### Plan 36: Table sample',
 E'{
  "Plan": {
    "Node Type": "Sample Scan",
    "Parallel Aware": false,
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 9.33,
    "Plan Rows": 133,
    "Plan Width": 12,
    "Actual Startup Time": 0.020,
    "Actual Total Time": 0.071,
    "Actual Rows": 185,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "Sampling Method": "system",
    "Sampling Parameters": ["\'1\'::real"],
    "Repeatable Seed": "\'1\'::double precision",
    "Shared Hit Blocks": 1,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.074,
  "Triggers": [
  ],
  "Execution Time": 0.236
}'),
(37, '###### Plan 37: Project Set',
 E'{
  "Plan": {
    "Node Type": "Table Function Scan",
    "Parallel Aware": false,
    "Table Function Name": "xmltable",
    "Alias": "xmltable",
    "Startup Cost": 0.00,
    "Total Cost": 1.00,
    "Plan Rows": 100,
    "Plan Width": 32,
    "Actual Startup Time": 0.098,
    "Actual Total Time": 0.098,
    "Actual Rows": 2,
    "Actual Loops": 1,
    "Output": ["name"],
    "Table Function Call": "XMLTABLE((\'//towns/town\'::text) PASSING (\'<towns><town><name>Toronto</name></town><town><name>Ottawa</name></town></towns>\'::xml) COLUMNS name text)",
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0
  },
  "Planning Time": 0.025,
  "Triggers": [
  ],
  "Execution Time": 0.216
}'),
(38, '###### Plan 38: Named Tuplestore Scan',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Plain",
    "Partial Mode": "Simple",
    "Parallel Aware": false,
    "Startup Cost": 0.00,
    "Total Cost": 0.01,
    "Plan Rows": 1,
    "Plan Width": 8,
    "Actual Startup Time": 0.005,
    "Actual Total Time": 0.005,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Named Tuplestore Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Startup Cost": 0.00,
        "Total Cost": 0.00,
        "Plan Rows": 1,
        "Plan Width": 4,
        "Actual Startup Time": 0.001,
        "Actual Total Time": 0.001,
        "Actual Rows": 1,
        "Actual Loops": 1,
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0
      }
    ]
  }
}'),
(39, '###### Plan 39: Parallel Seq Scan',
 '{
  "Plan": {
    "Node Type": "Gather",
    "Parallel Aware": false,
    "Startup Cost": 0.00,
    "Total Cost": 21845.68,
    "Plan Rows": 1814322,
    "Plan Width": 36,
    "Actual Startup Time": 0.443,
    "Actual Total Time": 110.055,
    "Actual Rows": 100000,
    "Actual Loops": 1,
    "Output": ["a", "b"],
    "Workers Planned": 2,
    "Workers Launched": 2,
    "Single Copy": false,
    "Shared Hit Blocks": 11376,
    "Shared Read Blocks": 3020,
    "Shared Dirtied Blocks": 3025,
    "Shared Written Blocks": 3013,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": true,
        "Relation Name": "lt1",
        "Schema": "public",
        "Alias": "lt1",
        "Startup Cost": 0.00,
        "Total Cost": 21845.68,
        "Plan Rows": 755968,
        "Plan Width": 36,
        "Actual Startup Time": 0.042,
        "Actual Total Time": 49.223,
        "Actual Rows": 33333,
        "Actual Loops": 3,
        "Output": ["a", "b"],
        "Shared Hit Blocks": 11271,
        "Shared Read Blocks": 3015,
        "Shared Dirtied Blocks": 3025,
        "Shared Written Blocks": 3009,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Workers": [
          {
            "Worker Number": 0,
            "Actual Startup Time": 0.041,
            "Actual Total Time": 64.126,
            "Actual Rows": 43328,
            "Actual Loops": 1,
            "Shared Hit Blocks": 4998,
            "Shared Read Blocks": 1192,
            "Shared Dirtied Blocks": 1192,
            "Shared Written Blocks": 1190,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Worker Number": 1,
            "Actual Startup Time": 0.035,
            "Actual Total Time": 64.204,
            "Actual Rows": 43204,
            "Actual Loops": 1,
            "Shared Hit Blocks": 5000,
            "Shared Read Blocks": 1172,
            "Shared Dirtied Blocks": 1172,
            "Shared Written Blocks": 1169,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.134,
  "Triggers": [
  ],
  "Execution Time": 125.149
}'),
(40, '###### Plan 40: Parallel Index Scan',
 '{
  "Plan": {
    "Node Type": "Gather",
    "Parallel Aware": false,
    "Startup Cost": 0.29,
    "Total Cost": 16.06,
    "Plan Rows": 133,
    "Plan Width": 12,
    "Actual Startup Time": 0.243,
    "Actual Total Time": 8.954,
    "Actual Rows": 100,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "Workers Planned": 1,
    "Workers Launched": 1,
    "Single Copy": false,
    "Shared Hit Blocks": 284,
    "Shared Read Blocks": 6,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Outer",
        "Parallel Aware": true,
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.29,
        "Total Cost": 16.06,
        "Plan Rows": 78,
        "Plan Width": 12,
        "Actual Startup Time": 0.011,
        "Actual Total Time": 0.096,
        "Actual Rows": 50,
        "Actual Loops": 2,
        "Output": ["a", "b", "c"],
        "Index Cond": "(tt1.a < 100)",
        "Rows Removed by Index Recheck": 0,
        "Shared Hit Blocks": 166,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Workers": [
          {
            "Worker Number": 0,
            "Actual Startup Time": 0.002,
            "Actual Total Time": 0.002,
            "Actual Rows": 0,
            "Actual Loops": 1,
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ]
      }
    ]
  },
  "Planning Time": 0.152,
  "Triggers": [
  ],
  "Execution Time": 9.620
}'),
(41, '###### Plan 41: Gather Merge',
 '{
  "Plan": {
    "Node Type": "Gather Merge",
    "Parallel Aware": false,
    "Startup Cost": 617.52,
    "Total Cost": 747.07,
    "Plan Rows": 11096,
    "Plan Width": 4,
    "Actual Startup Time": 8.062,
    "Actual Total Time": 12.057,
    "Actual Rows": 10000,
    "Actual Loops": 1,
    "Output": ["a"],
    "Workers Planned": 2,
    "Workers Launched": 2,
    "Shared Hit Blocks": 217,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Parallel Aware": false,
        "Startup Cost": 617.50,
        "Total Cost": 631.37,
        "Plan Rows": 5548,
        "Plan Width": 4,
        "Actual Startup Time": 2.169,
        "Actual Total Time": 2.511,
        "Actual Rows": 3333,
        "Actual Loops": 3,
        "Output": ["a"],
        "Sort Key": ["tt1.a"],
        "Sort Method": "quicksort",
        "Sort Space Used": 931,
        "Sort Space Type": "Memory",
        "Shared Hit Blocks": 313,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "Workers": [
          {
            "Worker Number": 0,
            "Actual Startup Time": 0.247,
            "Actual Total Time": 0.247,
            "Actual Rows": 0,
            "Actual Loops": 1,
            "Shared Hit Blocks": 48,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          },
          {
            "Worker Number": 1,
            "Actual Startup Time": 0.247,
            "Actual Total Time": 0.247,
            "Actual Rows": 0,
            "Actual Loops": 1,
            "Shared Hit Blocks": 48,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0
          }
        ],
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Parallel Aware": true,
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 272.48,
            "Plan Rows": 5548,
            "Plan Width": 4,
            "Actual Startup Time": 0.056,
            "Actual Total Time": 0.982,
            "Actual Rows": 3333,
            "Actual Loops": 3,
            "Output": ["a"],
            "Shared Hit Blocks": 217,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "Workers": [
              {
                "Worker Number": 0,
                "Actual Startup Time": 0.001,
                "Actual Total Time": 0.001,
                "Actual Rows": 0,
                "Actual Loops": 1,
                "Shared Hit Blocks": 0,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0
              },
              {
                "Worker Number": 1,
                "Actual Startup Time": 0.001,
                "Actual Total Time": 0.001,
                "Actual Rows": 0,
                "Actual Loops": 1,
                "Shared Hit Blocks": 0,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.079,
  "Triggers": [
  ],
  "Execution Time": 13.579
}'));

\pset pager
\set ECHO queries

\echo ###### set shortened JSON
UPDATE plans SET splan = pg_store_plans_shorten(lplan);

\echo ###### tag abbreviation test
SELECT splan FROM plans WHERE id in (-1, -2);

\echo ###### JSON properties round-trip test: !!! This shouldn''''t return a row
SELECT id FROM plans
	where pg_store_plans_jsonplan(splan) <> lplan;

\pset format unaligned
\pset tuples_only on
\pset recordsep '\n\n=======\n'
\echo  ###### format conversion tests
SELECT '### '||'yaml-short       '||title||E'\n'||
  pg_store_plans_yamlplan(splan)
  FROM plans WHERE id BETWEEN 1 AND 3 or id = 1 ORDER BY id;
\echo  ################## 
SELECT '### '||'xml-short        '||title||E'\n'||
  pg_store_plans_xmlplan(splan)
  FROM plans WHERE id BETWEEN 4 AND 6 or id = 1 ORDER BY id;

\echo  ###### text format output test
SELECT '### '||'TEXT-short       '||title||E'\n'||
  pg_store_plans_textplan(splan)
  FROM plans WHERE id >= 0 ORDER BY id;


\echo  ###### long-json-as-a-source test
SELECT '### '||'yaml-long JSON   '||title||E'\n'||
  pg_store_plans_yamlplan(lplan)
  FROM plans WHERE id = 1 ORDER BY id;
\echo  ################## 
SELECT '### '||'xml-long JSON    '||title||E'\n'||
  pg_store_plans_xmlplan(lplan)
  FROM plans WHERE id = 1 ORDER BY id;
\echo  ################## 
SELECT '### '||'text-long JSON   '||title||E'\n'||
  pg_store_plans_xmlplan(lplan)
  FROM plans WHERE id = 1 ORDER BY id;

\echo  ###### chopped-source test
SELECT '### '||'inflate-chopped  '||title||E'\n'||
  pg_store_plans_jsonplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 16 AND 18 ORDER BY id;
\echo  ################## 
SELECT '### '||'yaml-chopped     '||title||E'\n'||
  pg_store_plans_yamlplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 19 AND 21 ORDER BY id;
\echo  ################## 
SELECT '### '||'xml-chopped      '||title||E'\n'||
  pg_store_plans_xmlplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 22 AND 24 ORDER BY id;
\echo  ################## 
SELECT '### '||'text-chopped     '||title||E'\n'||
  pg_store_plans_textplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 25 AND 27 ORDER BY id;

\echo ###### shorten test
SELECT '### '||'shorten          '||title||E'\n'||
  pg_store_plans_shorten(lplan)
  FROM plans WHERE id = -2 ORDER BY id;
\echo ###### normalize test
SELECT '### '||'normalize        '||title||E'\n'||
  pg_store_plans_normalize(lplan)
  FROM plans ORDER BY id;

