\echo ###### Prepare for the test
\set QUIET
SET client_min_messages = 'error';
CREATE EXTENSION IF NOT EXISTS pg_store_plans;
DROP TABLE IF EXISTS plans;
CREATE TABLE plans (id int, title text, lplan text, splan text);
SET client_min_messages = 'notice';
\set ECHO none

\echo ###### insert original JSON plans
INSERT INTO plans (VALUES
(-1, '###### Plan -1: all properties',
 '{
  "Plan": 0,
  "Plans": 0,
  "Node Type": "Result",
  "Node Type": "ModifyTable",
  "Node Type": "Append",
  "Node Type": "Merge Append",
  "Node Type": "Recursive Union",
  "Node Type": "BitmapAnd",
  "Node Type": "BitmapOr",
  "Node Type": "Seq Scan",
  "Node Type": "Index Scan",
  "Node Type": "Index Only Scan",
  "Node Type": "Bitmap Index Scan",
  "Node Type": "Bitmap Heap Scan",
  "Node Type": "Tid Scan",
  "Node Type": "Subquery Scan",
  "Node Type": "Function Scan",
  "Node Type": "Values Scan",
  "Node Type": "CTE Scan",
  "Node Type": "WorkTable Scan",
  "Node Type": "Foreign Scan",
  "Node Type": "Nested Loop",
  "Node Type": "Merge Join",
  "Node Type": "Hash Join",
  "Node Type": "Materialize",
  "Node Type": "Sort",
  "Node Type": "Group",
  "Node Type": "Aggregate",
  "Node Type": "WindowAgg",
  "Node Type": "Unique",
  "Node Type": "Hash",
  "Node Type": "SetOp",
  "Node Type": "LockRows",
  "Node Type": "Limit",
  "Parent Relationship": "Outer",
  "Parent Relationship": "Inner",
  "Parent Relationship": "Subquery",
  "Parent Relationship": "Member",
  "Parent Relationship": "InitPlan",
  "Parent Relationship": "SubPlan",
  "Scan Direction": "Backward",
  "Scan Direction": "NoMovement",
  "Scan Direction": "Forward",
  "Index Name": 0,
  "Relation Name": 0,
  "Function Name": 0,
  "CTE Name": 0,
  "Schema": 0,
  "Alias": 0,
  "Output": "[]",
  "Merge Cond": "a",
  "Strategy": "Plain",
  "Strategy": "Sorted",
  "Strategy": "Hashed",
  "Join Type": "Inner",
  "Join Type": "Left",
  "Join Type": "Full",
  "Join Type": "Right",
  "Join Type": "Semi",
  "Join Type": "Anti",
  "Command": "Intersect",
  "Command": "Intersect All",
  "Command": "Except",
  "Command": "Except All",
  "Sort Method": "top-N heapsort",
  "Sort Method": "quicksort",
  "Sort Method": "external sort",
  "Sort Method": "external merge",
  "Sort Method": "still in progress",
  "Sort Key": "a",
  "Group Key": "a",
  "Grouping Sets": "a",
  "Group Keys": "a",
  "Filter": "a",
  "Join Filter": "a",
  "Hash Cond": "a",
  "Index Cond": "a",
  "TID Cond": "a",
  "Recheck Cond": "a",
  "Conflict Resolution": "a",
  "Conflict Arbiter Indexes": "a",
  "Tuples Inserted": 0,
  "Conflicting Tuples": 0,
  "Target Tables": "a",
  "Operation": "Insert",
  "Operation": "Delete",
  "Operation": "Update",
  "Subplan Name": "a",
  "Triggers": 0,
  "Trigger": 0,
  "Trigger Name": 0,
  "Relation": 0,
  "Constraint Name": 0,
  "Function Call": 0,
  "Startup Cost": 0,
  "Total Cost": 0,
  "Plan Rows": 0,
  "Plan Width": 0,
  "Actual Startup Time": 0,
  "Actual Total Time": 0,
  "Actual Rows": 0,
  "Actual Loops": 0,
  "Heap Fetches": 0,
  "Shared Hit Blocks": 0,
  "Shared Read Blocks": 0,
  "Shared Dirtied Blocks": 0,
  "Shared Written Blocks": 0,
  "Local Hit Blocks": 0,
  "Local Read Blocks": 0,
  "Local Dirtied Blocks": 0,
  "Local Written Blocks": 0,
  "Temp Read Blocks": 0,
  "Temp Written Blocks": 0,
  "I/O Read Time": 0,
  "I/O Write Time": 0,
  "Sort Space Used": 0,
  "Sort Space Type": "Disk",
  "Sort Space Type": "Memory",
  "Peak Memory Usage": 0,
  "Original Hash Batches": 0,
  "Original Hash Buckets": 0,
  "Hash Batches": 0,
  "Hash Buckets": 0,
  "Rows Removed by Filter": 0,
  "Rows Removed by Index Recheck": 0,
  "Time": 0,
  "Calls": 0,
  "Planning Time": 0,
  "Execution Time": 0,
  "Exact Heap Blocks": 0,
  "Lossy Heap Blocks": 0,
  "Rows Removed by Join Filter": 0
}'),(-2, '###### Plan -2: all properties plus unknown key',
 '{
  "Plan": 0,
  "Plans": 0,
  "Node Type": "Result",
  "Node Type": "ModifyTable",
  "Node Type": "Append",
  "Node Type": "Merge Append",
  "Node Type": "Recursive Union",
  "Node Type": "BitmapAnd",
  "Node Type": "BitmapOr",
  "Node Type": "Seq Scan",
  "Node Type": "Index Scan",
  "Node Type": "Index Only Scan",
  "Node Type": "Bitmap Index Scan",
  "Node Type": "Bitmap Heap Scan",
  "Node Type": "Tid Scan",
  "Node Type": "Subquery Scan",
  "Node Type": "Function Scan",
  "Node Type": "Values Scan",
  "Node Type": "CTE Scan",
  "Node Type": "WorkTable Scan",
  "Node Type": "Foreign Scan",
  "Node Type": "Nested Loop",
  "Node Type": "Merge Join",
  "Node Type": "Hash Join",
  "Node Type": "Materialize",
  "Node Type": "Sort",
  "Node Type": "Group",
  "Node Type": "Aggregate",
  "Node Type": "WindowAgg",
  "Node Type": "Unique",
  "Node Type": "Hash",
  "Node Type": "SetOp",
  "Node Type": "LockRows",
  "Node Type": "Limit",
  "Parent Relationship": "Outer",
  "Parent Relationship": "Inner",
  "Parent Relationship": "Subquery",
  "Parent Relationship": "Member",
  "Parent Relationship": "InitPlan",
  "Parent Relationship": "SubPlan",
  "Scan Direction": "Backward",
  "Scan Direction": "NoMovement",
  "Scan Direction": "Forward",
  "Index Name": 0,
  "Relation Name": 0,
  "Function Name": 0,
  "CTE Name": 0,
  "Schema": 0,
  "Alias": 0,
  "Output": "[]",
  "Merge Cond": "a",
  "Strategy": "Plain",
  "Strategy": "Sorted",
  "Strategy": "Hashed",
  "Join Type": "Inner",
  "Join Type": "Left",
  "Join Type": "Full",
  "Join Type": "Right",
  "Join Type": "Semi",
  "Join Type": "Anti",
  "Command": "Intersect",
  "Command": "Intersect All",
  "Command": "Except",
  "Command": "Except All",
  "Sort Method": "top-N heapsort",
  "Sort Method": "quicksort",
  "Sort Method": "external sort",
  "Sort Method": "external merge",
  "Sort Method": "still in progress",
  "Sort Key": "a",
  "Group Key": "a",
  "Grouping Sets": "a",
  "Group Keys": "a",
  "Filter": "a",
  "Join Filter": "a",
  "Hash Cond": "a",
  "Index Cond": "a",
  "TID Cond": "a",
  "Recheck Cond": "a",
  "Conflict Resolution": "a",
  "Conflict Arbiter Indexes": "a",
  "Tuples Inserted": 0,
  "Conflicting Tuples": 0,
  "Target Tables": "a",
  "Operation": "Insert",
  "Operation": "Delete",
  "Operation": "Update",
  "Subplan Name": "a",
  "Triggers": 0,
  "Trigger": 0,
  "Trigger Name": 0,
  "Relation": 0,
  "Constraint Name": 0,
  "Function Call": 0,
  "Startup Cost": 0,
  "Total Cost": 0,
  "Plan Rows": 0,
  "Plan Width": 0,
  "Actual Startup Time": 0,
  "Actual Total Time": 0,
  "Actual Rows": 0,
  "Actual Loops": 0,
  "Heap Fetches": 0,
  "Shared Hit Blocks": 0,
  "Shared Read Blocks": 0,
  "Shared Dirtied Blocks": 0,
  "Shared Written Blocks": 0,
  "Local Hit Blocks": 0,
  "Local Read Blocks": 0,
  "Local Dirtied Blocks": 0,
  "Local Written Blocks": 0,
  "Temp Read Blocks": 0,
  "Temp Written Blocks": 0,
  "I/O Read Time": 0,
  "I/O Write Time": 0,
  "Sort Space Used": 0,
  "Sort Space Type": "Disk",
  "Sort Space Type": "Memory",
  "Peak Memory Usage": 0,
  "Original Hash Batches": 0,
  "Original Hash Buckets": 0,
  "Hash Batches": 0,
  "Hash Buckets": 0,
  "Rows Removed by Filter": 0,
  "Rows Removed by Index Recheck": 0,
  "Time": 0,
  "Calls": 0,
  "Planning Time": 0,
  "Execution Time": 0,
  "Exact Heap Blocks": 0,
  "Lossy Heap Blocks": 0,
  "Rows Removed by Join Filter": 0,
  "Unknown Key": "Unknown Value"
}'),
(1, '###### Plan 1: Insert, Trigger',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Insert",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 10.00,
    "Plan Rows": 1000,
    "Plan Width": 4,
    "Actual Startup Time": 210.478,
    "Actual Total Time": 210.478,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Shared Hit Blocks": 29737,
    "Shared Read Blocks": 88,
    "Shared Dirtied Blocks": 85,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.260,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Function Scan",
        "Parent Relationship": "Member",
        "Function Name": "generate_series",
        "Schema": "pg_catalog",
        "Alias": "a",
        "Startup Cost": 0.00,
        "Total Cost": 10.00,
        "Plan Rows": 1000,
        "Plan Width": 4,
        "Actual Startup Time": 1.689,
        "Actual Total Time": 7.253,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["a.a", "NULL::integer", "NULL::text"],
        "Function Call": "generate_series(0, 10000)",
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.049,
  "Triggers": [
    {
      "Trigger Name": "tt1_trig_1",
      "Relation": "tt1",
      "Time": 71.597,
      "Calls": 10001
    },
    {
      "Trigger Name": "tt1_trig_2",
      "Relation": "tt1",
      "Time": 62.334,
      "Calls": 10001
    }
  ],
  "Execution Time": 210.989
}'),
(2, '###### Plan 2: Update, Trigger',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Update",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 137.50,
    "Plan Rows": 6600,
    "Plan Width": 46,
    "Actual Startup Time": 241.750,
    "Actual Total Time": 241.750,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Shared Hit Blocks": 50276,
    "Shared Read Blocks": 108,
    "Shared Dirtied Blocks": 108,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 137.50,
        "Plan Rows": 6600,
        "Plan Width": 46,
        "Actual Startup Time": 0.019,
        "Actual Total Time": 9.455,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["(a + 1)", "b", "c", "ctid"],
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.152,
  "Triggers": [
    {
      "Trigger Name": "tt1_trig_1",
      "Relation": "tt1",
      "Time": 72.650,
      "Calls": 10001
    },
    {
      "Trigger Name": "tt1_trig_2",
      "Relation": "tt1",
      "Time": 57.490,
      "Calls": 10001
    }
  ],
  "Execution Time": 241.978
}'),
(3, '###### Plan 3: Delete',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Delete",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 305.20,
    "Plan Rows": 65,
    "Plan Width": 6,
    "Actual Startup Time": 6.298,
    "Actual Total Time": 6.298,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Shared Hit Blocks": 1109,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 305.20,
        "Plan Rows": 65,
        "Plan Width": 6,
        "Actual Startup Time": 1.408,
        "Actual Total Time": 5.116,
        "Actual Rows": 1000,
        "Actual Loops": 1,
        "Output": ["ctid"],
        "Filter": "((tt1.a % 10) = 0)",
        "Rows Removed by Filter": 9001,
        "Shared Hit Blocks": 109,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.165,
  "Triggers": [
  ],
  "Execution Time": 6.503
}'),
(4, '###### Plan 4: Result, Append Seq Scan',
 '{
  "Plan": {
    "Node Type": "Result",
    "Startup Cost": 0.00,
    "Total Cost": 418.02,
    "Plan Rows": 20002,
    "Plan Width": 8,
    "Actual Startup Time": 1.913,
    "Actual Total Time": 27.382,
    "Actual Rows": 20002,
    "Actual Loops": 1,
    "Output": ["((tt1.a + 1))", "(3)", "1"],
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Append",
        "Parent Relationship": "Outer",
        "Startup Cost": 0.00,
        "Total Cost": 418.02,
        "Plan Rows": 20002,
        "Plan Width": 8,
        "Actual Startup Time": 1.911,
        "Actual Total Time": 18.649,
        "Actual Rows": 20002,
        "Actual Loops": 1,
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 263.01,
            "Plan Rows": 10001,
            "Plan Width": 8,
            "Actual Startup Time": 1.910,
            "Actual Total Time": 8.458,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["(tt1.a + 1)", "3"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          },
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 8,
            "Actual Startup Time": 0.013,
            "Actual Total Time": 4.940,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.a", "4"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          }
        ]
      }
    ]
  },
  "Planning Time": 0.409,
  "Triggers": [
  ],
  "Execution Time": 31.264
}'),
(5, '###### Plan 5: Index scan (forward) ANY, array in expr, escape',
 E'{
  "Plan": {
    "Node Type": "Index Scan",
    "Scan Direction": "Forward",
    "Index Name": "i_tt1",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "x\\"y",
    "Startup Cost": 0.29,
    "Total Cost": 21.21,
    "Plan Rows": 4,
    "Plan Width": 12,
    "Actual Startup Time": 0.010,
    "Actual Total Time": 0.043,
    "Actual Rows": 4,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "Index Cond": "(\\"x\\"\\"y\\".a = ANY (\'{50,120,300,500}\'::integer[]))",
    "Rows Removed by Index Recheck": 0,
    "Shared Hit Blocks": 24,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000
  },
  "Planning Time": 0.129,
  "Triggers": [
  ],
  "Execution Time": 0.316
}'),
(6, '###### Plan 6: Index scan (backward), MergeJoin, Sort, quicksort, alias',
 '{
  "Plan": {
    "Node Type": "Limit",
    "Startup Cost": 819.75,
    "Total Cost": 820.79,
    "Plan Rows": 10,
    "Plan Width": 12,
    "Actual Startup Time": 20.508,
    "Actual Total Time": 20.508,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["x.b", "x.c", "x.a"],
    "Shared Hit Blocks": 61,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Merge Join",
        "Parent Relationship": "Outer",
        "Join Type": "Inner",
        "Startup Cost": 819.75,
        "Total Cost": 1854.80,
        "Plan Rows": 10001,
        "Plan Width": 12,
        "Actual Startup Time": 20.506,
        "Actual Total Time": 20.506,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["x.b", "x.c", "x.a"],
        "Merge Cond": "(x.a = (((- y.b) * 3)))",
        "Shared Hit Blocks": 61,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Index Scan",
            "Parent Relationship": "Outer",
            "Scan Direction": "Backward",
            "Index Name": "i_tt1",
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "x",
            "Startup Cost": 0.29,
            "Total Cost": 760.30,
            "Plan Rows": 10001,
            "Plan Width": 12,
            "Actual Startup Time": 0.027,
            "Actual Total Time": 0.027,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["x.a", "x.b", "x.c"],
            "Shared Hit Blocks": 6,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          },
          {
            "Node Type": "Sort",
            "Parent Relationship": "Inner",
            "Startup Cost": 819.47,
            "Total Cost": 844.47,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 16.125,
            "Actual Total Time": 17.303,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["y.b", "(((- y.b) * 3))"],
            "Sort Key": ["(((- y.b) * 3)) DESC"],
            "Sort Method": "quicksort",
            "Sort Space Used": 811,
            "Sort Space Type": "Memory",
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000,
            "Plans": [
              {
                "Node Type": "Seq Scan",
                "Parent Relationship": "Outer",
                "Relation Name": "tt2",
                "Schema": "public",
                "Alias": "y",
                "Startup Cost": 0.00,
                "Total Cost": 155.01,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.015,
                "Actual Total Time": 6.452,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["y.b", "((- y.b) * 3)"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.348,
  "Triggers": [
  ],
  "Execution Time": 21.312
}'),
(7, '###### Plan 7: IndexOnlyScan',
 '{
  "Plan": {
    "Node Type": "Index Only Scan",
    "Scan Direction": "Forward",
    "Index Name": "i_tt1",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.29,
    "Total Cost": 8.46,
    "Plan Rows": 10,
    "Plan Width": 4,
    "Actual Startup Time": 0.020,
    "Actual Total Time": 0.052,
    "Actual Rows": 10,
    "Actual Loops": 1,
    "Output": ["a"],
    "Index Cond": "(tt1.a < 10)",
    "Rows Removed by Index Recheck": 0,
    "Heap Fetches": 29,
    "Shared Hit Blocks": 31,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000
  },
  "Planning Time": 0.095,
  "Triggers": [
  ],
  "Execution Time": 0.277
}'),
(8, '###### Plan 8: Plain Aggregate, CTE, Recursive Union, WorkTable Scan, CTE Scan',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Plain",
    "Startup Cost": 3.65,
    "Total Cost": 3.66,
    "Plan Rows": 1,
    "Plan Width": 4,
    "Actual Startup Time": 0.052,
    "Actual Total Time": 0.052,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Output": ["sum(cte1.a)"],
    "Shared Hit Blocks": 0,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Recursive Union",
        "Parent Relationship": "InitPlan",
        "Subplan Name": "CTE cte1",
        "Startup Cost": 0.00,
        "Total Cost": 2.95,
        "Plan Rows": 31,
        "Plan Width": 4,
        "Actual Startup Time": 0.002,
        "Actual Total Time": 0.031,
        "Actual Rows": 10,
        "Actual Loops": 1,
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Result",
            "Parent Relationship": "Outer",
            "Startup Cost": 0.00,
            "Total Cost": 0.01,
            "Plan Rows": 1,
            "Plan Width": 0,
            "Actual Startup Time": 0.001,
            "Actual Total Time": 0.001,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["1"],
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          },
          {
            "Node Type": "WorkTable Scan",
            "Parent Relationship": "Inner",
            "CTE Name": "cte1",
            "Alias": "cte1_1",
            "Startup Cost": 0.00,
            "Total Cost": 0.23,
            "Plan Rows": 3,
            "Plan Width": 4,
            "Actual Startup Time": 0.001,
            "Actual Total Time": 0.001,
            "Actual Rows": 1,
            "Actual Loops": 10,
            "Output": ["(cte1_1.a + 1)"],
            "Filter": "(cte1_1.a < 10)",
            "Rows Removed by Filter": 0,
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          }
        ]
      },
      {
        "Node Type": "CTE Scan",
        "Parent Relationship": "Outer",
        "CTE Name": "cte1",
        "Alias": "cte1",
        "Startup Cost": 0.00,
        "Total Cost": 0.62,
        "Plan Rows": 31,
        "Plan Width": 4,
        "Actual Startup Time": 0.004,
        "Actual Total Time": 0.042,
        "Actual Rows": 10,
        "Actual Loops": 1,
        "Output": ["cte1.a"],
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.137,
  "Triggers": [
  ],
  "Execution Time": 0.727
}'),
(9, '###### Plan 9: FunctionScan, Hash/HashJoin, Nested Loop',
 '{
  "Plan": {
    "Node Type": "Nested Loop",
    "Join Type": "Inner",
    "Startup Cost": 1.15,
    "Total Cost": 2.69,
    "Plan Rows": 1,
    "Plan Width": 64,
    "Actual Startup Time": 0.068,
    "Actual Total Time": 0.070,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Output": ["d.datname"],
    "Shared Hit Blocks": 3,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Hash Join",
        "Parent Relationship": "Outer",
        "Join Type": "Inner",
        "Startup Cost": 1.02,
        "Total Cost": 2.41,
        "Plan Rows": 1,
        "Plan Width": 4,
        "Actual Startup Time": 0.057,
        "Actual Total Time": 0.058,
        "Actual Rows": 1,
        "Actual Loops": 1,
        "Output": ["s.datid"],
        "Hash Cond": "(s.usesysid = u.oid)",
        "Shared Hit Blocks": 1,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Function Scan",
            "Parent Relationship": "Outer",
            "Function Name": "pg_stat_get_activity",
            "Schema": "pg_catalog",
            "Alias": "s",
            "Startup Cost": 0.00,
            "Total Cost": 1.00,
            "Plan Rows": 100,
            "Plan Width": 8,
            "Actual Startup Time": 0.040,
            "Actual Total Time": 0.041,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["s.datid", "s.pid", "s.usesysid", "s.application_name", "s.state", "s.query", "s.waiting", "s.xact_start", "s.query_start", "s.backend_start", "s.state_change", "s.client_addr", "s.client_hostname", "s.client_port", "s.backend_xid", "s.backend_xmin", "s.ssl", "s.sslversion", "s.sslcipher", "s.sslbits", "s.sslcompression", "s.sslclientdn"],
            "Function Call": "pg_stat_get_activity(NULL::integer)",
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          },
          {
            "Node Type": "Hash",
            "Parent Relationship": "Inner",
            "Startup Cost": 1.01,
            "Total Cost": 1.01,
            "Plan Rows": 1,
            "Plan Width": 4,
            "Actual Startup Time": 0.007,
            "Actual Total Time": 0.007,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["u.oid"],
            "Hash Buckets": 1024,
            "Original Hash Buckets": 1024,
            "Hash Batches": 1,
            "Original Hash Batches": 1,
            "Peak Memory Usage": 9,
            "Shared Hit Blocks": 1,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000,
            "Plans": [
              {
                "Node Type": "Seq Scan",
                "Parent Relationship": "Outer",
                "Relation Name": "pg_authid",
                "Schema": "pg_catalog",
                "Alias": "u",
                "Startup Cost": 0.00,
                "Total Cost": 1.01,
                "Plan Rows": 1,
                "Plan Width": 4,
                "Actual Startup Time": 0.004,
                "Actual Total Time": 0.005,
                "Actual Rows": 1,
                "Actual Loops": 1,
                "Output": ["u.oid"],
                "Shared Hit Blocks": 1,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000
              }
            ]
          }
        ]
      },
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Inner",
        "Scan Direction": "Forward",
        "Index Name": "pg_database_oid_index",
        "Relation Name": "pg_database",
        "Schema": "pg_catalog",
        "Alias": "d",
        "Startup Cost": 0.13,
        "Total Cost": 0.27,
        "Plan Rows": 1,
        "Plan Width": 68,
        "Actual Startup Time": 0.007,
        "Actual Total Time": 0.008,
        "Actual Rows": 1,
        "Actual Loops": 1,
        "Output": ["d.datname", "d.oid"],
        "Index Cond": "(d.oid = s.datid)",
        "Rows Removed by Index Recheck": 0,
        "Shared Hit Blocks": 2,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.668,
  "Triggers": [
  ],
  "Execution Time": 1.162
}'),
(10, '###### Plan 10: MergeAppend, Values',
 E'{
  "Plan": {
    "Node Type": "Merge Append",
    "Startup Cost": 0.36,
    "Total Cost": 985.44,
    "Plan Rows": 10004,
    "Plan Width": 4,
    "Actual Startup Time": 0.029,
    "Actual Total Time": 30.688,
    "Actual Rows": 10004,
    "Actual Loops": 1,
    "Sort Key": ["tt1.a"],
    "Shared Hit Blocks": 30069,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Index Only Scan",
        "Parent Relationship": "Member",
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.29,
        "Total Cost": 760.30,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.017,
        "Actual Total Time": 28.032,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt1.a"],
        "Heap Fetches": 29973,
        "Shared Hit Blocks": 30069,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      },
      {
        "Node Type": "Sort",
        "Parent Relationship": "Member",
        "Startup Cost": 0.06,
        "Total Cost": 0.07,
        "Plan Rows": 3,
        "Plan Width": 4,
        "Actual Startup Time": 0.010,
        "Actual Total Time": 0.010,
        "Actual Rows": 3,
        "Actual Loops": 1,
        "Output": ["\\"*VALUES*\\".column1"],
        "Sort Key": ["\\"*VALUES*\\".column1"],
        "Sort Method": "quicksort",
        "Sort Space Used": 25,
        "Sort Space Type": "Memory",
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Values Scan",
            "Parent Relationship": "Outer",
            "Alias": "*VALUES*",
            "Startup Cost": 0.00,
            "Total Cost": 0.04,
            "Plan Rows": 3,
            "Plan Width": 4,
            "Actual Startup Time": 0.002,
            "Actual Total Time": 0.004,
            "Actual Rows": 3,
            "Actual Loops": 1,
            "Output": ["\\"*VALUES*\\".column1"],
            "Shared Hit Blocks": 0,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          }
        ]
      }
    ]
  },
  "Planning Time": 0.136,
  "Triggers": [
  ],
  "Execution Time": 32.772
}'),
(11, '###### Plan 11: Append, HashAggregate',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Hashed",
    "Startup Cost": 668.04,
    "Total Cost": 868.06,
    "Plan Rows": 20002,
    "Plan Width": 4,
    "Actual Startup Time": 21.602,
    "Actual Total Time": 27.370,
    "Actual Rows": 20002,
    "Actual Loops": 1,
    "Output": ["tt1.a"],
    "Group Key": ["tt1.a"],
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Append",
        "Parent Relationship": "Outer",
        "Startup Cost": 0.00,
        "Total Cost": 618.04,
        "Plan Rows": 20002,
        "Plan Width": 4,
        "Actual Startup Time": 0.167,
        "Actual Total Time": 10.785,
        "Actual Rows": 20002,
        "Actual Loops": 1,
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 263.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.167,
            "Actual Total Time": 3.519,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt1.a"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          },
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Member",
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.010,
            "Actual Total Time": 3.366,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          }
        ]
      }
    ]
  },
  "Planning Time": 0.072,
  "Triggers": [
  ],
  "Execution Time": 30.173
}'),
(12, '###### Plan 12: GroupAggregate',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Sorted",
    "Startup Cost": 1067.47,
    "Total Cost": 1242.49,
    "Plan Rows": 10001,
    "Plan Width": 8,
    "Actual Startup Time": 13.280,
    "Actual Total Time": 25.173,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["sum(a)", "b"],
    "Group Key": ["tt1.b"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 22,
    "Temp Written Blocks": 22,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Startup Cost": 1067.47,
        "Total Cost": 1092.47,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 13.275,
        "Actual Total Time": 17.306,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["b", "a"],
        "Sort Key": ["tt1.b"],
        "Sort Method": "external merge",
        "Sort Space Used": 136,
        "Sort Space Type": "Disk",
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 22,
        "Temp Written Blocks": 22,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 263.01,
            "Plan Rows": 10001,
            "Plan Width": 8,
            "Actual Startup Time": 0.137,
            "Actual Total Time": 3.119,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["b", "a"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          }
        ]
      }
    ]
  },
  "Planning Time": 0.048,
  "Triggers": [
  ],
  "Execution Time": 27.082
}'),
(13, '###### Plan 13: Group',
 '{
  "Plan": {
    "Node Type": "Group",
    "Startup Cost": 1067.47,
    "Total Cost": 1117.47,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 12.006,
    "Actual Total Time": 20.222,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["b"],
    "Group Key": ["tt1.b"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 22,
    "Temp Written Blocks": 22,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Startup Cost": 1067.47,
        "Total Cost": 1092.47,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 12.005,
        "Actual Total Time": 15.570,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["b"],
        "Sort Key": ["tt1.b"],
        "Sort Method": "external merge",
        "Sort Space Used": 136,
        "Sort Space Type": "Disk",
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 22,
        "Temp Written Blocks": 22,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 263.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.134,
            "Actual Total Time": 2.915,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["b"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          }
        ]
      }
    ]
  },
  "Planning Time": 0.037,
  "Triggers": [
  ],
  "Execution Time": 21.590
}'),
(14, '###### Plan 14: SetOp intersect, SbuqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Startup Cost": 1332.50,
    "Total Cost": 1357.51,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 20.706,
    "Actual Total Time": 20.706,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 25,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Command": "Intersect",
        "Startup Cost": 0.00,
        "Total Cost": 668.04,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 20.703,
        "Actual Total Time": 20.703,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Startup Cost": 0.00,
            "Total Cost": 618.04,
            "Plan Rows": 20002,
            "Plan Width": 4,
            "Actual Startup Time": 0.125,
            "Actual Total Time": 13.961,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.125,
                "Actual Total Time": 5.660,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.120,
                    "Actual Total Time": 2.671,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0,
                    "I/O Read Time": 0.000,
                    "I/O Write Time": 0.000
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.007,
                "Actual Total Time": 5.275,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.007,
                    "Actual Total Time": 2.600,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0,
                    "I/O Read Time": 0.000,
                    "I/O Write Time": 0.000
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.067,
  "Triggers": [
  ],
  "Execution Time": 21.351
}'),
(15, '###### Plan 15: Sorted SetOp, Sort on Disk',
 E'{
  "Plan": {
    "Node Type": "SetOp",
    "Strategy": "Sorted",
    "Command": "Intersect",
    "Startup Cost": 2323.47,
    "Total Cost": 2423.48,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 44.251,
    "Actual Total Time": 44.251,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 70,
    "Temp Written Blocks": 70,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Startup Cost": 2323.47,
        "Total Cost": 2373.47,
        "Plan Rows": 20002,
        "Plan Width": 4,
        "Actual Startup Time": 32.669,
        "Actual Total Time": 38.315,
        "Actual Rows": 20002,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Sort Key": ["\\"*SELECT* 1\\".a"],
        "Sort Method": "external merge",
        "Sort Space Used": 320,
        "Sort Space Type": "Disk",
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 70,
        "Temp Written Blocks": 70,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Startup Cost": 0.00,
            "Total Cost": 618.04,
            "Plan Rows": 20002,
            "Plan Width": 4,
            "Actual Startup Time": 0.117,
            "Actual Total Time": 12.979,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.117,
                "Actual Total Time": 5.283,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.116,
                    "Actual Total Time": 2.577,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0,
                    "I/O Read Time": 0.000,
                    "I/O Write Time": 0.000
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.007,
                "Actual Total Time": 4.910,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.006,
                    "Actual Total Time": 2.426,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0,
                    "I/O Read Time": 0.000,
                    "I/O Write Time": 0.000
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.063,
  "Triggers": [
  ],
  "Execution Time": 44.861
}'),
(16, '###### Plan 16: HashSetOp intersect All, SubqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Startup Cost": 1332.50,
    "Total Cost": 1357.51,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 16.635,
    "Actual Total Time": 16.635,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 25,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Command": "Intersect All",
        "Startup Cost": 0.00,
        "Total Cost": 668.04,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 16.632,
        "Actual Total Time": 16.632,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Startup Cost": 0.00,
            "Total Cost": 618.04,
            "Plan Rows": 20002,
            "Plan Width": 4,
            "Actual Startup Time": 0.100,
            "Actual Total Time": 11.135,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.100,
                "Actual Total Time": 4.444,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.099,
                    "Actual Total Time": 2.122,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0,
                    "I/O Read Time": 0.000,
                    "I/O Write Time": 0.000
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.006,
                "Actual Total Time": 4.310,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.006,
                    "Actual Total Time": 2.100,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0,
                    "I/O Read Time": 0.000,
                    "I/O Write Time": 0.000
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.054,
  "Triggers": [
  ],
  "Execution Time": 17.161
}'),
(17, '###### Plan 17: HashSetOp except, SubqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Startup Cost": 1332.50,
    "Total Cost": 1357.51,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 21.220,
    "Actual Total Time": 21.898,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 811,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Command": "Except",
        "Startup Cost": 0.00,
        "Total Cost": 668.04,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 16.219,
        "Actual Total Time": 17.188,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Startup Cost": 0.00,
            "Total Cost": 618.04,
            "Plan Rows": 20002,
            "Plan Width": 4,
            "Actual Startup Time": 0.105,
            "Actual Total Time": 11.155,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.105,
                "Actual Total Time": 4.451,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.104,
                    "Actual Total Time": 2.108,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0,
                    "I/O Read Time": 0.000,
                    "I/O Write Time": 0.000
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.006,
                "Actual Total Time": 4.298,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.006,
                    "Actual Total Time": 2.079,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0,
                    "I/O Read Time": 0.000,
                    "I/O Write Time": 0.000
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.053,
  "Triggers": [
  ],
  "Execution Time": 23.793
}'),
(18, '###### Plan 18: HashSetOp except all, SubqueryScan',
 E'{
  "Plan": {
    "Node Type": "Sort",
    "Startup Cost": 1332.50,
    "Total Cost": 1357.51,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 21.153,
    "Actual Total Time": 21.804,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["\\"*SELECT* 1\\".a", "(0)"],
    "Sort Key": ["\\"*SELECT* 1\\".a"],
    "Sort Method": "quicksort",
    "Sort Space Used": 811,
    "Sort Space Type": "Memory",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "SetOp",
        "Strategy": "Hashed",
        "Parent Relationship": "Outer",
        "Command": "Except All",
        "Startup Cost": 0.00,
        "Total Cost": 668.04,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 16.271,
        "Actual Total Time": 17.182,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["\\"*SELECT* 1\\".a", "(0)"],
        "Shared Hit Blocks": 218,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Append",
            "Parent Relationship": "Outer",
            "Startup Cost": 0.00,
            "Total Cost": 618.04,
            "Plan Rows": 20002,
            "Plan Width": 4,
            "Actual Startup Time": 0.102,
            "Actual Total Time": 11.170,
            "Actual Rows": 20002,
            "Actual Loops": 1,
            "Shared Hit Blocks": 218,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000,
            "Plans": [
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Alias": "*SELECT* 1",
                "Startup Cost": 0.00,
                "Total Cost": 363.02,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.102,
                "Actual Total Time": 4.446,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 1\\".a", "0"],
                "Shared Hit Blocks": 163,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Relation Name": "tt1",
                    "Schema": "public",
                    "Alias": "tt1",
                    "Startup Cost": 0.00,
                    "Total Cost": 263.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.100,
                    "Actual Total Time": 2.136,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt1.a"],
                    "Shared Hit Blocks": 163,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0,
                    "I/O Read Time": 0.000,
                    "I/O Write Time": 0.000
                  }
                ]
              },
              {
                "Node Type": "Subquery Scan",
                "Parent Relationship": "Member",
                "Alias": "*SELECT* 2",
                "Startup Cost": 0.00,
                "Total Cost": 255.02,
                "Plan Rows": 10001,
                "Plan Width": 4,
                "Actual Startup Time": 0.006,
                "Actual Total Time": 4.259,
                "Actual Rows": 10001,
                "Actual Loops": 1,
                "Output": ["\\"*SELECT* 2\\".b", "1"],
                "Shared Hit Blocks": 55,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000,
                "Plans": [
                  {
                    "Node Type": "Seq Scan",
                    "Parent Relationship": "Subquery",
                    "Relation Name": "tt2",
                    "Schema": "public",
                    "Alias": "tt2",
                    "Startup Cost": 0.00,
                    "Total Cost": 155.01,
                    "Plan Rows": 10001,
                    "Plan Width": 4,
                    "Actual Startup Time": 0.006,
                    "Actual Total Time": 2.117,
                    "Actual Rows": 10001,
                    "Actual Loops": 1,
                    "Output": ["tt2.b"],
                    "Shared Hit Blocks": 55,
                    "Shared Read Blocks": 0,
                    "Shared Dirtied Blocks": 0,
                    "Shared Written Blocks": 0,
                    "Local Hit Blocks": 0,
                    "Local Read Blocks": 0,
                    "Local Dirtied Blocks": 0,
                    "Local Written Blocks": 0,
                    "Temp Read Blocks": 0,
                    "Temp Written Blocks": 0,
                    "I/O Read Time": 0.000,
                    "I/O Write Time": 0.000
                  }
                ]
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.054,
  "Triggers": [
  ],
  "Execution Time": 23.716
}'),
(19, '###### Plan 19: merge LEFT join',
 '{
  "Plan": {
    "Node Type": "Merge Join",
    "Join Type": "Left",
    "Startup Cost": 0.71,
    "Total Cost": 4300.43,
    "Plan Rows": 33599,
    "Plan Width": 4,
    "Actual Startup Time": 0.029,
    "Actual Total Time": 51.083,
    "Actual Rows": 60003,
    "Actual Loops": 1,
    "Output": ["x.b"],
    "Merge Cond": "(x.a = y.a)",
    "Shared Hit Blocks": 20944,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Outer",
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "x",
        "Startup Cost": 0.29,
        "Total Cost": 760.30,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 0.006,
        "Actual Total Time": 3.337,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["x.a", "x.b", "x.c"],
        "Shared Hit Blocks": 165,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      },
      {
        "Node Type": "Index Only Scan",
        "Parent Relationship": "Inner",
        "Scan Direction": "Forward",
        "Index Name": "i_tt3_a",
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "y",
        "Startup Cost": 0.42,
        "Total Cost": 9040.38,
        "Plan Rows": 180003,
        "Plan Width": 4,
        "Actual Startup Time": 0.019,
        "Actual Total Time": 26.518,
        "Actual Rows": 60004,
        "Actual Loops": 1,
        "Output": ["y.a"],
        "Heap Fetches": 60004,
        "Shared Hit Blocks": 20779,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.288,
  "Triggers": [
  ],
  "Execution Time": 56.031
}'),
(20, '###### Plan 20: hash FULL join',
 '{
  "Plan": {
    "Node Type": "Hash Join",
    "Join Type": "Full",
    "Startup Cost": 280.02,
    "Total Cost": 680.55,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 4.774,
    "Actual Total Time": 10.603,
    "Actual Rows": 17001,
    "Actual Loops": 1,
    "Output": ["x.b"],
    "Hash Cond": "(x.a = y.a)",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "x",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 8,
        "Actual Startup Time": 0.115,
        "Actual Total Time": 1.414,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["x.a", "x.b", "x.c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      },
      {
        "Node Type": "Hash",
        "Parent Relationship": "Inner",
        "Startup Cost": 155.01,
        "Total Cost": 155.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 4.644,
        "Actual Total Time": 4.644,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["y.a"],
        "Hash Buckets": 16384,
        "Original Hash Buckets": 16384,
        "Hash Batches": 1,
        "Original Hash Batches": 1,
        "Peak Memory Usage": 480,
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "y",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.008,
            "Actual Total Time": 2.078,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["y.a"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          }
        ]
      }
    ]
  },
  "Planning Time": 0.095,
  "Triggers": [
  ],
  "Execution Time": 12.117
}'),
(21, '###### Plan 21: hash SEMI join',
 '{
  "Plan": {
    "Node Type": "Hash Join",
    "Join Type": "Semi",
    "Startup Cost": 280.02,
    "Total Cost": 680.55,
    "Plan Rows": 10001,
    "Plan Width": 12,
    "Actual Startup Time": 7.910,
    "Actual Total Time": 7.910,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["tt1.a", "tt1.b", "tt1.c"],
    "Hash Cond": "(tt1.a = tt2.b)",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 12,
        "Actual Startup Time": 0.093,
        "Actual Total Time": 1.237,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt1.a", "tt1.b", "tt1.c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      },
      {
        "Node Type": "Hash",
        "Parent Relationship": "Inner",
        "Startup Cost": 155.01,
        "Total Cost": 155.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 4.703,
        "Actual Total Time": 4.703,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt2.b"],
        "Hash Buckets": 16384,
        "Original Hash Buckets": 16384,
        "Hash Batches": 1,
        "Original Hash Batches": 1,
        "Peak Memory Usage": 480,
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.006,
            "Actual Total Time": 2.134,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          }
        ]
      }
    ]
  },
  "Planning Time": 0.157,
  "Triggers": [
  ],
  "Execution Time": 8.236
}'),
(22, '###### Plan 22: Hash Anti Join',
 '{
  "Plan": {
    "Node Type": "Hash Join",
    "Join Type": "Anti",
    "Startup Cost": 280.02,
    "Total Cost": 580.54,
    "Plan Rows": 1,
    "Plan Width": 12,
    "Actual Startup Time": 4.918,
    "Actual Total Time": 9.632,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["tt1.a", "tt1.b", "tt1.c"],
    "Hash Cond": "(tt1.a = tt2.b)",
    "Shared Hit Blocks": 218,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 12,
        "Actual Startup Time": 0.097,
        "Actual Total Time": 1.312,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt1.a", "tt1.b", "tt1.c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      },
      {
        "Node Type": "Hash",
        "Parent Relationship": "Inner",
        "Startup Cost": 155.01,
        "Total Cost": 155.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 4.812,
        "Actual Total Time": 4.812,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt2.b"],
        "Hash Buckets": 16384,
        "Original Hash Buckets": 16384,
        "Hash Batches": 1,
        "Original Hash Batches": 1,
        "Peak Memory Usage": 480,
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.007,
            "Actual Total Time": 2.274,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 55,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          }
        ]
      }
    ]
  },
  "Planning Time": 0.110,
  "Triggers": [
  ],
  "Execution Time": 10.650
}'),
(23, '###### Plan 23: WindowAgg',
 '{
  "Plan": {
    "Node Type": "WindowAgg",
    "Startup Cost": 927.47,
    "Total Cost": 1127.49,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 5.164,
    "Actual Total Time": 14.618,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["first_value(a) OVER (?)", "((a / 10))"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Sort",
        "Parent Relationship": "Outer",
        "Startup Cost": 927.47,
        "Total Cost": 952.47,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 5.157,
        "Actual Total Time": 6.014,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["((a / 10))", "a"],
        "Sort Key": ["((tt1.a / 10))"],
        "Sort Method": "quicksort",
        "Sort Space Used": 811,
        "Sort Space Type": "Memory",
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Relation Name": "tt1",
            "Schema": "public",
            "Alias": "tt1",
            "Startup Cost": 0.00,
            "Total Cost": 263.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.099,
            "Actual Total Time": 2.822,
            "Actual Rows": 10001,
            "Actual Loops": 1,
            "Output": ["(a / 10)", "a"],
            "Shared Hit Blocks": 163,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          }
        ]
      }
    ]
  },
  "Planning Time": 0.046,
  "Triggers": [
  ],
  "Execution Time": 15.926
}'),
(24, '###### Plan 24: Unique',
 '{
  "Plan": {
    "Node Type": "Unique",
    "Startup Cost": 0.29,
    "Total Cost": 785.30,
    "Plan Rows": 10001,
    "Plan Width": 4,
    "Actual Startup Time": 0.009,
    "Actual Total Time": 6.684,
    "Actual Rows": 10001,
    "Actual Loops": 1,
    "Output": ["a"],
    "Shared Hit Blocks": 165,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Index Only Scan",
        "Parent Relationship": "Outer",
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.29,
        "Total Cost": 760.30,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.008,
        "Actual Total Time": 3.517,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["a"],
        "Heap Fetches": 10001,
        "Shared Hit Blocks": 165,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.034,
  "Triggers": [
  ],
  "Execution Time": 7.610
}'),
(25, '###### Plan 25: PlainAggregate',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Plain",
    "Startup Cost": 288.01,
    "Total Cost": 288.02,
    "Plan Rows": 1,
    "Plan Width": 4,
    "Actual Startup Time": 3.056,
    "Actual Total Time": 3.056,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Output": ["sum(a)"],
    "Shared Hit Blocks": 163,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 263.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.097,
        "Actual Total Time": 1.249,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["a", "b", "c"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.032,
  "Triggers": [
  ],
  "Execution Time": 3.229
}'),
(26, '###### Plan 26: BitmapIndexScan/BitmapHeapScan, BitmapOr, lossy',
 E'{
  "Plan": {
    "Node Type": "Bitmap Heap Scan",
    "Relation Name": "tt3",
    "Schema": "public",
    "Alias": "tt3",
    "Startup Cost": 4271.43,
    "Total Cost": 7494.44,
    "Plan Rows": 180001,
    "Plan Width": 12,
    "Actual Startup Time": 23.643,
    "Actual Total Time": 56.113,
    "Actual Rows": 180000,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "Recheck Cond": "(tt3.b > \'-99998\'::integer)",
    "Rows Removed by Index Recheck": 3,
    "Exact Heap Blocks": 558,
    "Lossy Heap Blocks": 415,
    "Shared Hit Blocks": 1690,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Bitmap Index Scan",
        "Parent Relationship": "Outer",
        "Index Name": "i_tt3_b",
        "Startup Cost": 0.00,
        "Total Cost": 4226.43,
        "Plan Rows": 180001,
        "Plan Width": 0,
        "Actual Startup Time": 23.536,
        "Actual Total Time": 23.536,
        "Actual Rows": 180000,
        "Actual Loops": 1,
        "Index Cond": "(tt3.b > \'-99998\'::integer)",
        "Shared Hit Blocks": 717,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.090,
  "Triggers": [
  ],
  "Execution Time": 69.513
}'),
(27, '###### Plan 27: Join Filter',
 '{
  "Plan": {
    "Node Type": "Limit",
    "Startup Cost": 0.00,
    "Total Cost": 21.52,
    "Plan Rows": 100,
    "Plan Width": 12,
    "Actual Startup Time": 4.752,
    "Actual Total Time": 4.861,
    "Actual Rows": 100,
    "Actual Loops": 1,
    "Output": ["tt2.a", "tt2.b", "tt2.c"],
    "Shared Hit Blocks": 40,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 12,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Nested Loop",
        "Parent Relationship": "Outer",
        "Join Type": "Inner",
        "Startup Cost": 0.00,
        "Total Cost": 43048282.11,
        "Plan Rows": 200023334,
        "Plan Width": 12,
        "Actual Startup Time": 4.751,
        "Actual Total Time": 4.848,
        "Actual Rows": 100,
        "Actual Loops": 1,
        "Output": ["tt2.a", "tt2.b", "tt2.c"],
        "Join Filter": "((tt2.a < tt3.a) AND ((tt3.a + tt2.a) < 100000))",
        "Rows Removed by Join Filter": 7001,
        "Shared Hit Blocks": 40,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 12,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 12,
            "Actual Startup Time": 0.013,
            "Actual Total Time": 0.013,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["tt2.a", "tt2.b", "tt2.c"],
            "Shared Hit Blocks": 1,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          },
          {
            "Node Type": "Materialize",
            "Parent Relationship": "Inner",
            "Startup Cost": 0.00,
            "Total Cost": 4377.05,
            "Plan Rows": 180003,
            "Plan Width": 4,
            "Actual Startup Time": 0.008,
            "Actual Total Time": 3.712,
            "Actual Rows": 7101,
            "Actual Loops": 1,
            "Output": ["tt3.a"],
            "Shared Hit Blocks": 39,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 12,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000,
            "Plans": [
              {
                "Node Type": "Seq Scan",
                "Parent Relationship": "Outer",
                "Relation Name": "tt3",
                "Schema": "public",
                "Alias": "tt3",
                "Startup Cost": 0.00,
                "Total Cost": 2773.03,
                "Plan Rows": 180003,
                "Plan Width": 4,
                "Actual Startup Time": 0.007,
                "Actual Total Time": 1.475,
                "Actual Rows": 7101,
                "Actual Loops": 1,
                "Output": ["tt3.a"],
                "Shared Hit Blocks": 39,
                "Shared Read Blocks": 0,
                "Shared Dirtied Blocks": 0,
                "Shared Written Blocks": 0,
                "Local Hit Blocks": 0,
                "Local Read Blocks": 0,
                "Local Dirtied Blocks": 0,
                "Local Written Blocks": 0,
                "Temp Read Blocks": 0,
                "Temp Written Blocks": 0,
                "I/O Read Time": 0.000,
                "I/O Write Time": 0.000
              }
            ]
          }
        ]
      }
    ]
  },
  "Planning Time": 0.153,
  "Triggers": [
  ],
  "Execution Time": 5.363
}'),
(28, '###### Plan 28: TidScan',
 E'{
  "Plan": {
    "Node Type": "Tid Scan",
    "Relation Name": "tt3",
    "Schema": "public",
    "Alias": "tt3",
    "Startup Cost": 0.00,
    "Total Cost": 4.01,
    "Plan Rows": 1,
    "Plan Width": 12,
    "Actual Startup Time": 0.004,
    "Actual Total Time": 0.004,
    "Actual Rows": 1,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "TID Cond": "(tt3.ctid = \'(0,28)\'::tid)",
    "Shared Hit Blocks": 1,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000
  },
  "Planning Time": 0.058,
  "Triggers": [
  ],
  "Execution Time": 0.113
}'),
(29, '###### Plan 29: LockRows',
 '{
  "Plan": {
    "Node Type": "LockRows",
    "Startup Cost": 0.00,
    "Total Cost": 313.51,
    "Plan Rows": 50,
    "Plan Width": 10,
    "Actual Startup Time": 0.132,
    "Actual Total Time": 4.061,
    "Actual Rows": 1001,
    "Actual Loops": 1,
    "Output": ["a", "ctid"],
    "Shared Hit Blocks": 1164,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 313.01,
        "Plan Rows": 50,
        "Plan Width": 10,
        "Actual Startup Time": 0.123,
        "Actual Total Time": 3.139,
        "Actual Rows": 1001,
        "Actual Loops": 1,
        "Output": ["a", "ctid"],
        "Filter": "((tt1.a % 10) = 0)",
        "Rows Removed by Filter": 9000,
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.034,
  "Triggers": [
  ],
  "Execution Time": 4.378
}'),
(30, '###### Plan 30: Materialize',
 '{
  "Plan": {
    "Node Type": "Seq Scan",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 1150490.52,
    "Plan Rows": 5000,
    "Plan Width": 12,
    "Actual Startup Time": 4.470,
    "Actual Total Time": 4.470,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Output": ["tt1.a", "tt1.b", "tt1.c"],
    "Filter": "(SubPlan 1)",
    "Rows Removed by Filter": 10001,
    "Shared Hit Blocks": 164,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Materialize",
        "Parent Relationship": "SubPlan",
        "Subplan Name": "SubPlan 1",
        "Startup Cost": 0.00,
        "Total Cost": 205.01,
        "Plan Rows": 10001,
        "Plan Width": 4,
        "Actual Startup Time": 0.000,
        "Actual Total Time": 0.000,
        "Actual Rows": 1,
        "Actual Loops": 10001,
        "Output": ["tt2.b"],
        "Shared Hit Blocks": 1,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000,
        "Plans": [
          {
            "Node Type": "Seq Scan",
            "Parent Relationship": "Outer",
            "Relation Name": "tt2",
            "Schema": "public",
            "Alias": "tt2",
            "Startup Cost": 0.00,
            "Total Cost": 155.01,
            "Plan Rows": 10001,
            "Plan Width": 4,
            "Actual Startup Time": 0.007,
            "Actual Total Time": 0.007,
            "Actual Rows": 1,
            "Actual Loops": 1,
            "Output": ["tt2.b"],
            "Shared Hit Blocks": 1,
            "Shared Read Blocks": 0,
            "Shared Dirtied Blocks": 0,
            "Shared Written Blocks": 0,
            "Local Hit Blocks": 0,
            "Local Read Blocks": 0,
            "Local Dirtied Blocks": 0,
            "Local Written Blocks": 0,
            "Temp Read Blocks": 0,
            "Temp Written Blocks": 0,
            "I/O Read Time": 0.000,
            "I/O Write Time": 0.000
          }
        ]
      }
    ]
  },
  "Planning Time": 0.047,
  "Triggers": [
  ],
  "Execution Time": 4.715
}'),
(31, '###### Plan 31: Update on partitioned tables',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Update",
    "Relation Name": "p",
    "Schema": "public",
    "Alias": "p",
    "Startup Cost": 0.00,
    "Total Cost": 3691.07,
    "Plan Rows": 200006,
    "Plan Width": 18,
    "Actual Startup Time": 2976.258,
    "Actual Total Time": 2976.258,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Target Tables": [
      {
        "Relation Name": "p",
        "Schema": "public",
        "Alias": "p"
      },
      {
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1"
      },
      {
        "Relation Name": "tt2",
        "Schema": "public",
        "Alias": "tt2"
      },
      {
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "tt3"
      }
    ],
    "Shared Hit Blocks": 1566205,
    "Shared Read Blocks": 2648,
    "Shared Dirtied Blocks": 2648,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Relation Name": "p",
        "Schema": "public",
        "Alias": "p",
        "Startup Cost": 0.00,
        "Total Cost": 0.00,
        "Plan Rows": 1,
        "Plan Width": 46,
        "Actual Startup Time": 0.000,
        "Actual Total Time": 0.000,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["p.a", "(p.b + 1)", "p.c", "p.ctid"],
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      },
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 288.01,
        "Plan Rows": 10001,
        "Plan Width": 18,
        "Actual Startup Time": 0.098,
        "Actual Total Time": 8.471,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt1.a", "(tt1.b + 1)", "tt1.c", "tt1.ctid"],
        "Shared Hit Blocks": 163,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      },
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Relation Name": "tt2",
        "Schema": "public",
        "Alias": "tt2",
        "Startup Cost": 0.00,
        "Total Cost": 180.01,
        "Plan Rows": 10001,
        "Plan Width": 18,
        "Actual Startup Time": 0.010,
        "Actual Total Time": 5.672,
        "Actual Rows": 10001,
        "Actual Loops": 1,
        "Output": ["tt2.a", "(tt2.b + 1)", "tt2.c", "tt2.ctid"],
        "Shared Hit Blocks": 55,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      },
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "tt3",
        "Startup Cost": 0.00,
        "Total Cost": 3223.04,
        "Plan Rows": 180003,
        "Plan Width": 18,
        "Actual Startup Time": 0.010,
        "Actual Total Time": 109.066,
        "Actual Rows": 180003,
        "Actual Loops": 1,
        "Output": ["tt3.a", "(tt3.b + 1)", "tt3.c", "tt3.ctid"],
        "Shared Hit Blocks": 973,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.153,
  "Triggers": [
    {
      "Trigger Name": "tt1_trig_1",
      "Relation": "tt1",
      "Time": 70.532,
      "Calls": 10001
    },
    {
      "Trigger Name": "tt1_trig_2",
      "Relation": "tt1",
      "Time": 56.766,
      "Calls": 10001
    }
  ],
  "Execution Time": 2976.755
}'),
(32, '###### Plan 32: Delete on partitioned tables',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Delete",
    "Relation Name": "p",
    "Schema": "public",
    "Alias": "p",
    "Startup Cost": 0.00,
    "Total Cost": 32.81,
    "Plan Rows": 6,
    "Plan Width": 6,
    "Actual Startup Time": 0.257,
    "Actual Total Time": 0.257,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Target Tables": [
      {
        "Relation Name": "p",
        "Schema": "public",
        "Alias": "p"
      },
      {
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1"
      },
      {
        "Relation Name": "tt2",
        "Schema": "public",
        "Alias": "tt2"
      },
      {
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "tt3"
      }
    ],
    "Shared Hit Blocks": 18,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Member",
        "Relation Name": "p",
        "Schema": "public",
        "Alias": "p",
        "Startup Cost": 0.00,
        "Total Cost": 0.00,
        "Plan Rows": 1,
        "Plan Width": 6,
        "Actual Startup Time": 0.001,
        "Actual Total Time": 0.001,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["p.ctid"],
        "Filter": "(p.a = 100)",
        "Rows Removed by Filter": 0,
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      },
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Member",
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.29,
        "Total Cost": 8.30,
        "Plan Rows": 1,
        "Plan Width": 6,
        "Actual Startup Time": 0.070,
        "Actual Total Time": 0.121,
        "Actual Rows": 1,
        "Actual Loops": 1,
        "Output": ["tt1.ctid"],
        "Index Cond": "(tt1.a = 100)",
        "Rows Removed by Index Recheck": 0,
        "Shared Hit Blocks": 5,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      },
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Member",
        "Scan Direction": "Forward",
        "Index Name": "i_tt2",
        "Relation Name": "tt2",
        "Schema": "public",
        "Alias": "tt2",
        "Startup Cost": 0.29,
        "Total Cost": 8.30,
        "Plan Rows": 1,
        "Plan Width": 6,
        "Actual Startup Time": 0.007,
        "Actual Total Time": 0.007,
        "Actual Rows": 0,
        "Actual Loops": 1,
        "Output": ["tt2.ctid"],
        "Index Cond": "(tt2.a = 100)",
        "Rows Removed by Index Recheck": 0,
        "Shared Hit Blocks": 2,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      },
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Member",
        "Scan Direction": "Forward",
        "Index Name": "i_tt3_a",
        "Relation Name": "tt3",
        "Schema": "public",
        "Alias": "tt3",
        "Startup Cost": 0.42,
        "Total Cost": 16.20,
        "Plan Rows": 3,
        "Plan Width": 6,
        "Actual Startup Time": 0.013,
        "Actual Total Time": 0.108,
        "Actual Rows": 2,
        "Actual Loops": 1,
        "Output": ["tt3.ctid"],
        "Index Cond": "(tt3.a = 100)",
        "Rows Removed by Index Recheck": 0,
        "Shared Hit Blocks": 8,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.333,
  "Triggers": [
  ],
  "Execution Time": 1.258
}'),
(33, '###### Plan 33: ON CONFLICT',
 '{
  "Plan": {
    "Node Type": "ModifyTable",
    "Operation": "Insert",
    "Relation Name": "ct1",
    "Schema": "public",
    "Alias": "ct1",
    "Startup Cost": 0.00,
    "Total Cost": 0.01,
    "Plan Rows": 1,
    "Plan Width": 0,
    "Actual Startup Time": 0.055,
    "Actual Total Time": 0.055,
    "Actual Rows": 0,
    "Actual Loops": 1,
    "Conflict Resolution": "UPDATE",
    "Conflict Arbiter Indexes": ["ct1_a_key"],
    "Tuples Inserted": 0,
    "Conflicting Tuples": 1,
    "Shared Hit Blocks": 4,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Result",
        "Parent Relationship": "Member",
        "Startup Cost": 0.00,
        "Total Cost": 0.01,
        "Plan Rows": 1,
        "Plan Width": 0,
        "Actual Startup Time": 0.001,
        "Actual Total Time": 0.002,
        "Actual Rows": 1,
        "Actual Loops": 1,
        "Output": ["1", "1"],
        "Shared Hit Blocks": 0,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.031,
  "Triggers": [
  ],
  "Execution Time": 0.443
}'),
(34, '###### Plan 34: GROUP BY',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Hashed",
    "Startup Cost": 450.00,
    "Total Cost": 583.13,
    "Plan Rows": 13314,
    "Plan Width": 12,
    "Actual Startup Time": 17.687,
    "Actual Total Time": 24.180,
    "Actual Rows": 10000,
    "Actual Loops": 1,
    "Output": ["a", "b", "max(c)"],
    "Group Key": ["tt1.a", "tt1.b"],
    "Shared Hit Blocks": 217,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Seq Scan",
        "Parent Relationship": "Outer",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.00,
        "Total Cost": 350.14,
        "Plan Rows": 13314,
        "Plan Width": 12,
        "Actual Startup Time": 0.215,
        "Actual Total Time": 5.890,
        "Actual Rows": 10000,
        "Actual Loops": 1,
        "Output": ["a", "b", "c"],
        "Shared Hit Blocks": 217,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.111,
  "Triggers": [
  ],
  "Execution Time": 26.038
}'),
(35, '###### Plan 35: GROUPING SETS',
 '{
  "Plan": {
    "Node Type": "Aggregate",
    "Strategy": "Sorted",
    "Startup Cost": 0.29,
    "Total Cost": 2475.05,
    "Plan Rows": 26629,
    "Plan Width": 12,
    "Actual Startup Time": 0.026,
    "Actual Total Time": 57.973,
    "Actual Rows": 20001,
    "Actual Loops": 1,
    "Output": ["a", "b", "max(c)"],
    "Grouping Sets": [
      {
        "Group Keys": [
          ["tt1.a"],
          []
        ]
      },
      {
        "Sort Key": ["tt1.b"],
        "Group Keys": [
          ["tt1.b"]
        ]
      }
    ],
    "Shared Hit Blocks": 20180,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000,
    "Plans": [
      {
        "Node Type": "Index Scan",
        "Parent Relationship": "Outer",
        "Scan Direction": "Forward",
        "Index Name": "i_tt1",
        "Relation Name": "tt1",
        "Schema": "public",
        "Alias": "tt1",
        "Startup Cost": 0.29,
        "Total Cost": 863.99,
        "Plan Rows": 13314,
        "Plan Width": 12,
        "Actual Startup Time": 0.016,
        "Actual Total Time": 21.131,
        "Actual Rows": 10000,
        "Actual Loops": 1,
        "Output": ["a", "b", "c"],
        "Shared Hit Blocks": 20180,
        "Shared Read Blocks": 0,
        "Shared Dirtied Blocks": 0,
        "Shared Written Blocks": 0,
        "Local Hit Blocks": 0,
        "Local Read Blocks": 0,
        "Local Dirtied Blocks": 0,
        "Local Written Blocks": 0,
        "Temp Read Blocks": 0,
        "Temp Written Blocks": 0,
        "I/O Read Time": 0.000,
        "I/O Write Time": 0.000
      }
    ]
  },
  "Planning Time": 0.091,
  "Triggers": [
  ],
  "Execution Time": 61.219
}'),
(36, '###### Plan 36: Table sample',
 E'{
  "Plan": {
    "Node Type": "Sample Scan",
    "Relation Name": "tt1",
    "Schema": "public",
    "Alias": "tt1",
    "Startup Cost": 0.00,
    "Total Cost": 9.33,
    "Plan Rows": 133,
    "Plan Width": 12,
    "Actual Startup Time": 0.018,
    "Actual Total Time": 0.061,
    "Actual Rows": 185,
    "Actual Loops": 1,
    "Output": ["a", "b", "c"],
    "Sampling Method": "system",
    "Sampling Parameters": ["\'1\'::real"],
    "Repeatable Seed": "\'1\'::double precision",
    "Shared Hit Blocks": 1,
    "Shared Read Blocks": 0,
    "Shared Dirtied Blocks": 0,
    "Shared Written Blocks": 0,
    "Local Hit Blocks": 0,
    "Local Read Blocks": 0,
    "Local Dirtied Blocks": 0,
    "Local Written Blocks": 0,
    "Temp Read Blocks": 0,
    "Temp Written Blocks": 0,
    "I/O Read Time": 0.000,
    "I/O Write Time": 0.000
  },
  "Planning Time": 0.062,
  "Triggers": [
  ],
  "Execution Time": 0.271
}'));

\pset pager
\set ECHO queries

\echo ###### set shortened JSON
UPDATE plans SET splan = pg_store_plans_shorten(lplan);

\echo ###### tag abbreviation test
SELECT splan FROM plans WHERE id = -1;

\echo ###### JSON properties round-trip test
SELECT id FROM plans
	where pg_store_plans_jsonplan(splan) <> lplan;

\pset format unaligned
\pset tuples_only on
\pset recordsep '\n\n=======\n'
\echo  ###### format conversion tests
SELECT '### '||'yaml-short       '||title||E'\n'||
  pg_store_plans_yamlplan(splan)
  FROM plans WHERE id BETWEEN 1 AND 3 or id = 1 ORDER BY id;
\echo  ################## 
SELECT '### '||'xml-short        '||title||E'\n'||
  pg_store_plans_xmlplan(splan)
  FROM plans WHERE id BETWEEN 4 AND 6 or id = 1 ORDER BY id;

\echo  ###### text format output test
SELECT '### '||'TEXT-short       '||title||E'\n'||
  pg_store_plans_textplan(splan)
  FROM plans ORDER BY id;

\echo  ###### long-json-as-a-source test
SELECT '### '||'yaml-long JSON   '||title||E'\n'||
  pg_store_plans_yamlplan(lplan)
  FROM plans WHERE id = 1 ORDER BY id;
\echo  ################## 
SELECT '### '||'xml-long JSON    '||title||E'\n'||
  pg_store_plans_xmlplan(lplan)
  FROM plans WHERE id = 1 ORDER BY id;
\echo  ################## 
SELECT '### '||'text-long JSON   '||title||E'\n'||
  pg_store_plans_xmlplan(lplan)
  FROM plans WHERE id = 1 ORDER BY id;

\echo  ###### chopped-source test
SELECT '### '||'inflate-chopped  '||title||E'\n'||
  pg_store_plans_jsonplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 16 AND 18 ORDER BY id;
\echo  ################## 
SELECT '### '||'yaml-chopped     '||title||E'\n'||
  pg_store_plans_yamlplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 19 AND 21 ORDER BY id;
\echo  ################## 
SELECT '### '||'xml-chopped      '||title||E'\n'||
  pg_store_plans_xmlplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 22 AND 24 ORDER BY id;
\echo  ################## 
SELECT '### '||'text-chopped     '||title||E'\n'||
  pg_store_plans_textplan(substring(splan from 1 for char_length(splan) / 3))
  FROM plans WHERE id BETWEEN 25 AND 27 ORDER BY id;

\echo ###### shorten test
SELECT '### '||'shorten          '||title||E'\n'||
  pg_store_plans_shorten(lplan)
  FROM plans WHERE id = -2 ORDER BY id;
\echo ###### normalize test
SELECT '### '||'normalize        '||title||E'\n'||
  pg_store_plans_normalize(lplan)
  FROM plans ORDER BY id;

