/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.xml;

import java.util.Vector;
import javax.swing.DefaultListModel;
import jp.sourceforge.jhime.pectin.model.XmlModel;
import jp.sourceforge.jhime.pectin.model.XmlModelAttribute;
import jp.sourceforge.jhime.pectin.model.XmlModelAttributeList;
import jp.sourceforge.jhime.pectin.model.XmlModelCode;
import jp.sourceforge.jhime.pectin.model.XmlModelDocument;
import jp.sourceforge.jhime.pectin.model.XmlModelDtd;
import jp.sourceforge.jhime.pectin.model.XmlModelElement;
import jp.sourceforge.jhime.pectin.model.XmlModelGroup;
import jp.sourceforge.jhime.pectin.model.XmlModelPi;
import jp.sourceforge.jhime.pectin.model.XmlModelTemplate;
import jp.sourceforge.jhime.pectin.model.XmlTreeModel;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLDocument {
    protected String xmlDir;
    protected Document doc;
    public static final String ROOT_TAG = "documentRoot";
    public static final String DOCUMENT_TAG = "document";
    public static final String GROUP_TAG = "group";
    public static final String TEMPLATE_TAG = "template";
    public static final String PI_TAG = "pi";
    public static final String ATTRIBUTE_TAG = "attribute";
    public static final String PARAM_TAG = "param";
    public static final String DTD_TAG = "dtd";
    public static final String ATTRIBUTE_LIST_TAG = "attributeList";
    public static final String ELEMENT_TAG = "element";
    public static final String CODE_TAG = "code";
    public static final String TEMPLATE_GROUP = "template";
    public static final String PI_GROUP = "pi";
    public static final String DTD_GROUP = "dtds";
    public static final String ATTRIBUTE_LIST_GROUP = "attrlist";
    public static final String ELEMENT_GROUP = "elements";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String REQUIRED_ATTRIBUTE = "required";
    public static final String CASE_ATTRIBUTE = "case";
    public static final String EMPTY_ATTRIBUTE = "empty";
    public static final String ATTRIBUTE_ATTRIBUTE = "attribute";
    public static final String ROOT_ATTRIBUTE = "root";
    public static final String PUBLIC_ATTRIBUTE = "public";
    public static final String SYSTEM_ATTRIBUTE = "system";

    private Element getElementGroup(String documentName, String groupName) throws XMLException {
        Element documentElement = this.getDocumentElement(documentName);
        if (documentElement == null) {
            throw new XMLException();
        }
        NodeList nodeList = documentElement.getElementsByTagName(GROUP_TAG);
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            String attrValue;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(attrValue = ((Element)node).getAttribute(TYPE_ATTRIBUTE)).equals(ELEMENT_GROUP) || !(attrValue = ((Element)node).getAttribute(NAME_ATTRIBUTE)).equals(groupName)) continue;
            return (Element)node;
        }
        return null;
    }

    private Element getElementElement(String documentName, String elementName) throws XMLException {
        Node node;
        Element documentElement = this.getDocumentElement(documentName);
        if (documentElement == null) {
            throw new XMLException();
        }
        NodeList nodeList = documentElement.getElementsByTagName(ELEMENT_TAG);
        int len = nodeList.getLength();
        for (int i = 0; i < len && (node = nodeList.item(i)).getNodeType() == 1; ++i) {
            String attrValue = ((Element)node).getAttribute(NAME_ATTRIBUTE);
            if (!elementName.equals(attrValue)) continue;
            return (Element)node;
        }
        return null;
    }

    private Element getGroupNode(Element docNode, String type) {
        Node node;
        NodeList nodeList = docNode.getElementsByTagName(GROUP_TAG);
        int len = nodeList.getLength();
        for (int i = 0; i < len && (node = nodeList.item(i)).getNodeType() == 1; ++i) {
            if (!type.equals(((Element)node).getAttribute(TYPE_ATTRIBUTE))) continue;
            return (Element)node;
        }
        return null;
    }

    private Vector getTemplateTreeModel(Element docNode) {
        Node node;
        Element tempGroupNode = this.getGroupNode(docNode, "template");
        if (tempGroupNode == null) {
            return null;
        }
        XmlTreeModel tree = new XmlTreeModel(tempGroupNode.getAttribute(NAME_ATTRIBUTE));
        NodeList nodeList = tempGroupNode.getElementsByTagName("template");
        int len = nodeList.getLength();
        for (int i = 0; i < len && (node = nodeList.item(i)).getNodeType() == 1; ++i) {
            XmlModelTemplate temp = new XmlModelTemplate(docNode, (Element)node);
            tree.add(temp);
        }
        return tree;
    }

    private Vector getPiTreeModel(Element docNode) {
        Node node;
        Element dtdGroupNode = this.getGroupNode(docNode, "pi");
        if (dtdGroupNode == null) {
            return null;
        }
        XmlTreeModel tree = new XmlTreeModel(dtdGroupNode.getAttribute(NAME_ATTRIBUTE));
        NodeList nodeList = dtdGroupNode.getElementsByTagName("pi");
        int len = nodeList.getLength();
        for (int i = 0; i < len && (node = nodeList.item(i)).getNodeType() == 1; ++i) {
            XmlModelPi pi = new XmlModelPi(docNode, (Element)node);
            tree.add(pi);
        }
        return tree;
    }

    private Vector getDtdTreeModel(Element docNode) {
        Node node;
        Element dtdGroupNode = this.getGroupNode(docNode, DTD_GROUP);
        if (dtdGroupNode == null) {
            return null;
        }
        XmlTreeModel tree = new XmlTreeModel(dtdGroupNode.getAttribute(NAME_ATTRIBUTE));
        NodeList nodeList = dtdGroupNode.getElementsByTagName(DTD_TAG);
        int len = nodeList.getLength();
        for (int i = 0; i < len && (node = nodeList.item(i)).getNodeType() == 1; ++i) {
            XmlModelDtd dtd = new XmlModelDtd(docNode, (Element)node);
            tree.add(dtd);
        }
        return tree;
    }

    private Vector getGeneralAttributeTreeModel(Element docNode) {
        Node node;
        Element attrListGroupNode = this.getGroupNode(docNode, ATTRIBUTE_LIST_GROUP);
        if (attrListGroupNode == null) {
            return null;
        }
        XmlTreeModel tree = new XmlTreeModel(attrListGroupNode.getAttribute(NAME_ATTRIBUTE));
        NodeList nodeList = attrListGroupNode.getElementsByTagName(ATTRIBUTE_LIST_TAG);
        int len = nodeList.getLength();
        for (int i = 0; i < len && (node = nodeList.item(i)).getNodeType() == 1; ++i) {
            XmlModelAttributeList attrList = new XmlModelAttributeList(docNode, (Element)node);
            tree.add(attrList);
        }
        return tree;
    }

    private Vector getElementsTreeModel(Element docNode, Vector vector) {
        Node node;
        NodeList elementsList = docNode.getElementsByTagName(GROUP_TAG);
        if (elementsList == null) {
            return vector;
        }
        int len = elementsList.getLength();
        for (int i = 0; i < len && (node = elementsList.item(i)).getNodeType() == 1; ++i) {
            Node enode;
            if (!ELEMENT_GROUP.equals(((Element)node).getAttribute(TYPE_ATTRIBUTE))) continue;
            XmlTreeModel tree = new XmlTreeModel(((Element)node).getAttribute(NAME_ATTRIBUTE));
            NodeList nodeList = ((Element)node).getElementsByTagName(ELEMENT_TAG);
            int elen = nodeList.getLength();
            for (int j = 0; j < elen && (enode = nodeList.item(j)).getNodeType() == 1; ++j) {
                XmlModelElement element = new XmlModelElement(docNode, (Element)enode);
                tree.add(element);
            }
            vector.add(tree);
        }
        return vector;
    }

    private Element appendGroupElement(Element documentElement, String name, String type) {
        Element groupElement = this.doc.createElement(GROUP_TAG);
        groupElement.setAttribute(NAME_ATTRIBUTE, name);
        groupElement.setAttribute(TYPE_ATTRIBUTE, type);
        documentElement.appendChild(groupElement);
        return groupElement;
    }

    private Element getChildElementByNameAttribute(Element parentElement, String tagName, String attribute, String value) {
        if (parentElement == null) {
            return null;
        }
        NodeList nodeList = parentElement.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            String nameValue;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(tagName) || !(nameValue = ((Element)node).getAttribute(attribute)).equals(value)) continue;
            return (Element)node;
        }
        return null;
    }

    private Vector getChildListByTagName(Element parentElement, String tagName) {
        Vector<String> vector = new Vector<String>();
        if (parentElement == null) {
            return vector;
        }
        NodeList nodeList = parentElement.getChildNodes();
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(tagName)) continue;
            String name = ((Element)node).getAttribute(NAME_ATTRIBUTE);
            vector.add(name);
        }
        return vector;
    }

    private boolean apeendChildInGroup(String documentName, String groupType, String groupName, XmlModel model) {
        boolean flag = false;
        try {
            Element element = model.createElement(this.doc);
            if (null == element) {
                StaticUtil.errorMessage(model.getType() + " \u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            Element documentElement = this.getDocumentElement(documentName);
            Element groupElement = this.getGroupNode(documentElement, groupType);
            if (null == groupElement) {
                groupElement = this.appendGroupElement(documentElement, groupName, groupType);
            }
            groupElement.appendChild(element);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage(model.getType() + " \u8981\u7d20\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    private boolean removeChildInGroup(String documentName, String groupType, String tagName, String name) {
        boolean flag = false;
        try {
            Element documentElement = this.getDocumentElement(documentName);
            Element groupElement = this.getGroupNode(documentElement, groupType);
            if (null == groupElement) {
                StaticUtil.errorMessage(groupType + " \u30b0\u30eb\u30fc\u30d7\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            Element element = this.getChildElementByNameAttribute(groupElement, tagName, NAME_ATTRIBUTE, name);
            if (null == element) {
                StaticUtil.errorMessage(tagName + " \u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            groupElement.removeChild(element);
            if (groupElement.getChildNodes().getLength() <= 0) {
                documentElement.removeChild(groupElement);
            }
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    private boolean updateChildInGroup(String documentName, String groupType, String tagName, String name, XmlModel model) {
        boolean flag = false;
        try {
            Element documentElement = this.getDocumentElement(documentName);
            Element groupElement = this.getGroupNode(documentElement, groupType);
            if (null == groupElement) {
                StaticUtil.errorMessage(groupType + " \u30b0\u30eb\u30fc\u30d7\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            Element oldElement = this.getChildElementByNameAttribute(groupElement, tagName, NAME_ATTRIBUTE, name);
            if (null == oldElement) {
                StaticUtil.errorMessage(tagName + " \u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            Element newElement = model.createElement(this.doc);
            if (null == newElement) {
                StaticUtil.errorMessage("\u65b0\u3057\u3044 " + tagName + " \u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            NodeList list = oldElement.getChildNodes();
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = list.item(i).cloneNode(true);
                newElement.appendChild(node);
            }
            groupElement.replaceChild(newElement, oldElement);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u4fee\u6b63\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    private boolean elementUp(Element parentElement, Element element1, Element element2) {
        boolean flag = false;
        try {
            if (null == parentElement || null == element1 || null == element2) {
                StaticUtil.errorMessage("\u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            parentElement.insertBefore(element2, element1);
            flag = true;
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("DOM exception", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public abstract boolean transform();

    public Vector getTreeModel(String documentName) {
        Element docNode = this.getDocumentElement(documentName);
        Vector tree = new Vector();
        Vector tempVector = this.getTemplateTreeModel(docNode);
        Vector piVector = this.getPiTreeModel(docNode);
        Vector dtdVector = this.getDtdTreeModel(docNode);
        Vector attrVector = this.getGeneralAttributeTreeModel(docNode);
        if (tempVector != null) {
            tree.add(tempVector);
        }
        if (piVector != null) {
            tree.add(piVector);
        }
        if (dtdVector != null) {
            tree.add(dtdVector);
        }
        if (attrVector != null) {
            tree.add(attrVector);
        }
        tree = this.getElementsTreeModel(docNode, tree);
        return tree;
    }

    public Vector getDocumentList() {
        if (this.doc == null) {
            return null;
        }
        Vector<String> docVector = new Vector<String>();
        NodeList nodeList = this.doc.getElementsByTagName(DOCUMENT_TAG);
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String id = ((Element)node).getAttribute(ID_ATTRIBUTE);
            docVector.add(id);
        }
        return docVector;
    }

    public DefaultListModel getDocumentList(DefaultListModel listModel) {
        if (this.doc == null) {
            return listModel;
        }
        NodeList nodeList = this.doc.getElementsByTagName(DOCUMENT_TAG);
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            String id = ((Element)node).getAttribute(ID_ATTRIBUTE);
            listModel.addElement(id);
        }
        return listModel;
    }

    public Element getDocumentElement(String documentName) {
        NodeList nodeList = this.doc.getElementsByTagName(DOCUMENT_TAG);
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            String id;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !documentName.equals(id = ((Element)node).getAttribute(ID_ATTRIBUTE))) continue;
            return (Element)node;
        }
        return null;
    }

    public boolean appendDocument(XmlModelDocument model) {
        boolean flag = false;
        try {
            Element documentElement = model.createElement(this.doc);
            this.doc.getDocumentElement().appendChild(documentElement);
            flag = true;
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean removeDocument(String documentName) {
        boolean flag = false;
        try {
            Element documentElement = this.getDocumentElement(documentName);
            if (null == documentElement) {
                StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            this.doc.getDocumentElement().removeChild(documentElement);
            flag = true;
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean updateDocument(String oldDocumentName, XmlModelDocument model) {
        boolean flag = false;
        try {
            Element documentElement = this.getDocumentElement(oldDocumentName);
            if (null == documentElement) {
                StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            documentElement.setAttribute(ID_ATTRIBUTE, model.getName());
            flag = true;
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u4fee\u6b63\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public DefaultListModel getTemplateList(DefaultListModel listModel, String documentName) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupNode = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, TYPE_ATTRIBUTE, "template");
        if (groupNode == null) {
            return listModel;
        }
        Vector vector = this.getChildListByTagName(groupNode, "template");
        int len = vector.size();
        for (int i = 0; i < len; ++i) {
            listModel.addElement(vector.get(i));
        }
        return listModel;
    }

    public Element getTemplateByNameAttribute(String documentName, String name) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupNode = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, TYPE_ATTRIBUTE, "template");
        Element node = this.getChildElementByNameAttribute(groupNode, "template", NAME_ATTRIBUTE, name);
        return node;
    }

    public XmlModelTemplate getTemplateModel(String documentName, String templateName) {
        Element templateNode = this.getTemplateByNameAttribute(documentName, templateName);
        if (templateNode == null) {
            return null;
        }
        Element documentNode = this.getDocumentElement(documentName);
        return new XmlModelTemplate(documentNode, templateNode);
    }

    public boolean appendTemplate(String documentName, XmlModelTemplate model) {
        return this.apeendChildInGroup(documentName, "template", "\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8", model);
    }

    public boolean removeTemplate(String documentName, String templateName) {
        return this.removeChildInGroup(documentName, "template", "template", templateName);
    }

    public boolean updateTemplate(String documentName, String templateName, XmlModelTemplate model) {
        return this.updateChildInGroup(documentName, "template", "template", templateName, model);
    }

    public boolean templateUpDown(String documentName, String tempName1, String tempName2) {
        Element temp1 = this.getTemplateByNameAttribute(documentName, tempName1);
        Element temp2 = this.getTemplateByNameAttribute(documentName, tempName2);
        Element documentElement = this.getDocumentElement(documentName);
        Element groupElement = this.getGroupNode(documentElement, "template");
        return this.elementUp(groupElement, temp1, temp2);
    }

    public DefaultListModel getPIElementList(DefaultListModel listModel, String documentName) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupNode = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, TYPE_ATTRIBUTE, "pi");
        if (groupNode == null) {
            return listModel;
        }
        Vector vector = this.getChildListByTagName(groupNode, "pi");
        int len = vector.size();
        for (int i = 0; i < len; ++i) {
            listModel.addElement(vector.get(i));
        }
        return listModel;
    }

    public Element getPiByNameAttribute(String documentName, String name) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupNode = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, TYPE_ATTRIBUTE, "pi");
        Element node = this.getChildElementByNameAttribute(groupNode, "pi", NAME_ATTRIBUTE, name);
        return node;
    }

    public XmlModelPi getPiModel(String documentName, String piName) {
        Element piNode = this.getPiByNameAttribute(documentName, piName);
        if (null == piNode) {
            return null;
        }
        Element documentNode = this.getDocumentElement(documentName);
        return new XmlModelPi(documentNode, piNode);
    }

    public boolean appendPi(String documentName, XmlModelPi model) {
        return this.apeendChildInGroup(documentName, "pi", "\u51e6\u7406\u547d\u4ee4", model);
    }

    public boolean removePi(String documentName, String piName) {
        return this.removeChildInGroup(documentName, "pi", "pi", piName);
    }

    public boolean updatePi(String documentName, String piName, XmlModelPi model) {
        return this.updateChildInGroup(documentName, "pi", "pi", piName, model);
    }

    public boolean piUpDown(String documentName, String piName1, String piName2) {
        Element pi1 = this.getPiByNameAttribute(documentName, piName1);
        Element pi2 = this.getPiByNameAttribute(documentName, piName2);
        Element documentElement = this.getDocumentElement(documentName);
        Element groupElement = this.getGroupNode(documentElement, "pi");
        return this.elementUp(groupElement, pi1, pi2);
    }

    public DefaultListModel getDtdElementList(DefaultListModel listModel, String documentName) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupNode = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, TYPE_ATTRIBUTE, DTD_GROUP);
        if (groupNode == null) {
            return listModel;
        }
        Vector vector = this.getChildListByTagName(groupNode, DTD_TAG);
        int len = vector.size();
        for (int i = 0; i < len; ++i) {
            listModel.addElement(vector.get(i));
        }
        return listModel;
    }

    public Element getDtdByNameAttribute(String documentName, String name) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupNode = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, TYPE_ATTRIBUTE, DTD_GROUP);
        Element node = this.getChildElementByNameAttribute(groupNode, DTD_TAG, NAME_ATTRIBUTE, name);
        return node;
    }

    public XmlModelDtd getDtdModel(String documentName, String dtdName) {
        Element dtdNode = this.getDtdByNameAttribute(documentName, dtdName);
        if (null == dtdNode) {
            return null;
        }
        Element documentNode = this.getDocumentElement(documentName);
        return new XmlModelDtd(documentNode, dtdNode);
    }

    public boolean appendDtd(String documentName, XmlModelDtd model) {
        return this.apeendChildInGroup(documentName, DTD_GROUP, "DTD\u5ba3\u8a00", model);
    }

    public boolean removeDtd(String documentName, String dtdName) {
        return this.removeChildInGroup(documentName, DTD_GROUP, DTD_TAG, dtdName);
    }

    public boolean updateDtd(String documentName, String dtdName, XmlModelDtd model) {
        return this.updateChildInGroup(documentName, DTD_GROUP, DTD_TAG, dtdName, model);
    }

    public boolean dtdUpDown(String documentName, String dtdName1, String dtdName2) {
        Element dtd1 = this.getDtdByNameAttribute(documentName, dtdName1);
        Element dtd2 = this.getDtdByNameAttribute(documentName, dtdName2);
        Element documentElement = this.getDocumentElement(documentName);
        Element groupElement = this.getGroupNode(documentElement, DTD_GROUP);
        return this.elementUp(groupElement, dtd1, dtd2);
    }

    public DefaultListModel getAttributeListElementList(DefaultListModel listModel, String documentName) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupNode = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, TYPE_ATTRIBUTE, ATTRIBUTE_LIST_GROUP);
        if (null == groupNode) {
            return listModel;
        }
        Vector vector = this.getChildListByTagName(groupNode, ATTRIBUTE_LIST_TAG);
        int len = vector.size();
        for (int i = 0; i < len; ++i) {
            listModel.addElement(vector.get(i));
        }
        return listModel;
    }

    public Element getAttributeListByNameAttribute(String documentName, String name) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupNode = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, TYPE_ATTRIBUTE, ATTRIBUTE_LIST_GROUP);
        Element node = this.getChildElementByNameAttribute(groupNode, ATTRIBUTE_LIST_TAG, NAME_ATTRIBUTE, name);
        return node;
    }

    public DefaultListModel getElementAttributeListList(DefaultListModel listModel, String documentName, String elementName) {
        Element documentElement = this.getDocumentElement(documentName);
        Element element = this.getElementByNameAttribute(documentName, elementName);
        if (null == element) {
            return listModel;
        }
        Vector vector = this.getChildListByTagName(element, ATTRIBUTE_LIST_TAG);
        int len = vector.size();
        for (int i = 0; i < len; ++i) {
            listModel.addElement(vector.get(i));
        }
        return listModel;
    }

    public XmlModelAttributeList getAtributeListModel(String documentName, String listName) {
        Element listNode = this.getAttributeListByNameAttribute(documentName, listName);
        if (null == listNode) {
            return null;
        }
        Element documentNode = this.getDocumentElement(documentName);
        return new XmlModelAttributeList(documentNode, listNode);
    }

    public XmlModelAttributeList getAttributeListModel(String documentName, Element parentElement, String name) {
        Element attributeListElement = this.getChildElementByNameAttribute(parentElement, ATTRIBUTE_LIST_TAG, NAME_ATTRIBUTE, name);
        if (null == attributeListElement) {
            return null;
        }
        Element documentElement = this.getDocumentElement(documentName);
        return new XmlModelAttributeList(documentElement, attributeListElement);
    }

    public DefaultListModel getPiAttributeList(DefaultListModel listModel, String documentName, String piName) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupElement = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, TYPE_ATTRIBUTE, "pi");
        Element piElement = this.getChildElementByNameAttribute(groupElement, "pi", NAME_ATTRIBUTE, piName);
        if (piElement == null) {
            return listModel;
        }
        Vector vector = this.getChildListByTagName(piElement, "attribute");
        int len = vector.size();
        for (int i = 0; i < len; ++i) {
            listModel.addElement(vector.get(i));
        }
        return listModel;
    }

    public DefaultListModel getAttributeListAttributeList(DefaultListModel listModel, String documentName, String listName) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupElement = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, TYPE_ATTRIBUTE, ATTRIBUTE_LIST_GROUP);
        Element listElement = this.getChildElementByNameAttribute(groupElement, ATTRIBUTE_LIST_TAG, NAME_ATTRIBUTE, listName);
        if (null == listElement) {
            return listModel;
        }
        Vector vector = this.getChildListByTagName(listElement, "attribute");
        int len = vector.size();
        for (int i = 0; i < len; ++i) {
            listModel.addElement(vector.get(i));
        }
        return listModel;
    }

    public DefaultListModel getElementAttributeList(DefaultListModel listModel, String documentName, String elementName) {
        Element documentElement = this.getDocumentElement(documentName);
        Element element = this.getElementByNameAttribute(documentName, elementName);
        if (null == element) {
            return listModel;
        }
        Vector vector = this.getChildListByTagName(element, "attribute");
        int len = vector.size();
        for (int i = 0; i < len; ++i) {
            listModel.addElement(vector.get(i));
        }
        return listModel;
    }

    public Element getAttributeElement(Element parentElement, String name) {
        return this.getChildElementByNameAttribute(parentElement, "attribute", NAME_ATTRIBUTE, name);
    }

    public XmlModelAttribute getAttributeModel(String documentName, Element parentElement, String name) {
        Element attributeElement = this.getAttributeElement(parentElement, name);
        if (null == attributeElement) {
            return null;
        }
        Element documentElement = this.getDocumentElement(documentName);
        return new XmlModelAttribute(documentElement, attributeElement);
    }

    public boolean appendAttributeElement(Element parentElement, XmlModelAttribute model) {
        Element attributeElement = model.createElement(this.doc);
        if (null == attributeElement || null == parentElement) {
            StaticUtil.errorMessage("attribute\u8981\u7d20\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
            return false;
        }
        parentElement.appendChild(attributeElement);
        return true;
    }

    public boolean removeAttributeElement(Element parentElement, String name) {
        Element element = this.getAttributeElement(parentElement, name);
        if (null == element) {
            StaticUtil.errorMessage("attribute\u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
            return false;
        }
        parentElement.removeChild(element);
        return true;
    }

    public boolean updateAttributeElement(Element parentElement, String name, XmlModelAttribute model) {
        boolean flag = false;
        try {
            Element oldElement = this.getAttributeElement(parentElement, name);
            if (null == oldElement) {
                StaticUtil.errorMessage("attribute\u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            Element newElement = model.createElement(this.doc);
            if (null == newElement) {
                StaticUtil.errorMessage("\u65b0\u3057\u3044 attribute \u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            parentElement.replaceChild(newElement, oldElement);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u4fee\u6b63\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean attributeUpDown(Element parentElement, String name1, String name2) {
        Element attrElement1 = this.getAttributeElement(parentElement, name1);
        Element attrElement2 = this.getAttributeElement(parentElement, name2);
        return this.elementUp(parentElement, attrElement1, attrElement2);
    }

    public DefaultListModel getGroupList(DefaultListModel listModel, String documentName) {
        Element documentElement = this.getDocumentElement(documentName);
        if (null == documentElement) {
            return listModel;
        }
        NodeList nodeList = documentElement.getElementsByTagName(GROUP_TAG);
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            String attrValue;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(attrValue = ((Element)node).getAttribute(TYPE_ATTRIBUTE)).equals(ELEMENT_GROUP)) continue;
            attrValue = ((Element)node).getAttribute(NAME_ATTRIBUTE);
            listModel.addElement(attrValue);
        }
        return listModel;
    }

    public Element getGroupByNameAttribute(String documentName, String name) {
        return this.getElementGroup(documentName, name);
    }

    public XmlModelGroup getGroupModel(String documentName, String name) {
        Element groupElement = this.getGroupByNameAttribute(documentName, name);
        if (null == groupElement) {
            return null;
        }
        Element documentElement = this.getDocumentElement(documentName);
        return new XmlModelGroup(documentElement, groupElement);
    }

    public boolean appendGroup(String documentName, XmlModelGroup model) {
        boolean flag = false;
        try {
            Element documentElement = this.getDocumentElement(documentName);
            Element groupElement = model.createElement(this.doc);
            documentElement.appendChild(groupElement);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("group\u8981\u7d20\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean removeGroup(String documentName, String groupName) {
        boolean flag = false;
        try {
            Element groupElement = this.getGroupByNameAttribute(documentName, groupName);
            if (null == groupElement) {
                StaticUtil.errorMessage("\u30b0\u30eb\u30fc\u30d7\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            Element documentElement = this.getDocumentElement(documentName);
            documentElement.removeChild(groupElement);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean updateGroup(String documentName, String oldName, XmlModelGroup model) {
        boolean flag = false;
        try {
            Element documentElement = this.getDocumentElement(documentName);
            Element oldElement = this.getGroupByNameAttribute(documentName, oldName);
            if (null == oldElement) {
                StaticUtil.errorMessage(oldName + " \u8981\u7d20\u30b0\u30eb\u30fc\u30d7\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            Element newElement = model.createElement(this.doc);
            if (null == newElement) {
                StaticUtil.errorMessage("\u65b0\u3057\u3044\u8981\u7d20\u30b0\u30eb\u30fc\u30d7\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            NodeList list = oldElement.getChildNodes();
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = list.item(i).cloneNode(true);
                newElement.appendChild(node);
            }
            documentElement.replaceChild(newElement, oldElement);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u4fee\u6b63\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean groupUpDown(String documentName, String name1, String name2) {
        try {
            Element groupElement1 = this.getGroupByNameAttribute(documentName, name1);
            Element groupElement2 = this.getGroupByNameAttribute(documentName, name2);
            Element documentElement = this.getDocumentElement(documentName);
            return this.elementUp(documentElement, groupElement1, groupElement2);
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u4fee\u6b63\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return false;
    }

    public DefaultListModel getElementList(DefaultListModel listModel, String documentName, String groupName) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupElement = this.getGroupByNameAttribute(documentName, groupName);
        if (null == groupElement) {
            return listModel;
        }
        Vector vector = this.getChildListByTagName(groupElement, ELEMENT_TAG);
        int len = vector.size();
        for (int i = 0; i < len; ++i) {
            listModel.addElement(vector.get(i));
        }
        return listModel;
    }

    public Element getElementByNameAttribute(String documentName, String name) {
        DefaultListModel list = new DefaultListModel();
        list = this.getGroupList(list, documentName);
        Element documentElement = this.getDocumentElement(documentName);
        for (int i = 0; i < list.size(); ++i) {
            Element groupNode = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, NAME_ATTRIBUTE, (String)list.get(i));
            Element node = this.getChildElementByNameAttribute(groupNode, ELEMENT_TAG, NAME_ATTRIBUTE, name);
            if (null == node) continue;
            return node;
        }
        return null;
    }

    public XmlModelElement getElementModel(String documentName, String name) {
        Element element = this.getElementByNameAttribute(documentName, name);
        if (null == element) {
            return null;
        }
        Element documentElement = this.getDocumentElement(documentName);
        return new XmlModelElement(documentElement, element);
    }

    public boolean appendElement(String documentName, String groupName, XmlModelElement model) {
        boolean flag = false;
        try {
            Element groupElement = this.getGroupByNameAttribute(documentName, groupName);
            if (null == groupElement) {
                Element documentElement = this.getDocumentElement(documentName);
                groupElement = this.appendGroupElement(documentElement, groupName, ELEMENT_GROUP);
            }
            Element element = model.createElement(this.doc);
            groupElement.appendChild(element);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u8981\u7d20\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean removeElement(String documentName, String elementName) {
        boolean flag = false;
        try {
            Element element = this.getElementByNameAttribute(documentName, elementName);
            if (null == element) {
                StaticUtil.errorMessage("\u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            Node parentNode = element.getParentNode();
            parentNode.removeChild(element);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u8981\u7d20\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean updateElement(String documentName, String elementName, XmlModelElement model) {
        boolean flag = false;
        try {
            Element oldElement = this.getElementByNameAttribute(documentName, elementName);
            if (null == oldElement) {
                StaticUtil.errorMessage(elementName + " \u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            Element newElement = model.createElement(this.doc);
            if (null == newElement) {
                StaticUtil.errorMessage("\u65b0\u3057\u3044\u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            NodeList list = oldElement.getChildNodes();
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = list.item(i).cloneNode(true);
                newElement.appendChild(node);
            }
            Node parentNode = oldElement.getParentNode();
            parentNode.replaceChild(newElement, oldElement);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean elementUpDown(String documentName, String name1, String name2) {
        try {
            Element element1 = this.getElementByNameAttribute(documentName, name1);
            Element element2 = this.getElementByNameAttribute(documentName, name2);
            Node parentNode = element1.getParentNode();
            return this.elementUp((Element)parentNode, element1, element2);
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u79fb\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return false;
    }

    public DefaultListModel getCodeList(DefaultListModel listModel, String documentName, String groupName) {
        Element documentElement = this.getDocumentElement(documentName);
        Element groupElement = this.getGroupByNameAttribute(documentName, groupName);
        if (null == groupElement) {
            return listModel;
        }
        Vector vector = this.getChildListByTagName(groupElement, CODE_TAG);
        int len = vector.size();
        for (int i = 0; i < len; ++i) {
            listModel.addElement(vector.get(i));
        }
        return listModel;
    }

    public Element getCodeByNameAttribute(String documentName, String name) {
        DefaultListModel list = new DefaultListModel();
        list = this.getGroupList(list, documentName);
        Element documentElement = this.getDocumentElement(documentName);
        for (int i = 0; i < list.size(); ++i) {
            Element groupNode = this.getChildElementByNameAttribute(documentElement, GROUP_TAG, NAME_ATTRIBUTE, (String)list.get(i));
            Element node = this.getChildElementByNameAttribute(groupNode, CODE_TAG, NAME_ATTRIBUTE, name);
            if (null == node) continue;
            return node;
        }
        return null;
    }

    public XmlModelCode getCodeModel(String documentName, String name) {
        Element element = this.getCodeByNameAttribute(documentName, name);
        if (null == element) {
            return null;
        }
        Element documentElement = this.getDocumentElement(documentName);
        return new XmlModelCode(documentElement, element);
    }

    public boolean appendCode(String documentName, String groupName, XmlModelCode model) {
        boolean flag = false;
        try {
            Element groupElement = this.getGroupByNameAttribute(documentName, groupName);
            if (null == groupElement) {
                Element documentElement = this.getDocumentElement(documentName);
                groupElement = this.appendGroupElement(documentElement, groupName, ELEMENT_GROUP);
            }
            Element element = model.createElement(this.doc);
            groupElement.appendChild(element);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u8981\u7d20\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean removeCode(String documentName, String codeName) {
        boolean flag = false;
        try {
            Element element = this.getCodeByNameAttribute(documentName, codeName);
            if (null == element) {
                StaticUtil.errorMessage("\u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            Node parentNode = element.getParentNode();
            parentNode.removeChild(element);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u8981\u7d20\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean updateCode(String documentName, String elementName, XmlModelCode model) {
        boolean flag = false;
        try {
            Element oldElement = this.getCodeByNameAttribute(documentName, elementName);
            if (null == oldElement) {
                StaticUtil.errorMessage(elementName + " \u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            Element newElement = model.createElement(this.doc);
            if (null == newElement) {
                StaticUtil.errorMessage("\u65b0\u3057\u3044\u8981\u7d20\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
                return flag;
            }
            NodeList list = oldElement.getChildNodes();
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = list.item(i).cloneNode(true);
                newElement.appendChild(node);
            }
            Node parentNode = oldElement.getParentNode();
            parentNode.replaceChild(newElement, oldElement);
            flag = true;
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return flag;
    }

    public boolean codeUpDown(String documentName, String name1, String name2) {
        try {
            Element element1 = this.getCodeByNameAttribute(documentName, name1);
            Element element2 = this.getCodeByNameAttribute(documentName, name2);
            Node parentNode = element1.getParentNode();
            return this.elementUp((Element)parentNode, element1, element2);
        }
        catch (XMLException e) {
            StaticUtil.errorMessage("\u6587\u66f8\u578b\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "\u30a8\u30e9\u30fc");
        }
        catch (DOMException e) {
            StaticUtil.errorMessage("\u79fb\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc");
        }
        return false;
    }

    protected class XMLException
    extends RuntimeException {
        protected XMLException() {
        }
    }
}

