/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins.css;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.plugins.PluginGUICSSAttributePanel;
import jp.sourceforge.jhime.pectin.plugins.css.CheckBoxItemListener;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUICSSLengthComponent;

public class PluginGUIFontPanel
extends PluginGUICSSAttributePanel {
    private static final String[] GENERIC_FAMILY = new String[]{"serif", "sans-serif", "cursive", "fantasy", "monospace", "inherit"};
    private static final String[] STYLE = new String[]{"normal", "italic", "oblique", "inherit"};
    private static final String[] VARIANT = new String[]{"normal", "small-caps", "inherit"};
    private static final String[] WEIGHT = new String[]{"normal", "bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900", "inherit"};
    private static final String[] STRETCH = new String[]{"normal", "wider", "narrower", "ultra-condensed", "extra-condensed", "condensed", "semi-condensed", "semi-expanded", "expanded", "extra-expanded", "ultra-expanded", "inherit"};
    private static final String[] SIZE = new String[]{"\u5024\u6307\u5b9a", "xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large", "larger", "smaller", "inherit"};
    private static final String[] ADJUST = new String[]{"\u5024\u6307\u5b9a", "none", "inherit"};
    private JCheckBox familyBtn = new JCheckBox("\u30d5\u30a1\u30df\u30ea");
    private JCheckBox styleBtn = new JCheckBox("\u30a4\u30bf\u30ea\u30c3\u30af\u4f53");
    private JCheckBox variantBtn = new JCheckBox("\u30b9\u30e2\u30fc\u30eb\u30ad\u30e3\u30d4\u30bf\u30eb");
    private JCheckBox weightBtn = new JCheckBox("\u30dc\u30fc\u30eb\u30c9\u4f53");
    private JCheckBox stretchBtn = new JCheckBox("\u30d5\u30a9\u30f3\u30c8\u5e45");
    private JCheckBox sizeBtn = new JCheckBox("\u30d5\u30a9\u30f3\u30c8\u30b5\u30a4\u30ba");
    private JCheckBox adjustBtn = new JCheckBox("\u30b5\u30a4\u30ba\u8abf\u6574");
    private JCheckBox fontBtn = new JCheckBox("font \u306b\u3088\u308b\u4e00\u62ec\u6307\u5b9a");
    private JComboBox familyBox1 = new JComboBox();
    private JComboBox familyBox2 = new JComboBox();
    private JComboBox familyBox3 = new JComboBox<String>(GENERIC_FAMILY);
    private JComboBox styleBox = new JComboBox<String>(STYLE);
    private JComboBox variantBox = new JComboBox<String>(VARIANT);
    private JComboBox weightBox = new JComboBox<String>(WEIGHT);
    private JComboBox stretchBox = new JComboBox<String>(STRETCH);
    private JComboBox sizeBox = new JComboBox<String>(SIZE);
    private PluginGUICSSLengthComponent sizeComp = new PluginGUICSSLengthComponent("LengthPercent");
    private JComboBox adjustBox = new JComboBox<String>(ADJUST);
    private JTextField adjustField = new JTextField(5);

    public PluginGUIFontPanel() {
        this.initComponent();
        this.setLayout(new BorderLayout(5, 5));
        JComponent cPan = this.createContentsPanel();
        this.add((Component)cPan, "Center");
    }

    private void initComponent() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fm = ge.getAvailableFontFamilyNames();
        this.familyBox1.addItem("\u6307\u5b9a\u306a\u3057");
        this.familyBox2.addItem("\u6307\u5b9a\u306a\u3057");
        for (int i = 0; i < fm.length; ++i) {
            this.familyBox1.addItem(fm[i]);
            this.familyBox2.addItem(fm[i]);
        }
        Vector<JComboBox> familyComp = new Vector<JComboBox>();
        familyComp.add(this.familyBox1);
        familyComp.add(this.familyBox2);
        familyComp.add(this.familyBox3);
        this.familyBtn.addItemListener(new CheckBoxItemListener(familyComp));
        this.styleBtn.addItemListener(new CheckBoxItemListener(this.styleBox));
        this.variantBtn.addItemListener(new CheckBoxItemListener(this.variantBox));
        this.weightBtn.addItemListener(new CheckBoxItemListener(this.weightBox));
        this.stretchBtn.addItemListener(new CheckBoxItemListener(this.stretchBox));
        this.sizeBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PluginGUIFontPanel.this.sizeBtnSelected();
            }
        });
        this.sizeBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String str = (String)((JComboBox)e.getSource()).getSelectedItem();
                if (str.equals("\u5024\u6307\u5b9a")) {
                    PluginGUIFontPanel.this.sizeComp.setEnabled(true);
                } else {
                    PluginGUIFontPanel.this.sizeComp.setEnabled(false);
                }
            }
        });
        this.adjustBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PluginGUIFontPanel.this.adjustBtnSelected();
            }
        });
        this.adjustBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String str = (String)((JComboBox)e.getSource()).getSelectedItem();
                if (str.equals("\u5024\u6307\u5b9a")) {
                    PluginGUIFontPanel.this.adjustField.setEnabled(true);
                } else {
                    PluginGUIFontPanel.this.adjustField.setEnabled(false);
                }
            }
        });
    }

    private JComponent createContentsPanel() {
        GUIGridPanel gridPanel = new GUIGridPanel();
        gridPanel.gridLayoutComponent(this.familyBtn, 0, 0);
        GUIGridPanel familyPanel = new GUIGridPanel(0, 0);
        familyPanel.gridLayoutComponent(this.familyBox1, 0, 0, false);
        familyPanel.gridLayoutComponent(this.familyBox2, 1, 0, false);
        familyPanel.gridLayoutComponent(this.familyBox3, 2, 0, false);
        gridPanel.setWidth(3);
        gridPanel.gridLayoutComponent(familyPanel, 1, 0, false);
        gridPanel.setWidth(1);
        gridPanel.gridLayoutComponent(this.styleBtn, 0, 1);
        gridPanel.gridLayoutComponent(this.styleBox, 1, 1, false);
        gridPanel.gridLayoutComponent(this.variantBtn, 0, 2);
        gridPanel.gridLayoutComponent(this.variantBox, 1, 2, false);
        gridPanel.gridLayoutComponent(this.weightBtn, 0, 3);
        gridPanel.gridLayoutComponent(this.weightBox, 1, 3, false);
        gridPanel.gridLayoutComponent(this.stretchBtn, 0, 4);
        gridPanel.gridLayoutComponent(this.stretchBox, 1, 4, false);
        gridPanel.gridLayoutComponent(this.createGapPanel(this.sizeBtn), 0, 5);
        gridPanel.gridLayoutComponent(this.createGapPanel(this.sizeBox), 1, 5);
        this.sizeBox.setEnabled(false);
        gridPanel.gridLayoutComponent(this.sizeComp, 2, 5, false);
        gridPanel.gridLayoutComponent(this.adjustBtn, 0, 6);
        gridPanel.gridLayoutComponent(this.adjustBox, 1, 6, false);
        gridPanel.gridLayoutComponent(this.adjustField, 2, 6, false);
        gridPanel.setWidth(2);
        gridPanel.gridLayoutComponent(this.fontBtn, 0, 7);
        return gridPanel;
    }

    private JPanel createGapPanel(Component comp) {
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        pane.add(comp, "Center");
        return pane;
    }

    private void sizeBtnSelected() {
        if (this.sizeBtn.isSelected()) {
            this.sizeBox.setEnabled(true);
            if (((String)this.sizeBox.getSelectedItem()).equals("\u5024\u6307\u5b9a")) {
                this.sizeComp.setEnabled(true);
            }
        } else {
            this.sizeBox.setEnabled(false);
            this.sizeComp.setEnabled(false);
        }
    }

    private void adjustBtnSelected() {
        if (this.adjustBtn.isSelected()) {
            this.adjustBox.setEnabled(true);
            if (((String)this.adjustBox.getSelectedItem()).equals("\u5024\u6307\u5b9a")) {
                this.adjustField.setEnabled(true);
            }
        } else {
            this.adjustBox.setEnabled(false);
            this.adjustField.setEnabled(false);
        }
    }

    private String fontFamilyString() {
        if (!this.familyBtn.isSelected()) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        if (!this.fontBtn.isSelected()) {
            buff.append("\tfont-family:");
        }
        String family1 = (String)this.familyBox1.getSelectedItem();
        String family2 = (String)this.familyBox2.getSelectedItem();
        String gFamily = (String)this.familyBox3.getSelectedItem();
        if (gFamily.equals("inherit")) {
            buff.append(" " + gFamily);
        } else {
            String str1 = "\"" + family1.trim() + "\"";
            if (!family1.equals("\u6307\u5b9a\u306a\u3057")) {
                buff.append(" " + str1);
            }
            String str2 = "\"" + family2.trim() + "\"";
            if (!family2.equals("\u6307\u5b9a\u306a\u3057")) {
                if (!family1.equals("\u6307\u5b9a\u306a\u3057") && str1.length() > 2) {
                    buff.append("," + str2);
                } else {
                    buff.append(" " + str2);
                }
            }
            if (!family1.equals("\u6307\u5b9a\u306a\u3057") && str1.length() > 2 || !family2.equals("\u6307\u5b9a\u306a\u3057") && str2.length() > 2) {
                buff.append("," + gFamily);
            } else {
                buff.append(" " + gFamily);
            }
        }
        if (!this.fontBtn.isSelected()) {
            buff.append(";\n");
        }
        return buff.toString();
    }

    private String fontStyleString() {
        if (!this.styleBtn.isSelected()) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        if (!this.fontBtn.isSelected()) {
            buff.append("\tfont-style:");
        }
        buff.append(" " + (String)this.styleBox.getSelectedItem());
        if (!this.fontBtn.isSelected()) {
            buff.append(";\n");
        }
        return buff.toString();
    }

    private String fontVariantString() {
        if (!this.variantBtn.isSelected()) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        if (!this.fontBtn.isSelected()) {
            buff.append("\tfont-variant:");
        }
        buff.append(" " + (String)this.variantBox.getSelectedItem());
        if (!this.fontBtn.isSelected()) {
            buff.append(";\n");
        }
        return buff.toString();
    }

    private String fontWeightString() {
        if (!this.weightBtn.isSelected()) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        if (!this.fontBtn.isSelected()) {
            buff.append("\tfont-weight:");
        }
        buff.append(" " + (String)this.weightBox.getSelectedItem());
        if (!this.fontBtn.isSelected()) {
            buff.append(";\n");
        }
        return buff.toString();
    }

    private String fontStretchString() {
        if (!this.stretchBtn.isSelected()) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        if (!this.fontBtn.isSelected()) {
            buff.append("\tfont-stretch:");
        }
        buff.append(" " + (String)this.stretchBox.getSelectedItem());
        if (!this.fontBtn.isSelected()) {
            buff.append(";\n");
        }
        return buff.toString();
    }

    private String fontSizeString() {
        String str;
        if (!this.sizeBtn.isSelected()) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        if (!this.fontBtn.isSelected()) {
            buff.append("\tfont-size:");
        }
        if ((str = (String)this.sizeBox.getSelectedItem()).equals("\u5024\u6307\u5b9a")) {
            String val = this.sizeComp.getString();
            buff.append(" " + val);
        } else {
            buff.append(" " + str);
        }
        if (!this.fontBtn.isSelected()) {
            buff.append(";\n");
        }
        return buff.toString();
    }

    private String fontSizeAdjustString() {
        String str;
        if (!this.adjustBtn.isSelected()) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        if (!this.fontBtn.isSelected()) {
            buff.append("\tfont-size-adjust:");
        }
        if ((str = (String)this.adjustBox.getSelectedItem()).equals("\u5024\u6307\u5b9a")) {
            String val = this.adjustField.getText();
            buff.append(" " + val.trim());
        } else {
            buff.append(" " + str);
        }
        if (!this.fontBtn.isSelected()) {
            buff.append(";\n");
        }
        return buff.toString();
    }

    public String getString() {
        StringBuffer buff = new StringBuffer();
        if (this.fontBtn.isSelected()) {
            buff.append("\tfont:");
        }
        buff.append(this.fontFamilyString());
        buff.append(this.fontStyleString());
        buff.append(this.fontVariantString());
        buff.append(this.fontWeightString());
        buff.append(this.fontStretchString());
        buff.append(this.fontSizeString());
        buff.append(this.fontSizeAdjustString());
        if (this.fontBtn.isSelected()) {
            buff.append(";\n");
        }
        return buff.toString();
    }

    public String toString() {
        return "\u30d5\u30a9\u30f3\u30c8\u306e\u8a2d\u5b9a";
    }
}

