/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins.css;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.plugins.PluginGUICSSAttributePanel;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUICSSLengthComponent;

public class PluginGUIDisplaySizePanel
extends PluginGUICSSAttributePanel {
    private static final String[] WIDTH_HEIGHT_SIZE = new String[]{"auto", "\u5024\u6307\u5b9a", "inherit"};
    private static final String[] MIN_WIDTH_HEIGHT_SIZE = new String[]{"\u5024\u6307\u5b9a", "inherit"};
    private static final String[] MAX_WIDTH_HEIGHT_SIZE = new String[]{"none", "\u5024\u6307\u5b9a", "inherit"};
    private static final String[] LINE_HEIGHT = new String[]{"normal", "\u5024\u6307\u5b9a", "inherit"};
    private static final String[] VERTICAL_ALIGN = new String[]{"baseline", "sub", "super", "top", "text-top", "middle", "bottom", "text-bottom", "\u5024\u6307\u5b9a", "inherit"};
    private JCheckBox[] itemBtn = new JCheckBox[8];
    private JComboBox[] itemBox = new JComboBox[8];
    private PluginGUICSSLengthComponent[] itemComp = new PluginGUICSSLengthComponent[8];

    public PluginGUIDisplaySizePanel() {
        this.initComponent();
        this.setLayout(new BorderLayout(5, 5));
        JComponent cPan = this.createContentsPanel();
        this.add((Component)cPan, "Center");
    }

    private void initComponent() {
        String label = null;
        String type = null;
        String[] box = null;
        for (int i = 0; i < 8; ++i) {
            switch (i) {
                case 0: {
                    label = "\u5185\u5bb9\u9818\u57df\u306e\u5e45";
                    box = WIDTH_HEIGHT_SIZE;
                    type = "LengthPercent";
                    break;
                }
                case 1: {
                    label = "\u6700\u5c0f\u5e45";
                    box = MIN_WIDTH_HEIGHT_SIZE;
                    type = "LengthPercent";
                    break;
                }
                case 2: {
                    label = "\u6700\u5927\u5e45";
                    box = MAX_WIDTH_HEIGHT_SIZE;
                    type = "LengthPercent";
                    break;
                }
                case 3: {
                    label = "\u5185\u5bb9\u9818\u57df\u306e\u9ad8\u3055";
                    box = WIDTH_HEIGHT_SIZE;
                    type = "LengthPercent";
                    break;
                }
                case 4: {
                    label = "\u6700\u5c0f\u9ad8\u3055";
                    box = MIN_WIDTH_HEIGHT_SIZE;
                    type = "LengthPercent";
                    break;
                }
                case 5: {
                    label = "\u6700\u5927\u9ad8\u3055";
                    box = MAX_WIDTH_HEIGHT_SIZE;
                    type = "LengthPercent";
                    break;
                }
                case 6: {
                    label = "\u884c\u306e\u9ad8\u3055";
                    box = LINE_HEIGHT;
                    type = "Full";
                    break;
                }
                case 7: {
                    label = "\u5782\u76f4\u914d\u7f6e";
                    box = VERTICAL_ALIGN;
                    type = "LengthPercent";
                }
            }
            this.itemBtn[i] = new JCheckBox(label);
            this.itemBox[i] = new JComboBox<String>(box);
            this.itemComp[i] = new PluginGUICSSLengthComponent(type);
            this.itemBtn[i].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    PluginGUIDisplaySizePanel.this.itemBtnSelected((JCheckBox)e.getSource());
                }
            });
            this.itemBox[i].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    PluginGUIDisplaySizePanel.this.itemBoxSelected((JComboBox)e.getSource());
                }
            });
        }
    }

    private JComponent createContentsPanel() {
        GUIGridPanel gridPanel = new GUIGridPanel();
        for (int i = 0; i < 8; ++i) {
            gridPanel.gridLayoutComponent(this.createGapPanel(this.itemBtn[i]), 0, i);
            gridPanel.gridLayoutComponent(this.createGapPanel(this.itemBox[i]), 1, i);
            this.itemBox[i].setEnabled(false);
            gridPanel.gridLayoutComponent(this.itemComp[i], 2, i, false);
        }
        return gridPanel;
    }

    private JPanel createGapPanel(Component comp) {
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        pane.add(comp, "Center");
        return pane;
    }

    private void itemBtnSelected(JCheckBox btn) {
        int idx = -1;
        for (int i = 0; i < 8; ++i) {
            if (!btn.equals(this.itemBtn[i])) continue;
            idx = i;
            break;
        }
        if (btn.isSelected()) {
            this.itemBox[idx].setEnabled(true);
            if (((String)this.itemBox[idx].getSelectedItem()).equals("\u5024\u6307\u5b9a")) {
                this.itemComp[idx].setEnabled(true);
            }
        } else {
            this.itemBox[idx].setEnabled(false);
            this.itemComp[idx].setEnabled(false);
        }
    }

    private void itemBoxSelected(JComboBox box) {
        String str;
        int idx = -1;
        for (int i = 0; i < 8; ++i) {
            if (!box.equals(this.itemBox[i])) continue;
            idx = i;
            break;
        }
        if ((str = (String)box.getSelectedItem()).equals("\u5024\u6307\u5b9a")) {
            this.itemComp[idx].setEnabled(true);
        } else {
            this.itemComp[idx].setEnabled(false);
        }
    }

    private String itemString(String name, JComboBox box, PluginGUICSSLengthComponent comp) {
        StringBuffer buff = new StringBuffer(name);
        String str = (String)box.getSelectedItem();
        if (str.equals("\u5024\u6307\u5b9a")) {
            buff.append(" " + comp.getString());
        } else {
            buff.append(" " + str);
        }
        buff.append(";\n");
        return buff.toString();
    }

    public String getString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < 8; ++i) {
            String str = null;
            switch (i) {
                case 0: {
                    str = "\twidth:";
                    break;
                }
                case 1: {
                    str = "\tmin-width:";
                    break;
                }
                case 2: {
                    str = "\tmax-width:";
                    break;
                }
                case 3: {
                    str = "\theight:";
                    break;
                }
                case 4: {
                    str = "\tmin-height:";
                    break;
                }
                case 5: {
                    str = "\tmax-height:";
                    break;
                }
                case 6: {
                    str = "\tline-height:";
                    break;
                }
                case 7: {
                    str = "\tvertical-align:";
                }
            }
            if (!this.itemBtn[i].isSelected()) continue;
            buff.append(this.itemString(str, this.itemBox[i], this.itemComp[i]));
        }
        return buff.toString();
    }

    public String toString() {
        return "\u30b5\u30a4\u30ba\u3001\u884c\u30dc\u30c3\u30af\u30b9";
    }
}

