/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins.css;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;

public class PluginGUICSSColorComponent
extends GUIGridPanel {
    private static final String KEYWORD_TYPE = "\u30ad\u30fc\u30ef\u30fc\u30c9";
    private static final String HEX24_TYPE = "#rrggbb\u5f62\u5f0f";
    private static final String HEX12_TYPE = "#rgb\u5f62\u5f0f";
    private static final String DEC_TYPE = "10\u9032\u5f62\u5f0f";
    private static final String PERCENT_TYPE = "10\u9032%\u5f62\u5f0f";
    private static final String[] TYPE_ARRAY = new String[]{"\u30ad\u30fc\u30ef\u30fc\u30c9", "#rrggbb\u5f62\u5f0f", "#rgb\u5f62\u5f0f", "10\u9032\u5f62\u5f0f", "10\u9032%\u5f62\u5f0f"};
    private static final String[] COLOR_KEYWORD = new String[]{"aqua", "black", "blue", "fuchsia", "gray", "green", "lime", "maroon", "navy", "olive", "purple", "red", "silver", "teal", "white", "yellow", "orange"};
    private JTextField colorField = new JTextField(10);
    private JComboBox typeBox = new JComboBox<String>(TYPE_ARRAY);
    private JComboBox keywordBox = new JComboBox<String>(COLOR_KEYWORD);
    private JButton colorBtn = new JButton("\u8272\u53c2\u7167");

    public PluginGUICSSColorComponent() {
        this.initComponent();
        this.layoutComponent();
        this.typeBox.setSelectedIndex(0);
        this.keywordBox.setSelectedIndex(1);
        this.keywordBox.setEnabled(true);
        this.colorBtn.setEnabled(false);
    }

    private void initComponent() {
        this.typeBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String type = (String)((JComboBox)e.getSource()).getSelectedItem();
                if (type.equals(PluginGUICSSColorComponent.KEYWORD_TYPE)) {
                    PluginGUICSSColorComponent.this.keywordBox.setEnabled(true);
                    PluginGUICSSColorComponent.this.colorBtn.setEnabled(false);
                } else {
                    PluginGUICSSColorComponent.this.keywordBox.setEnabled(false);
                    PluginGUICSSColorComponent.this.colorBtn.setEnabled(true);
                }
            }
        });
        this.keywordBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String word = (String)((JComboBox)e.getSource()).getSelectedItem();
                PluginGUICSSColorComponent.this.colorField.setText(word);
            }
        });
        this.colorBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginGUICSSColorComponent.this.colorAction();
            }
        });
    }

    private void layoutComponent() {
        this.gridLayoutComponent(this.colorField, 0, 0);
        this.gridLayoutComponent(this.typeBox, 1, 0);
        this.gridLayoutComponent(this.keywordBox, 2, 0);
        this.gridLayoutComponent(this.colorBtn, 3, 0);
    }

    private void colorAction() {
        Color color = JColorChooser.showDialog(null, "\u8272\u306e\u9078\u629e", Color.BLACK);
        if (null == color) {
            return;
        }
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        StringBuffer buff = new StringBuffer();
        if (((String)this.typeBox.getSelectedItem()).equals(HEX24_TYPE)) {
            String r = "0" + Integer.toHexString(red);
            String g = "0" + Integer.toHexString(green);
            String b = "0" + Integer.toHexString(blue);
            buff.append("#");
            buff.append(r.substring(r.length() - 2, r.length()));
            buff.append(g.substring(g.length() - 2, g.length()));
            buff.append(b.substring(b.length() - 2, b.length()));
        } else if (((String)this.typeBox.getSelectedItem()).equals(HEX12_TYPE)) {
            String r = "0" + Integer.toHexString(red);
            String g = "0" + Integer.toHexString(green);
            String b = "0" + Integer.toHexString(blue);
            buff.append("#");
            buff.append(Integer.toHexString(red).substring(0, 1));
            buff.append(Integer.toHexString(green).substring(0, 1));
            buff.append(Integer.toHexString(blue).substring(0, 1));
        } else if (((String)this.typeBox.getSelectedItem()).equals(DEC_TYPE)) {
            buff.append("rgb(");
            buff.append(Integer.toString(red));
            buff.append(",");
            buff.append(Integer.toString(green));
            buff.append(",");
            buff.append(Integer.toString(blue));
            buff.append(")");
        } else {
            float[] rgb = new float[3];
            color.getRGBColorComponents(rgb);
            buff.append("rgb(");
            buff.append(Float.toString(rgb[0] * 100.0f));
            buff.append("%,");
            buff.append(Float.toString(rgb[1] * 100.0f));
            buff.append("%,");
            buff.append(Float.toString(rgb[2] * 100.0f));
            buff.append("%)");
        }
        this.colorField.setText(buff.toString());
    }

    public void setEnabled(boolean flag) {
        if (flag) {
            this.colorField.setEnabled(true);
            this.typeBox.setEnabled(true);
            String type = (String)this.typeBox.getSelectedItem();
            if (type.equals(KEYWORD_TYPE)) {
                this.keywordBox.setEnabled(true);
                this.colorBtn.setEnabled(false);
            } else {
                this.keywordBox.setEnabled(false);
                this.colorBtn.setEnabled(true);
            }
        } else {
            this.colorField.setEnabled(false);
            this.typeBox.setEnabled(false);
            this.keywordBox.setEnabled(false);
            this.colorBtn.setEnabled(false);
        }
    }

    public void addKeyword(String str) {
        this.keywordBox.addItem(str);
    }

    public String getString() {
        return this.colorField.getText().trim();
    }
}

