/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins.css;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.plugins.PluginGUICSSAttributePanel;
import jp.sourceforge.jhime.pectin.plugins.css.CheckBoxItemListener;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUICSSColorComponent;
import jp.sourceforge.jhime.pectin.plugins.css.PluginGUICSSLengthComponent;

public class PluginGUIBorderPanel
extends PluginGUICSSAttributePanel {
    private static final String[] WIDTH = new String[]{"\u5024\u6307\u5b9a", "thin", "medium", "thick"};
    private static final String[] STYLE = new String[]{"none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset"};
    private JCheckBox borderBtn = new JCheckBox("\u56db\u89d2\u30dc\u30fc\u30c0\u30fc");
    private JCheckBox[] chkBtn = new JCheckBox[4];
    private JCheckBox[] widthBtn = new JCheckBox[4];
    private JComboBox[] widthBox = new JComboBox[4];
    private PluginGUICSSLengthComponent[] widthComp = new PluginGUICSSLengthComponent[4];
    private JCheckBox[] styleBtn = new JCheckBox[4];
    private JComboBox[] styleBox = new JComboBox[4];
    private JCheckBox[] colorBtn = new JCheckBox[4];
    private PluginGUICSSColorComponent[] colorComp = new PluginGUICSSColorComponent[4];

    public PluginGUIBorderPanel() {
        this.initComponent();
        this.setLayout(new BorderLayout(5, 5));
        JComponent cPan = this.createContentsPanel();
        this.add((Component)cPan, "Center");
    }

    private void initComponent() {
        for (int i = 0; i < 4; ++i) {
            String label = null;
            switch (i) {
                case 0: {
                    label = "\u4e0a\u30dc\u30fc\u30c0\u30fc";
                    break;
                }
                case 1: {
                    label = "\u4e0b\u30dc\u30fc\u30c0\u30fc";
                    break;
                }
                case 2: {
                    label = "\u5de6\u30dc\u30fc\u30c0\u30fc";
                    break;
                }
                case 3: {
                    label = "\u53f3\u30dc\u30fc\u30c0\u30fc";
                }
            }
            this.chkBtn[i] = new JCheckBox(label);
            this.widthBtn[i] = new JCheckBox("\u5e45");
            this.widthBox[i] = new JComboBox<String>(WIDTH);
            this.widthComp[i] = new PluginGUICSSLengthComponent("Length");
            this.styleBtn[i] = new JCheckBox("\u5f62");
            this.styleBox[i] = new JComboBox<String>(STYLE);
            this.colorBtn[i] = new JCheckBox("\u8272");
            this.colorComp[i] = new PluginGUICSSColorComponent();
            this.chkBtn[i].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    PluginGUIBorderPanel.this.btnSelected((JCheckBox)e.getSource());
                }
            });
            this.widthBtn[i].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    PluginGUIBorderPanel.this.widthBtnSelected((JCheckBox)e.getSource());
                }
            });
            this.widthBox[i].addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    PluginGUIBorderPanel.this.widthSelected((JComboBox)e.getSource());
                }
            });
            this.styleBtn[i].addItemListener(new CheckBoxItemListener(this.styleBox[i]));
            this.colorBtn[i].addItemListener(new CheckBoxItemListener(this.colorComp[i]));
        }
        this.borderBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PluginGUIBorderPanel.this.borderBtnSelected((JCheckBox)e.getSource());
            }
        });
    }

    private JComponent createContentsPanel() {
        GUIGridPanel gridPanel = new GUIGridPanel(2, 0);
        gridPanel.gridLayoutComponent(this.borderBtn, 0, 0);
        for (int i = 0; i < 4; ++i) {
            int y = i * 2 + 1;
            gridPanel.gridLayoutComponent(this.createGapPanel(this.chkBtn[i]), 0, y);
            gridPanel.gridLayoutComponent(this.createGapPanel(this.widthBtn[i]), 1, y);
            this.widthBtn[i].setEnabled(false);
            gridPanel.gridLayoutComponent(this.createGapPanel(this.widthBox[i]), 2, y);
            this.widthBox[i].setEnabled(false);
            gridPanel.gridLayoutComponent(this.widthComp[i], 3, y, false);
            gridPanel.gridLayoutComponent(this.createGapPanel(this.styleBtn[i]), 4, y);
            this.styleBtn[i].setEnabled(false);
            gridPanel.gridLayoutComponent(this.createGapPanel(this.styleBox[i]), 5, y);
            this.styleBox[i].setEnabled(false);
            this.colorComp[i].addKeyword("transparent");
            this.colorComp[i].addKeyword("inherit");
            gridPanel.gridLayoutComponent(this.createGapPanel(this.colorBtn[i]), 1, y + 1);
            this.colorBtn[i].setEnabled(false);
            gridPanel.setWidth(4);
            gridPanel.gridLayoutComponent(this.colorComp[i], 2, y + 1, false);
            gridPanel.setWidth(1);
        }
        return gridPanel;
    }

    private JPanel createGapPanel(Component comp) {
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        pane.add(comp, "Center");
        return pane;
    }

    private JPanel createGapPanel(JLabel comp) {
        JPanel pane = new JPanel(new FlowLayout(0));
        ((FlowLayout)pane.getLayout()).setVgap(5);
        pane.add(comp);
        return pane;
    }

    private void borderBtnSelected(JCheckBox btn) {
        if (btn.isSelected()) {
            for (int i = 0; i < 4; ++i) {
                this.chkBtn[i].setSelected(false);
                this.chkBtn[i].setEnabled(false);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                this.chkBtn[i].setEnabled(true);
            }
        }
        this.btnSelected(btn);
    }

    private void btnSelected(JCheckBox btn) {
        int index = -1;
        if (btn.equals(this.borderBtn)) {
            index = 0;
        } else {
            for (int i = 0; i < 4; ++i) {
                if (!btn.equals(this.chkBtn[i])) continue;
                index = i;
                break;
            }
        }
        if (btn.isSelected()) {
            this.widthBtn[index].setEnabled(true);
            this.styleBtn[index].setEnabled(true);
            this.colorBtn[index].setEnabled(true);
            this.widthBtnSelected(this.widthBtn[index]);
            if (this.styleBtn[index].isSelected()) {
                this.styleBox[index].setEnabled(true);
            }
            if (this.colorBtn[index].isSelected()) {
                this.colorComp[index].setEnabled(true);
            }
        } else {
            this.widthBtn[index].setEnabled(false);
            this.widthBox[index].setEnabled(false);
            this.widthComp[index].setEnabled(false);
            this.styleBtn[index].setEnabled(false);
            this.colorBtn[index].setEnabled(false);
            this.styleBox[index].setEnabled(false);
            this.colorComp[index].setEnabled(false);
        }
    }

    private void widthBtnSelected(JCheckBox btn) {
        JComboBox box = null;
        Component comp = null;
        for (int i = 0; i < 4; ++i) {
            if (!btn.equals(this.widthBtn[i])) continue;
            box = this.widthBox[i];
            comp = this.widthComp[i];
            break;
        }
        if (btn.isSelected()) {
            box.setEnabled(true);
            if (((String)box.getSelectedItem()).equals("\u5024\u6307\u5b9a")) {
                comp.setEnabled(true);
            }
        } else {
            box.setEnabled(false);
            comp.setEnabled(false);
        }
    }

    private void widthSelected(JComboBox box) {
        String str;
        Component comp = null;
        for (int i = 0; i < 4; ++i) {
            if (!box.equals(this.widthBox[i])) continue;
            comp = this.widthComp[i];
            break;
        }
        if ((str = (String)box.getSelectedItem()).equals("\u5024\u6307\u5b9a")) {
            comp.setEnabled(true);
        } else {
            comp.setEnabled(false);
        }
    }

    private String borderString(int index, String pName) {
        String val;
        StringBuffer buff = new StringBuffer(pName);
        if (this.widthBtn[index].isSelected()) {
            val = (String)this.widthBox[index].getSelectedItem();
            if (val.equals("\u5024\u6307\u5b9a")) {
                buff.append(" " + this.widthComp[index].getString());
            } else {
                buff.append(" " + val);
            }
        }
        if (this.styleBtn[index].isSelected()) {
            val = (String)this.styleBox[index].getSelectedItem();
            buff.append(" " + val);
        }
        if (this.colorBtn[index].isSelected()) {
            val = this.colorComp[index].getString();
            buff.append(" " + val);
        }
        buff.append(";\n");
        return buff.toString();
    }

    public String getString() {
        StringBuffer buff = new StringBuffer();
        if (this.borderBtn.isSelected()) {
            buff.append(this.borderString(0, "\tborder:"));
        } else {
            for (int i = 0; i < 4; ++i) {
                String str = null;
                switch (i) {
                    case 0: {
                        str = "\tborder-top:";
                        break;
                    }
                    case 1: {
                        str = "\tborder-bottom:";
                        break;
                    }
                    case 2: {
                        str = "\tborder-left:";
                        break;
                    }
                    case 3: {
                        str = "\tborder-right:";
                    }
                }
                if (!this.chkBtn[i].isSelected()) continue;
                buff.append(this.borderString(i, str));
            }
        }
        return buff.toString();
    }

    public String toString() {
        return "\u30dc\u30fc\u30c0\u30fc";
    }
}

