/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.sourceforge.jhime.pectin.pectin;
import jp.sourceforge.jhime.pectin.plugins.PluginXMLDocument;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginXMLProperties {
    private Document document = null;
    private String dirPath = null;

    public PluginXMLProperties() {
        this.createDir();
        this.readDocument();
    }

    private void createDir() {
        try {
            this.dirPath = pectin.userDir + System.getProperty("file.separator") + "plugins";
            File pluginsDir = new File(this.dirPath);
            if (!pluginsDir.exists()) {
                pluginsDir.mkdir();
            }
        }
        catch (Exception e) {
            StaticUtil.errorMessage("plugins\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u5165\u51fa\u529b\u30a8\u30e9\u30fc");
        }
    }

    private void readDocument() {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            File file = new File(this.dirPath + System.getProperty("file.separator") + "plugins.xml");
            InputStream is = file.toURL().openStream();
            this.document = builder.parse(is);
            is.close();
        }
        catch (ParserConfigurationException e) {
            StaticUtil.errorMessage("plugins.xml\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u69cb\u6210\u30a8\u30e9\u30fc");
        }
        catch (SAXException e) {
            StaticUtil.errorMessage("plugins.xml\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "SAX\u30a8\u30e9\u30fc");
        }
        catch (FileNotFoundException e) {
            this.document = builder.newDocument();
            Element root = this.document.createElement("pluginsRoot");
            this.document.appendChild(root);
        }
        catch (IOException e) {
            StaticUtil.errorMessage("plugins.xml\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "IO\u30a8\u30e9\u30fc");
            this.document = null;
        }
    }

    private Element getPlugin(String pluginName, String pluginClassName) {
        if (null == this.document) {
            return null;
        }
        NodeList nodeList = this.document.getElementsByTagName("plugin");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String name = element.getAttribute("name");
            String className = element.getAttribute("class");
            if (!name.equals(pluginName) || !className.equals(pluginClassName)) continue;
            element.setAttribute("alive", "true");
            return element;
        }
        return null;
    }

    private Element createPlugin(String pluginName, String pluginClassName) {
        if (null == this.document) {
            return null;
        }
        Element element = this.document.createElement("plugin");
        element.setAttribute("name", pluginName);
        element.setAttribute("class", pluginClassName);
        element.setAttribute("enabled", "false");
        element.setAttribute("alive", "true");
        this.document.getDocumentElement().appendChild(element);
        return element;
    }

    private void removeAlive() {
        if (null == this.document) {
            return;
        }
        NodeList nodeList = this.document.getDocumentElement().getElementsByTagName("plugin");
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Element element = (Element)nodeList.item(i);
            if (!element.getAttribute("alive").equals("false")) continue;
            this.document.getDocumentElement().removeChild(element);
        }
    }

    public void init() {
        if (null == this.document) {
            return;
        }
        NodeList nodeList = this.document.getElementsByTagName("plugin");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            element.setAttribute("alive", "false");
        }
    }

    public boolean setEnablePlugin(PluginXMLDocument xmlDoc) {
        String pluginClassName;
        String pluginName = xmlDoc.toString();
        Element element = this.getPlugin(pluginName, pluginClassName = xmlDoc.getClass().getName());
        if (null == element) {
            element = this.createPlugin(pluginName, pluginClassName);
        }
        return null != element && element.getAttribute("enabled").equals("true");
    }

    public void setEnabled(String pluginName, String pluginClassName, boolean flag) {
        Element element = this.getPlugin(pluginName, pluginClassName);
        if (null == element) {
            return;
        }
        String enabled = "false";
        if (flag) {
            enabled = "true";
        }
        element.setAttribute("enabled", enabled);
    }

    public void save() {
        this.removeAlive();
        try {
            TransformerFactory formerFactory = TransformerFactory.newInstance();
            Transformer former = formerFactory.newTransformer();
            DOMSource xmlSource = new DOMSource(this.document.getDocumentElement());
            String path = this.dirPath + System.getProperty("file.separator") + "plugins.xml";
            StreamResult outputTarget = new StreamResult(new FileOutputStream(path));
            former.transform(xmlSource, outputTarget);
        }
        catch (TransformerFactoryConfigurationError e) {
        }
        catch (TransformerConfigurationException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (TransformerException e) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public Vector createTableHead() {
        Vector<String> vector = new Vector<String>();
        vector.add("\u30d7\u30e9\u30b0\u30a4\u30f3\u540d");
        vector.add("\u30af\u30e9\u30b9\u540d");
        vector.add("\u6709\u52b9");
        return vector;
    }

    public Vector createTableCell() {
        Vector<PluginElement> vector = new Vector<PluginElement>();
        NodeList nodeList = this.document.getDocumentElement().getElementsByTagName("plugin");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            PluginElement plugin = new PluginElement(element);
            vector.add(plugin);
        }
        return vector;
    }

    class PluginElement
    extends Vector {
        PluginElement(Element element) {
            String pluginName = element.getAttribute("name");
            String pluginClassName = element.getAttribute("class");
            String pluginEnabled = element.getAttribute("enabled");
            Boolean pluginFlag = pluginEnabled.equals("true") ? new Boolean(true) : new Boolean(false);
            this.add(pluginName);
            this.add(pluginClassName);
            this.add(pluginFlag);
        }
    }
}

