/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.plugins;

import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JFrame;
import jp.sourceforge.jhime.pectin.pectin;
import jp.sourceforge.jhime.pectin.plugins.PluginXMLDocument;
import jp.sourceforge.jhime.pectin.util.StaticUtil;

public final class Plugin {
    private Vector plugins = new Vector();

    public Plugin(JFrame frame) {
        this.pluginClassLoad(frame);
    }

    private void pluginClassLoad(JFrame frame) {
        String pluginPath = pectin.userDir + System.getProperty("file.separator") + "plugins";
        File pluginDir = new File(pluginPath);
        if (!pluginDir.exists()) {
            return;
        }
        File[] jarFiles = pluginDir.listFiles(new JarFileFilter());
        if (jarFiles.length == 0) {
            return;
        }
        ArrayList<String> errorFiles = new ArrayList<String>();
        for (int i = 0; i < jarFiles.length; ++i) {
            File jarFile = jarFiles[i];
            try {
                JarFile jar = new JarFile(jarFile);
                Manifest manifest = jar.getManifest();
                Attributes attr = manifest.getMainAttributes();
                String className = attr.getValue("Main-Class").trim();
                URL url = jarFile.toURL();
                URLClassLoader loader = new URLClassLoader(new URL[]{url});
                Class<?> cls = loader.loadClass(className);
                PluginXMLDocument pluginObject = (PluginXMLDocument)cls.newInstance();
                pluginObject.setFrame(frame);
                this.plugins.add(pluginObject);
                continue;
            }
            catch (Exception e) {
                errorFiles.add(jarFile.getName());
            }
        }
        if (errorFiles.size() > 0) {
            errorFiles.add("\u30d7\u30e9\u30b0\u30a4\u30f3\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            StaticUtil.errorMessage(errorFiles.toArray(), "\u30d7\u30e9\u30b0\u30a4\u30f3\u30a8\u30e9\u30fc");
        }
    }

    public Vector getPlugins() {
        return this.plugins;
    }

    private class JarFileFilter
    implements FileFilter {
        private JarFileFilter() {
        }

        public boolean accept(File pathname) {
            if (!pathname.isFile()) {
                return false;
            }
            String filename = pathname.getName().toLowerCase();
            return filename.endsWith(".jar");
        }
    }
}

