/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.model;

import jp.sourceforge.jhime.pectin.model.XmlModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlModelDtd
extends XmlModel {
    private String rootName;
    private String publicValue;
    private String systemValue;

    public XmlModelDtd(String name, String rootName, String publicValue, String systemValue) {
        this.setName(name);
        this.setType("dtd");
        this.rootName = rootName;
        this.publicValue = publicValue;
        this.systemValue = systemValue;
    }

    public XmlModelDtd(Element docNode, Element element) {
        super(docNode, element);
        this.rootName = element.getAttribute("root");
        this.publicValue = element.getAttribute("public");
        this.systemValue = element.getAttribute("system");
    }

    public String getRootName() {
        return this.rootName;
    }

    public String getPublicValue() {
        return this.publicValue;
    }

    public String getSystemValue() {
        return this.systemValue;
    }

    public Element createElement(Document doc) {
        String name = this.getName();
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        Element dtdElement = doc.createElement("dtd");
        dtdElement.setAttribute("name", name);
        dtdElement.setAttribute("root", this.rootName);
        if (this.publicValue != null && this.publicValue.trim().length() > 0) {
            dtdElement.setAttribute("public", this.publicValue);
        }
        if (this.systemValue != null && this.systemValue.trim().length() > 0) {
            dtdElement.setAttribute("system", this.systemValue);
        }
        return dtdElement;
    }

    public String getString() {
        StringBuffer buff = new StringBuffer();
        buff.append("<!DOCTYPE ");
        buff.append(this.rootName);
        if (null != this.publicValue && this.publicValue.trim().length() > 0) {
            buff.append(" PUBLIC \"" + this.publicValue + "\"");
        }
        if (null != this.systemValue && this.systemValue.trim().length() > 0) {
            buff.append(" \"" + this.systemValue + "\"");
        }
        buff.append(">");
        return buff.toString();
    }
}

