/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.io;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ImageIOFilter
extends FileFilter {
    public static final String JPEG = "jpeg";
    public static final String PNG = "png";
    public static final String GIF = "gif";
    public static final String ALL_IMAGE = "jpeg/png/gif";
    private String type;

    public ImageIOFilter(String type) {
        this.type = type;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        boolean retFlag = false;
        String filename = file.getName().toLowerCase();
        if (this.type.equals(JPEG)) {
            retFlag = filename.endsWith(".jpeg") || filename.endsWith(".jpg");
        } else if (this.type.equals(PNG)) {
            retFlag = filename.endsWith(".png");
        } else if (this.type.equals(GIF)) {
            retFlag = filename.endsWith(".gif");
        } else if (this.type.equals(ALL_IMAGE)) {
            retFlag = filename.endsWith(".jpeg") || filename.endsWith(".jpg") || filename.endsWith(".png") || filename.endsWith(".gif");
        }
        return retFlag;
    }

    public String getDescription() {
        String str = null;
        if (this.type.equals(JPEG)) {
            str = "JPEG\u30d5\u30a1\u30a4\u30eb (*.jpg, *.jpeg)";
        } else if (this.type.equals(PNG)) {
            str = "PNG\u30d5\u30a1\u30a4\u30eb (*.png)";
        } else if (this.type.equals(GIF)) {
            str = "GIF\u30d5\u30a1\u30a4\u30eb (*.gif)";
        } else if (this.type.equals(ALL_IMAGE)) {
            str = "\u753b\u50cf\u30d5\u30a1\u30a4\u30eb (*.jpeg, *.jpg, *.png, *.gif)";
        }
        return str;
    }
}

