/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;
import jp.sourceforge.jhime.pectin.model.XmlModelAttribute;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;
import jp.sourceforge.jhime.pectin.xml.XMLDocumentUser;
import org.w3c.dom.Element;

public class GUIXmlAttributeDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private Element parentElement;
    private JButton okBtn;
    private JButton cancelBtn;
    private JTextField attributeField;
    private JCheckBox requiredBtn;
    private JCheckBox initValueBtn;
    private JTextField initValueField;
    private JRadioButton caseNoneBtn;
    private JRadioButton caseInputBtn;
    private JRadioButton caseSelectBtn;
    private JList caseValueList;
    private JButton caseValueAppendBtn;
    private JButton caseValueDeleteBtn;
    private JButton caseValueUpdateBtn;
    private String attributeName = null;
    private boolean required = false;
    private boolean initValueFlag = false;
    private String initValue = null;
    private int caseValueType = 0;
    private Vector caseValue = null;
    private XmlModelAttribute model = null;
    private boolean updateFlag;

    public GUIXmlAttributeDialog(GUIFrame obj, Element element, XmlModelAttribute model, boolean updateFlag) {
        super((Frame)null, "\u5c5e\u6027\u8a2d\u5b9a", true);
        this.appObject = obj;
        this.parentElement = element;
        this.model = model;
        this.updateFlag = updateFlag;
        if (this.model != null) {
            this.attributeName = this.model.getName();
            this.required = this.model.getRequired();
            this.initValue = this.model.getValue();
            this.caseValueType = this.model.getComboBox();
            this.caseValue = this.model.getCaseValue();
            if (this.model.getName() != null) {
                this.setTitle(this.model.getName() + "\u5c5e\u6027\u8a2d\u5b9a");
            }
        }
        this.display();
    }

    public GUIXmlAttributeDialog(GUIFrame obj, Element element, XmlModelAttribute model) {
        this(obj, element, model, true);
    }

    public GUIXmlAttributeDialog(GUIFrame obj, Element element) {
        this(obj, element, null, false);
    }

    private void display() {
        this.paramInitialize();
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.okBtn);
        if (this.initValueBtn.isSelected()) {
            this.initValueField.setEnabled(true);
            this.initValueAction(true);
        } else {
            this.initValueField.setEnabled(false);
            this.initValueAction(false);
        }
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(true);
    }

    private JPanel createButtonPanel() {
        this.okBtn = new JButton("\u8a2d\u5b9a");
        this.cancelBtn = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!GUIXmlAttributeDialog.this.actionOk()) {
                    return;
                }
                GUIXmlAttributeDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlAttributeDialog.this.attributeName = null;
                GUIXmlAttributeDialog.this.model = null;
                GUIXmlAttributeDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.cancelBtn);
        pan.add(this.okBtn);
        return pan;
    }

    private void paramInitialize() {
        this.attributeField = new JTextField(10);
        if (this.attributeName != null) {
            this.attributeField.setText(this.attributeName);
        }
        this.requiredBtn = new JCheckBox("\u5fc5\u9808\u5c5e\u6027", this.required);
        this.initValueFlag = this.initValue != null;
        this.initValueBtn = new JCheckBox("\u521d\u671f\u5024", this.initValueFlag);
        this.initValueField = new JTextField(30);
        if (this.initValue != null) {
            this.initValueField.setText(this.initValue);
        }
        this.caseNoneBtn = new JRadioButton("\u9078\u629e\u306a\u3057");
        this.caseInputBtn = new JRadioButton("\u5165\u529b\u9078\u629e");
        this.caseSelectBtn = new JRadioButton("\u56fa\u5b9a\u9078\u629e");
        switch (this.caseValueType) {
            case 1: {
                this.caseInputBtn.setSelected(true);
                break;
            }
            case 2: {
                this.caseSelectBtn.setSelected(true);
                break;
            }
            default: {
                this.caseNoneBtn.setSelected(true);
            }
        }
        this.caseValueList = new JList(new DefaultListModel());
        this.caseValueList.setLayoutOrientation(1);
        this.caseValueList.setVisibleRowCount(0);
        DefaultListModel list = (DefaultListModel)this.caseValueList.getModel();
        list.clear();
        if (this.caseValue != null) {
            for (int i = 0; i < this.caseValue.size(); ++i) {
                list.addElement(this.caseValue.get(i));
            }
        }
        ImageIcon icon = new ImageIcon(ClassLoader.getSystemResource("images/add.png"));
        this.caseValueAppendBtn = new JButton(icon);
        icon = new ImageIcon(ClassLoader.getSystemResource("images/delete.png"));
        this.caseValueDeleteBtn = new JButton(icon);
        icon = new ImageIcon(ClassLoader.getSystemResource("images/wrench.png"));
        this.caseValueUpdateBtn = new JButton(icon);
    }

    private JPanel createContentsPanel() {
        this.addAction();
        ButtonGroup caseGroup = new ButtonGroup();
        caseGroup.add(this.caseNoneBtn);
        caseGroup.add(this.caseInputBtn);
        caseGroup.add(this.caseSelectBtn);
        JScrollPane casePane = new JScrollPane(this.caseValueList);
        this.caseValueList.setEnabled(false);
        JPanel caseBtnPane = new JPanel(new GridLayout(1, 3));
        caseBtnPane.add(this.caseValueAppendBtn);
        caseBtnPane.add(this.caseValueDeleteBtn);
        caseBtnPane.add(this.caseValueUpdateBtn);
        this.caseValueAppendBtn.setEnabled(false);
        this.caseValueDeleteBtn.setEnabled(false);
        this.caseValueUpdateBtn.setEnabled(false);
        GUIGridPanel pan = new GUIGridPanel();
        pan.gridLayoutComponent(new JLabel("\u5c5e\u6027\u540d"), 0, 0);
        pan.gridLayoutComponent(this.attributeField, 1, 0);
        pan.gridLayoutComponent(this.requiredBtn, 2, 0);
        pan.gridLayoutComponent(this.initValueBtn, 0, 1);
        pan.setWidth(2);
        if (this.initValueBtn.isSelected()) {
            pan.gridLayoutComponent(this.initValueField, 1, 1, true);
        } else {
            pan.gridLayoutComponent(this.initValueField, 1, 1, false);
        }
        pan.setWidth(1);
        pan.gridLayoutComponent(this.caseNoneBtn, 0, 2);
        pan.setWidth(2);
        pan.setHeight(3);
        pan.setFill(1);
        pan.gridLayoutComponent(casePane, 1, 2);
        pan.setWidth(1);
        pan.setHeight(1);
        pan.setFill(2);
        pan.gridLayoutComponent(this.caseInputBtn, 0, 3);
        pan.gridLayoutComponent(this.caseSelectBtn, 0, 4);
        pan.setWidth(2);
        pan.gridLayoutComponent(caseBtnPane, 1, 5, false);
        return pan;
    }

    private void addAction() {
        this.initValueBtn.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    GUIXmlAttributeDialog.this.initValueAction(true);
                    GUIXmlAttributeDialog.this.initValueField.setEnabled(true);
                    GUIXmlAttributeDialog.this.initValueField.requestFocusInWindow();
                } else {
                    GUIXmlAttributeDialog.this.initValueAction(false);
                    GUIXmlAttributeDialog.this.initValueField.setEnabled(false);
                }
            }
        });
        this.caseNoneBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlAttributeDialog.this.changeCaseButton();
            }
        });
        this.caseInputBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlAttributeDialog.this.changeCaseButton();
            }
        });
        this.caseSelectBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlAttributeDialog.this.changeCaseButton();
            }
        });
        this.caseValueAppendBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlAttributeDialog.this.caseValueAppend();
            }
        });
        this.caseValueDeleteBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlAttributeDialog.this.caseValueDelete();
            }
        });
        this.caseValueUpdateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIXmlAttributeDialog.this.caseValueUpdate();
            }
        });
    }

    private boolean actionOk() {
        String name = this.attributeField.getText();
        if (name.trim().length() == 0) {
            StaticUtil.errorMessage("\u5c5e\u6027\u540d\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044", "\u30a8\u30e9\u30fc");
            return false;
        }
        XMLDocument xmlDoc = XMLDocumentUser.newInstance();
        if (!(null == xmlDoc.getAttributeElement(this.parentElement, name) || this.updateFlag && this.attributeName.equals(name))) {
            StaticUtil.errorMessage(name + " \u5c5e\u6027\u306f\u767b\u9332\u6e08\u307f\u3067\u3059", "\u30a8\u30e9\u30fc");
            return false;
        }
        this.attributeName = name;
        boolean required = this.requiredBtn.isSelected();
        String initValue = null;
        if (this.initValueBtn.isSelected()) {
            initValue = this.initValueField.getText();
        }
        int combobox = 0;
        if (this.caseInputBtn.isSelected()) {
            combobox = 1;
        } else if (this.caseSelectBtn.isSelected()) {
            combobox = 2;
        }
        Vector vector = new Vector();
        DefaultListModel list = (DefaultListModel)this.caseValueList.getModel();
        for (int i = 0; i < list.size(); ++i) {
            vector.add(list.get(i));
        }
        this.model = new XmlModelAttribute(name, required, initValue, combobox, vector);
        return true;
    }

    private void changeCaseButton() {
        if (this.caseNoneBtn.isSelected()) {
            this.caseValueList.setEnabled(false);
            this.caseValueAppendBtn.setEnabled(false);
            this.caseValueDeleteBtn.setEnabled(false);
            this.caseValueUpdateBtn.setEnabled(false);
        } else {
            this.caseValueList.setEnabled(true);
            this.caseValueAppendBtn.setEnabled(true);
            this.caseValueDeleteBtn.setEnabled(true);
            this.caseValueUpdateBtn.setEnabled(true);
        }
    }

    private void initValueAction(boolean flag) {
        if (flag) {
            this.caseNoneBtn.setEnabled(false);
            this.caseInputBtn.setEnabled(false);
            this.caseSelectBtn.setEnabled(false);
            this.caseValueList.setEnabled(false);
            this.caseValueAppendBtn.setEnabled(false);
            this.caseValueDeleteBtn.setEnabled(false);
            this.caseValueUpdateBtn.setEnabled(false);
        } else {
            this.caseNoneBtn.setEnabled(true);
            this.caseInputBtn.setEnabled(true);
            this.caseSelectBtn.setEnabled(true);
            this.changeCaseButton();
        }
    }

    private void caseValueAppend() {
        String val = StaticUtil.inputMessage("\u9078\u629e\u9805\u76ee\u5024\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044", "\u9078\u629e\u9805\u76ee\u5024\u8a2d\u5b9a");
        if (val == null) {
            return;
        }
        ((DefaultListModel)this.caseValueList.getModel()).addElement(val);
    }

    private void caseValueDelete() {
        int idx = this.caseValueList.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        ((DefaultListModel)this.caseValueList.getModel()).removeElementAt(idx);
    }

    private void caseValueUpdate() {
        String val = (String)this.caseValueList.getSelectedValue();
        if (val == null) {
            return;
        }
        if ((val = (String)JOptionPane.showInputDialog(null, "\u9078\u629e\u9805\u76ee\u5024\u3092\u4fee\u6b63\u3057\u3066\u304f\u3060\u3055\u3044", "\u9078\u629e\u9805\u76ee\u5024\u4fee\u6b63", 1, null, null, val)) == null || val.trim().length() == 0) {
            return;
        }
        int idx = this.caseValueList.getSelectedIndex();
        ((DefaultListModel)this.caseValueList.getModel()).set(idx, val);
    }

    public void windowClosing(WindowEvent e) {
        this.attributeName = null;
        this.model = null;
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public String getName() {
        return this.attributeName;
    }

    public boolean getRequired() {
        return this.required;
    }

    public boolean getInitValueFlag() {
        return this.initValueFlag;
    }

    public String getInitValue() {
        return this.initValue;
    }

    public XmlModelAttribute getModel() {
        return this.model;
    }
}

