/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.util.ResourceUtil;
import jp.sourceforge.jhime.pectin.util.StaticUtil;

public class GUIPrint
implements Printable {
    private GUIFrame appObject = null;
    private String headString;
    private int[] pageBreaks;
    private ArrayList textLines = new ArrayList();
    private int linesPerPage;

    public GUIPrint(GUIFrame obj) {
        this.appObject = obj;
    }

    private int addText(int linesNumber, String str) {
        if (ResourceUtil.getPrintHeader() && linesNumber % this.linesPerPage == 1) {
            this.textLines.add(this.headString);
            this.textLines.add("");
        }
        this.textLines.add(str);
        if (ResourceUtil.getPrintFooter() && linesNumber % this.linesPerPage == 0) {
            String pageStr = "\nPage. " + String.valueOf(linesNumber / this.linesPerPage);
            this.textLines.add("");
            this.textLines.add(pageStr);
        }
        return ++linesNumber;
    }

    private int addTextLine(Graphics g, PageFormat pf, FontMetrics metrics, String str, int linesNumber) {
        double lw;
        Rectangle2D rect2d = metrics.getStringBounds(str, g);
        double pw = pf.getImageableWidth();
        if (pw < (lw = rect2d.getWidth())) {
            while (pw < lw) {
                int pos = (int)((double)str.length() * pw / lw);
                String lStr = str.substring(0, pos);
                Rectangle2D r2d = metrics.getStringBounds(lStr, g);
                double lw2 = r2d.getWidth();
                while (pw < lw2) {
                    lStr = str.substring(0, --pos);
                    r2d = metrics.getStringBounds(lStr, g);
                    lw2 = r2d.getWidth();
                }
                linesNumber = this.addText(linesNumber, lStr);
                str = str.substring(pos);
                if (ResourceUtil.getPrintLineNumber()) {
                    str = "       " + str;
                }
                rect2d = metrics.getStringBounds(str, g);
                lw = rect2d.getWidth();
            }
            if (str.length() > 0) {
                linesNumber = this.addText(linesNumber, str);
            }
        } else {
            linesNumber = this.addText(linesNumber, str);
        }
        return linesNumber;
    }

    private String tabToSpace(String str) {
        StringBuffer buff = new StringBuffer(str);
        int tabSize = ResourceUtil.getTabSize();
        for (int i = 0; i < buff.length(); ++i) {
            if (buff.charAt(i) != '\t') continue;
            int sp = 4 - i % tabSize;
            String spStr = "";
            for (int j = 0; j < sp; ++j) {
                spStr = spStr + " ";
            }
            buff.replace(i, i + 1, spStr);
        }
        return buff.toString();
    }

    private void initTextLines(Graphics g, PageFormat pf, FontMetrics metrics) {
        int linesNumber = 1;
        int lineHeight = metrics.getHeight();
        this.linesPerPage = (int)(pf.getImageableHeight() / (double)lineHeight);
        this.headString = "\t" + this.appObject.getView().getFileName();
        if (ResourceUtil.getPrintHeader()) {
            this.linesPerPage -= 2;
        }
        if (ResourceUtil.getPrintFooter()) {
            this.linesPerPage -= 2;
        }
        try {
            int i;
            StringReader sr = new StringReader(this.appObject.getView().getText());
            BufferedReader br = new BufferedReader(sr);
            if (this.textLines.isEmpty()) {
                String line;
                this.textLines.clear();
                i = 1;
                while (null != (line = br.readLine())) {
                    line = this.tabToSpace(line);
                    String str = "";
                    if (ResourceUtil.getPrintLineNumber()) {
                        str = StaticUtil.getNumberToString(i);
                        str = str + ": ";
                    }
                    str = str + line;
                    linesNumber = this.addTextLine(g, pf, metrics, str, linesNumber);
                    ++i;
                }
            }
            br.close();
            sr.close();
            int rest = (linesNumber - 1) % this.linesPerPage;
            if (rest != 0) {
                for (i = 0; i < this.linesPerPage - rest; ++i) {
                    linesNumber = this.addText(linesNumber, "");
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private int getRightPosition(Graphics g, PageFormat pf, FontMetrics metrics, String str) {
        Rectangle2D rect2d = metrics.getStringBounds(str, g);
        double lw = rect2d.getWidth();
        double pw = pf.getImageableWidth();
        int x = (int)(pw - lw);
        return x >= 0 ? x : 0;
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        Font font = new Font("Monospaced", 0, ResourceUtil.getPrintFontSize());
        g.setFont(font);
        FontMetrics metrics = g.getFontMetrics(font);
        int lineHeight = metrics.getHeight();
        if (this.pageBreaks == null) {
            this.initTextLines(g, pf, metrics);
            this.linesPerPage = (int)(pf.getImageableHeight() / (double)lineHeight);
            int numBreaks = (this.textLines.size() - 1) / this.linesPerPage;
            this.pageBreaks = new int[numBreaks];
            for (int b = 0; b < numBreaks; ++b) {
                this.pageBreaks[b] = (b + 1) * this.linesPerPage;
            }
        }
        if (pageIndex > this.pageBreaks.length) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        int y = 0;
        int x = 0;
        int start = pageIndex == 0 ? 0 : this.pageBreaks[pageIndex - 1];
        int end = pageIndex == this.pageBreaks.length ? this.textLines.size() : this.pageBreaks[pageIndex];
        int line = start;
        for (line = start; line < end; ++line) {
            int w;
            int h;
            char c;
            String str = (String)this.textLines.get(line);
            x = 0;
            y += lineHeight;
            char c2 = c = str.length() > 0 ? str.charAt(0) : (char)'\u0000';
            if (c == '\t') {
                str = str.substring(1) + " ";
                x = this.getRightPosition(g, pf, metrics, str);
                g.drawString(str, x, y);
                h = y + lineHeight / 2;
                if (y + metrics.getDescent() > h) {
                    h = y + metrics.getDescent();
                }
                w = (int)(pf.getImageableWidth() - 1.0);
                g.drawLine(0, h, w, h);
                continue;
            }
            if (c == '\n') {
                h = y - metrics.getAscent() - lineHeight / 2;
                w = (int)(pf.getImageableWidth() - 1.0);
                g.drawLine(0, h, w, h);
                str = str.substring(1) + " ";
                x = this.getRightPosition(g, pf, metrics, str);
                g.drawString(str, x, y);
                continue;
            }
            g.drawString(str, 0, y);
        }
        return 0;
    }
}

