/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.jhime.pectin.gui.GUIFindDialog;
import jp.sourceforge.jhime.pectin.gui.GUIMenuBar;
import jp.sourceforge.jhime.pectin.gui.GUIStatusBar;
import jp.sourceforge.jhime.pectin.gui.GUIToolBar;
import jp.sourceforge.jhime.pectin.gui.GUIView;
import jp.sourceforge.jhime.pectin.gui.GUIXmlTreePanel;
import jp.sourceforge.jhime.pectin.gui.GUIXmlTreeUserPanel;
import jp.sourceforge.jhime.pectin.plugins.PluginTreePanel;
import jp.sourceforge.jhime.pectin.util.ResourceUtil;
import jp.sourceforge.jhime.pectin.util.StaticUtil;
import jp.sourceforge.jhime.pectin.xml.XMLDocument;
import jp.sourceforge.jhime.pectin.xml.XMLDocumentCode;
import jp.sourceforge.jhime.pectin.xml.XMLDocumentUser;

public class GUIFrame
extends JFrame
implements WindowListener {
    private static GUIFrame frame = null;
    private static int UNDEFINED_COUNTER = 1;
    private GUIView viewObject = null;
    private JSplitPane splitPane;
    private JTabbedPane editPane = null;
    private GUIMenuBar menuBar = null;
    private GUIToolBar toolBar = null;
    private GUIStatusBar statusBar = null;
    private GUIFindDialog findDialog = null;
    private JTabbedPane framePane = null;
    private PluginTreePanel systemXmlPanel = null;
    private GUIXmlTreePanel userXmlPanel = null;
    private GUIXmlTreePanel userCodePanel = null;

    private GUIFrame() {
        super("pectin version 0.2");
        int h;
        int y;
        int w;
        int x;
        XMLDocument codeXmlDocument;
        ResourceUtil.getResource();
        try {
            String laf = ResourceUtil.getLookAndFeel();
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.splitPane = this.createPanel();
        Container cont = this.getContentPane();
        cont.setLayout(new BorderLayout());
        cont.add((Component)this.splitPane, "Center");
        cont.add((Component)new JLabel(" "), "West");
        this.menuBar = new GUIMenuBar(this);
        this.setJMenuBar(this.menuBar);
        XMLDocument userXmlDocument = XMLDocumentUser.newInstance();
        if (((XMLDocumentUser)userXmlDocument).isError()) {
            this.menuBar.getXmlMenu().setXmlUserMenuEnabled(false);
        }
        if (((XMLDocumentCode)(codeXmlDocument = XMLDocumentCode.newInstance())).isError()) {
            this.menuBar.getXmlMenu().setXmlCodeMenuEnabled(false);
        }
        this.toolBar = new GUIToolBar(this);
        cont.add((Component)this.toolBar, "First");
        this.statusBar = new GUIStatusBar(this);
        cont.add((Component)this.statusBar, "Last");
        Rectangle rect = this.getGraphicsConfiguration().getBounds();
        if (rect.x < 0) {
            x = rect.x;
            w = 600;
        } else {
            w = (int)((double)rect.width * 0.8);
            x = (rect.width - w) / 2;
        }
        if (rect.y < 0) {
            y = rect.y;
            h = 500;
        } else {
            h = (int)((double)rect.height * 0.8);
            y = 0;
        }
        this.setSize(w, h);
        this.setLocation(x, y);
        this.setVisible(true);
        this.findDialog = new GUIFindDialog(this);
    }

    private JSplitPane createPanel() {
        this.editPane = new JTabbedPane();
        this.editPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GUIView view = GUIFrame.this.getView();
                if (view == null) {
                    return;
                }
                view.setVisible(true);
                view.setFocus();
            }
        });
        this.framePane = new JTabbedPane(1, 0);
        this.systemXmlPanel = new PluginTreePanel(this);
        this.userXmlPanel = new GUIXmlTreeUserPanel(this, XMLDocumentUser.newInstance());
        this.userCodePanel = new GUIXmlTreePanel(this, XMLDocumentCode.newInstance());
        this.userCodePanel.setBtnPanel(false);
        this.framePane.addTab("\u7d44\u8fbc\u307f\u6587\u66f8", this.systemXmlPanel);
        this.framePane.addTab("\u30e6\u30fc\u30b6XML", this.userXmlPanel);
        this.framePane.addTab("\u30b3\u30fc\u30c9", this.userCodePanel);
        this.splitPane = new JSplitPane(1, null, this.editPane);
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setDividerLocation(300);
        this.splitPane.setDividerSize(5);
        return this.splitPane;
    }

    public static GUIFrame newInstance() {
        if (frame == null) {
            frame = new GUIFrame();
        }
        return frame;
    }

    public void setTitle(String title) {
        this.editPane.setTitleAt(this.editPane.getSelectedIndex(), title);
    }

    public void addView(GUIView view) {
        String title = view.getFileName();
        if (title == null) {
            title = "\u540d\u79f0\u672a\u8a2d\u5b9a" + UNDEFINED_COUNTER++;
        }
        this.editPane.addTab(title, view);
        this.editPane.setSelectedIndex(this.getViewCount() - 1);
    }

    public int getViewCount() {
        return this.editPane.getTabCount();
    }

    public void removeView() {
        int idx = this.editPane.getSelectedIndex();
        this.editPane.removeTabAt(idx);
    }

    public GUIView getView() {
        return (GUIView)this.editPane.getSelectedComponent();
    }

    public GUIView getView(int i) {
        return (GUIView)this.editPane.getComponentAt(i);
    }

    public void setMenuStatus(boolean flag) {
        this.menuBar.setMenuStatus(flag);
    }

    public GUIMenuBar getMenuObject() {
        return this.menuBar;
    }

    public void setStatusBarPosition(String str) {
        this.statusBar.setPosition(str);
    }

    public void setToolBarVisible(boolean bool) {
        this.toolBar.setVisible(bool);
    }

    public void setStatusBarVisible(boolean bool) {
        this.statusBar.setVisible(bool);
    }

    public GUIFindDialog getFindDialog() {
        return this.findDialog;
    }

    public PluginTreePanel getSystemXmlPanel() {
        return this.systemXmlPanel;
    }

    public GUIXmlTreePanel getUserXmlPanel() {
        return this.userXmlPanel;
    }

    public GUIXmlTreePanel getUserCodePanel() {
        return this.userCodePanel;
    }

    public void setXmlPanelVisible(boolean bool) {
        if (bool) {
            this.splitPane.setLeftComponent(this.framePane);
            this.splitPane.setDividerLocation(300);
        } else {
            this.splitPane.remove(this.framePane);
        }
    }

    public void windowClosing(WindowEvent e) {
        ArrayList<String> msg = new ArrayList<String>();
        for (int i = this.getViewCount() - 1; i >= 0; --i) {
            this.editPane.setSelectedIndex(i);
            if (!this.getView().isChangeText()) continue;
            msg.add(this.editPane.getTitleAt(i));
        }
        if (msg.size() > 0) {
            msg.add("\u3053\u308c\u3089\u306e\u30d5\u30a1\u30a4\u30eb\u306f\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\u3053\u306e\u307e\u307e\u7d42\u4e86\u3057\u307e\u3059\u304b\uff1f");
            Object[] options = new Object[]{"\u4fdd\u5b58\u3057\u306a\u3044\u3067\u7d42\u4e86", "\u7de8\u96c6\u306b\u623b\u308b"};
            int ret = StaticUtil.warningMessage(msg.toArray(), "\u7d42\u4e86\u78ba\u8a8d", options, 1);
            if (ret == 1) {
                this.getView().setFocus();
                return;
            }
        }
        if (this.findDialog != null) {
            this.findDialog.dispose();
        }
        ResourceUtil.putResource();
        this.dispose();
        System.exit(0);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

