/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.sourceforge.jhime.pectin.gui.GUIFrame;
import jp.sourceforge.jhime.pectin.gui.GUIGridPanel;

public class GUIFindDialog
extends JDialog
implements WindowListener {
    private GUIFrame appObject;
    private JLabel resultLine = new JLabel(" ");
    private JTextField findTextField = new JTextField(30);
    private JTextField replaceTextField = new JTextField(30);
    private JButton nextFindBtn = new JButton("\u6b21\u3078");
    private JButton prevFindBtn = new JButton("\u524d\u3078");
    private JButton replaceBtn = new JButton("\u7f6e\u304d\u63db\u3048");
    private JButton replaceNextBtn = new JButton("\u7f6e\u304d\u63db\u3048\u3066\u6b21\u306e\u691c\u7d22");
    private JButton replaceAllBtn = new JButton("\u3059\u3079\u3066\u7f6e\u304d\u63db\u3048");
    private JRadioButton firstReplaceBtn = new JRadioButton("\u5148\u982d\u304b\u3089\u7f6e\u304d\u63db\u3048");
    private JRadioButton nowReplaceBtn = new JRadioButton("\u73fe\u5728\u4f4d\u7f6e\u304b\u3089\u7f6e\u304d\u63db\u3048", true);
    private JCheckBox alphaCaseBtn = new JCheckBox("\u5927\u6587\u5b57\uff0f\u5c0f\u6587\u5b57\u3092\u533a\u5225\u3057\u306a\u3044");
    private boolean alphaCase = false;

    public GUIFindDialog(GUIFrame obj) {
        super((Frame)null, "\u30c6\u30ad\u30b9\u30c8\u691c\u7d22", false);
        this.appObject = obj;
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        JPanel cPan = this.createContentsPanel();
        this.getContentPane().add((Component)cPan, "Center");
        this.getContentPane().add((Component)this.resultLine, "South");
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(this.appObject);
        this.setVisible(false);
    }

    private JPanel createContentsPanel() {
        this.addAction();
        JPanel replacePan = new JPanel(new GridLayout(2, 1));
        replacePan.setBorder(BorderFactory.createTitledBorder("\u7f6e\u63db\u30aa\u30d7\u30b7\u30e7\u30f3"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.firstReplaceBtn);
        bg.add(this.nowReplaceBtn);
        replacePan.add(this.firstReplaceBtn);
        replacePan.add(this.nowReplaceBtn);
        JPanel optionPan = new JPanel(new FlowLayout(0));
        optionPan.setBorder(BorderFactory.createTitledBorder("\u691c\u7d22\u30aa\u30d7\u30b7\u30e7\u30f3"));
        optionPan.add(this.alphaCaseBtn);
        GUIGridPanel pan = new GUIGridPanel();
        pan.gridLayoutComponent(new JLabel("\u691c\u7d22\u6587\u5b57\u5217: "), 0, 0);
        pan.setWidth(2);
        pan.gridLayoutComponent(this.findTextField, 1, 0);
        pan.setWidth(1);
        pan.gridLayoutComponent(this.nextFindBtn, 3, 0);
        pan.gridLayoutComponent(new JLabel("\u7f6e\u63db\u6587\u5b57\u5217: "), 0, 1);
        pan.setWidth(2);
        pan.gridLayoutComponent(this.replaceTextField, 1, 1);
        pan.setWidth(1);
        pan.gridLayoutComponent(this.prevFindBtn, 3, 1);
        pan.setHeight(2);
        pan.gridLayoutComponent(replacePan, 1, 2);
        pan.setHeight(2);
        pan.gridLayoutComponent(optionPan, 2, 2);
        pan.setHeight(1);
        pan.gridLayoutComponent(this.replaceBtn, 3, 2);
        pan.gridLayoutComponent(this.replaceNextBtn, 3, 3);
        pan.gridLayoutComponent(this.replaceAllBtn, 3, 4);
        return pan;
    }

    private void addAction() {
        this.nextFindBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIFindDialog.this.nextFind();
            }
        });
        this.prevFindBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIFindDialog.this.prevFind();
            }
        });
        this.replaceBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIFindDialog.this.replace();
            }
        });
        this.replaceNextBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIFindDialog.this.replaceNext();
            }
        });
        this.replaceAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIFindDialog.this.replaceAll();
            }
        });
        this.alphaCaseBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                GUIFindDialog.this.alphaCase = !GUIFindDialog.this.alphaCase;
            }
        });
    }

    private int find(String word, int len) {
        int sPos = this.appObject.getView().getCaretPosition();
        int fPos = this.appObject.getView().indexOf(word, sPos, this.alphaCase);
        return fPos;
    }

    private void nextFind() {
        this.resultLine.setText(" ");
        String word = this.findTextField.getText();
        int len = word.length();
        int fPos = this.find(word, len);
        if (fPos < 0) {
            this.resultLine.setText("\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f");
        } else {
            this.appObject.getView().select(fPos, fPos + len);
        }
    }

    private void prevFind() {
        this.resultLine.setText(" ");
        String word = this.findTextField.getText();
        int len = word.length();
        int sPos = this.appObject.getView().getCaretPosition() - this.appObject.getView().isSelect() - 1;
        int fPos = this.appObject.getView().lastIndexOf(word, sPos, this.alphaCase);
        if (fPos < 0) {
            this.resultLine.setText("\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f");
        } else {
            this.appObject.getView().select(fPos, fPos + len);
        }
    }

    private void replace() {
        this.appObject.getView().replaceRange(this.replaceTextField.getText());
    }

    private void replaceNext() {
        this.replace();
        this.nextFind();
    }

    private void replaceAll() {
        if (this.firstReplaceBtn.isSelected()) {
            this.appObject.getView().setCaretPosition(0);
        }
        this.resultLine.setText(" ");
        String word = this.findTextField.getText();
        int len = word.length();
        int fPos = this.find(word, len);
        if (fPos < 0) {
            this.resultLine.setText("\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f");
            return;
        }
        while (fPos != fPos + len) {
            this.appObject.getView().select(fPos, fPos + len);
            this.replace();
            fPos = this.find(word, len);
            if (-1 != fPos) continue;
        }
        this.resultLine.setText("\u7f6e\u63db\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f");
    }

    public void getNextFind() {
        this.nextFind();
    }

    public void getPrevFind() {
        this.prevFind();
    }

    public void getReplace() {
        this.replace();
    }

    public void getReplaceNext() {
        this.replaceNext();
    }

    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.appObject.getView().setFocus();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

