/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import jp.sourceforge.jhime.pectin.io.FileIOFilter;
import jp.sourceforge.jhime.pectin.pectin;
import jp.sourceforge.jhime.pectin.util.ResourceUtil;

public class GUIFileChooser
extends JFileChooser {
    public static final String FILTER_NONE = "file";
    public static final String FILTER_XML = "xfile";
    public static final String FILTER_ALLXML = "afile";
    public static final String FILTER_IMAGE = "gfile";
    public static final String FILTER_OBJECT = "ofile";
    private static final String[] ENCODING_STR = new String[]{"UTF-8", "UTF-16", "Shift_JIS", "EUC-JP", "ISO-2022-JP"};
    private JRadioButton[] encodingBtn = new JRadioButton[ENCODING_STR.length];
    private String urlOfExternal = null;
    private String localPathName = null;

    public GUIFileChooser() {
        super(System.getProperty("user.dir"));
        this.setAccessory(this.createEncodingPanel());
        FileFilter fl = this.getFileFilter();
        this.addChoosableFileFilter(new FileIOFilter("xml_g"));
        this.addChoosableFileFilter(new FileIOFilter("xsl_g"));
        this.setFileFilter(fl);
    }

    public GUIFileChooser(String type) {
        this.urlOfExternal = ResourceUtil.getUrlOfExternal();
        File currentDir = new File(System.getProperty("user.dir"));
        String pathName = pectin.appObject.getView().getPathName();
        String fileName = pectin.appObject.getView().getFileName();
        if (null != fileName && null != pathName) {
            int pos = pathName.lastIndexOf(fileName);
            pathName = pathName.substring(0, pos);
            currentDir = new File(pathName);
        }
        this.setCurrentDirectory(currentDir);
        this.localPathName = this.getCurrentDirectory().getPath();
        FileFilter fl = this.getFileFilter();
        if (type.equals(FILTER_XML)) {
            this.addChoosableFileFilter(new FileIOFilter("xml_g"));
            this.addChoosableFileFilter(new FileIOFilter("xsl_g"));
        } else if (type.equals(FILTER_ALLXML)) {
            this.addChoosableFileFilter(new FileIOFilter("xml_g"));
            this.addChoosableFileFilter(new FileIOFilter("xsl_g"));
            this.addChoosableFileFilter(new FileIOFilter("javascript"));
        } else if (type.equals(FILTER_IMAGE)) {
            this.addChoosableFileFilter(new FileIOFilter("hpeg_g"));
        } else if (type.equals(FILTER_OBJECT)) {
            this.addChoosableFileFilter(new FileIOFilter("mov_g"));
            this.addChoosableFileFilter(new FileIOFilter("audio_g"));
            this.addChoosableFileFilter(new FileIOFilter("itunes_g"));
            this.addChoosableFileFilter(new FileIOFilter("hpeg_g"));
        } else {
            this.addChoosableFileFilter(new FileIOFilter("xml_g"));
            this.addChoosableFileFilter(new FileIOFilter("xsl_g"));
            this.addChoosableFileFilter(new FileIOFilter("javascript"));
            this.addChoosableFileFilter(new FileIOFilter("hpeg_g"));
            this.addChoosableFileFilter(new FileIOFilter("mov_g"));
            this.addChoosableFileFilter(new FileIOFilter("audio_g"));
            this.addChoosableFileFilter(new FileIOFilter("itunes_g"));
        }
        this.setFileFilter(fl);
    }

    private JPanel createEncodingPanel() {
        JPanel encodingPane = new JPanel(new GridLayout(ENCODING_STR.length, 1));
        encodingPane.setBorder(BorderFactory.createLoweredBevelBorder());
        ButtonGroup bg = new ButtonGroup();
        for (int i = 0; i < ENCODING_STR.length; ++i) {
            this.encodingBtn[i] = i == 0 ? new JRadioButton(ENCODING_STR[i], true) : new JRadioButton(ENCODING_STR[i]);
            encodingPane.add(this.encodingBtn[i]);
            bg.add(this.encodingBtn[i]);
        }
        JPanel pane = new JPanel(new BorderLayout(2, 2));
        pane.add((Component)new JLabel(" "), "West");
        pane.add((Component)new JLabel(" "), "East");
        pane.add((Component)new JLabel("\u30a8\u30f3\u30b3\u30fc\u30c7\u30a3\u30f3\u30b0", 0), "North");
        pane.add((Component)encodingPane, "Center");
        return pane;
    }

    public String getEncoding() {
        String encoding = null;
        for (int i = 0; i < ENCODING_STR.length; ++i) {
            if (!this.encodingBtn[i].isSelected()) continue;
            encoding = ENCODING_STR[i];
            break;
        }
        return encoding;
    }

    public void approveSelection() {
        super.approveSelection();
        String dir = this.getCurrentDirectory().getPath();
        System.setProperty("user.dir", dir);
    }

    public String getPath() {
        String path = null;
        if (this.urlOfExternal.equals(FILTER_NONE)) {
            path = this.getSelectedFile().getName();
        } else if (this.urlOfExternal.equals("absolute")) {
            path = this.getSelectedFile().getPath();
        } else {
            String separator = System.getProperty("file.separator");
            this.localPathName = this.localPathName + separator;
            path = this.getSelectedFile().getPath();
            int localLen = this.localPathName.length();
            int pathLen = path.length();
            StringBuffer buff = new StringBuffer();
            int pos = 0;
            for (int i = 0; i < localLen && i < pathLen && this.localPathName.charAt(i) == path.charAt(i); ++i) {
                buff.append(path.charAt(i));
            }
            int len = buff.length();
            this.localPathName = this.localPathName.substring(len);
            path = path.substring(len);
            pos = this.localPathName.indexOf(separator);
            while (pos != -1) {
                path = "../" + path;
                pos = this.localPathName.indexOf(separator, pos + 1);
            }
        }
        return path;
    }
}

