/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jhime.pectin.ftp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.sourceforge.jhime.pectin.ftp.FtpDocument;
import jp.sourceforge.jhime.pectin.ftp.FtpHostSetupDialog;
import jp.sourceforge.jhime.pectin.ftp.Host;
import jp.sourceforge.jhime.pectin.util.StaticUtil;

public class FtpHostDialog
extends JDialog
implements WindowListener {
    private JFrame frame;
    private JButton appendBtn;
    private JButton updateBtn;
    private JButton deleteBtn;
    private JButton cancelBtn;
    private FtpDocument doc;
    private JComboBox hostBox;
    private boolean connectFlag;
    private Host host;

    public FtpHostDialog(JFrame frame, String command) {
        super(frame, "FTP\u30db\u30b9\u30c8\u9078\u629e", true);
        this.frame = frame;
        this.connectFlag = null != command && command.equals("ftpconnect");
        this.doc = new FtpDocument();
        if (this.doc.isError()) {
            return;
        }
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel pan = this.createButtonPanel();
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.getContentPane().add((Component)pan, "South");
        pan.getRootPane().setDefaultButton(this.cancelBtn);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize(dim.width + 50, dim.height + 10);
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    public FtpHostDialog(JFrame frame) {
        this(frame, null);
    }

    private JPanel createButtonPanel() {
        this.appendBtn = new JButton("\u65b0\u898f\u767b\u9332");
        this.updateBtn = new JButton("\u8a2d\u5b9a\u5909\u66f4");
        this.deleteBtn = new JButton("\u8a2d\u5b9a\u524a\u9664");
        this.cancelBtn = new JButton("\u9589\u3058\u308b");
        if (this.connectFlag) {
            this.appendBtn.setText("\u63a5\u7d9a");
            this.appendBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FtpHostDialog.this.ftpAction();
                }
            });
        } else {
            this.appendBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FtpHostDialog.this.appendAction();
                }
            });
        }
        this.updateBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpHostDialog.this.updateAction();
            }
        });
        this.deleteBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpHostDialog.this.deleteAction();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FtpHostDialog.this.closeAction();
                FtpHostDialog.this.dispose();
            }
        });
        JPanel pan = new JPanel(new FlowLayout(2));
        pan.add(this.appendBtn);
        if (!this.connectFlag) {
            pan.add(this.updateBtn);
            pan.add(this.deleteBtn);
        }
        pan.add(this.cancelBtn);
        return pan;
    }

    private JPanel createPanel() {
        this.hostBox = new JComboBox(this.doc.getFtpNames());
        JPanel pane = new JPanel(new BorderLayout(10, 0));
        pane.add((Component)new JLabel(" "), "East");
        pane.add((Component)new JLabel(" "), "West");
        pane.add((Component)this.hostBox, "Center");
        if (this.doc.getFtpNames().size() <= 0) {
            this.hostBox.setEnabled(false);
            this.updateBtn.setEnabled(false);
            this.deleteBtn.setEnabled(false);
            this.hostBox.addItem("\u767b \u9332 \u306a \u3057");
            if (this.connectFlag) {
                this.appendBtn.setEnabled(false);
            }
        }
        return pane;
    }

    private void appendAction() {
        FtpHostSetupDialog dlg = new FtpHostSetupDialog(this.frame, this.doc);
        this.doc = dlg.getDocument();
        Vector host = this.doc.getFtpNames();
        if (host.size() > 0) {
            this.hostBox.removeAllItems();
            for (int i = 0; i < host.size(); ++i) {
                this.hostBox.addItem(host.get(i));
            }
            this.hostBox.setEnabled(true);
            this.updateBtn.setEnabled(true);
            this.deleteBtn.setEnabled(true);
        }
    }

    private void updateAction() {
        String name = (String)this.hostBox.getSelectedItem();
        Host host = this.doc.getHost(name);
        FtpHostSetupDialog dlg = new FtpHostSetupDialog(this.frame, this.doc, host);
        this.doc = dlg.getDocument();
        Vector hostList = this.doc.getFtpNames();
        this.hostBox.removeAllItems();
        for (int i = 0; i < hostList.size(); ++i) {
            this.hostBox.addItem(hostList.get(i));
        }
    }

    private void deleteAction() {
        String name = (String)this.hostBox.getSelectedItem();
        Object[] options = new Object[]{"\u524a\u9664\u3059\u308b", "\u524a\u9664\u3057\u306a\u3044"};
        int ret = StaticUtil.warningMessage(name + " \u306eFTP\u30b5\u30fc\u30d0\u30fc\u8a2d\u5b9a\u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f", "FTP\u8a2d\u5b9a\u524a\u9664\u78ba\u8a8d", options, 1);
        if (ret != 0) {
            return;
        }
        if (!this.doc.delete(name)) {
            StaticUtil.errorMessage("FTP\u8a2d\u5b9a\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "DOM\u30a8\u30e9\u30fc");
            return;
        }
        this.hostBox.removeAllItems();
        if (this.doc.getFtpNames().size() <= 0) {
            this.hostBox.setEnabled(false);
            this.updateBtn.setEnabled(false);
            this.deleteBtn.setEnabled(false);
            this.hostBox.addItem("\u767b \u9332 \u306a \u3057");
        } else {
            Vector hostList = this.doc.getFtpNames();
            for (int i = 0; i < hostList.size(); ++i) {
                this.hostBox.addItem(hostList.get(i));
            }
        }
    }

    private void closeAction() {
        if (!this.connectFlag && !this.doc.transform()) {
            StaticUtil.errorMessage("FTP\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "IO\u30a8\u30e9\u30fc");
        }
    }

    private void ftpAction() {
        String name = (String)this.hostBox.getSelectedItem();
        this.host = this.doc.getHost(name);
        this.dispose();
    }

    public Host getHost() {
        return this.host;
    }

    public void windowClosing(WindowEvent e) {
        this.closeAction();
        this.dispose();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }
}

